/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.salaryfile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelServiceHelper;
import kd.swc.hsas.common.utils.BatchResult;
import kd.swc.hsas.opplugin.validator.salaryfile.TaxFileImportSaveValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaxFileImportSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(TaxFileImportSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TaxFileImportSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (StringUtils.equals((CharSequence)this.getOption().getVariableValue("op", ""), (CharSequence)"validate")) {
            e.setCancel(true);
            return;
        }
        DynamicObject[] taxFileTemps = e.getDataEntities();
        ArrayList<DynamicObject> taxFileTmpList = new ArrayList<DynamicObject>(taxFileTemps.length);
        ArrayList<DynamicObject> successTaxFileList = new ArrayList<DynamicObject>(taxFileTemps.length);
        for (DynamicObject taxFileTmp : taxFileTemps) {
            if (!SWCStringUtils.isEmpty((String)taxFileTmp.getString("failmsg"))) {
                taxFileTmpList.add(taxFileTmp);
                continue;
            }
            successTaxFileList.add(taxFileTmp);
        }
        this.pushTaxFiles(taxFileTmpList, successTaxFileList);
        LOGGER.info("\u4e2a\u7a0e\u63a8\u9001\u6570\u636e\u4fdd\u5b58\u7ed3\u675f");
        if (!successTaxFileList.isEmpty()) {
            this.saveSalaryTaxFileRel(successTaxFileList);
        }
        LOGGER.info("\u4fdd\u5b58\u4e2a\u7a0e\u4e0e\u53d1\u85aa\u5173\u8054\u5173\u7cfb\u7ed3\u675f");
        e.setDataEntities(taxFileTmpList.toArray(new DynamicObject[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSalaryTaxFileRel(List<DynamicObject> successTaxFile) {
        SWCDataServiceHelper relDataServiceHelper = new SWCDataServiceHelper("hsas_salarytaxfilerel");
        Object[] pkIds = new Object[successTaxFile.size()];
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>(successTaxFile.size());
        for (int i = 0; i < pkIds.length; ++i) {
            DynamicObject taxEntity = successTaxFile.get(i);
            pkIds[i] = taxEntity.get("id");
            relations.add(this.convertTaxFileTempToRel(relDataServiceHelper, taxEntity));
        }
        try (TXHandle txHandle = TX.required();){
            relDataServiceHelper.save(relations.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject convertTaxFileTempToRel(SWCDataServiceHelper relDataServiceHelper, DynamicObject taxEntity) {
        DynamicObject relEntity = relDataServiceHelper.generateEmptyDynamicObject();
        relEntity.set("creator", taxEntity.get("creator"));
        relEntity.set("createtime", (Object)new Date());
        relEntity.set("modifier", taxEntity.get("modifier"));
        relEntity.set("modifytime", (Object)new Date());
        relEntity.set("status", (Object)"C");
        relEntity.set("person", taxEntity.get("person"));
        relEntity.set("salaryfile", taxEntity.get("salaryfile"));
        relEntity.set("taxfile", taxEntity.get("taxfile"));
        return relEntity;
    }

    private void pushTaxFiles(List<DynamicObject> taxFileTmpList, List<DynamicObject> successTaxFileList) {
        BatchResult batchResult = SalaryTaxFileRelServiceHelper.pushTaxFilesToItc(successTaxFileList, (String)"1", (String)"3");
        if (batchResult != null) {
            List failResult = batchResult.getFailResult();
            if (!CollectionUtils.isEmpty((Collection)failResult)) {
                for (DynamicObject failDyn : failResult) {
                    successTaxFileList.remove(failDyn);
                    taxFileTmpList.add(failDyn);
                }
            }
        } else {
            taxFileTmpList.addAll(successTaxFileList);
            successTaxFileList.clear();
        }
    }
}

