/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.secret;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.encrypt.MultiEncryptNewService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.EncryptLevelEnum;
import kd.swc.hsbp.common.enums.EncryptTypeEnum;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class SecretKeySaveOp
extends SWCDataBaseOp {
    private static final String DONOTHING_CLEAR = "donothing_clear";
    private static final String DONOTHING_SAVECONFIRM_YES = "donothing_saveconfirm_yes";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String opKey;
        switch (opKey = e.getOperationKey()) {
            case "donothing_saveconfirm_yes": {
                this.refreshSecretKey(e);
                break;
            }
            case "donothing_clear": {
                this.clearSecretKey();
                break;
            }
        }
    }

    private void clearSecretKey() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_secretkey");
        DynamicObject dynamicObject = helper.queryOne("secretkey,modifytime", new QFilter[0]);
        if (dynamicObject != null) {
            helper.deleteOne((Object)dynamicObject);
        }
    }

    private void refreshSecretKey(BeginOperationTransactionArgs e) {
        String secretKey = e.getDataEntities()[0].getString("textfield_secret");
        MultiEncryptNewService service = new MultiEncryptNewService(EncryptTypeEnum.ENCRYPT_TYPE_INTERNATIONAL, EncryptLevelEnum.ENCRYPT_LEVEL_HIGH);
        String dataKey = service.getSecretKey(secretKey);
        this.saveData(dataKey);
    }

    private void saveData(String dataKey) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_secretkey");
        DynamicObject dynamicObject = helper.queryOne("secretkey,modifytime,modifier", new QFilter[0]);
        Long currUserId = RequestContext.get().getCurrUserId();
        if (dynamicObject == null) {
            DynamicObject insertObject = helper.generateEmptyDynamicObject();
            insertObject.set("secretkey", (Object)dataKey);
            insertObject.set("creator", (Object)currUserId);
            insertObject.set("createtime", (Object)new Date());
            helper.saveOne(insertObject);
        } else {
            dynamicObject.set("secretkey", (Object)dataKey);
            dynamicObject.set("modifier", (Object)currUserId);
            dynamicObject.set("modifytime", (Object)new Date());
            helper.updateOne(dynamicObject);
        }
    }
}

