/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.calpayrolltask;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.business.calpayrolltask.TaskService;
import kd.swc.hsas.business.calpayrolltask.entity.AddPersonRequest;
import kd.swc.hsas.business.calpayrolltask.entity.AddPersonResult;
import kd.swc.hsas.business.calpayrolltask.entity.CreateAndCalResult;
import kd.swc.hsas.business.calpayrolltask.entity.CreateTaskAddPersonRequest;
import kd.swc.hsas.business.calpayrolltask.entity.CreateTaskAddPersonResult;
import kd.swc.hsas.business.calpayrolltask.entity.CreateTaskRequest;
import kd.swc.hsas.business.calpayrolltask.entity.CreateTaskResult;
import kd.swc.hsas.mservice.api.calpayrolltask.ICalPayrolltaskService;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.jetbrains.annotations.NotNull;

public class CalPayrolltaskService
implements ICalPayrolltaskService {
    private static final Log logger = LogFactory.getLog(CalPayrolltaskService.class);

    public Map<String, Object> createTask(List<Map<String, Object>> params) {
        List taskPersonResult;
        logger.info("begin createTask,params:{}", (Object)JSONObject.toJSONString(params));
        Map<String, Object> result = this.initResultMap();
        TaskService taskService = new TaskService();
        ArrayList<CreateTaskRequest> paramList = new ArrayList<CreateTaskRequest>(params.size());
        ArrayList<CreateAndCalResult> resultList = new ArrayList<CreateAndCalResult>(paramList.size());
        for (Map<String, Object> param : params) {
            boolean boolCheck = taskService.checkCreateParamType(param, resultList);
            if (!boolCheck) continue;
            CreateTaskRequest request = (CreateTaskRequest)SWCJSONUtils.map2Bean(param, CreateTaskRequest.class);
            paramList.add(request);
        }
        result.put("data", resultList);
        Set commonHideTaskUnionIdSet = paramList.stream().filter(single -> SWCStringUtils.equals((String)"0", (String)single.getTaskType()) && single.getHide() != false).map(singel -> singel.getUnionId()).collect(Collectors.toSet());
        Map checkMsgMap = taskService.checkCreateTaskParams(paramList);
        Map<String, CreateTaskRequest> paramMap = paramList.stream().collect(Collectors.toMap(CreateTaskRequest::getUnionId, Function.identity(), (v1, v2) -> v1));
        if (checkMsgMap.size() > 0) {
            StringBuilder errMsgSb = this.genErrResult(paramList, resultList, paramMap, checkMsgMap);
            if (paramList.size() == 0) {
                result.put("data", this.convertToMap(resultList));
                return result;
            }
        }
        logger.info("check params finish, msg:{}", (Object)checkMsgMap.toString());
        try {
            taskPersonResult = taskService.createTaskAndAddPerson(paramList);
        }
        catch (Exception exception) {
            logger.error("createTask_error", (Throwable)exception);
            result.put("data", this.convertToMap(resultList));
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25\u3002", "CalPayrolltaskService_5", "swc-hsas-mservice");
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "CalPayrolltaskService_3", "swc-hsas-mservice");
            SWCOpLogServiceHelper.addOpLog((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"save", (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
            return result;
        }
        logger.info("taskPersonResult:{}", (Object)JSONObject.toJSONString((Object)taskPersonResult));
        HashSet<Long> waitDelTaskIdSet = new HashSet<Long>(16);
        for (CreateTaskResult param : taskPersonResult) {
            String uniqueCode = param.getUniqueCode();
            CreateTaskRequest request = paramMap.get(uniqueCode);
            CreateAndCalResult ret = new CreateAndCalResult(uniqueCode, request.getPayrollGroupId(), request.getPayrollSceneId(), request.getPeriodId());
            Long taskId = param.getTaskId();
            List personIdList = param.getPersonIdList();
            if (taskId == 0L || personIdList.size() == 0) {
                ret.setSuccess(Boolean.FALSE);
                ret.setMessage(ResManager.loadKDString((String)"\u521b\u5efa\u4efb\u52a1\u6216\u4eba\u5458\u85aa\u8d44\u6863\u6848\u6dfb\u52a0\u6838\u7b97\u540d\u5355\u5931\u8d25\u3002", (String)"CalPayrolltaskService_0", (String)"swc-hsas-mservice", (Object[])new Object[0]));
            } else {
                try {
                    String calType = request.getCalType();
                    if (SWCStringUtils.isEmpty((String)calType) || !"afterTaxCal".equals(calType) && !"preTaxCal".equals(calType) && !"cal".equals(calType)) {
                        calType = "preTaxCal";
                    }
                    List responseLsit = (List)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IHSCSService", (String)"salaryCalPreTax", (Object[])new Object[]{taskId, personIdList, calType});
                    ret.setResult(responseLsit);
                    ret.setSuccess(Boolean.TRUE);
                    if (commonHideTaskUnionIdSet.contains(uniqueCode)) {
                        waitDelTaskIdSet.add(taskId);
                    }
                }
                catch (Exception exception) {
                    ret.setSuccess(Boolean.FALSE);
                    ret.setMessage(exception.getMessage());
                }
            }
            resultList.add(ret);
        }
        result.put("data", this.convertToMap(resultList));
        ThreadPools.executeOnce((String)"DEL_HIDECOMMONTASK_POOL_ASYNC", () -> {
            logger.info("CalPayrolltaskService.delHideCommonTask,waitDelTaskIdSet= {}", (Object)waitDelTaskIdSet);
            taskService.delHideCommonTask(waitDelTaskIdSet);
        });
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "CalPayrolltaskService_4", "swc-hsas-mservice");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "CalPayrolltaskService_3", "swc-hsas-mservice");
        SWCOpLogServiceHelper.addOpLog((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"save", (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
        return result;
    }

    public Map<String, Object> createAndAutoAddPerson(List<Map<String, Object>> params) {
        List taskPersonResult;
        logger.info("begin createAndAutoAddPerson,params:{}", (Object)JSONObject.toJSONString(params));
        Map<String, Object> result = this.initResultMap();
        TaskService taskService = new TaskService();
        ArrayList<CreateTaskAddPersonRequest> paramList = new ArrayList<CreateTaskAddPersonRequest>(params.size());
        ArrayList<CreateTaskAddPersonResult> resultList = new ArrayList<CreateTaskAddPersonResult>(paramList.size());
        for (Map<String, Object> param : params) {
            boolean boolCheck = taskService.checkParamType(param, resultList);
            if (!boolCheck) continue;
            CreateTaskAddPersonRequest request = (CreateTaskAddPersonRequest)SWCJSONUtils.map2Bean(param, CreateTaskAddPersonRequest.class);
            paramList.add(request);
        }
        result.put("data", resultList);
        if (paramList.size() == 0) {
            result.put("data", this.convertToMap(resultList));
            return result;
        }
        Map checkMsgMap = taskService.checkCreateTaskAndPersonParams(paramList);
        Map<String, CreateTaskAddPersonRequest> paramMap = paramList.stream().collect(Collectors.toMap(CreateTaskAddPersonRequest::getUnionId, Function.identity(), (v1, v2) -> v1));
        if (checkMsgMap.size() > 0) {
            StringBuilder errMsgSb = this.genErrResultForAddPerson(paramList, resultList, paramMap, checkMsgMap);
            if (paramList.size() == 0) {
                result.put("data", this.convertToMap(resultList));
                return result;
            }
        }
        logger.info("check params finish, msg:{}", (Object)checkMsgMap.toString());
        try {
            taskPersonResult = taskService.createTaskAndAddPersonAuto(paramMap.values().stream().collect(Collectors.toList()));
        }
        catch (Exception exception) {
            logger.error("createAndAutoAddPerson error", (Throwable)exception);
            result.put("data", this.convertToMap(resultList));
            return result;
        }
        logger.info("taskPersonResult:{}", (Object)JSONObject.toJSONString((Object)taskPersonResult));
        resultList.addAll(taskPersonResult);
        result.put("data", this.convertToMap(resultList));
        return result;
    }

    public Map<String, Object> addPerson(List<Map<String, Object>> params) {
        List addPersonResult;
        logger.info("begin addPerson,params:{}", (Object)JSONObject.toJSONString(params));
        Map<String, Object> result = this.initResultMap();
        TaskService taskService = new TaskService();
        ArrayList<AddPersonRequest> paramList = new ArrayList<AddPersonRequest>(params.size());
        ArrayList<AddPersonResult> resultList = new ArrayList<AddPersonResult>(paramList.size());
        HashMap taskPersonCountMap = new HashMap(params.size());
        this.assembleParamBean(params, paramList, resultList);
        result.put("data", resultList);
        if (paramList.size() == 0) {
            result.put("data", this.convertToMap(resultList));
            return result;
        }
        HashMap invalidFileIdMap = new HashMap(16);
        Map checkMsgMap = taskService.checkPersonParams(paramList, taskPersonCountMap, invalidFileIdMap);
        Map<String, AddPersonRequest> paramMap = paramList.stream().collect(Collectors.toMap(AddPersonRequest::getUnionId, Function.identity(), (v1, v2) -> v1));
        if (checkMsgMap.size() > 0) {
            this.genAddPersonErrResult(paramList, resultList, paramMap, checkMsgMap);
            if (paramList.size() == 0) {
                result.put("data", this.convertToMap(resultList));
                return result;
            }
        }
        logger.info("check params finish, msg:{}", (Object)checkMsgMap.toString());
        try {
            addPersonResult = taskService.addPerson(paramMap.values().stream().collect(Collectors.toList()), taskPersonCountMap, invalidFileIdMap);
        }
        catch (Exception exception) {
            logger.error("addPerson error", (Throwable)exception);
            result.put("data", this.convertToMap(resultList));
            return result;
        }
        logger.info("addPersonResult:{}", (Object)JSONObject.toJSONString((Object)addPersonResult));
        resultList.addAll(addPersonResult);
        result.put("data", this.convertToMap(resultList));
        return result;
    }

    private void assembleParamBean(List<Map<String, Object>> params, List<AddPersonRequest> paramList, List<AddPersonResult> resultList) {
        int count = 0;
        if (params.size() > 10) {
            AddPersonResult ret = new AddPersonResult("", ResManager.loadKDString((String)"\u975e\u6cd5\u5165\u53c2\uff1a\u6700\u591a\u540c\u65f6\u53d1\u8d7710\u7ec4\u6838\u7b97\u4efb\u52a1\u51711000\u4eba\u7684\u6dfb\u52a0\u3002", (String)"CalPayrolltaskService_2", (String)"swc-hsas-mservice", (Object[])new Object[0]));
            resultList.add(ret);
            return;
        }
        for (Map<String, Object> param : params) {
            AddPersonRequest request = (AddPersonRequest)SWCJSONUtils.map2Bean(param, AddPersonRequest.class);
            List salaryFiles = request.getSalaryFiles();
            if (!SWCListUtils.isEmpty((List)salaryFiles) && salaryFiles.size() > 100) {
                AddPersonResult ret = new AddPersonResult(param.get("unionId") + "", ResManager.loadKDString((String)"\u975e\u6cd5\u5165\u53c2\uff1a\u5355\u7ec4\u6863\u6848\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u3002", (String)"CalPayrolltaskService_1", (String)"swc-hsas-mservice", (Object[])new Object[0]));
                resultList.add(ret);
                continue;
            }
            paramList.add(request);
            count += salaryFiles.size();
        }
        if (count > 1000) {
            AddPersonResult ret = new AddPersonResult("", ResManager.loadKDString((String)"\u975e\u6cd5\u5165\u53c2\uff1a\u6700\u591a\u540c\u65f6\u53d1\u8d7710\u7ec4\u6838\u7b97\u4efb\u52a1\u51711000\u4eba\u7684\u6dfb\u52a0\u3002", (String)"CalPayrolltaskService_2", (String)"swc-hsas-mservice", (Object[])new Object[0]));
            resultList.add(ret);
        }
    }

    private Map<String, Object> initResultMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("success", true);
        result.put("message", "");
        return result;
    }

    @NotNull
    private StringBuilder genErrResult(List<CreateTaskRequest> paramList, List<CreateAndCalResult> resultList, Map<String, CreateTaskRequest> paramMap, Map<String, String> checkMsgMap) {
        StringBuilder errMsgSb = new StringBuilder();
        for (Map.Entry<String, String> msgEntry : checkMsgMap.entrySet()) {
            String uniqueCode = msgEntry.getKey();
            String errMsg = msgEntry.getValue();
            errMsgSb.append(errMsg);
            CreateTaskRequest errRequest = paramMap.get(uniqueCode);
            CreateAndCalResult errResult = new CreateAndCalResult(uniqueCode, errRequest.getPayrollGroupId(), errRequest.getPayrollSceneId(), errRequest.getPeriodId(), Boolean.FALSE, errMsg);
            resultList.add(errResult);
            paramList.remove(errRequest);
        }
        return errMsgSb;
    }

    private StringBuilder genErrResultForAddPerson(List<CreateTaskAddPersonRequest> paramList, List<CreateTaskAddPersonResult> resultList, Map<String, CreateTaskAddPersonRequest> paramMap, Map<String, String> checkMsgMap) {
        StringBuilder errMsgSb = new StringBuilder();
        for (Map.Entry<String, String> msgEntry : checkMsgMap.entrySet()) {
            String uniqueCode = msgEntry.getKey();
            String errMsg = msgEntry.getValue();
            errMsgSb.append(errMsg);
            CreateTaskAddPersonRequest errRequest = paramMap.get(uniqueCode);
            CreateTaskAddPersonResult errResult = new CreateTaskAddPersonResult(uniqueCode, null, errMsg);
            resultList.add(errResult);
            paramList.remove(errRequest);
        }
        return errMsgSb;
    }

    private StringBuilder genAddPersonErrResult(List<AddPersonRequest> paramList, List<AddPersonResult> resultList, Map<String, AddPersonRequest> paramMap, Map<String, String> checkMsgMap) {
        StringBuilder errMsgSb = new StringBuilder();
        for (Map.Entry<String, String> msgEntry : checkMsgMap.entrySet()) {
            String uniqueCode = msgEntry.getKey();
            String errMsg = msgEntry.getValue();
            errMsgSb.append(errMsg);
            AddPersonRequest errRequest = paramMap.get(uniqueCode);
            AddPersonResult errResult = new AddPersonResult(uniqueCode, errMsg);
            resultList.add(errResult);
            paramList.remove(errRequest);
        }
        return errMsgSb;
    }

    private <T> List<Map<String, Object>> convertToMap(List<T> resultList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(resultList.size());
        try {
            for (T result : resultList) {
                list.add(SWCJSONUtils.convertObjectToMap(result));
            }
        }
        catch (Exception exception) {
            logger.error("convertToMap error", (Throwable)exception);
        }
        return list;
    }
}

