/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class RptFilterSchemeUpdateService
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String sql = "select fschemeid,fformid,fschemename, fscheme,fmodifytime from t_bas_filterscheme where fformid = ?";
        Object[] params = new Object[]{"hsas_monthdeptsalsumrpt"};
        ArrayList updateParams = Lists.newArrayListWithExpectedSize((int)10);
        Timestamp modifyTime = new Timestamp(System.currentTimeMillis());
        DataSet schemeDataSet = DB.queryDataSet((String)"getSalaryRptFilterScheme", (DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        for (Row row : schemeDataSet) {
            Map fieldMap;
            Object orgObj;
            String schemeJson = row.getString("fscheme");
            Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
            String custFilters = (String)filterMap.get("custfilters");
            if (StringUtils.isEmpty((CharSequence)custFilters) || (orgObj = (fieldMap = (Map)SerializationUtils.fromJsonString((String)custFilters, HashMap.class)).get("org")) instanceof List) continue;
            Map orgMap = (Map)orgObj;
            ArrayList orgList = Lists.newArrayListWithCapacity((int)10);
            LinkedHashMap mulOrgMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            mulOrgMap.put("_Type_", "org");
            mulOrgMap.put("fbasedataid", orgMap);
            mulOrgMap.put("fbasedataid_id", orgMap.get("id"));
            orgList.add(mulOrgMap);
            fieldMap.put("org", orgList);
            custFilters = SerializationUtils.toJsonString((Object)fieldMap);
            filterMap.put("custfilters", custFilters);
            schemeJson = SerializationUtils.toJsonString((Object)filterMap);
            Object[] updateParam = new Object[]{schemeJson, modifyTime, row.get("fschemeid")};
            updateParams.add(updateParam);
        }
        TXHandle tx = TX.requiresNew();
        try {
            if (!CollectionUtils.isEmpty((Collection)updateParams)) {
                String updateSql = "UPDATE t_bas_filterscheme SET fscheme = ? ,fmodifytime = ? WHERE fschemeid = ? ";
                SWCDbUtil.executeBatch((DBRoute)DBRoute.basedata, (String)updateSql, (List)updateParams);
            }
        }
        catch (Exception ex) {
            tx.markRollback();
            throw ex;
        }
        finally {
            tx.close();
            schemeDataSet.close();
        }
        return new UpgradeResult();
    }
}

