/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class ApproveBillTaskUpdateService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ApproveBillTaskUpdateService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try {
            String sql = "select fid,fcaltaskid from t_hsas_approvebill where fcaltaskid != 0 ";
            DataSet dateSet = SWCDbUtil.queryDataSet((String)"ApproveBillTaskUpdateService", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[0]);
            HashMap<Long, Long> billTaskMap = new HashMap<Long, Long>(16);
            ArrayList<Object[]> billIdsParams = new ArrayList<Object[]>(10);
            while (dateSet.hasNext()) {
                Row orgRow = dateSet.next();
                Long billId = orgRow.getLong("fid");
                Long taskId = orgRow.getLong("fcaltaskid");
                billTaskMap.put(billId, taskId);
                billIdsParams.add(new Object[]{billId});
            }
            if (billTaskMap.size() == 0) {
                return null;
            }
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)"DELETE FROM T_HSAS_APPROVEBILLTASK WHERE FID = ?", billIdsParams);
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)this.getInsertFieldSql(), this.getInsertPayDetailFieldParam(billTaskMap));
        }
        catch (Exception exception) {
            log.error("CalResultTplOrgUpdateService error,", (Throwable)exception);
        }
        return null;
    }

    private String getInsertFieldSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(" INSERT INTO ").append("t_hsas_approvebilltask").append(" (FPKID,FID,FBASEDATAID)").append(" VALUES ").append(" (?,?,?) ");
        return sb.toString();
    }

    private List<Object[]> getInsertPayDetailFieldParam(Map<Long, Long> billTaskMap) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(billTaskMap.size());
        long[] ids = DB.genLongIds((String)"t_hsas_approvebilltask", (int)billTaskMap.size());
        int index = 0;
        for (Map.Entry<Long, Long> entry : billTaskMap.entrySet()) {
            Object[] param = new Object[]{ids[index], entry.getKey(), entry.getValue()};
            ++index;
            params.add(param);
        }
        return params;
    }
}

