/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;

public class CalListViewUpdateService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(CalListViewUpdateService.class);
    private Set<Long> needUpdateIds = new HashSet<Long>(16);
    private Map<Long, Set<Long>> needUpdateIdVidMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, String> fidFreezeMap = new HashMap<Long, String>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try {
            Long fid;
            Row row;
            String queryAllSql = "select  fid,fboid from t_hsas_callistview where fboid != 0 and fboid is not null";
            String queryIsFresszeColumSql = "select  fid,fisfreezecolumn,fsourcekey from t_hsas_callistviewentry where fseq = 4";
            String alreadyUpdateSql = "select  fid from t_hsas_callistviewentry where fsourcekey = 'hsas_calperson'";
            try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"CalListViewUpdateService", (DBRoute)SWCConstants.SWC_ROUETE, (String)queryAllSql, (Object[])new Object[0]);){
                while (dateSet.hasNext()) {
                    row = dateSet.next();
                    fid = row.getLong("fid");
                    Long fboid = row.getLong("fboid");
                    Set vids = this.needUpdateIdVidMap.computeIfAbsent(fboid, o -> new HashSet(16));
                    vids.add(fid);
                    this.needUpdateIds.add(fid);
                }
            }
            var9_11 = null;
            try (DataSet dateSet2 = SWCDbUtil.queryDataSet((String)"CalListViewUpdateService", (DBRoute)SWCConstants.SWC_ROUETE, (String)queryIsFresszeColumSql, (Object[])new Object[0]);){
                while (dateSet2.hasNext()) {
                    row = dateSet2.next();
                    fid = row.getLong("fid");
                    String isfreezecolumn = row.getString("fisfreezecolumn");
                    this.fidFreezeMap.put(fid, isfreezecolumn);
                }
            }
            catch (Throwable row2) {
                var9_11 = row2;
                throw row2;
            }
            var9_11 = null;
            try (DataSet dateSet3 = SWCDbUtil.queryDataSet((String)"CalListViewUpdateService", (DBRoute)SWCConstants.SWC_ROUETE, (String)alreadyUpdateSql, (Object[])new Object[0]);){
                while (dateSet3.hasNext()) {
                    row = dateSet3.next();
                    fid = row.getLong("fid");
                    this.needUpdateIds.remove(fid);
                    this.needUpdateIdVidMap.remove(fid);
                }
            }
            catch (Throwable row3) {
                var9_11 = row3;
                throw row3;
            }
            if (this.needUpdateIdVidMap.size() <= 0) {
                return null;
            }
            int size = this.needUpdateIds.size() * 10;
            ArrayList<Object[]> params = new ArrayList<Object[]>(size);
            ArrayList<Object[]> langParams = new ArrayList<Object[]>(size);
            long[] ids = DB.genLongIds((String)"t_hsas_callistviewentry", (int)size);
            String[] stringIds = DB.genStringIds((String)"t_hsas_callistviewentry_l", (int)(size * 2));
            int index = 0;
            for (Map.Entry<Long, Set<Long>> entry : this.needUpdateIdVidMap.entrySet()) {
                long[] entryBoidArr = Arrays.copyOfRange(ids, index, index + 10);
                String[] strPkArr = Arrays.copyOfRange(stringIds, index * 2, index * 2 + 20);
                index += 10;
                this.addParams(params, entry.getKey(), entryBoidArr, entryBoidArr);
                this.addLangParams(langParams, entryBoidArr, strPkArr);
                Set<Long> vids = entry.getValue();
                for (Long vid : vids) {
                    if (vid.equals(entry.getKey())) continue;
                    long[] entryIdArr = Arrays.copyOfRange(ids, index, index + 10);
                    String[] strPkArrv = Arrays.copyOfRange(stringIds, index * 2, index * 2 + 20);
                    this.addParams(params, vid, entryBoidArr, entryIdArr);
                    this.addLangParams(langParams, entryIdArr, strPkArrv);
                    index += 10;
                }
            }
            try (TXHandle txHandle = TX.required();){
                String insertSql = "INSERT INTO t_hsas_callistviewentry (fentryid,fid,fseq,fisfreezecolumn,fsourcekey,ffieldkey,fcalcolorid,fsort,fsortpriority,fisdisplay,ffieldname,fsource,ffield,fentryboid) VALUES \n(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                String insertLangSql = "INSERT INTO t_hsas_callistviewentry_l (fpkid,fentryid,flocaleid,ffieldname,fsource) VALUES (?,?,?,?,?)";
                if (!SWCListUtils.isEmpty(params)) {
                    SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertSql, params);
                }
                if (!SWCListUtils.isEmpty(langParams)) {
                    SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertLangSql, langParams);
                }
                StringBuilder updateSql = new StringBuilder("update t_hsas_callistviewentry set fseq = fseq + 10 where fid in (");
                Object[] fids = this.needUpdateIds.toArray();
                for (int i = 0; i < fids.length; ++i) {
                    updateSql.append('?');
                    if (i + 1 >= fids.length) continue;
                    updateSql.append(',');
                }
                updateSql.append(") and fsourcekey != 'hsas_calperson' and fseq > 3");
                SWCDbUtil.update((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql.toString(), (Object[])fids);
            }
        }
        catch (Exception exception) {
            log.error("CalListViewUpdateService error,", (Throwable)exception);
        }
        return null;
    }

    private void addParams(List<Object[]> params, Long fid, long[] entryBoidArr, long[] entryIdArr) {
        String isfreezecolumn = this.fidFreezeMap.get(fid) == null ? "0" : this.fidFreezeMap.get(fid);
        String personInfoDesc = ResManager.loadKDString((String)"\u6838\u7b97\u540d\u5355\u4fe1\u606f", (String)"CalListViewUpdateService_0", (String)"swc-hsas-mservice", (Object[])new Object[0]);
        params.add(new Object[]{entryIdArr[0], fid, 4, isfreezecolumn, "hsas_calperson", "donothing_viewcalresultform", 832553614320283648L, "0", "0", Character.valueOf('1'), ResManager.loadKDString((String)"\u8be6\u7ec6\u7ed3\u679c", (String)"CalListViewUpdateService_1", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc, "viewdetailresult", entryBoidArr[0]});
        params.add(new Object[]{entryIdArr[1], fid, 5, isfreezecolumn, "hsas_calperson", "viewcalpersonmark", 832553614320283648L, "0", "0", Character.valueOf('1'), ResManager.loadKDString((String)"\u6807\u8bb0", (String)"CalListViewUpdateService_2", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc, "calpersonmark", entryBoidArr[1]});
        params.add(new Object[]{entryIdArr[2], fid, 6, isfreezecolumn, "hsas_calperson", "isproration", 832553614320283648L, "0", "0", Character.valueOf('1'), ResManager.loadKDString((String)"\u662f\u5426\u5206\u6bb5", (String)"CalListViewUpdateService_3", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc, "isproration", entryBoidArr[2]});
        params.add(new Object[]{entryIdArr[3], fid, 7, isfreezecolumn, "hsas_calperson", "addfiletype", 832553614320283648L, "0", "0", Character.valueOf('1'), ResManager.loadKDString((String)"\u6dfb\u52a0\u65b9\u5f0f", (String)"CalListViewUpdateService_4", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc, "addfiletype", entryBoidArr[3]});
        params.add(new Object[]{entryIdArr[4], fid, 8, isfreezecolumn, "hsas_calperson", "onholdstatus", 832553614320283648L, "0", "0", Character.valueOf('1'), ResManager.loadKDString((String)"\u505c\u7f13\u53d1\u72b6\u6001", (String)"CalListViewUpdateService_5", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc, "onholdstatus", entryBoidArr[4]});
        params.add(new Object[]{entryIdArr[5], fid, 9, isfreezecolumn, "hsas_calperson", "calstatus", 832553614320283648L, "0", "0", Character.valueOf('1'), ResManager.loadKDString((String)"\u6838\u7b97\u72b6\u6001", (String)"CalListViewUpdateService_6", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc, "calstatus", entryBoidArr[5]});
        params.add(new Object[]{entryIdArr[6], fid, 10, isfreezecolumn, "hsas_calperson", "taxstatus", 832553614320283648L, "0", "0", Character.valueOf('1'), ResManager.loadKDString((String)"\u4e2a\u7a0e\u6570\u636e\u72b6\u6001", (String)"CalListViewUpdateService_7", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc, "taxstatus", entryBoidArr[6]});
        params.add(new Object[]{entryIdArr[7], fid, 11, isfreezecolumn, "hsas_calperson", "paystatus", 832553614320283648L, "0", "0", Character.valueOf('1'), ResManager.loadKDString((String)"\u53d1\u653e\u72b6\u6001", (String)"CalListViewUpdateService_8", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc, "paystatus", entryBoidArr[7]});
        params.add(new Object[]{entryIdArr[8], fid, 12, isfreezecolumn, "hsas_calperson", "allotstatus", 832553614320283648L, "0", "0", Character.valueOf('1'), ResManager.loadKDString((String)"\u5206\u644a\u72b6\u6001", (String)"CalListViewUpdateService_9", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc, "allotstatus", entryBoidArr[8]});
        params.add(new Object[]{entryIdArr[9], fid, 13, isfreezecolumn, "hsas_calperson", "salarystatus", 832553614320283648L, "0", "0", Character.valueOf('1'), ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u72b6\u6001", (String)"CalListViewUpdateService_10", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc, "salarystatus", entryBoidArr[9]});
    }

    private void addLangParams(List<Object[]> params, long[] entryIdArr, String[] stringsIdArr) {
        String personInfoDesc = ResManager.loadKDString((String)"\u6838\u7b97\u540d\u5355\u4fe1\u606f", (String)"CalListViewUpdateService_0", (String)"swc-hsas-mservice", (Object[])new Object[0]);
        params.add(new Object[]{stringsIdArr[0], entryIdArr[0], "zh_CN", ResManager.loadKDString((String)"\u8be6\u7ec6\u7ed3\u679c", (String)"CalListViewUpdateService_1", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc});
        params.add(new Object[]{stringsIdArr[1], entryIdArr[1], "zh_CN", ResManager.loadKDString((String)"\u6807\u8bb0", (String)"CalListViewUpdateService_2", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc});
        params.add(new Object[]{stringsIdArr[2], entryIdArr[2], "zh_CN", ResManager.loadKDString((String)"\u662f\u5426\u5206\u6bb5", (String)"CalListViewUpdateService_3", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc});
        params.add(new Object[]{stringsIdArr[3], entryIdArr[3], "zh_CN", ResManager.loadKDString((String)"\u6dfb\u52a0\u65b9\u5f0f", (String)"CalListViewUpdateService_4", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc});
        params.add(new Object[]{stringsIdArr[4], entryIdArr[4], "zh_CN", ResManager.loadKDString((String)"\u505c\u7f13\u53d1\u72b6\u6001", (String)"CalListViewUpdateService_5", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc});
        params.add(new Object[]{stringsIdArr[5], entryIdArr[5], "zh_CN", ResManager.loadKDString((String)"\u6838\u7b97\u72b6\u6001", (String)"CalListViewUpdateService_6", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc});
        params.add(new Object[]{stringsIdArr[6], entryIdArr[6], "zh_CN", ResManager.loadKDString((String)"\u4e2a\u7a0e\u6570\u636e\u72b6\u6001", (String)"CalListViewUpdateService_7", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc});
        params.add(new Object[]{stringsIdArr[7], entryIdArr[7], "zh_CN", ResManager.loadKDString((String)"\u53d1\u653e\u72b6\u6001", (String)"CalListViewUpdateService_8", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc});
        params.add(new Object[]{stringsIdArr[8], entryIdArr[8], "zh_CN", ResManager.loadKDString((String)"\u5206\u644a\u72b6\u6001", (String)"CalListViewUpdateService_9", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc});
        params.add(new Object[]{stringsIdArr[9], entryIdArr[9], "zh_CN", ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u72b6\u6001", (String)"CalListViewUpdateService_10", (String)"swc-hsas-mservice", (Object[])new Object[0]), personInfoDesc});
        params.add(new Object[]{stringsIdArr[10], entryIdArr[0], "en_US", "Result Details", "Accounting List Information"});
        params.add(new Object[]{stringsIdArr[11], entryIdArr[1], "en_US", "Mark", "Accounting List Information"});
        params.add(new Object[]{stringsIdArr[12], entryIdArr[2], "en_US", "Segmentation", "Accounting List Information"});
        params.add(new Object[]{stringsIdArr[13], entryIdArr[3], "en_US", "Add Method", "Accounting List Information"});
        params.add(new Object[]{stringsIdArr[14], entryIdArr[4], "en_US", "Salary Deferral Status", "Accounting List Information"});
        params.add(new Object[]{stringsIdArr[15], entryIdArr[5], "en_US", "Calculation Status", "Accounting List Information"});
        params.add(new Object[]{stringsIdArr[16], entryIdArr[6], "en_US", "Tax Data Entry Status", "Accounting List Information"});
        params.add(new Object[]{stringsIdArr[17], entryIdArr[7], "en_US", "Payment Status", "Accounting List Information"});
        params.add(new Object[]{stringsIdArr[18], entryIdArr[8], "en_US", "Allocation Status", "Accounting List Information"});
        params.add(new Object[]{stringsIdArr[19], entryIdArr[9], "en_US", "Payslip Status", "Accounting List Information"});
    }
}

