/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsas.common.enums.PresetItemEnum;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.entity.SWCI18NParam;
import kd.swc.hsbp.common.util.SWCDbUtil;
import org.apache.commons.collections.CollectionUtils;

public class MigrationDataUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(MigrationDataUpdateService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            this.updateMigrationTemplateData();
            this.updateImportTaskData();
            this.updateVerifyRecord();
        }
        return null;
    }

    private void updateMigrationTemplateData() {
        List<Long> migrationTemplateIdList = this.getUpdateMigrationTemplateIdList();
        if (CollectionUtils.isNotEmpty(migrationTemplateIdList)) {
            int insertCount = migrationTemplateIdList.size() * 2;
            ArrayList<Object[]> insertEntryParamsList = new ArrayList<Object[]>(insertCount);
            ArrayList<Object[]> insertEntryLParamsList = new ArrayList<Object[]>(insertCount * 3);
            String fidConditionSql = this.getPlaceHolderConditionSql(migrationTemplateIdList.size());
            Object[] idParams = migrationTemplateIdList.toArray();
            this.createConidtionAndParams(migrationTemplateIdList, insertEntryParamsList, insertEntryLParamsList);
            StringBuilder updateSqlBuilder = new StringBuilder();
            updateSqlBuilder.append("update t_hsas_migrationtpl set fwritetasktype = '1' where fid in ");
            updateSqlBuilder.append(fidConditionSql);
            SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSqlBuilder.toString(), (Object[])idParams);
            StringBuilder updateEntrySqlBuilder = new StringBuilder();
            updateEntrySqlBuilder.append("update t_hsas_migrationtplent set fseq = fseq + 3 where fitemtype != '0' and fid in ");
            updateEntrySqlBuilder.append(fidConditionSql);
            SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateEntrySqlBuilder.toString(), (Object[])idParams);
            String insertEntrySql = "insert into t_hsas_migrationtplent(fentryid,fid,fseq,fmatchcolumn,fitemtype,fitemid,fitemnumber,fdatatypeid,fcomment) values(?,?,?,?,?,?,?,?,?)";
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertEntrySql, insertEntryParamsList);
            String insertEntryLSql = "insert into t_hsas_migrationtplent_l(fpkid, fentryid, flocaleid, fcomment) values(?,?,?,?)";
            SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertEntryLSql, insertEntryLParamsList);
        }
        String updateOldEntry = "update t_hsas_migrationtplent set fcomment = ? where fitemid = ?";
        String updateOldEntryL = "update t_hsas_migrationtplent_l set fcomment = ? where fentryid in (select m.fentryid from t_hsas_migrationtplent m where m.fitemid = ?) and flocaleid = 'zh_CN'";
        Object[] updateParams = new Object[]{PresetItemEnum.SALARYFILE_NUMBER.getComment().getLocaleString().get((Object)"zh_CN"), PresetItemEnum.SALARYFILE_NUMBER.getItemId()};
        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateOldEntry, (Object[])updateParams);
        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateOldEntryL, (Object[])updateParams);
        updateParams[0] = PresetItemEnum.CALTASK.getComment().getLocaleString().get((Object)"zh_CN");
        updateParams[1] = PresetItemEnum.CALTASK.getItemId();
        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateOldEntry, (Object[])updateParams);
        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateOldEntryL, (Object[])updateParams);
        updateOldEntryL = "update t_hsas_migrationtplent_l set fcomment = ? where fentryid in (select m.fentryid from t_hsas_migrationtplent m where m.fitemid = ?) and flocaleid = 'zh_TW'";
        updateParams[0] = PresetItemEnum.SALARYFILE_NUMBER.getComment().getLocaleString().get((Object)"zh_TW");
        updateParams[1] = PresetItemEnum.SALARYFILE_NUMBER.getItemId();
        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateOldEntryL, (Object[])updateParams);
        updateParams[0] = PresetItemEnum.CALTASK.getComment().getLocaleString().get((Object)"zh_TW");
        updateParams[1] = PresetItemEnum.CALTASK.getItemId();
        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateOldEntryL, (Object[])updateParams);
        updateOldEntryL = "update t_hsas_migrationtplent_l set fcomment = ? where fentryid in (select m.fentryid from t_hsas_migrationtplent m where m.fitemid = ?) and flocaleid = 'en_US'";
        updateParams[0] = PresetItemEnum.SALARYFILE_NUMBER.getComment().getLocaleString().get((Object)"en_US");
        updateParams[1] = PresetItemEnum.SALARYFILE_NUMBER.getItemId();
        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateOldEntryL, (Object[])updateParams);
        updateParams[0] = PresetItemEnum.CALTASK.getComment().getLocaleString().get((Object)"en_US");
        updateParams[1] = PresetItemEnum.CALTASK.getItemId();
        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateOldEntryL, (Object[])updateParams);
        this.replenishEntryL(migrationTemplateIdList);
    }

    private void replenishEntryL(List<Long> migrationTemplateIdList) {
        if (CollectionUtils.isEmpty(migrationTemplateIdList)) {
            return;
        }
        String selectSql = "select fentryid,fitemid from t_hsas_migrationtplent where fitemtype = '0' and fid in ";
        selectSql = selectSql + this.getPlaceHolderConditionSql(migrationTemplateIdList.size());
        HashMap<Long, Long> entryItemIdMap = new HashMap<Long, Long>(16);
        try (DataSet dataSet = SWCDbUtil.queryDataSet((String)"queryMigrationTemplateEntryService", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectSql, (Object[])migrationTemplateIdList.toArray());){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                entryItemIdMap.put(row.getLong("fentryid"), row.getLong("fitemid"));
            }
        }
        if (entryItemIdMap.isEmpty()) {
            return;
        }
        Map<Long, Set<String>> entryLMap = this.collectReplenishEntryLData(entryItemIdMap);
        if (entryLMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> insertEntryLParamsList = new ArrayList<Object[]>(entryLMap.size() * 3);
        String[] pkIds = DB.genStringIds((String)"t_hsas_migrationtplent_l", (int)(entryLMap.size() * 3));
        Map<Long, SWCI18NParam> presetItemMap = Arrays.stream(PresetItemEnum.values()).collect(Collectors.toMap(PresetItemEnum::getItemId, PresetItemEnum::getComment));
        int index = 0;
        for (Map.Entry<Long, Set<String>> entry : entryLMap.entrySet()) {
            Long itemId = (Long)entryItemIdMap.get(entry.getKey());
            SWCI18NParam comment = presetItemMap.get(itemId);
            String cnValue = (String)comment.getLocaleString().get((Object)"zh_CN");
            for (String localString : entry.getValue()) {
                Object[] params = new Object[]{pkIds[index], entry.getKey(), localString, comment.getLocaleString().get((Object)localString)};
                if (params[3] == null) {
                    params[3] = cnValue;
                }
                insertEntryLParamsList.add(params);
                ++index;
            }
        }
        String insertEntryLSql = "insert into t_hsas_migrationtplent_l(fpkid, fentryid, flocaleid, fcomment) values(?,?,?,?)";
        SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertEntryLSql, insertEntryLParamsList);
    }

    private Map<Long, Set<String>> collectReplenishEntryLData(Map<Long, Long> entryItemIdMap) {
        String selectSql = "select fentryid,flocaleid from t_hsas_migrationtplent_l where fentryid in ";
        selectSql = selectSql + this.getPlaceHolderConditionSql(entryItemIdMap.size());
        HashMap<Long, Set<String>> entryLMap = new HashMap<Long, Set<String>>(entryItemIdMap.size());
        HashSet<String> defaultLangSet = new HashSet<String>(3);
        defaultLangSet.add("zh_CN");
        defaultLangSet.add("zh_TW");
        defaultLangSet.add("en_US");
        for (Long entryId : entryItemIdMap.keySet()) {
            HashSet<String> langSet = new HashSet<String>(3);
            langSet.addAll(defaultLangSet);
            entryLMap.put(entryId, langSet);
        }
        try (DataSet dataSet = SWCDbUtil.queryDataSet((String)"queryMigrationTemplateEntryLService", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectSql, (Object[])entryItemIdMap.keySet().toArray());){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Set langSet = (Set)entryLMap.get(row.getLong("fentryid"));
                if (!CollectionUtils.isEmpty((Collection)langSet)) {
                    langSet.remove(row.getString("flocaleid"));
                }
                if (!CollectionUtils.isEmpty((Collection)langSet)) continue;
                entryLMap.remove(row.getLong("fentryid"));
            }
        }
        return entryLMap;
    }

    private void createConidtionAndParams(List<Long> migrationTemplateIdList, List<Object[]> insertEntryParamsList, List<Object[]> insertEntryLParamsList) {
        int insertCount = migrationTemplateIdList.size() * 2;
        long[] entryIds = DB.genLongIds((String)"t_hsas_migrationtplent", (int)insertCount);
        String[] pkIds = DB.genStringIds((String)"t_hsas_migrationtplent_l", (int)(insertCount * 3));
        int idIndex = 0;
        for (int index = 0; index < migrationTemplateIdList.size(); ++index) {
            Long migrationTemplateId = migrationTemplateIdList.get(index);
            Object[] jParams = new Object[]{entryIds[idIndex], migrationTemplateId, 10, PresetItemEnum.ADMINORG.getMatchColumn(), "0", PresetItemEnum.ADMINORG.getItemId(), "-", PresetItemEnum.ADMINORG.getDataTypeId(), PresetItemEnum.ADMINORG.getComment().getLocaleString().get((Object)"zh_CN")};
            insertEntryParamsList.add(jParams);
            Object[] jLParams = new Object[]{pkIds[idIndex * 3], entryIds[idIndex], "zh_CN", PresetItemEnum.ADMINORG.getComment().getLocaleString().get((Object)"zh_CN")};
            insertEntryLParamsList.add(jLParams);
            Object cnValue = jParams[3];
            jLParams = new Object[]{pkIds[idIndex * 3 + 1], entryIds[idIndex], "zh_TW", PresetItemEnum.ADMINORG.getComment().getLocaleString().get((Object)"zh_TW")};
            if (jLParams[3] == null) {
                jLParams[3] = cnValue;
            }
            insertEntryLParamsList.add(jLParams);
            jLParams = new Object[]{pkIds[idIndex * 3 + 2], entryIds[idIndex], "en_US", PresetItemEnum.ADMINORG.getComment().getLocaleString().get((Object)"en_US")};
            if (jLParams[3] == null) {
                jLParams[3] = cnValue;
            }
            insertEntryLParamsList.add(jLParams);
            Object[] kParams = new Object[]{entryIds[++idIndex], migrationTemplateId, 11, PresetItemEnum.EMPGROUP.getMatchColumn(), "0", PresetItemEnum.EMPGROUP.getItemId(), "-", PresetItemEnum.EMPGROUP.getDataTypeId(), PresetItemEnum.EMPGROUP.getComment().getLocaleString().get((Object)"zh_CN")};
            insertEntryParamsList.add(kParams);
            Object[] kLParams = new Object[]{pkIds[idIndex * 3], entryIds[idIndex], "zh_CN", PresetItemEnum.EMPGROUP.getComment().getLocaleString().get((Object)"zh_CN")};
            insertEntryLParamsList.add(kLParams);
            cnValue = kLParams[3];
            kLParams = new Object[]{pkIds[idIndex * 3 + 1], entryIds[idIndex], "zh_TW", PresetItemEnum.EMPGROUP.getComment().getLocaleString().get((Object)"zh_TW")};
            if (kLParams[3] == null) {
                kLParams[3] = cnValue;
            }
            insertEntryLParamsList.add(kLParams);
            kLParams = new Object[]{pkIds[idIndex * 3 + 2], entryIds[idIndex], "en_US", PresetItemEnum.EMPGROUP.getComment().getLocaleString().get((Object)"en_US")};
            if (kLParams[3] == null) {
                kLParams[3] = cnValue;
            }
            insertEntryLParamsList.add(kLParams);
            ++idIndex;
        }
    }

    private List<Long> getUpdateMigrationTemplateIdList() {
        ArrayList<Long> migrationTemplateIdList = new ArrayList<Long>(10);
        String selectSql = "select fid from t_hsas_migrationtpl where fwritetasktype is null or fwritetasktype = '' or fwritetasktype = ' '";
        try (DataSet dataSet = SWCDbUtil.queryDataSet((String)"queryUpdateMigrationTemplateDataService", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectSql, (Object[])new Object[0]);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                migrationTemplateIdList.add(row.getLong("fid"));
            }
        }
        return migrationTemplateIdList;
    }

    private void updateImportTaskData() {
        List<Long> importTaskIdList = this.getUpdateImportTaskIdList();
        if (CollectionUtils.isEmpty(importTaskIdList)) {
            return;
        }
        this.updateImportTask(importTaskIdList);
    }

    private List<Long> getUpdateImportTaskIdList() {
        ArrayList<Long> importTaskIdList = new ArrayList<Long>(10);
        String selectSql = "select fid from t_hsas_importtask where fwritetasktype is null or fwritetasktype = '' or fwritetasktype = ' '";
        try (DataSet dataSet = SWCDbUtil.queryDataSet((String)"queryUpdateImportTaskDataService", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectSql, (Object[])new Object[0]);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                importTaskIdList.add(row.getLong("fid"));
            }
        }
        return importTaskIdList;
    }

    private void updateImportTask(List<Long> importTaskIdList) {
        HashMap<Long, Integer> importTaskCountMap = new HashMap<Long, Integer>(importTaskIdList.size());
        StringBuilder selectSqlBuilder = new StringBuilder();
        selectSqlBuilder.append("select fimporttaskid from t_hsas_temporarydata where fimporttaskid in ");
        selectSqlBuilder.append(this.getPlaceHolderConditionSql(importTaskIdList.size()));
        DataSet dataSet = SWCDbUtil.queryDataSet((String)"queryUpdateTemporaryDataService", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectSqlBuilder.toString(), (Object[])importTaskIdList.toArray());
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long importTaskId = row.getLong("fimporttaskid");
                Integer importTaskCount = importTaskCountMap.computeIfAbsent(importTaskId, key -> 0);
                importTaskCountMap.put(importTaskId, importTaskCount + 1);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(importTaskIdList.size());
        for (Long importTaskId : importTaskIdList) {
            Object[] params = new Object[]{importTaskCountMap.computeIfAbsent(importTaskId, key -> 0), importTaskId};
            paramsList.add(params);
        }
        StringBuilder updateSqlBuilder = new StringBuilder();
        updateSqlBuilder.append("update t_hsas_importtask set fwritetasktype = '1',fcount = ? where fid = ?");
        SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSqlBuilder.toString(), paramsList);
    }

    private String getPlaceHolderConditionSql(int count) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('?');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private void updateVerifyRecord() {
        String updateSql = "update t_hsas_verifyrecord set foperationtype = '1' where foperationtype is null or foperationtype = '' or foperationtype = ' '";
        SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, (Object[])new Object[0]);
    }
}

