/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.constants.SWCBaseConstants;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class SalaryFileDepEmpUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SalaryFileDepEmpUpdateService.class);
    private static final String QUERY_SQL = "SELECT  DISTINCT   REL.FID AS FID,  1 AS FSEQ,  DEP.FID AS FWORKROLEID,  DEP.FSTARTDATE AS FPAYSTARTDATE,  DEP.FENDDATE AS FPAYENDDATE,  '1' AS FISMAINWORKROLE FROM  T_HSAS_SALARYFILE T LEFT JOIN T_HSAS_EMPPOSORGREL REL ON T.FBOID = REL.FSALARYFILEID LEFT JOIN T_HSAS_EMPPOSORGRELHR EMP ON T.FEMPPOSINFOID = EMP.FID LEFT JOIN T_HSAS_DEPEMP DEP ON DEP.FID = EMP.FDEPEMPID LEFT JOIN T_HSAS_EMPPOSORGRELENT ENT ON EMP.FDEPEMPID = ENT.fworkroleid  and REL.FID = ENT.FID WHERE  T.FDATASTATUS IN ('0', '1', '2', '-3')  AND (REL.FID != 0 AND REL.FID IS NOT NULL)  AND (DEP.FID != 0 AND DEP.FID IS NOT NULL)  AND (EMP.FID != 0 AND EMP.FID is not NULL)  AND ENT.fentryid IS null";
    private static final String UPDATE_SQL = "UPDATE T_HSAS_SALARYFILE T SET FDEPEMPID = (SELECT CASE EMP.FDEPEMPID WHEN NULL THEN 0 ELSE EMP.FDEPEMPID END FROM T_HSAS_EMPPOSORGRELHR EMP WHERE T.FEMPPOSINFOID = EMP.FID ) WHERE (T.FDEPEMPID = 0 OR T.FDEPEMPID IS NULL)AND T.FEMPPOSINFOID IN ( SELECT EMPD.FID FROM T_HSAS_EMPPOSORGRELHR EMPD )";
    private static final String INSERT_SQL = "INSERT INTO T_HSAS_EMPPOSORGRELENT(FID,FENTRYID,FSEQ,FWORKROLEID,FPAYSTARTDATE,FPAYENDDATE,FISMAINWORKROLE) VALUES(?,?,?,?,?,?,?)";
    private static final String UPDATE_PAY_END_DATE_SQL = "UPDATE T_HSAS_EMPPOSORGRELENT SET FPAYENDDATE = {ts'2999-12-31 00:00:00'} WHERE FPAYENDDATE IS NULL";
    private static final String QUERY_PAYSTART_DATE = "SELECT FID,FENTRYID,FPAYSTARTDATE FROM T_HSAS_EMPPOSORGRELENT";
    private static final String UPDATE_PAY_START_DATE_SQL = "UPDATE T_HSAS_EMPPOSORGRELENT SET FPAYSTARTDATE = ? WHERE FENTRYID = ?";

    private void execute() {
        this.updateSalaryDatas();
        List<Object[]> insertDepEmpList = this.getInsertDepEmpList();
        if (!CollectionUtils.isEmpty(insertDepEmpList)) {
            logger.info("[salaryfileupdate]: 3.  insertDepEmpList.size = {}", (Object)insertDepEmpList.size());
            this.setEnetryIds(insertDepEmpList);
            SWCDbUtil.executeBatch((DBRoute)SWCBaseConstants.DB_ROUTE_SWC, (String)INSERT_SQL, insertDepEmpList);
        }
        SWCDbUtil.update((DBRoute)SWCBaseConstants.DB_ROUTE_SWC, (String)UPDATE_PAY_END_DATE_SQL, null);
        this.updatePayStartDate();
    }

    private void updatePayStartDate() {
        ArrayList<Object[]> result = new ArrayList<Object[]>(10);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"updatePayStartDate", (DBRoute)SWCConstants.SWC_ROUETE, (String)QUERY_PAYSTART_DATE, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long fid = row.getLong("FID");
                Long fentryid = row.getLong("FENTRYID");
                Date fpayStartDate = row.getDate("FPAYSTARTDATE");
                if (fpayStartDate == null) continue;
                int hours = fpayStartDate.getHours();
                int minutes = fpayStartDate.getMinutes();
                int seconds = fpayStartDate.getSeconds();
                if (hours == 0 && minutes == 0 && seconds == 0) continue;
                fpayStartDate = SWCDateTimeUtils.getDayDate((Date)fpayStartDate);
                Object[] temp = new Object[]{fpayStartDate, fentryid};
                result.add(temp);
            }
        }
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        SWCDbUtil.executeBatch((DBRoute)DBRoute.of((String)"swc"), (String)UPDATE_PAY_START_DATE_SQL, result);
    }

    private void updateSalaryDatas() {
        SWCDbUtil.update((DBRoute)SWCBaseConstants.DB_ROUTE_SWC, (String)UPDATE_SQL, null);
    }

    private void setEnetryIds(List<Object[]> insertDepEmpList) {
        long[] ids = DB.genLongIds((String)"T_HSAS_EMPPOSORGRELENT", (int)insertDepEmpList.size());
        for (int i = 0; i < insertDepEmpList.size(); ++i) {
            Object[] objects = insertDepEmpList.get(i);
            objects[1] = ids[i];
        }
    }

    private List<Object[]> getInsertDepEmpList() {
        ArrayList<Object[]> result = new ArrayList<Object[]>(10);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"getInsertDepEmpList", (DBRoute)SWCConstants.SWC_ROUETE, (String)QUERY_SQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long fid = row.getLong("FID");
                Integer fseq = row.getInteger("FSEQ");
                Long fworkrRoleId = row.getLong("FWORKROLEID");
                Date fpayStartDate = row.getDate("FPAYSTARTDATE");
                Date fpayEndDate = row.getDate("FPAYENDDATE");
                if (fpayEndDate == null) {
                    fpayEndDate = this.getMaxDate();
                }
                fpayStartDate = SWCDateTimeUtils.getDayDate((Date)fpayStartDate);
                String fisMainWorkRole = row.getString("FISMAINWORKROLE");
                Object[] temp = new Object[]{fid, null, fseq, fworkrRoleId, fpayStartDate, fpayEndDate, fisMainWorkRole};
                result.add(temp);
            }
        }
        return result;
    }

    private Date getMaxDate() {
        Timestamp endDate = Timestamp.valueOf("2999-12-31 00:00:00");
        return endDate;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("[salaryfileupdate]: 1. SalaryFileDepEmpUpdateService begin");
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        this.execute();
        logger.info("[salaryfileupdate]: 2. SalaryFileDepEmpUpdateService end");
        return upgradeResult;
    }
}

