/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update.thread;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CountDownLatch;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class PayDetailUpdateBySqlService
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(PayDetailUpdateBySqlService.class);
    private CountDownLatch countDownLatch;
    private List<Long> calTableIds;

    public PayDetailUpdateBySqlService(CountDownLatch countDownLatch, List<Long> calTabIdList) {
        this.countDownLatch = countDownLatch;
        this.calTableIds = calTabIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String caltaskSql = "select fid,fcaltaskid from t_hsas_caltable where fid in (" + this.getParamIndex(this.calTableIds.size()) + ")";
            Map calTaskAndTabMap = (Map)SWCDbUtil.query((DBRoute)SWCConstants.SWC_ROUETE, (String)caltaskSql, (Object[])this.calTableIds.toArray(), (ResultSetHandler)new ResultSetHandler<Map<Long, Set<Long>>>(){

                public Map<Long, Set<Long>> handle(ResultSet rs) throws Exception {
                    HashMap<Long, Set<Long>> resMap = new HashMap<Long, Set<Long>>(16);
                    while (rs.next()) {
                        long fcaltaskid = rs.getLong("fcaltaskid");
                        HashSet<Long> set = (HashSet<Long>)resMap.get(fcaltaskid);
                        if (set == null) {
                            set = new HashSet<Long>(16);
                        }
                        set.add(rs.getLong("fid"));
                        resMap.put(fcaltaskid, set);
                    }
                    return resMap;
                }
            });
            for (Map.Entry calTaskAndTabEntry : calTaskAndTabMap.entrySet()) {
                Long calTaskId = (Long)calTaskAndTabEntry.getKey();
                Set calTabIds = (Set)calTaskAndTabEntry.getValue();
                String updateSqL = "update t_hsas_paydetail set fcaltaskid = ? where fcaltableid in(" + this.getParamIndex(calTabIds.size()) + ")";
                ArrayList<Long> params = new ArrayList<Long>(calTabIds.size() + 1);
                params.add(calTaskId);
                params.addAll(calTabIds);
                SWCDbUtil.update((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSqL, (Object[])params.toArray());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    private String getParamIndex(int size) {
        StringJoiner sj = new StringJoiner(",");
        for (int i = 0; i < size; ++i) {
            sj.add("?");
        }
        return sj.toString();
    }
}

