/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update.thread;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class PaydetailBankOfferService
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(PaydetailBankOfferService.class);
    private CountDownLatch countDownLatch;
    private List<Long> idList;

    public PaydetailBankOfferService(CountDownLatch countDownLatch, List<Long> idList) {
        this.countDownLatch = countDownLatch;
        this.idList = idList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            HashSet<Long> set = this.queryPayDetailAIds();
            ArrayList<Object[]> insertList = new ArrayList<Object[]>(10);
            for (Long id : this.idList) {
                if (!set.isEmpty() && set.contains(id)) continue;
                Object[] insertData = new Object[]{id, "1"};
                insertList.add(insertData);
            }
            try (TXHandle txHandle = TX.required();){
                this.insertData(insertList);
            }
        }
        catch (Exception e) {
            LOGGER.error("error:", (Throwable)e);
        }
        finally {
            LOGGER.info("update success{}", (Object)Thread.currentThread().getName());
            this.countDownLatch.countDown();
        }
    }

    private HashSet<Long> queryPayDetailAIds() {
        int paramSize = this.idList.size();
        HashSet<Long> set = new HashSet<Long>(16);
        StringBuilder selectSql = new StringBuilder("SELECT FID FROM T_HSAS_PAYDETAIL_B where FID in (");
        for (int i = 0; i < paramSize; ++i) {
            if (i != paramSize - 1) {
                selectSql.append('?').append(',');
                continue;
            }
            selectSql.append('?');
            selectSql.append(')');
        }
        DataSet dataSet = SWCDbUtil.queryDataSet((String)"payDetailAService", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectSql.toString(), (Object[])this.idList.toArray(new Object[0]));
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            set.add(row.getLong("FID"));
        }
        return set;
    }

    private void insertData(List<Object[]> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        String insertSql = "INSERT INTO T_HSAS_PAYDETAIL_B(FID,FBANKOFFERSTATUS) VALUES (?,?)";
        SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertSql, params);
    }
}

