/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update.thread;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class PaydetailPayrollDateUpdateService
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(PaydetailPayrollDateUpdateService.class);
    private CountDownLatch countDownLatch;
    private List<Long> idList;
    private Map<Long, Date> payrollDateMap;

    public PaydetailPayrollDateUpdateService(CountDownLatch countDownLatch, List<Long> idList, Map<Long, Date> payrollDateMap) {
        this.countDownLatch = countDownLatch;
        this.idList = idList;
        this.payrollDateMap = payrollDateMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Map<Long, Object[]> longObjectMap = this.queryPayDetail();
            HashSet<Long> set = this.queryPayDetailAIds();
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> insertList = new ArrayList<Object[]>(10);
            for (Map.Entry<Long, Object[]> entry : longObjectMap.entrySet()) {
                Long key = entry.getKey();
                Object[] value = entry.getValue();
                Long id = (Long)value[this.getIntOne()];
                if (value[0] == null) {
                    Date payrolldate = this.payrollDateMap.get(id);
                    if (payrolldate == null) {
                        try {
                            payrolldate = SWCDateTimeUtils.parseDate((String)"1900-01-01");
                            updateList.add(new Object[]{payrolldate, key});
                        }
                        catch (Exception e) {
                            LOGGER.error("error:", (Throwable)e);
                        }
                    } else {
                        updateList.add(new Object[]{payrolldate, key});
                    }
                }
                if (!set.isEmpty() && set.contains(key)) continue;
                Object[] insertData = Arrays.copyOfRange(value, 2, value.length);
                insertList.add(insertData);
            }
            try (TXHandle txHandle = TX.required();){
                this.updateData(updateList);
                this.insertData(insertList);
            }
        }
        catch (Exception e) {
            LOGGER.error("error:", (Throwable)e);
        }
        finally {
            LOGGER.info("update success{}", (Object)Thread.currentThread().getName());
            this.countDownLatch.countDown();
        }
    }

    private Map<Long, Object[]> queryPayDetail() {
        int paramSize = this.idList.size();
        HashMap<Long, Object[]> map = new HashMap<Long, Object[]>(16);
        StringBuilder selectSql = new StringBuilder("SELECT FPAYROLLDATE,FID,FCALTASKID,FENTRYDATE,FREGULARDATE,FQUITDATE,FEXRATE,FEXRATETABLEID,FEXRATEID").append(",FEXRATEDATE FROM T_HSAS_PAYDETAIL where FID in (");
        for (int i = 0; i < paramSize; ++i) {
            if (i != paramSize - 1) {
                selectSql.append('?').append(',');
                continue;
            }
            selectSql.append('?');
            selectSql.append(')');
        }
        DataSet dataSet = SWCDbUtil.queryDataSet((String)"payDetailUpgradeService", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectSql.toString(), (Object[])this.idList.toArray(new Object[0]));
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Date fpayrolldate = row.getDate("FPAYROLLDATE");
            long fid = row.getLong("FID");
            long fcaltaskid = row.getLong("FCALTASKID");
            Date fentrydate = row.getDate("FENTRYDATE");
            Date fregulardate = row.getDate("FREGULARDATE");
            Date fquitdate = row.getDate("FQUITDATE");
            BigDecimal fexrate = row.getBigDecimal("FEXRATE");
            long fexratetableid = row.getLong("FEXRATETABLEID");
            long fexrateid = row.getLong("FEXRATEID");
            Date fexratedate = row.getDate("FEXRATEDATE");
            Object[] o = new Object[]{fpayrolldate, fcaltaskid, fid, fentrydate, fregulardate, fquitdate, fexrate, fexratetableid, fexrateid, fexratedate};
            map.put(fid, o);
        }
        return map;
    }

    private HashSet<Long> queryPayDetailAIds() {
        int paramSize = this.idList.size();
        HashSet<Long> set = new HashSet<Long>(16);
        StringBuilder selectSql = new StringBuilder("SELECT FID FROM T_HSAS_PAYDETAIL_A where FID in (");
        for (int i = 0; i < paramSize; ++i) {
            if (i != paramSize - 1) {
                selectSql.append('?').append(',');
                continue;
            }
            selectSql.append('?');
            selectSql.append(')');
        }
        DataSet dataSet = SWCDbUtil.queryDataSet((String)"payDetailAService", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectSql.toString(), (Object[])this.idList.toArray(new Object[0]));
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            set.add(row.getLong("FID"));
        }
        return set;
    }

    private void updateData(List<Object[]> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        String updateSql = "UPDATE T_HSAS_PAYDETAIL SET FPAYROLLDATE = ? WHERE FID = ?;";
        SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, params);
    }

    private void insertData(List<Object[]> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        String insertSql = "INSERT INTO T_HSAS_PAYDETAIL_A(FID,FENTRYDATE,FREGULARDATE,FQUITDATE,FEXRATE,FEXRATETABLEID,FEXRATEID,FEXRATEDATE) VALUES (?,?,?,?,?,?,?,?)";
        SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertSql, params);
    }

    private int getIntOne() {
        return 1;
    }
}

