/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update.thread;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class PaydetailUpdateService
implements Runnable {
    private CountDownLatch countDownLatch;
    private List<Long> caltableIdList;
    private DynamicObject[] details;

    public PaydetailUpdateService(CountDownLatch countDownLatch, List<Long> caltableIdList, DynamicObject[] details) {
        this.countDownLatch = countDownLatch;
        this.caltableIdList = caltableIdList;
        this.details = details;
    }

    @Override
    public void run() {
        long calTableId;
        SWCDataServiceHelper calHelper = new SWCDataServiceHelper("hsas_caltable");
        DynamicObject[] caltables = calHelper.queryOriginalArray("id,caltask.id", new QFilter[]{new QFilter("id", "in", this.caltableIdList)});
        HashMap<Long, Long> tabTaskMap = new HashMap<Long, Long>(16);
        for (DynamicObject caltable : caltables) {
            calTableId = caltable.getLong("id");
            long calTaskId = caltable.getLong("caltask.id");
            tabTaskMap.put(calTableId, calTaskId);
        }
        for (DynamicObject detail : this.details) {
            calTableId = detail.getLong("caltableid");
            Long calTaskId = (Long)tabTaskMap.get(calTableId);
            if (calTaskId == null || calTaskId == 0L) continue;
            detail.set("caltask", (Object)calTaskId);
        }
        this.countDownLatch.countDown();
    }
}

