/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsas.business.salaryfile.DefaultEmptyPage;
import kd.swc.hsas.common.utils.SalaryFileUtils;
import kd.swc.hsas.formplugin.web.file.SingleAddPersonFilePlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class HSASDefaultEmptyPagePlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DefaultEmptyPage.initPage((IFormView)this.getView());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"newlabel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "newlabel": {
                boolean isValidate = this.isAlreadyValidate();
                if (isValidate) {
                    IFormView parentView = this.getView().getParentView();
                    parentView.invokeOperation("refresh");
                    this.getView().sendFormAction(parentView);
                    break;
                }
                this.embedTargetFlex();
                break;
            }
        }
    }

    private boolean isAlreadyValidate() {
        boolean isValidate = false;
        String salaryFileId = (String)this.getView().getFormShowParameter().getCustomParam("salaryfileid");
        String status = (String)this.getView().getFormShowParameter().getCustomParam("status");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject salaryFileDyobj = null;
        if (salaryFileId != null) {
            salaryFileDyobj = serviceHelper.queryOne((Object)Long.parseLong(salaryFileId));
        }
        if (null != salaryFileDyobj && !SWCStringUtils.equals((String)salaryFileDyobj.getString("status"), (String)status)) {
            isValidate = true;
        }
        return isValidate;
    }

    private void embedTargetFlex() {
        String targetFlex = (String)this.getView().getFormShowParameter().getCustomParam("targetFlex");
        IFormView parentView = this.getView().getParentView();
        String pageNumber = (String)this.getView().getFormShowParameter().getCustomParam("pageNumber");
        if (!SWCStringUtils.isEmpty((String)pageNumber)) {
            if (this.hasAddPermission(pageNumber)) {
                switch (parentView.getEntityId()) {
                    case "hsas_addpersonfile": {
                        this.embedAddSalaryFileTargetFlex(parentView, pageNumber, targetFlex);
                        break;
                    }
                }
            } else {
                String pageName = SalaryFileUtils.getPageNameByPageNumber((String)pageNumber);
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"HSASDefaultEmptyPagePlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), pageName));
            }
        }
    }

    private boolean hasAddPermission(String entityName) {
        return SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)entityName, (String)"47156aff000000ac");
    }

    private void embedAddSalaryFileTargetFlex(IFormView parentView, String pageNumber, String targetFlex) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetFlex);
        showParameter.setCloseCallBack(new CloseCallBack(SingleAddPersonFilePlugin.class.getName(), targetFlex));
        showParameter.setFormId(pageNumber);
        showParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        parentView.showForm((FormShowParameter)showParameter);
        this.pageViewReg(showParameter, pageNumber);
        HSASDefaultEmptyPagePlugin.setParentAdvNotCollapsible(parentView, targetFlex);
        this.getView().sendFormAction(parentView);
    }

    private String getPageNumberFlexName(String targetFlex) {
        String baseFormNumber = "";
        switch (targetFlex) {
            case "itemgrpcfgflex": {
                baseFormNumber = "hsas_itemgrpcfg";
                break;
            }
            case "paysettingflex": {
                baseFormNumber = "hsas_paysetting";
                break;
            }
        }
        return baseFormNumber;
    }

    private void pageViewReg(BaseShowParameter showParameter, String pageNumber) {
        SWCPageCache pageCache = new SWCPageCache(this.getView().getParentView());
        Map pageIds = (Map)pageCache.get("pageids", Map.class);
        pageIds.put(pageNumber, showParameter.getPageId());
        pageCache.put("pageids", (Object)pageIds);
    }

    private static void setParentAdvNotCollapsible(IFormView formView, String flexKey) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("collapsible", Boolean.FALSE);
        formView.updateControlMetadata(flexKey, map);
    }
}

