/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class HSASFixedFieldListPlugin
extends AbstractListPlugin {
    private Map<String, List<String>> fixFieldListMap;
    private static final String OP_COLUMN = "listoperationcolumnap";
    private static final String PARAM_ISFIXED = "param_isfixed";

    public void initialize() {
        super.initialize();
        this.initFixFieldListMap();
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List<String> fixedFieldKeyList = this.getFixedFieldKeyList();
        if (CollectionUtils.isEmpty(fixedFieldKeyList)) {
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String isFixed = pageCache.get(PARAM_ISFIXED);
        if (SWCStringUtils.isNotEmpty((String)isFixed)) {
            return;
        }
        List<IListColumn> columns = args.getListColumns().stream().filter(column -> fixedFieldKeyList.contains(column.getListFieldKey())).collect(Collectors.toList());
        columns.forEach(column -> column.setFixed(true));
        pageCache.put(PARAM_ISFIXED, Boolean.TRUE.toString());
    }

    private List<String> getFixedFieldKeyList() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String formId = listShowParameter.getBillFormId();
        return this.fixFieldListMap.get(formId);
    }

    private void initFixFieldListMap() {
        this.fixFieldListMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<String> salaryBlockFixFieldList = new ArrayList<String>();
        salaryBlockFixFieldList.add("salaryfile.person.name");
        salaryBlockFixFieldList.add("salaryfile.employee.empnumber");
        salaryBlockFixFieldList.add("salaryfile.number");
        this.fixFieldListMap.put("hsas_salarystru", salaryBlockFixFieldList);
        this.fixFieldListMap.put("hsas_regularitem", salaryBlockFixFieldList);
        this.fixFieldListMap.put("hsas_paysetting", salaryBlockFixFieldList);
        this.fixFieldListMap.put("hsas_costallot", salaryBlockFixFieldList);
        ArrayList<String> calpersonFixFieldList = new ArrayList<String>();
        calpersonFixFieldList.add("number");
        calpersonFixFieldList.add("person.name");
        calpersonFixFieldList.add("person.empnumber");
        this.fixFieldListMap.put("hsas_calpersonf7", calpersonFixFieldList);
        ArrayList<String> taskFixFieldList = new ArrayList<String>();
        taskFixFieldList.add("number");
        taskFixFieldList.add("mergelistcolumnap");
        this.fixFieldListMap.put("hsas_calpayrolltask", taskFixFieldList);
        ArrayList<String> paydetailFixFieldList = new ArrayList<String>();
        paydetailFixFieldList.add("salaryfilehis.person.name");
        paydetailFixFieldList.add("salaryfilehis.employee.empnumber");
        paydetailFixFieldList.add("salaryfilehis.number");
        paydetailFixFieldList.add("onholdstatus");
        this.fixFieldListMap.put("hsas_paydetail", paydetailFixFieldList);
        ArrayList<String> hsasPersonFixFieldList = new ArrayList<String>();
        hsasPersonFixFieldList.add("employee.person.name");
        hsasPersonFixFieldList.add("employee.empnumber");
        hsasPersonFixFieldList.add("number");
        this.fixFieldListMap.put("hsas_person", hsasPersonFixFieldList);
        ArrayList<String> hsasPersonHisFixFieldList = new ArrayList<String>();
        hsasPersonHisFixFieldList.add("name");
        hsasPersonHisFixFieldList.add("empnumber");
        this.fixFieldListMap.put("hsas_personhis", hsasPersonHisFixFieldList);
        ArrayList<String> empposInfoFixFieldList = new ArrayList<String>();
        empposInfoFixFieldList.add(OP_COLUMN);
        empposInfoFixFieldList.add("company.name");
        empposInfoFixFieldList.add("adminorg.name");
        empposInfoFixFieldList.add("position.name");
        this.fixFieldListMap.put("hsas_empposinfowithent", empposInfoFixFieldList);
        ArrayList<String> empposInfoEntHisFixFieldList = new ArrayList<String>();
        empposInfoEntHisFixFieldList.add("person.name");
        empposInfoEntHisFixFieldList.add("person.empnumber");
        empposInfoEntHisFixFieldList.add("company.name");
        empposInfoEntHisFixFieldList.add("adminorg.name");
        empposInfoEntHisFixFieldList.add("position.name");
        this.fixFieldListMap.put("hsas_empposinfo_enthis", empposInfoEntHisFixFieldList);
        ArrayList<String> salaryFileFixFieldList = new ArrayList<String>();
        salaryFileFixFieldList.add("employee.person.name");
        salaryFileFixFieldList.add("employee.empnumber");
        salaryFileFixFieldList.add("number");
        this.fixFieldListMap.put("hsas_salaryfile", salaryFileFixFieldList);
        this.fixFieldListMap.put("hsas_salaryfileextend", salaryFileFixFieldList);
        ArrayList<String> onholdFixFieldList = new ArrayList<String>();
        onholdFixFieldList.add("person.name");
        onholdFixFieldList.add("person.empnumber");
        this.fixFieldListMap.put("hsas_onholdbill", onholdFixFieldList);
        ArrayList<String> perBankCardInSFFixFieldList = new ArrayList<String>();
        perBankCardInSFFixFieldList.add("person.name");
        perBankCardInSFFixFieldList.add("employee.empnumber");
        perBankCardInSFFixFieldList.add("number");
        this.fixFieldListMap.put("hsas_perbankcardinsf", perBankCardInSFFixFieldList);
        ArrayList<String> proTitleFixFieldList = new ArrayList<String>();
        proTitleFixFieldList.add(OP_COLUMN);
        this.fixFieldListMap.put("hsas_perprotitle", proTitleFixFieldList);
        ArrayList<String> ocpqualFixFieldList = new ArrayList<String>();
        ocpqualFixFieldList.add(OP_COLUMN);
        this.fixFieldListMap.put("hsas_perocpqual", ocpqualFixFieldList);
        ArrayList<String> practqualFixFieldList = new ArrayList<String>();
        practqualFixFieldList.add(OP_COLUMN);
        this.fixFieldListMap.put("hsas_perpractqual", practqualFixFieldList);
        ArrayList<String> bankCardOpFixFieldList = new ArrayList<String>();
        bankCardOpFixFieldList.add("person.name");
        bankCardOpFixFieldList.add("person.empnumber");
        bankCardOpFixFieldList.add("operate");
        bankCardOpFixFieldList.add("changetype");
        this.fixFieldListMap.put("hsas_bankcardoplog", bankCardOpFixFieldList);
        ArrayList<String> calListViewFixFieldList = new ArrayList<String>();
        calListViewFixFieldList.add("fseq");
        calListViewFixFieldList.add("createorg.name");
        calListViewFixFieldList.add("number");
        calListViewFixFieldList.add("name");
        this.fixFieldListMap.put("hsas_callistview", calListViewFixFieldList);
        ArrayList<String> PerBankCardExtFixFieldList = new ArrayList<String>();
        PerBankCardExtFixFieldList.add("fseq");
        PerBankCardExtFixFieldList.add(OP_COLUMN);
        PerBankCardExtFixFieldList.add("number");
        this.fixFieldListMap.put("hsas_perbankcardext", PerBankCardExtFixFieldList);
    }
}

