/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator;

import java.text.MessageFormat;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AccumulatorListPlugin
extends AbstractListPlugin {
    private static final String DISABLE_ACC = "disable_acc";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (SWCStringUtils.equals((String)"disable", (String)operateKey)) {
            this.disableConfirm(operate, args);
        } else if (SWCStringUtils.equals((String)"delete", (String)operateKey)) {
            operate.getOption().setVariableValue("ignorerefentityids", "hsas_cumulaterecord");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "disable_acc": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(DISABLE_ACC, "true");
                this.getView().invokeOperation("disable", operateOption);
                break;
            }
        }
    }

    private void disableConfirm(FormOperate operate, BeforeDoOperationEventArgs args) {
        RefObject afterConfirm = new RefObject();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (!operate.getOption().tryGetVariableValue(DISABLE_ACC, afterConfirm)) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u9009\u4e2d\u7684{0}\u884c\u8bb0\u5f55\u7981\u7528\u540e\uff0c\u5c06\u5bfc\u81f4\u7d2f\u52a0\u5668\u4e0d\u53ef\u7528\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AccumulatorListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(MessageFormat.format(msg, selectedRows.size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DISABLE_ACC));
        }
    }
}

