/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator;

import java.text.MessageFormat;
import java.util.Locale;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.swc.hsas.common.constants.AccumulatorConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class AccumulatorPlugin
extends SWCDataBaseEdit {
    private static final String DELETE_ACCDIM_ENTRY = "deleteAccDimEntry";
    private static final String DELETE_ACCMEM_ENTRY = "deleteAccMemEntry";
    public static final String SAVE_ACC_MEM_ENTRY = "saveAccMemEntry";
    private static final String SAVE_OPKEY = "save";
    private static final String DISABLE_ACC = "disable_acc";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "newentry_accdimension": {
                this.checkAccDimensonCount(args);
                break;
            }
            case "deleteentry_accdimension": {
                this.accDimDelEntryConfirm();
                args.setCancel(true);
                break;
            }
            case "deleteentry_accmember": {
                this.accMumberDelEntryConfirm();
                args.setCancel(true);
                break;
            }
            case "save": {
                if (!this.checkAccDimEntry() || !this.checkAccMemEntry()) {
                    args.setCancel(true);
                    break;
                }
                this.saveAccumulatorConfirm(operate, args);
                break;
            }
            case "submit": {
                if (this.checkAccDimEntry() && this.checkAccMemEntry()) break;
                args.setCancel(true);
                break;
            }
            case "audit": {
                this.auditAccumulatorConfirm(args);
                break;
            }
            case "disable": {
                this.disableConfirm(operate, args);
                break;
            }
            case "delete": {
                operate.getOption().setVariableValue("ignorerefentityids", "hsas_cumulaterecord");
                break;
            }
        }
    }

    private boolean checkAccMemEntry() {
        DynamicObjectCollection dynamicObjects = this.getView().getModel().getEntryEntity("accmemberentry");
        boolean flag = true;
        if (dynamicObjects.isEmpty()) {
            return flag;
        }
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            String memItem = ((DynamicObject)dynamicObjects.get(i)).getString("accmemberitem");
            if (!SWCStringUtils.isEmpty((String)memItem)) continue;
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7d2f\u52a0\u6210\u5458\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccumulatorPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), i + 1);
            this.getView().showTipNotification(msg);
            flag = false;
        }
        return flag;
    }

    private boolean checkAccDimEntry() {
        DynamicObjectCollection accdimitementry = this.getView().getModel().getEntryEntity("accdimitementry");
        boolean flag = true;
        if (accdimitementry.isEmpty()) {
            return flag;
        }
        for (int i = 0; i < accdimitementry.size(); ++i) {
            String dimItem = ((DynamicObject)accdimitementry.get(i)).getString("dimitem");
            if (!SWCStringUtils.isEmpty((String)dimItem)) continue;
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7d2f\u52a0\u5b50\u7ef4\u5ea6\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccumulatorPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), i + 1));
            flag = false;
        }
        return flag;
    }

    private void auditAccumulatorConfirm(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection accMemberEntry = this.getModel().getEntryEntity("accmemberentry");
        if (accMemberEntry.size() <= AccumulatorConstants.ACCMEMCOUNT_0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u4e0b\uff0c\u7d2f\u52a0\u6210\u5458\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccumulatorPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void disableConfirm(FormOperate operate, BeforeDoOperationEventArgs args) {
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue(DISABLE_ACC, afterConfirm)) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u7981\u7528\u540e\uff0c\u5c06\u5bfc\u81f4\u7d2f\u52a0\u5668\u4e0d\u53ef\u7528\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AccumulatorPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(MessageFormat.format(msg, 1), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DISABLE_ACC));
        }
    }

    private void saveAccumulatorConfirm(FormOperate operate, BeforeDoOperationEventArgs args) {
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue(SAVE_ACC_MEM_ENTRY, afterConfirm)) {
            DynamicObjectCollection accMemberEntry = this.getModel().getEntryEntity("accmemberentry");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String status = dataEntity.getString("status");
            if (accMemberEntry.size() <= AccumulatorConstants.ACCMEMCOUNT_0) {
                args.setCancel(true);
                if (!SWCStringUtils.equals((String)"A", (String)status)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u4e0b\uff0c\u7d2f\u52a0\u6210\u5458\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccumulatorPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u60a8\u672a\u7ef4\u62a4\u7d2f\u52a0\u6210\u5458\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AccumulatorPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SAVE_ACC_MEM_ENTRY));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "deleteAccDimEntry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                EntryGrid entryGrid = (EntryGrid)this.getControl("accdimitementry");
                int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
                this.getModel().deleteEntryRows("accdimitementry", selectedRows);
                break;
            }
            case "deleteAccMemEntry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                EntryGrid entryGrid = (EntryGrid)this.getControl("accmemberentry");
                int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
                this.getModel().deleteEntryRows("accmemberentry", selectedRows);
                break;
            }
            case "saveAccMemEntry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                DynamicObject obj = this.getModel().getDataEntity();
                String status = obj.getString("status");
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(SAVE_ACC_MEM_ENTRY, "true");
                operateOption.setVariableValue("status", status);
                this.getView().invokeOperation(SAVE_OPKEY, operateOption);
                break;
            }
            case "disable_acc": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(DISABLE_ACC, "true");
                this.getView().invokeOperation("disable", operateOption);
                break;
            }
        }
    }

    private void accMumberDelEntryConfirm() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("accmemberentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length > 0) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u62e9%s\u6761\u8bb0\u5f55\uff0c\u5220\u9664\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AccumulatorPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), selectedRows.length);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_ACCMEM_ENTRY));
        }
    }

    private void accDimDelEntryConfirm() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("accdimitementry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length > 0) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u62e9%s\u6761\u8bb0\u5f55\uff0c\u5220\u9664\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AccumulatorPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), selectedRows.length);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_ACCDIM_ENTRY));
        }
    }

    private void checkAccDimensonCount(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("accdimitementry");
        if (collection.size() >= AccumulatorConstants.ACCDIMCOUNT_5) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u67095\u4e2a\u7d2f\u52a0\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u518d\u6dfb\u52a0\u65b0\u7d2f\u52a0\u7ef4\u5ea6\u3002", (String)"AccumulatorPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }
}

