/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator.accresultlist;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.accumulator.AccCalMutexUtils;
import kd.swc.hsas.business.accumulator.AccResultPermService;
import kd.swc.hsas.business.accumulator.accresultdetail.AccResultDetailHelper;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.EntryImportContext;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;

public class AccResultImportAdjustDataPlugin {
    private static Log log = LogFactory.getLog(AccResultImportAdjustDataPlugin.class);
    private static final int EMPNUMBER_INDEX = 0;
    private static final String CONNECTOR = "@;@";
    private static final int SALARYFILENUMBER_INDEX = 1;
    private static final int ACCNUMBER_INDEX = 3;
    private static final int INSTANCE_INDEX = 5;
    private ProgressHandler processHandler;
    private Map<String, DynamicObject> accInfoDataMap;
    private Map<String, DynamicObject> salaryFileMap;
    private Map<String, List<DynamicObject>> employeeInfoMap;
    private Set<Long> personIndexIdSet;

    public AccResultImportAdjustDataPlugin(ProgressHandler processHandler) {
        this.processHandler = processHandler;
        this.accInfoDataMap = new HashMap<String, DynamicObject>(16);
        this.salaryFileMap = new HashMap<String, DynamicObject>(16);
        this.employeeInfoMap = new HashMap<String, List<DynamicObject>>(16);
        this.personIndexIdSet = new HashSet<Long>(16);
    }

    public void dataImport(List<Map<Integer, String>> dataRow) {
        log.info("AccResultImportAdjustDataPlugin.dataImport start");
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(10);
        try {
            this.checkImportData(dataRow, dataList);
            this.batchWriteImportData(dataList);
        }
        catch (Exception ex) {
            log.error("dataImport error.", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
        finally {
            if (this.personIndexIdSet.size() > 0) {
                AccCalMutexUtils.releaseSalaryCalMutexData(this.personIndexIdSet, (String)"3");
            }
        }
        log.info("AccResultImportAdjustDataPlugin.dataImport end");
    }

    private void checkImportData(List<Map<Integer, String>> dataRow, List<DynamicObject> dataList) {
        List<Map<Integer, String>> successRowList = this.nullDataAndDataTypeCheck(dataRow);
        if (successRowList.size() == 0) {
            log.info("all data nullDataAndDataTypeCheck no pass");
            return;
        }
        HashMap<Long, Map<String, Long>> personIndexMap = new HashMap<Long, Map<String, Long>>(16);
        QFilter accResultFilter = new QFilter("1", "=", (Object)1);
        if ((successRowList = this.checkDataExist(successRowList, personIndexMap, accResultFilter)).size() == 0) {
            log.info("all data checkDataExistAndReletion no pass");
            return;
        }
        if ((successRowList = this.checkPersonIsCalingOrAdjust(successRowList, personIndexMap)).size() == 0) {
            log.info("all data checkPersonIsCalingOrAdjust no pass");
            return;
        }
        this.checkDBExistAndCurrencyPrecission(successRowList, dataList, accResultFilter);
    }

    private List<Map<Integer, String>> checkPersonIsCalingOrAdjust(List<Map<Integer, String>> dataRowList, Map<Long, Map<String, Long>> personIndexMap) {
        ArrayList<Map<Integer, String>> successRowList = new ArrayList<Map<Integer, String>>(dataRowList.size());
        HashMap errorDataMap = new HashMap(personIndexMap.size());
        AccCalMutexUtils.checkPersonHrIsCalingAndAddMutexData(personIndexMap, errorDataMap);
        this.personIndexIdSet.addAll(AccCalMutexUtils.addSalaryCalMutexData(personIndexMap, errorDataMap, (String)"3"));
        if (errorDataMap.size() == 0) {
            return dataRowList;
        }
        List<DynamicObject> tempList = null;
        for (Map<Integer, String> tempMap : dataRowList) {
            String empNumber = tempMap.get(0);
            tempList = this.employeeInfoMap.get(empNumber);
            if (SWCListUtils.isEmpty(tempList)) continue;
            Integer excelRow = Integer.valueOf(tempMap.get(EntryImportContext.EXCEL_ROW_NUMBER));
            DynamicObject employee = tempList.get(0);
            String msg = (String)errorDataMap.get(employee.getLong("person.personindexid"));
            if (SWCStringUtils.isNotEmpty((String)msg)) {
                this.processHandler.putRowError(excelRow, msg);
                this.processHandler.incrByProgress(0, 1);
                continue;
            }
            successRowList.add(tempMap);
        }
        return successRowList;
    }

    private List<Map<Integer, String>> nullDataAndDataTypeCheck(List<Map<Integer, String>> dataRowList) {
        ArrayList<Map<Integer, String>> successRowList = new ArrayList<Map<Integer, String>>(dataRowList.size());
        Map<Integer, String> dataMap = null;
        int size = dataRowList.size();
        boolean isCheckPass = true;
        for (int i = 0; i < size; ++i) {
            String msg;
            String msg2;
            String instanceNum;
            String accNumber;
            isCheckPass = true;
            dataMap = dataRowList.get(i);
            Integer excelRow = Integer.valueOf(dataMap.get(EntryImportContext.EXCEL_ROW_NUMBER));
            String employeePersonNumber = dataMap.get(0);
            if (SWCStringUtils.isEmpty((String)employeePersonNumber)) {
                String msg3 = ResManager.loadKDString((String)"\u5fc5\u586b\u5b57\u6bb5\u201c\u5de5\u53f7\u201d\u672a\u586b\u5199\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, msg3);
                isCheckPass = false;
            }
            if (SWCStringUtils.isEmpty((String)(accNumber = dataMap.get(3)))) {
                String msg4 = ResManager.loadKDString((String)"\u5fc5\u586b\u5b57\u6bb5\u201c\u7d2f\u52a0\u5668\u7f16\u7801\u201d\u672a\u586b\u5199\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, msg4);
                isCheckPass = false;
            }
            if (SWCStringUtils.isEmpty((String)(instanceNum = dataMap.get(5)))) {
                String msg5 = ResManager.loadKDString((String)"\u5fc5\u586b\u5b57\u6bb5\u201c\u7d2f\u52a0\u5b9e\u4f8b\u53f7\u201d\u672a\u586b\u5199\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, msg5);
                isCheckPass = false;
            } else {
                try {
                    Integer.valueOf(instanceNum);
                }
                catch (Exception e) {
                    msg2 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6574\u6570\u7c7b\u578b\u7684\u7d2f\u52a0\u5b9e\u4f8b\u53f7\u3002", (String)"AccResultImportAdjustDataPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.processHandler.putRowError(excelRow, msg2);
                    isCheckPass = false;
                }
            }
            String accAmount = dataMap.get(15);
            if (SWCStringUtils.isEmpty((String)accAmount)) {
                msg2 = ResManager.loadKDString((String)"\u5fc5\u586b\u5b57\u6bb5\u201c\u8c03\u6574\u503c\u201d\u672a\u586b\u5199\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, msg2);
                isCheckPass = false;
            } else {
                try {
                    new BigDecimal(accAmount);
                }
                catch (Exception e) {
                    msg = ResManager.loadKDString((String)"\u201c\u8c03\u6574\u503c\u201d\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.processHandler.putRowError(excelRow, msg);
                    isCheckPass = false;
                }
            }
            String accReason = dataMap.get(16);
            if (SWCStringUtils.isEmpty((String)accReason)) {
                msg = ResManager.loadKDString((String)"\u5fc5\u586b\u5b57\u6bb5\u201c\u8c03\u6574\u539f\u56e0\u201d\u672a\u586b\u5199\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, msg);
                isCheckPass = false;
            } else if (accReason.length() > 128) {
                msg = ResManager.loadKDString((String)"\u201c\u8c03\u6574\u539f\u56e0\u201d\u5bfc\u5165\u6570\u636e\u7684\u6700\u5927\u957f\u5ea6\u53ea\u652f\u6301128\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, msg);
                isCheckPass = false;
            }
            if (isCheckPass) {
                successRowList.add(dataMap);
                continue;
            }
            this.processHandler.incrByProgress(0, 1);
        }
        return successRowList;
    }

    private Map<String, DynamicObject> getAccResultMap(QFilter accResultFilter) {
        log.info("getAccResultMap start");
        HashMap<String, DynamicObject> accResultMap = new HashMap<String, DynamicObject>(16);
        AccResultDetailHelper helper = new AccResultDetailHelper();
        DynamicObject[] accResultArray = helper.getAccResultInfo(accResultFilter);
        if (accResultArray == null || accResultArray.length == 0) {
            return accResultMap;
        }
        String mapKey = null;
        for (DynamicObject obj : accResultArray) {
            mapKey = obj.getString("employee.empnumber") + CONNECTOR + obj.getString("salaryfile.number") + CONNECTOR + obj.getString("acc.number") + CONNECTOR + obj.getInt("instancenum") + CONNECTOR + this.dealDimensionData(obj.getString("dimension1")) + CONNECTOR + this.dealDimensionData(obj.getString("dimension2")) + CONNECTOR + this.dealDimensionData(obj.getString("dimension3")) + CONNECTOR + this.dealDimensionData(obj.getString("dimension4")) + CONNECTOR + this.dealDimensionData(obj.getString("dimension5"));
            accResultMap.put(mapKey, obj);
        }
        log.info("getAccResultMap end");
        return accResultMap;
    }

    private String dealDimensionData(String value) {
        if (SWCStringUtils.isEmpty((String)value)) {
            return "";
        }
        return value;
    }

    private void checkDBExistAndCurrencyPrecission(List<Map<Integer, String>> dataRowList, List<DynamicObject> dataList, QFilter accResultFilter) {
        HashMap<String, DynamicObject> successDataMap = new HashMap<String, DynamicObject>(dataRowList.size());
        Map<String, DynamicObject> accResultMap = this.getAccResultMap(accResultFilter);
        String mapKey = null;
        DynamicObject accResult = null;
        for (Map<Integer, String> rowMap : dataRowList) {
            mapKey = rowMap.get(0) + CONNECTOR + rowMap.get(1) + CONNECTOR + rowMap.get(3) + CONNECTOR + rowMap.get(5) + CONNECTOR + this.dealDimensionData(rowMap.get(10)) + CONNECTOR + this.dealDimensionData(rowMap.get(11)) + CONNECTOR + this.dealDimensionData(rowMap.get(12)) + CONNECTOR + this.dealDimensionData(rowMap.get(13)) + CONNECTOR + this.dealDimensionData(rowMap.get(14));
            accResult = accResultMap.get(mapKey);
            Integer excelRow = Integer.valueOf(rowMap.get(EntryImportContext.EXCEL_ROW_NUMBER));
            if (accResult == null) {
                String failMsg = ResManager.loadKDString((String)"\u4e0e\u7d2f\u52a0\u7ed3\u679c\u8868\u5173\u952e\u5b57\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, failMsg);
                this.processHandler.incrByProgress(0, 1);
                continue;
            }
            String adjustValStr = rowMap.get(15);
            int accurencyLen = this.getAccurencyLength(adjustValStr);
            DynamicObject queryAccObj = accResult.getDynamicObject("acc");
            DynamicObject queryCurrencyObj = accResult.getDynamicObject("currency");
            int scale = this.getDecimalScale(queryCurrencyObj, queryAccObj);
            if (accurencyLen > scale) {
                String failMsg = ResManager.loadKDString((String)"\u201c\u8c03\u6574\u503c\u201d\u5bfc\u5165\u6570\u636e\u7684\u6570\u636e\u7cbe\u5ea6\u8d85\u8fc7\u7d2f\u52a0\u7ed3\u679c\u7684\u6570\u636e\u7cbe\u5ea6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, failMsg);
                this.processHandler.incrByProgress(0, 1);
                continue;
            }
            DynamicObject tempObj = (DynamicObject)successDataMap.get(mapKey);
            tempObj = tempObj == null ? this.setAccResultPropValAndReturn(accResult, rowMap) : this.setAccResultPropValAndReturn(tempObj, rowMap);
            successDataMap.put(mapKey, tempObj);
            this.processHandler.incrByProgress(1, 0);
        }
        dataList.addAll(successDataMap.values());
    }

    private DynamicObject setAccResultPropValAndReturn(DynamicObject obj, Map<Integer, String> rowMap) {
        BigDecimal adjustValue = new BigDecimal(rowMap.get(15));
        DynamicObjectCollection entryList = obj.getDynamicObjectCollection("adjustentry");
        DynamicObject entry = entryList.addNew();
        entry.set("adjustamount", (Object)adjustValue);
        entry.set("adjustdescript", (Object)rowMap.get(16));
        entry.set("adjusttime", (Object)new Date());
        entry.set("adjustperson", (Object)RequestContext.get().getCurrUserId());
        obj.set("isadjust", (Object)"1");
        BigDecimal resultValue = obj.getBigDecimal("resultvalue");
        if (resultValue == null) {
            resultValue = BigDecimal.ZERO;
        }
        resultValue = resultValue.add(adjustValue);
        obj.set("resultvalue", (Object)resultValue);
        return obj;
    }

    private int getAccurencyLength(String str) {
        String[] strs = str.split("\\.");
        if (strs.length != 2) {
            return 0;
        }
        return strs[1].length();
    }

    private List<Map<Integer, String>> checkDataExist(List<Map<Integer, String>> dataRowList, Map<Long, Map<String, Long>> personIndexMap, QFilter accResultFilter) {
        ArrayList<Map<Integer, String>> successRowList = new ArrayList<Map<Integer, String>>(dataRowList.size());
        HashSet<Long> hasPermsAccIdSet = new HashSet<Long>(dataRowList.size());
        HashSet<Long> hasPermsEmployeeIdSet = new HashSet<Long>(dataRowList.size());
        HashSet<Long> hasPermsSalaryFileIdSet = new HashSet<Long>(dataRowList.size());
        this.dealExcelDataAndGetInfo(dataRowList, hasPermsAccIdSet, hasPermsEmployeeIdSet, hasPermsSalaryFileIdSet);
        HashSet<Long> accIdSet = new HashSet<Long>(dataRowList.size());
        HashSet<Long> employeeIdSet = new HashSet<Long>(dataRowList.size());
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(dataRowList.size());
        salaryFileIdSet.add(0L);
        HashSet<Integer> instanceNumSet = new HashSet<Integer>(dataRowList.size());
        int size = dataRowList.size();
        List<DynamicObject> tempPersonList = null;
        DynamicObject personObj = null;
        DynamicObject salaryFileObj = null;
        boolean isCheckPass = true;
        for (int index = 0; index < size; ++index) {
            String msg;
            DynamicObject accObj;
            String msg2;
            isCheckPass = true;
            Map<Integer, String> dataMap = dataRowList.get(index);
            Integer excelRow = Integer.valueOf(dataMap.get(EntryImportContext.EXCEL_ROW_NUMBER));
            personObj = null;
            tempPersonList = this.employeeInfoMap.get(dataMap.get(0));
            if (tempPersonList == null) {
                msg2 = ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u8ba1\u85aa\u4eba\u5458\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, msg2);
                isCheckPass = false;
            } else {
                personObj = tempPersonList.get(0);
                if (!hasPermsEmployeeIdSet.contains(personObj.getLong("id"))) {
                    msg2 = ResManager.loadKDString((String)"\u8be5\u8ba1\u85aa\u4eba\u5458\u4e0d\u5728\u7528\u6237\u6743\u9650\u5185\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.processHandler.putRowError(excelRow, msg2);
                    isCheckPass = false;
                }
            }
            String salaryfileNumber = dataMap.get(1);
            salaryFileObj = null;
            if (SWCStringUtils.isNotEmpty((String)salaryfileNumber)) {
                String msg3;
                salaryFileObj = this.salaryFileMap.get(salaryfileNumber);
                if (salaryFileObj == null) {
                    msg3 = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.processHandler.putRowError(excelRow, msg3);
                    isCheckPass = false;
                } else if (!hasPermsSalaryFileIdSet.contains(salaryFileObj.getLong("id"))) {
                    msg3 = ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6863\u6848\u4e0d\u5728\u7528\u6237\u6743\u9650\u5185\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.processHandler.putRowError(excelRow, msg3);
                    isCheckPass = false;
                }
            }
            if ((accObj = this.accInfoDataMap.get(dataMap.get(3))) == null) {
                msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u7d2f\u52a0\u5668\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, msg);
                isCheckPass = false;
            } else if (!hasPermsAccIdSet.contains(accObj.getLong("id"))) {
                msg = ResManager.loadKDString((String)"\u8be5\u7d2f\u52a0\u5668\u4e0d\u5728\u7528\u6237\u6743\u9650\u5185\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"AccResultImportAdjustDataPlugin_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.processHandler.putRowError(excelRow, msg);
                isCheckPass = false;
            }
            if (isCheckPass) {
                successRowList.add(dataMap);
                accIdSet.add(accObj.getLong("id"));
                instanceNumSet.add(Integer.valueOf(dataMap.get(5)));
                HashMap<String, Long> tempPersonMap = new HashMap<String, Long>(2);
                if (null != salaryFileObj) {
                    salaryFileIdSet.add(salaryFileObj.getLong("id"));
                    tempPersonMap.put("salaryfile", salaryFileObj.getLong("id"));
                } else {
                    tempPersonMap.put("salaryfile", 0L);
                }
                if (null == personObj) continue;
                employeeIdSet.add(personObj.getLong("id"));
                tempPersonMap.put("employee", personObj.getLong("id"));
                personIndexMap.put(personObj.getLong("person.personindexid"), tempPersonMap);
                continue;
            }
            this.processHandler.incrByProgress(0, 1);
        }
        accResultFilter.and(new QFilter("personindexid", "in", personIndexMap.keySet()));
        accResultFilter.and(new QFilter("acc.id", "in", accIdSet));
        accResultFilter.and(new QFilter("employee.id", "in", employeeIdSet));
        accResultFilter.and(new QFilter("salaryfile.id", "in", salaryFileIdSet));
        accResultFilter.and(new QFilter("instancenum", "in", instanceNumSet));
        return successRowList;
    }

    private void dealExcelDataAndGetInfo(List<Map<Integer, String>> dataRowList, Set<Long> hasPermsAccIdSet, Set<Long> hasPermsEmployeeIdSet, Set<Long> hasPermsSalaryFileIdSet) {
        HashSet<String> accNumberSet = new HashSet<String>(dataRowList.size());
        HashSet<String> empNumberSet = new HashSet<String>(dataRowList.size());
        HashSet<String> fileNumberSet = new HashSet<String>(dataRowList.size());
        for (Map<Integer, String> tempMap : dataRowList) {
            accNumberSet.add(tempMap.get(3));
            empNumberSet.add(tempMap.get(0));
            fileNumberSet.add(tempMap.get(1));
        }
        AccResultPermService permService = new AccResultPermService();
        this.accInfoDataMap.putAll(permService.getAccDataMap(accNumberSet));
        hasPermsAccIdSet.addAll(permService.getHasPermsAccDataSet(this.accInfoDataMap));
        HashSet tempEmployeeIdSet = new HashSet(16);
        this.employeeInfoMap.putAll(permService.getEmployeeDataMap(empNumberSet, tempEmployeeIdSet));
        hasPermsEmployeeIdSet.addAll(permService.getHasPermsEmployeeDataSet(tempEmployeeIdSet));
        this.salaryFileMap.putAll(permService.getSalaryFileData(fileNumberSet));
        hasPermsSalaryFileIdSet.addAll(permService.getHasPermsSalaryFileDataSet(this.salaryFileMap));
    }

    private void batchWriteImportData(List<DynamicObject> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            AccResultDetailHelper helper = new AccResultDetailHelper();
            if (dataList != null && dataList.size() > 0) {
                helper.batchWriteData(dataList);
            }
        }
    }

    private int getDecimalScale(DynamicObject currencyObj, DynamicObject accObj) {
        DynamicObject dataPrecisionObj;
        if (!SWCObjectUtils.isEmpty((Object)currencyObj)) {
            int amtprecision = currencyObj.getInt("amtprecision");
            return amtprecision;
        }
        if (!SWCObjectUtils.isEmpty((Object)accObj) && !SWCObjectUtils.isEmpty((Object)(dataPrecisionObj = accObj.getDynamicObject("dataprecision")))) {
            long dataPrecisionId = dataPrecisionObj.getLong("id");
            return ItemDataUtils.getScal((long)dataPrecisionId);
        }
        return 2;
    }
}

