/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator.accresultlist;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.accumulator.AccResultCheckService;
import kd.swc.hsas.business.accumulator.accresultdetail.AccResultDetailHelper;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.formplugin.web.accumulator.accresultlist.AccResultListEntityTypeBillList;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AccResultListViewPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AccResultListViewPlugin.class);
    private static final String ACC_RESULT_DETAIL_PAGE = "hsas_accresultdetailinfo";
    private static final String QUERY_BTN = "query";
    private static final String RESET_BTN = "reset";
    private static final String KEY_BILL_LIST_AP = "billlistap";
    private static final String ACC = "queryacc";
    private static final String ADJUST = "donothing_adjust";
    private static final String START_DATE = "querystartdate";
    private static final String END_DATE = "queryenddate";
    private static final String DONOTHING_MODIFY = "donothing_modify";
    private static final String EMPLOYEE = "employee";
    private static final String SALARYFILE = "salaryfile";
    private AccResultListEntityTypeBillList billList;
    private Map<Long, Integer> scaleMap = new HashMap<Long, Integer>(16);

    public void registerListener(EventObject event) {
        this.addClickListeners(new String[]{QUERY_BTN, RESET_BTN});
        BasedataEdit startDateItem = (BasedataEdit)this.getView().getControl(ACC);
        startDateItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit employeeItem = (BasedataEdit)this.getView().getControl(EMPLOYEE);
        employeeItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit salaryFileItem = (BasedataEdit)this.getView().getControl(SALARYFILE);
        salaryFileItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject event) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_dataprecision");
        DynamicObject[] allDataPrecisionArray = helper.queryOriginalArray("id,scale", new QFilter[0]);
        HashMap<Long, Integer> scaleMap = new HashMap<Long, Integer>(allDataPrecisionArray.length);
        for (DynamicObject precisionObj : allDataPrecisionArray) {
            scaleMap.put(precisionObj.getLong("id"), precisionObj.getInt("scale"));
        }
        this.scaleMap = scaleMap;
    }

    public void afterBindData(EventObject event) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"importflex"});
    }

    public void click(EventObject evt) {
        String clickedKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (clickedKey = source.getKey()) {
            case "query": {
                this.queryClickEvent();
                break;
            }
            case "reset": {
                this.resetClickEvent();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)DONOTHING_MODIFY, (String)optKey)) {
            this.doModifyCheck(args);
        } else if (ADJUST.equals(optKey)) {
            this.doAdjustCheck(args);
        }
    }

    private void doAdjustCheck(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4fee\u6539\u3002", (String)"AccResultListViewPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ListSelectedRow row = selectedRows.get(0);
        Long accResultId = (Long)row.getPrimaryKeyValue();
        HashSet<Long> accResultSet = new HashSet<Long>(1);
        accResultSet.add(accResultId);
        AccResultCheckService checkService = new AccResultCheckService();
        Map accDetailMap = checkService.getAccDetailMapByAccResultId(accResultSet);
        if (accDetailMap.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7d2f\u52a0\u7ed3\u679c\u6570\u636e\u4e2d\u5df2\u5b58\u5728\u901a\u8fc7\u85aa\u8d44\u6838\u7b97\u751f\u6210\u7684\u7d2f\u52a0\u660e\u7ec6\u7ed3\u679c\uff0c\u65e0\u6cd5\u8c03\u6574\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"AccResultListViewPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String fields = "id,resultvalue,acc.id,acc.datatype.id,acc.dataprecision.id,currency.amtprecision,personindexid,employee.id,salaryfile.id";
        DynamicObject accResult = checkService.getAccResultById(accResultId, fields);
        if (accResult == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7d2f\u52a0\u7ed3\u679c\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AccResultListViewPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        AccResultDetailHelper detailHelper = new AccResultDetailHelper();
        FormShowParameter parameter = detailHelper.getAdjustPageParameter(accResult, accResultId.longValue());
        this.getView().showForm(parameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey = arg.getProperty().getName();
        if (SWCStringUtils.equals((String)fieldKey, (String)ACC)) {
            this.accFilter(arg);
        } else if (EMPLOYEE.equals(fieldKey)) {
            this.addEmployeeFilter(arg);
        } else if (SALARYFILE.equals(fieldKey)) {
            this.addSalaryFileFilter(arg);
        }
    }

    private void addEmployeeFilter(BeforeF7SelectEvent arg) {
        ListShowParameter showParameter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter dataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)EMPLOYEE);
        if (dataFilter != null) {
            qFilters.add(dataFilter);
        }
        if ((showParameter = (ListShowParameter)arg.getFormShowParameter()).getListFilterParameter().getQFilters() != null) {
            showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
        } else {
            showParameter.getListFilterParameter().setQFilters(qFilters);
        }
    }

    private void addSalaryFileFilter(BeforeF7SelectEvent arg) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"47150e89000000ac");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            qFilters.add(new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter dataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)SALARYFILE);
        if (dataFilter != null) {
            filter.and(dataFilter);
        }
        qFilters.add(filter);
        ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
        if (showParameter.getListFilterParameter().getQFilters() != null) {
            showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
        } else {
            showParameter.getListFilterParameter().setQFilters(qFilters);
        }
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        this.setGridScaleField(event, "resultvalue");
    }

    private void setGridScaleField(PackageDataEvent event, String decimalFldKey) {
        if (((AbstractColumnDesc)event.getSource()).getFieldKey().equals(decimalFldKey)) {
            BigDecimal decimal = event.getRowData().getBigDecimal(decimalFldKey);
            if (decimal == null) {
                decimal = BigDecimal.ZERO;
            }
            DynamicObject currencyObj = event.getRowData().getDynamicObject("currency");
            DynamicObject accObj = event.getRowData().getDynamicObject("acc");
            int scale = this.getDecimalScale(currencyObj, accObj, this.scaleMap);
            String formatValue = this.getScaleFormatValue(decimal, scale);
            event.setFormatValue((Object)formatValue);
        }
    }

    private int getDecimalScale(DynamicObject currencyObj, DynamicObject accObj, Map<Long, Integer> scaleMap) {
        DynamicObject dataPrecisionObj;
        if (!SWCObjectUtils.isEmpty((Object)currencyObj)) {
            int amtprecision = currencyObj.getInt("amtprecision");
            return amtprecision;
        }
        if (!SWCObjectUtils.isEmpty((Object)accObj) && !SWCObjectUtils.isEmpty((Object)(dataPrecisionObj = accObj.getDynamicObject("dataprecision")))) {
            int scale = 2;
            long dataPrecisionId = dataPrecisionObj.getLong("id");
            if (scaleMap.get(dataPrecisionId) != null) {
                scale = scaleMap.get(dataPrecisionId);
            }
            return scale;
        }
        return 2;
    }

    private String getScaleFormatValue(BigDecimal value, int scale) {
        StringBuilder format = new StringBuilder("#,##0");
        if (scale > 0) {
            format.append('.');
        }
        for (int i = 0; i < scale; ++i) {
            format.append('0');
        }
        DecimalFormat myFormat = new DecimalFormat(format.toString());
        return myFormat.format(value);
    }

    private void accFilter(BeforeF7SelectEvent arg) {
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"47150e89000000ac");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        logger.info("start query accFilter");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            QFilter baseDataFilter;
            if (!SWCListUtils.isEmpty((List)hasPermOrgResult.getHasPermOrgs())) {
                CalHelper.printLog((String)"accresult org is:", (Object)hasPermOrgResult.getHasPermOrgs());
            }
            if ((baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_accumulator", (List)hasPermOrgResult.getHasPermOrgs(), (boolean)true)) != null) {
                qFilters.add(baseDataFilter);
            }
        } else {
            logger.info("has all org perms");
        }
        QFilter dataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_accresult", (String)"acc");
        if (dataFilter != null) {
            qFilters.add(dataFilter);
        }
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(filter);
        ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
        showParameter.getListFilterParameter().setQFilters(qFilters);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.setDataListOrder();
        List columnList = args.getListColumns();
        int seq = columnList.size() + 1;
        ListColumn column = new ListColumn();
        column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c\u5df2\u8fd0\u884c", (String)"AccResultListViewPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        column.setKey("runaccresult");
        column.setListFieldKey("runaccresult");
        column.setSeq(seq);
        columnList.add(column);
    }

    private void setDataListOrder() {
        StringBuilder sb = new StringBuilder();
        sb.append("employee.person.number asc,");
        sb.append("salaryfile.number asc,");
        sb.append("acc.number asc,");
        sb.append("startdate desc");
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
        billList.setOrderBy(sb.toString());
    }

    private boolean checkQueryDate() {
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(END_DATE);
        if (startDate != null && endDate != null && startDate.getTime() > endDate.getTime()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u9700\u5c0f\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"AccResultListViewPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(END_DATE, null);
            return false;
        }
        return true;
    }

    private void doModifyCheck(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectColl = args.getListSelectedData();
        if (selectColl.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4fee\u6539\u3002", (String)"AccResultListViewPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (selectColl.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4fee\u6539\u3002", (String)"AccResultListViewPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ListSelectedRow row = selectColl.get(0);
        Long accResultId = (Long)row.getPrimaryKeyValue();
        this.openAccResultDetailPage(accResultId, "modify");
    }

    public void setFilter(SetFilterEvent event) {
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection employeeList = data.getDynamicObjectCollection(EMPLOYEE);
        if (employeeList == null || employeeList.size() == 0) {
            QFilter qFilter = new QFilter("acc.id", "=", (Object)0L);
            qFilter.and("employee.id", "=", (Object)0L);
            qFilter.and("personindexid", "=", (Object)0L);
            event.getQFilters().add(qFilter);
            return;
        }
        DynamicObjectCollection accColl = this.getModel().getDataEntity().getDynamicObjectCollection(ACC);
        if (accColl != null && accColl.size() > 0) {
            Set accIdSet = accColl.stream().map(obj -> obj.getLong("fbasedataid.id")).collect(Collectors.toSet());
            event.getQFilters().add(new QFilter("acc.id", "in", accIdSet));
        }
        QFilter dateFilter1 = null;
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(END_DATE);
        if (startDate != null && endDate != null) {
            endDate = SWCDateTimeUtils.getOffsetDate((Date)endDate, (int)1);
            dateFilter1 = new QFilter("startdate", ">=", (Object)startDate);
            dateFilter1.and("startdate", "<", (Object)endDate);
            QFilter dateFilter2 = new QFilter("enddate", ">=", (Object)startDate);
            dateFilter2.and("enddate", "<", (Object)endDate);
            QFilter dateFilter3 = new QFilter("startdate", "<=", (Object)startDate);
            dateFilter3.and("enddate", ">", (Object)endDate);
            dateFilter1 = dateFilter1.or(dateFilter2).or(dateFilter3);
        } else if (startDate != null && endDate == null) {
            dateFilter1 = new QFilter("enddate", ">=", (Object)startDate);
        } else if (startDate == null && endDate != null) {
            endDate = SWCDateTimeUtils.getOffsetDate((Date)endDate, (int)1);
            dateFilter1 = new QFilter("startdate", "<", (Object)endDate);
        }
        if (dateFilter1 != null) {
            event.getQFilters().add(dateFilter1);
        }
        Set employeeIdSet = employeeList.stream().map(obj -> obj.getLong("fbasedataid.id")).collect(Collectors.toSet());
        AccResultDetailHelper detailHelper = new AccResultDetailHelper();
        Set personIndexIdSet = detailHelper.getPersonIndexIdSet(employeeIdSet);
        QFilter employeeFilter = new QFilter("employee.id", "in", employeeIdSet);
        employeeFilter.and("personindexid", "in", (Object)personIndexIdSet);
        DynamicObjectCollection salayFileList = data.getDynamicObjectCollection(SALARYFILE);
        if (salayFileList != null && salayFileList.size() > 0) {
            Set fileIdSet = salayFileList.stream().map(obj -> obj.getLong("fbasedataid.id")).collect(Collectors.toSet());
            employeeFilter.and(new QFilter("salaryfile.id", "in", fileIdSet));
        }
        event.getQFilters().add(employeeFilter);
        event.setOrderBy("employee.person.number asc,acc.number asc,instancenum asc,startdate desc");
    }

    private void queryClickEvent() {
        DynamicObjectCollection employeeColl = this.getModel().getDataEntity().getDynamicObjectCollection(EMPLOYEE);
        if (employeeColl == null || employeeColl.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u85aa\u4eba\u5458\u3002", (String)"AccResultListViewPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkQueryDate()) {
            return;
        }
        this.getView().invokeOperation("refresh");
    }

    private void resetClickEvent() {
        this.getModel().setValue(EMPLOYEE, null);
        this.getModel().setValue(SALARYFILE, null);
        this.getModel().setValue(ACC, null);
        if (this.getModel().getValue(START_DATE) != null) {
            this.getModel().setValue(START_DATE, null);
        }
        if (this.getModel().getValue(END_DATE) != null) {
            this.getModel().setValue(END_DATE, null);
        }
        this.getView().invokeOperation("refresh");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (SWCStringUtils.equals((String)"hsas_accresultlist", (String)this.getView().getEntityId())) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            ListSelectedRow selectRow = listView.getCurrentSelectedRowInfo();
            Long selectId = (Long)selectRow.getPrimaryKeyValue();
            if (selectId != null) {
                this.openAccResultDetailPage(selectId, "view");
            }
        }
    }

    private void openAccResultDetailPage(Long accResultId, String pageType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(ACC_RESULT_DETAIL_PAGE);
        showParameter.setCaption(ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c", (String)"AccResultListViewPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("accResultId", (Object)accResultId);
        showParameter.setCustomParam("pageType", (Object)pageType);
        this.getView().showForm(showParameter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.size() == 0) {
                    return rows;
                }
                AccResultListViewPlugin.this.addBillColumnProp(rows.getDynamicObjectType());
                AccResultCheckService checkService = new AccResultCheckService();
                Set accResultIdSet = rows.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
                Map accDetailMap = checkService.getAccDetailMapByAccResultId(accResultIdSet);
                String yes = ResManager.loadKDString((String)"\u662f", (String)"AccResultListViewPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                String no = ResManager.loadKDString((String)"\u5426", (String)"AccResultListViewPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                for (DynamicObject obj2 : rows) {
                    if (accDetailMap.containsKey(obj2.getLong("id"))) {
                        obj2.set("runaccresult", (Object)yes);
                        continue;
                    }
                    obj2.set("runaccresult", (Object)no);
                }
                return rows;
            }
        });
    }

    public void getEntityType(GetEntityTypeEventArgs eventArgs) {
        super.getEntityType(eventArgs);
        eventArgs.setNewEntityType(this.getEntityType());
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        BillList customControl = null;
        if (KEY_BILL_LIST_AP.equals(key)) {
            customControl = this.createBillList(key);
        }
        if (customControl != null) {
            args.setControl((Control)customControl);
        }
    }

    private BillList createBillList(String key) {
        if (this.billList != null) {
            return this.billList;
        }
        this.billList = new AccResultListEntityTypeBillList((EntityType)this.getEntityType());
        this.billList.setKey(key);
        this.billList.setEntityId("hsas_accresult");
        ListView listView = (ListView)this.getView();
        this.billList.setBillFormId(listView.getBillFormId());
        this.billList.setView((IFormView)listView);
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.billList);
        return this.billList;
    }

    private void replaceBillList(List<Control> items, Control billList) {
        for (int i = 0; i < items.size(); ++i) {
            Control control = items.get(i);
            if (control.getKey().equals(billList.getKey())) {
                items.set(i, billList);
                return;
            }
            if (!(control instanceof Container)) continue;
            this.replaceBillList(((Container)control).getItems(), billList);
        }
    }

    private MainEntityType getEntityType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hsas_accresult");
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = (MainEntityType)mainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            logger.error("getNewEntityType: ", (Throwable)e1);
        }
        if (mainEntityType == null) {
            return mainType;
        }
        this.addBillColumnProp((DynamicObjectType)mainEntityType);
        return mainEntityType;
    }

    private void addBillColumnProp(DynamicObjectType mainEntityType) {
        TextProp property = new TextProp();
        property.setName("runaccresult");
        property.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u7d2f\u52a0\u7ed3\u679c\u5df2\u8fd0\u884c", (String)"AccResultListViewPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        property.setMaxLenth(200);
        mainEntityType.addProperty((DynamicProperty)property);
    }
}

