/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.accumulator.accresultlist;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsas.business.accumulator.AccResultCheckService;

public class AdjustDataPlugin
extends AbstractFormPlugin {
    public static final String DONOTHING_OK = "donothing_ok";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        BigDecimal oldValue = (BigDecimal)parameter.getCustomParam("resultValue");
        Integer scale = (Integer)parameter.getCustomParam("scale");
        HashMap mapHead = Maps.newHashMap();
        HashMap map = Maps.newHashMap();
        map.put("sc", scale);
        mapHead.put("item", map);
        this.getView().updateControlMetadata("oldresultvalue", (Map)mapHead);
        this.getView().updateControlMetadata("newresultvalue", (Map)mapHead);
        this.getModel().setValue("oldresultvalue", (Object)oldValue);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (DONOTHING_OK.equals(operate.getOperateKey())) {
            BigDecimal value = this.getModel().getDataEntity().getBigDecimal("newresultvalue");
            if (value == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u7d2f\u52a0\u7ed3\u679c\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustDataPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Long accResultId = (Long)parameter.getCustomParam("accResultId");
            Long employeeId = (Long)parameter.getCustomParam("employee");
            String salaryFileIdStr = (String)parameter.getCustomParam("salaryfile");
            Long personIndexId = (Long)parameter.getCustomParam("personindexid");
            HashMap<String, Long> personMap = new HashMap<String, Long>(2);
            personMap.put("employee", employeeId);
            personMap.put("salaryfile", Long.parseLong(salaryFileIdStr));
            AccResultCheckService checkService = new AccResultCheckService();
            try {
                checkService.checkDataAndSave(accResultId.longValue(), value, personIndexId, personMap);
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u6574\u6210\u529f\uff01", (String)"AdjustDataPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    parentView.invokeOperation("refresh");
                    this.getView().sendFormAction(parentView);
                }
                this.getView().close();
            }
            catch (Exception ex) {
                this.getView().showTipNotification(ex.getMessage());
                args.setCancel(true);
                return;
            }
        }
    }
}

