/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.agencypay;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.agencypay.AgencyPayHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldBillHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AgencyPayBillEdit
extends AbstractBillPlugIn {
    private static final String CALLBACKID_ADD_PERSON = "callBackIdAddPerson";
    private static final String KEY_OVERVIEW_SHOW = "overviewshow";
    private static final String KEY_OPEN_OVERVIEW = "openoverview";
    private static final String KEY_CLOSE_OVERVIEW = "closeoverview";
    private static final String KEY_SHOWDOWN = "showdown";
    private static final String KEY_SHOWUP = "showup";
    private static final String KEY_FLEX_PANEL_SUB = "flexpanelap_sub";
    private static final String KEY_FLEX_PANEL_LINE = "flexpanelap_line";
    private static final String KEY_FLEX_PANEL_PARENT = "flexpanelap_parent";
    private static final String HSAS_AGENCYINFOPANEL = "hsas_agencyinfopanel";
    private static final String KEY_ISWRITEBACK = "iswriteback";
    private static final String KEY_PAYAMOUNT = "payamount";
    public final Log log = LogFactory.getLog(AgencyPayBillEdit.class);

    public void afterLoadData(EventObject eventObject) {
        this.setOnHoldStatusColor();
        this.getModel().setDataChanged(false);
        AdvContainer adv = (AdvContainer)this.getControl("advconap3");
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)viewStatus)) {
            adv.setCollapse(false);
        } else {
            adv.setCollapse(true);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        UpdateTabNameHelper.updateTabName((IFormView)this.getView(), (String)"billno");
        String isFirstIn = this.getView().getPageCache().get("isFirstIn");
        if (StringUtils.isEmpty((CharSequence)isFirstIn)) {
            this.getView().getPageCache().put("isFirstIn", "true");
            this.initAgencyInfoPanel();
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setEntryAmount();
        this.setBillStatus();
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{KEY_OPEN_OVERVIEW, KEY_CLOSE_OVERVIEW});
    }

    public void click(EventObject evt) {
        String clkKey;
        super.click(evt);
        switch (clkKey = ((Control)evt.getSource()).getKey()) {
            case "openoverview": {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_OPEN_OVERVIEW, KEY_SHOWDOWN});
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CLOSE_OVERVIEW, KEY_SHOWUP, KEY_FLEX_PANEL_LINE, KEY_FLEX_PANEL_SUB});
                Map<String, Map<String, Object>> infoMaps = this.getAgencyInfoMap(new HashMap<String, Integer>(16));
                FlexPanelAp parenPanelAp = this.getFlexPanelAp("parenPanelAp");
                for (Map.Entry<String, Map<String, Object>> entry : infoMaps.entrySet()) {
                    this.showAgencyInfoPanelInCycle(entry.getValue(), parenPanelAp);
                }
                break;
            }
            case "closeoverview": {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_OPEN_OVERVIEW, KEY_SHOWDOWN});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CLOSE_OVERVIEW, KEY_SHOWUP, KEY_FLEX_PANEL_SUB, KEY_FLEX_PANEL_LINE});
                FlexPanelAp parenPanelAp = this.getFlexPanelAp("parenPanelAp");
                this.getView().updateControlMetadata(parenPanelAp.getKey(), parenPanelAp.createControl());
                this.getView().updateControlMetadata(KEY_FLEX_PANEL_SUB, parenPanelAp.createControl());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "donothing_addent": {
                this.getModel().setValue(KEY_ISWRITEBACK, (Object)Boolean.TRUE);
                break;
            }
            case "deleteentry": {
                this.getModel().setValue(KEY_ISWRITEBACK, (Object)Boolean.TRUE);
                break;
            }
            case "save": {
                Boolean isWriteBack = (Boolean)this.getModel().getValue(KEY_ISWRITEBACK);
                if (isWriteBack != null && isWriteBack.booleanValue()) {
                    formOperate.getOption().setVariableValue(KEY_ISWRITEBACK, Boolean.TRUE.toString());
                    break;
                }
                formOperate.getOption().setVariableValue(KEY_ISWRITEBACK, Boolean.FALSE.toString());
                break;
            }
            case "submitfi": {
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
                if (entryColl == null || entryColl.isEmpty()) {
                    String msg = ResManager.loadKDString((String)"\u4ee3\u53d1\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgencyPayBillEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(msg);
                    args.setCancel(true);
                    return;
                }
                Set<Long> detailIds = this.getEntryPayDetailIds();
                long billId = this.getModel().getDataEntity().getLong("id");
                long payrollGroupId = this.getModel().getDataEntity().getLong("payrollgrp.id");
                long orgId = this.getModel().getDataEntity().getLong("org.id");
                QFilter filter = AgencyPayHelper.getQFilter((long)billId, detailIds, (long)payrollGroupId, (long)orgId);
                QFilter billIdFilter = new QFilter("agencypaybill.id", "=", (Object)billId);
                filter.or(billIdFilter);
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
                DynamicObjectCollection detailDys = helper.queryOriginalCollection("id", filter.toArray());
                HashSet<Long> enableDetailIds = new HashSet<Long>(detailDys.size());
                for (Object detailDy : detailDys) {
                    enableDetailIds.add(detailDy.getLong("id"));
                }
                int index = 1;
                for (DynamicObject ent : entryColl) {
                    if (!enableDetailIds.contains(ent.getLong("paydetail.id"))) {
                        String content = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4ee3\u53d1\u5206\u5f55\u7b2c%s\u884c\uff1a\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u7b26\u5408\u6dfb\u52a0\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u8c03\u6574\u3002", (String)"AgencyPaySaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), index);
                        this.getView().showErrorNotification(content);
                        args.setCancel(true);
                        return;
                    }
                    ++index;
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("isSubmit", "true");
                this.getView().invokeOperation("save", option);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "donothing_addent": {
                this.openPayDetailF7();
                break;
            }
            case "deleteentry": {
                this.adjustCountInfo();
                this.initAgencyInfoPanel();
                break;
            }
            case "submitfi": {
                FormShowParameter param = this.getView().getFormShowParameter();
                if (OperationStatus.VIEW.equals((Object)param.getStatus())) {
                    param.setStatus(OperationStatus.EDIT);
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "save": {
                FormOperate formOperate = (FormOperate)args.getSource();
                boolean isFromSubmit = formOperate.getOption().tryGetVariableValue("isSubmit", new RefObject());
                OperationResult result = args.getOperationResult();
                if (!isFromSubmit || !result.isSuccess()) break;
                result.setShowMessage(false);
                break;
            }
            case "unsubmit": {
                FormShowParameter formParam = this.getView().getFormShowParameter();
                if (!OperationStatus.EDIT.equals((Object)formParam.getStatus())) break;
                formParam.setStatus(OperationStatus.VIEW);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actId;
        super.closedCallBack(event);
        switch (actId = event.getActionId()) {
            case "callBackIdAddPerson": {
                this.addClosedCallBackEvent(event);
                break;
            }
        }
    }

    private void setOnHoldStatusColor() {
        DynamicObjectCollection subEntryEntityList = this.getModel().getEntryEntity("entryentity");
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ArrayList rowStyle = new ArrayList(10);
        for (int i = 0; i < subEntryEntityList.size(); ++i) {
            DynamicObject object = (DynamicObject)subEntryEntityList.get(i);
            String onHoldStatus = object.getString("paydetail.onholdstatus");
            HashMap<String, Object> val = new HashMap<String, Object>(4);
            val.put("r", i);
            val.put("c", "onholdstatus");
            val.put("s", OnHoldBillHelper.getOnHoldStatusStyle((String)onHoldStatus));
            rowStyle.add(val);
        }
        clientViewProxy.invokeControlMethod("entryentity", "setCellStyle", new Object[]{rowStyle});
    }

    private void addClosedCallBackEvent(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        ListSelectedRowCollection dataColl = (ListSelectedRowCollection)returnData;
        if (dataColl == null) {
            return;
        }
        DynamicObject[] payDetails = this.queryDataForEnt(dataColl.getPrimaryKeyValues());
        this.addDetailToEnt(payDetails);
        this.adjustCountInfo();
        this.setOnHoldStatusColor();
        this.setEntryAmount();
        this.initAgencyInfoPanel();
    }

    private void addDetailToEnt(DynamicObject[] payDetails) {
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        TableValueSetter vsData = new TableValueSetter(new String[0]);
        this.initTableValueSetter(vsData);
        Date nowDate = new Date();
        long nowUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject detail : payDetails) {
            long payerId = this.getDefaultPayer(detail.getDynamicObject("paysubjecthis"));
            vsData.addRow(new Object[]{detail.getLong("id"), detail.getLong("salaryfilehis.id"), detail.getLong("paysubjecthis.id"), payerId, nowUserId, nowDate, detail.getLong("caltask.payrollgroup.id"), "0", detail.getLong("perbankcard.id"), detail.getLong("paytype.id")});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", vsData);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private long getDefaultPayer(DynamicObject paySubjectHis) {
        if (paySubjectHis == null) {
            return 0L;
        }
        DynamicObjectCollection entryentity = paySubjectHis.getDynamicObjectCollection("payorgent");
        for (DynamicObject ent : entryentity) {
            if (!ent.getBoolean("isdefault")) continue;
            return ent.getLong("agentpayorg.id");
        }
        return 0L;
    }

    private void initTableValueSetter(TableValueSetter vsData) {
        vsData.addField("paydetail", new Object[0]);
        vsData.addField("salaryfilehis", new Object[0]);
        vsData.addField("paysubjectv", new Object[0]);
        vsData.addField("agentpayorg", new Object[0]);
        vsData.addField("operator", new Object[0]);
        vsData.addField("operatedate", new Object[0]);
        vsData.addField("payrollgroup", new Object[0]);
        vsData.addField("paystate", new Object[0]);
        vsData.addField("perbankcardv", new Object[0]);
        vsData.addField("paytype", new Object[0]);
    }

    private DynamicObject[] queryDataForEnt(Object[] primaryKeyValues) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        String selectFields = "id,salaryfilehis.id,paysubjecthis.id,paysubjecthis.payorgent,caltask.payrollgroup.id,perbankcard.id,paytype.id";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)};
        return helper.query(selectFields, filters);
    }

    private void openPayDetailF7() {
        Set<Long> detailIds = this.getEntryPayDetailIds();
        long billId = this.getModel().getDataEntity().getLong("id");
        long payrollGroupId = this.getModel().getDataEntity().getLong("payrollgrp.id");
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        QFilter filter = AgencyPayHelper.getQFilter((long)billId, detailIds, (long)payrollGroupId, (long)orgId);
        if (detailIds.size() > 0) {
            filter.and("id", "not in", detailIds);
        }
        QFilter billIdFilter = new QFilter("agencypaybill.id", "=", (Object)billId);
        if (detailIds.size() > 0) {
            billIdFilter.and("id", "not in", detailIds);
        }
        filter.or(billIdFilter);
        this.openF7("hsas_paydetail", true, CALLBACKID_ADD_PERSON, filter);
    }

    private Set<Long> getEntryPayDetailIds() {
        DynamicObjectCollection coll = this.getModel().getEntryEntity("entryentity");
        int estimatedSize = coll.size() * 4 / 3;
        HashSet billIds = Sets.newHashSetWithExpectedSize((int)estimatedSize);
        for (DynamicObject dynamicObject : coll) {
            long paydetailId = dynamicObject.getLong("paydetail.id");
            if (paydetailId == 0L) continue;
            billIds.add(paydetailId);
        }
        return billIds;
    }

    private void openF7(String formId, boolean isMultiSelect, String actionId, QFilter filter) {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
        para.getListFilterParameter().setFilter(filter);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm((FormShowParameter)para);
    }

    private Map<String, Map<String, Object>> getAgencyInfoMap(Map<String, Integer> countMap) {
        DynamicObjectCollection ents = this.getModel().getEntryEntity("entryentity");
        int totalCount = 0;
        int successCountAll = 0;
        int failureCountAll = 0;
        HashMap<String, Map<String, Object>> infoMaps = new HashMap<String, Map<String, Object>>(ents.size());
        for (DynamicObject dyObj : ents) {
            BigDecimal amount = dyObj.getBigDecimal("paydetail.payamount");
            String curName = dyObj.getString("paydetail.paycurrency.name");
            String curSign = dyObj.getString("paydetail.paycurrency.sign");
            long curId = dyObj.getLong("paydetail.paycurrency.id");
            Object curScale = dyObj.get("paydetail.paycurrency.amtprecision");
            String payState = dyObj.getString("paystate");
            HashMap<String, Object> panelInfo = (HashMap<String, Object>)infoMaps.get(String.valueOf(curId));
            int successCount = 0;
            int failureCount = 0;
            if (panelInfo == null) {
                panelInfo = new HashMap<String, Object>(16);
                panelInfo.put("currencyName", curName);
                panelInfo.put("currencySign", curSign);
                panelInfo.put("currencyId", curId);
                panelInfo.put("amount", amount);
                panelInfo.put("currencyScale", curScale);
                panelInfo.put("totalCount", 1);
                if (SWCStringUtils.equals((String)payState, (String)"1")) {
                    successCount = 1;
                } else if (SWCStringUtils.equals((String)payState, (String)"-1")) {
                    failureCount = 1;
                }
                panelInfo.put("successCount", successCount);
                panelInfo.put("failureCount", failureCount);
            } else {
                BigDecimal addRes = amount.add((BigDecimal)panelInfo.get("amount"));
                panelInfo.put("amount", addRes);
                panelInfo.put("totalCount", (Integer)panelInfo.get("totalCount") + 1);
                if (SWCStringUtils.equals((String)payState, (String)"1")) {
                    successCount = (Integer)panelInfo.get("successCount") + 1;
                    panelInfo.put("successCount", successCount);
                } else if (SWCStringUtils.equals((String)payState, (String)"-1")) {
                    failureCount = (Integer)panelInfo.get("failureCount") + 1;
                    panelInfo.put("failureCount", failureCount);
                }
            }
            infoMaps.put(String.valueOf(curId), panelInfo);
            if (SWCStringUtils.equals((String)payState, (String)"1")) {
                ++successCountAll;
            } else if (SWCStringUtils.equals((String)payState, (String)"-1")) {
                ++failureCountAll;
            }
            ++totalCount;
        }
        countMap.put("totalCount", totalCount);
        countMap.put("successCountAll", successCountAll);
        countMap.put("failureCountAll", failureCountAll);
        return infoMaps;
    }

    private void showAgencyInfoPanel(boolean isAll, Map<String, Object> infoPanel, int totalCount, int successCount, int failureCount, String targetKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("totalcount", (Object)totalCount);
        showParameter.setCustomParam("isAll", (Object)isAll);
        showParameter.setCustomParam("successcount", (Object)successCount);
        showParameter.setCustomParam("failurecount", (Object)failureCount);
        if (isAll) {
            Object currencyName = infoPanel.get("currencyName");
            Object currencySign = infoPanel.get("currencySign");
            Object currencyScale = infoPanel.get("currencyScale");
            Object amount = infoPanel.get("amount");
            showParameter.setCustomParam("amount", amount);
            showParameter.setCustomParam("currencyName", currencyName);
            showParameter.setCustomParam("currencySign", currencySign);
            showParameter.setCustomParam("currencyScale", currencyScale);
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(HSAS_AGENCYINFOPANEL);
        this.getView().showForm(showParameter);
    }

    private void showAgencyInfoPanelInCycle(Map<String, Object> infoPanel, FlexPanelAp parentAp) {
        String subKey = "subPanelAp" + System.currentTimeMillis();
        FlexPanelAp subFlexPanelAp = new FlexPanelAp();
        subFlexPanelAp.setKey(subKey);
        subFlexPanelAp.setId(subKey);
        subFlexPanelAp.setWidth(new LocaleString("100%"));
        this.getView().updateControlMetadata(subFlexPanelAp.getKey(), subFlexPanelAp.createControl());
        parentAp.getItems().add(subFlexPanelAp);
        this.getView().updateControlMetadata(parentAp.getKey(), parentAp.createControl());
        this.showAgencyInfoPanel(true, infoPanel, (Integer)infoPanel.get("totalCount"), (Integer)infoPanel.get("successCount"), (Integer)infoPanel.get("failureCount"), subKey);
        this.getView().updateControlMetadata(KEY_FLEX_PANEL_SUB, parentAp.createControl());
    }

    private FlexPanelAp getFlexPanelAp(String key) {
        FlexPanelAp parentAp = new FlexPanelAp();
        parentAp.setWidth(new LocaleString("100%"));
        parentAp.setKey(key);
        parentAp.setId(key);
        parentAp.setWrap(true);
        parentAp.setDirection("row");
        parentAp.setAlignContent("flex-start");
        parentAp.setAlignItems("flex-start");
        parentAp.setJustifyContent("center");
        return parentAp;
    }

    private void adjustCountInfo() {
        int unpayCount = 0;
        int totalCount = 0;
        int successCount = 0;
        int unpayCountofStop = 0;
        int unpayCountofAbandon = 0;
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("entryentity");
        for (DynamicObject ent : entryEntity) {
            String payState = ent.getString("paystate");
            int onholdStatus = ent.getInt("paydetail.onholdstatus");
            if (SWCStringUtils.equals((String)payState, (String)"1")) {
                ++successCount;
            } else if (SWCStringUtils.equals((String)payState, (String)"-1")) {
                ++unpayCount;
            }
            if (onholdStatus == OnHoldStatusEnum.STATUS_STOPPAY.getCode()) {
                ++unpayCountofStop;
                continue;
            }
            if (onholdStatus != OnHoldStatusEnum.ABANDON.getCode()) continue;
            ++unpayCountofAbandon;
        }
        totalCount = entryEntity.size() - unpayCountofAbandon;
        this.getModel().setValue("totalcount", (Object)totalCount);
        this.getModel().setValue("unpaycount", (Object)unpayCount);
        this.getModel().setValue("paidcount", (Object)successCount);
    }

    private void setEntryAmount() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int index = 0;
        for (DynamicObject dyObj : entryEntity) {
            String curSign = dyObj.getString("paydetail.paycurrency.sign");
            int curScale = dyObj.getInt("paydetail.paycurrency.amtprecision");
            BigDecimal amount = dyObj.getBigDecimal("paydetail.payamount");
            BigDecimal bigDecimal = AgencyPayHelper.setAmountScale((BigDecimal)amount, (int)curScale);
            String amountStr = AgencyPayHelper.formateDecimal((String)bigDecimal.toString());
            this.getModel().setValue(KEY_PAYAMOUNT, (Object)(curSign + amountStr), index);
            ++index;
        }
    }

    private void initAgencyInfoPanel() {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        Map<String, Map<String, Object>> infoMaps = this.getAgencyInfoMap(countMap);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PANEL_SUB, KEY_FLEX_PANEL_LINE});
        if (infoMaps.isEmpty()) {
            this.showAgencyInfoPanel(false, new HashMap<String, Object>(), 0, 0, 0, KEY_FLEX_PANEL_PARENT);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_OVERVIEW_SHOW});
        } else if (infoMaps.size() == 1) {
            for (Map.Entry<String, Map<String, Object>> entry : infoMaps.entrySet()) {
                this.showAgencyInfoPanel(true, entry.getValue(), (Integer)countMap.get("totalCount"), (Integer)countMap.get("successCountAll"), (Integer)countMap.get("failureCountAll"), KEY_FLEX_PANEL_PARENT);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_OVERVIEW_SHOW});
            FlexPanelAp parenPanelAp = this.getFlexPanelAp("parenPanelAp");
            this.getView().updateControlMetadata(parenPanelAp.getKey(), parenPanelAp.createControl());
            this.getView().updateControlMetadata(KEY_FLEX_PANEL_SUB, parenPanelAp.createControl());
        } else {
            this.showAgencyInfoPanel(false, new HashMap<String, Object>(), (Integer)countMap.get("totalCount"), (Integer)countMap.get("successCountAll"), (Integer)countMap.get("failureCountAll"), KEY_FLEX_PANEL_PARENT);
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_OVERVIEW_SHOW, KEY_SHOWDOWN, KEY_OPEN_OVERVIEW});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CLOSE_OVERVIEW, KEY_SHOWUP});
            FlexPanelAp parenPanelAp = this.getFlexPanelAp("parenPanelAp");
            this.getView().updateControlMetadata(parenPanelAp.getKey(), parenPanelAp.createControl());
            this.getView().updateControlMetadata(KEY_FLEX_PANEL_SUB, parenPanelAp.createControl());
        }
    }

    private void setBillStatus() {
        String auditStatus = (String)this.getModel().getValue("auditstatus");
        if ("A".equals(auditStatus)) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        } else if ("B".equals(auditStatus)) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
        } else if ("J".equals(auditStatus) || "K".equals(auditStatus)) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
        }
    }
}

