/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.agencypay;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CreateBillConfirmPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(CreateBillConfirmPlugin.class);
    private static final String CONTEXT = "context";
    private static final String BTN_OK = "btnyes";
    private static final String LBL_EXPORT = "exportexcel";
    private static final String LBL_ISSPLIT = "issplit";
    private static final String AP_ISSPLIT = "issplitap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, LBL_EXPORT});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "exportexcel": {
                this.doExport();
                break;
            }
            case "btnyes": {
                this.doYes();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formParam = this.getView().getFormShowParameter();
        Map params = formParam.getCustomParams();
        String context = (String)params.get(CONTEXT);
        Boolean isShowSplit = (Boolean)params.get("isShowSplit");
        String failListStr = (String)params.get("failList");
        String context1 = (String)params.get("context1");
        if (SWCStringUtils.isEmpty((String)failListStr)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LBL_EXPORT});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{LBL_EXPORT});
        }
        if (null != context1) {
            this.getModel().setValue("context1", (Object)context1);
        }
        this.getModel().setValue(CONTEXT, (Object)context);
        if (isShowSplit != null && !isShowSplit.booleanValue()) {
            this.getView().setVisible(isShowSplit, new String[]{AP_ISSPLIT});
        }
    }

    private void doYes() {
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
        Boolean issplit = (Boolean)this.getModel().getValue(LBL_ISSPLIT);
        if (issplit != null && issplit.booleanValue()) {
            returnData.put(LBL_ISSPLIT, Boolean.TRUE);
        } else {
            returnData.put(LBL_ISSPLIT, Boolean.FALSE);
        }
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    private void doExport() {
        FormShowParameter formParam = this.getView().getFormShowParameter();
        Map params = formParam.getCustomParams();
        String failListStr = (String)params.get("failList");
        String operateName = (String)params.get("operateName");
        List failList = SerializationUtils.fromJsonStringToList((String)failListStr, String.class);
        ArrayList data = Lists.newArrayListWithExpectedSize((int)failList.size());
        ArrayList head = Lists.newArrayListWithExpectedSize((int)10);
        this.setExportInfo(operateName, failList, data, head);
        String format = ResManager.loadKDString((String)"\u751f\u6210\u53d1\u653e\u660e\u7ec6_\u9519\u8bef\u8be6\u60c5_%s", (String)"CreateBillConfirmPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        Date now = new Date();
        String nowStr = SWCDateTimeUtils.format((Date)now, (String)"MMdd");
        String excelName = String.format(Locale.ROOT, format, nowStr);
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)data, (List)head);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        if (!SWCStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private void setExportInfo(String operateName, List<String> failList, List<Map<String, Object>> data, List<HRExportHeadObject> head) {
        HRExportHeadObject headObj1 = new HRExportHeadObject();
        headObj1.setColumnId("operateName");
        headObj1.setColumnAlias(ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"CreateBillConfirmPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        HRExportHeadObject headObj2 = new HRExportHeadObject();
        headObj2.setColumnId("failInfo");
        headObj2.setColumnAlias(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"CreateBillConfirmPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        head.add(headObj1);
        head.add(headObj2);
        HashMap map = null;
        for (String failInfo : failList) {
            map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("operateName", operateName);
            map.put("failInfo", failInfo);
            data.add(map);
        }
    }
}

