/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.approve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsas.business.approve.ApproveBillTplService;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.business.util.MultiLangHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ApproveDealSchemeEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ApproveDealSchemeEdit.class);

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.init();
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit reportScheme = (BasedataEdit)this.getView().getControl("reportscheme");
        reportScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("btnok".equals(operate.getOperateKey()) && !SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_approvebilltpl", (String)"4715a0df000000ac")) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201c\u85aa\u8d44\u5ba1\u6279\u5355\u6a21\u677f\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalApproveBillTplTips_57", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            args.setCancelMessage(msg);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "btnok": {
                if (!args.getOperationResult().isSuccess()) break;
                if (this.saveModify()) {
                    IFormView msgView = this.msgView();
                    msgView.showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f\u3002", (String)"CalApproveBillTplTips_50", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    if (!msgView.equals(this.getView())) {
                        this.getView().sendFormAction(msgView);
                    }
                }
                this.dealClose();
                break;
            }
        }
    }

    private IFormView msgView() {
        String parentPageId;
        IFormView parentView = this.getView();
        IFormView parentTempView = parentView.getViewNoPlugin(parentPageId = parentView.getFormShowParameter().getParentPageId());
        if (parentTempView == null) {
            return parentView;
        }
        parentView = parentTempView;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approveschememsg");
        QFilter solvedFilter = new QFilter("issolved", "=", (Object)Boolean.FALSE);
        QFilter tplFilter = ApproveBillTplService.packageTplFilterForSchemeMsg();
        Object[] approveSchemeMsgArr = helper.query("id, issolved", new QFilter[]{solvedFilter, tplFilter});
        if (!ArrayUtils.isEmpty((Object[])approveSchemeMsgArr)) {
            return parentView;
        }
        parentPageId = parentView.getFormShowParameter().getParentPageId();
        parentTempView = parentView.getViewNoPlugin(parentPageId);
        if (parentTempView != null) {
            parentView = parentTempView;
        }
        return parentView;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)"reportscheme")) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_salaryrptdisplayschm", (boolean)false);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectSchemeClose"));
            int entryIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dealDy = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryIndex);
            DynamicObject approveBillTplDy = dealDy.getDynamicObject("approvebilltpl");
            DynamicObjectCollection schemeEntryEntity = approveBillTplDy.getDynamicObjectCollection("schemeentryentity");
            List sourceSchemeIds = ApproveBillTplService.getSourceSchemeIds((DynamicObjectCollection)schemeEntryEntity);
            String referReport = dealDy.getString("referreport");
            List qFilters = ApproveBillTplService.getSchemeFilters((ListShowParameter)showParameter, (IFormView)this.getView(), (String)referReport, (List)sourceSchemeIds);
            if (!CollectionUtils.isEmpty((Collection)qFilters)) {
                showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
                this.getView().showForm((FormShowParameter)showParameter);
            }
            event.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "selectSchemeClose": {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    return;
                }
                Long reportSchemeId = (Long)selectedRows.get(0).getPrimaryKeyValue();
                int entryIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("reportscheme", (Object)reportSchemeId, entryIndex);
                this.getView().updateView("entryentity", entryIndex);
                break;
            }
        }
    }

    private void init() {
        List<Long> approveSchemeMsgIds = this.getSelectApproveSchemeMsgIds();
        SWCDataServiceHelper approveSchemeMsgHelper = new SWCDataServiceHelper("hsas_approveschememsg");
        DynamicObject[] approveSchemeMsgArr = this.queryApproveSchemeMsgArr(approveSchemeMsgIds, approveSchemeMsgHelper);
        int modifyNum = 0;
        String split = MultiLangHelper.getMultiLangCommaDelimiter();
        TableValueSetter setter = this.createTableSetter();
        for (DynamicObject approveSchemeMsgDy : approveSchemeMsgArr) {
            String modifyType = approveSchemeMsgDy.getString("modifytype");
            if ("1".equals(modifyType)) {
                ++modifyNum;
                String modifyApproveSchemeMsgListStr = this.getView().getPageCache().get("modifyApproveSchemeMsgList");
                if (StringUtils.isEmpty((String)modifyApproveSchemeMsgListStr)) {
                    this.getView().getPageCache().put("modifyApproveSchemeMsgList", SerializationUtils.serializeToBase64((Object)Lists.newArrayList((Object[])new DynamicObject[]{approveSchemeMsgDy})));
                    continue;
                }
                List modifyApproveSchemeMsgList = (List)SerializationUtils.deSerializeFromBase64((String)modifyApproveSchemeMsgListStr);
                modifyApproveSchemeMsgList.add(approveSchemeMsgDy);
                this.getView().getPageCache().put("modifyApproveSchemeMsgList", SerializationUtils.serializeToBase64((Object)modifyApproveSchemeMsgList));
                continue;
            }
            DynamicObject approveBillTplDy = approveSchemeMsgDy.getDynamicObject("approvebilltpl");
            DynamicObjectCollection schemeCollection = approveBillTplDy.getDynamicObjectCollection("schemeentryentity");
            Long reportSchemeId = approveSchemeMsgDy.getLong("reportscheme.id");
            String schemeName = "";
            String referReportName = "";
            for (DynamicObject schemeDy : schemeCollection) {
                Long schemeId = schemeDy.getLong("reportscheme.id");
                if (!schemeId.equals(reportSchemeId)) continue;
                schemeName = kd.bos.util.StringUtils.isEmpty((String)schemeName) ? schemeDy.getString("schemename") : schemeName + split + schemeDy.getString("schemename");
                referReportName = schemeDy.getString("referreport");
            }
            setter.addRow(new Object[]{schemeName, referReportName, null, approveSchemeMsgDy.getLong("approvebilltpl.id"), approveSchemeMsgDy.getLong("id")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
        int countTotal = approveSchemeMsgIds.size();
        Label labelTotal = (Label)this.getView().getControl("counttotal");
        labelTotal.setText(String.valueOf(countTotal));
        Label labelModify = (Label)this.getView().getControl("modifynum");
        if (modifyNum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
        } else {
            labelModify.setText(String.valueOf(modifyNum));
        }
        int deleteNum = countTotal - modifyNum;
        if (deleteNum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap31"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        } else {
            Label labelDelete = (Label)this.getView().getControl("deletenum");
            labelDelete.setText(String.valueOf(deleteNum));
        }
    }

    private List<Long> getSelectApproveSchemeMsgIds() {
        ListSelectedRowCollection listSelectedRows = this.getListSelectedRows();
        ArrayList<Long> approveSchemeMsgIds = new ArrayList<Long>(10);
        for (ListSelectedRow selectedRow : listSelectedRows) {
            approveSchemeMsgIds.add((Long)selectedRow.getPrimaryKeyValue());
        }
        return approveSchemeMsgIds;
    }

    private boolean saveModify() {
        Date modifyTime = new Date();
        SWCDataServiceHelper approveSchemeMsgHelper = new SWCDataServiceHelper("hsas_approveschememsg");
        List<Long> approveSchemeMsgIds = this.getSelectApproveSchemeMsgIds();
        QFilter filter = new QFilter("id", "in", approveSchemeMsgIds);
        Object[] approveSchemeMsgArr = approveSchemeMsgHelper.query("id, issolved, modifytime, schemename, reportname, reportscheme.id, reportscheme.number, reportscheme.name, reportscheme.sourceid,approvebilltpl.id, approvebilltpl.number, approvebilltpl.enable, approvebilltpl.schemeentryentity", new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])approveSchemeMsgArr)) {
            return true;
        }
        int totalSize = approveSchemeMsgArr.length;
        this.resolveSchemeName((DynamicObject[])approveSchemeMsgArr);
        HashMap successMsg = Maps.newHashMapWithExpectedSize((int)totalSize);
        ArrayList failedMsg = Lists.newArrayListWithExpectedSize((int)totalSize);
        String resolvedMsgTpl = ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u6a21\u677f{0}\u7684\u5ba1\u6279\u89c6\u56fe{1}\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u65e0\u9700\u91cd\u590d\u5904\u7406\u3002", (String)"CalApproveBillTplTips_52", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        for (Object msgDy : approveSchemeMsgArr) {
            if (msgDy.getBoolean("issolved")) {
                failedMsg.add(MessageFormat.format(resolvedMsgTpl, msgDy.getString("approvebilltpl.number"), msgDy.getString("schemename")));
                continue;
            }
            msgDy.set("modifytime", (Object)modifyTime);
            msgDy.set("issolved", (Object)Boolean.TRUE);
            successMsg.put(msgDy.getLong("id"), msgDy);
        }
        if (CollectionUtils.isEmpty((Map)successMsg)) {
            IFormView msgView = this.msgView();
            msgView.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u65e0\u9700\u91cd\u590d\u5904\u7406\u3002", (String)"CalApproveBillTplTips_51", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            if (!msgView.equals(this.getView())) {
                this.getView().sendFormAction(msgView);
            }
            return false;
        }
        try (TXHandle required = TX.required();){
            failedMsg.addAll(this.doDealApproveSchemeMsg(successMsg, modifyTime));
            approveSchemeMsgHelper.save(successMsg.values().toArray(new DynamicObject[0]));
            required.commit();
        }
        if (CollectionUtils.isEmpty((Collection)failedMsg)) {
            return true;
        }
        String operateName = ResManager.loadKDString((String)"\u5904\u7406\u7ed3\u679c", (String)"CalApproveBillTplTips_55", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String title = ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210\u3002\u5171{0}\u6761\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"CalApproveBillTplTips_56", (String)"swc-hsas-formplugin", (Object[])new Object[]{totalSize, totalSize - failedMsg.size(), failedMsg.size()});
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, (List)failedMsg);
        IFormView msgView = this.msgView();
        parameters.setParentPageId(msgView.getPageId());
        msgView.showForm(parameters);
        if (!msgView.equals(this.getView())) {
            this.getView().sendFormAction(msgView);
        }
        return false;
    }

    private void resolveSchemeName(DynamicObject[] approveSchemeMsgArr) {
        String split = MultiLangHelper.getMultiLangCommaDelimiter();
        for (DynamicObject msgDy : approveSchemeMsgArr) {
            DynamicObject approveBillTplDy = msgDy.getDynamicObject("approvebilltpl");
            if (approveBillTplDy == null) {
                msgDy.set("schemename", (Object)msgDy.getString("reportscheme.name"));
                continue;
            }
            Long reportSchemeId = msgDy.getLong("reportscheme.id");
            DynamicObjectCollection schemeEntry = approveBillTplDy.getDynamicObjectCollection("schemeentryentity");
            for (DynamicObject schemeDy : schemeEntry) {
                Long schemeId = schemeDy.getLong("reportscheme.id");
                if (!reportSchemeId.equals(schemeId)) continue;
                String schemeName = msgDy.getString("schemename");
                if (kd.bos.util.StringUtils.isEmpty((String)schemeName)) {
                    msgDy.set("schemename", (Object)schemeDy.getString("schemename"));
                    continue;
                }
                msgDy.set("schemename", (Object)(schemeName + split + schemeDy.getString("schemename")));
            }
        }
    }

    private List<String> doDealApproveSchemeMsg(Map<Long, DynamicObject> successMsg, Date modifyTime) {
        HashMap newSchemeOfOldOfApproveTpl = Maps.newHashMapWithExpectedSize((int)32);
        ArrayList failedMsg = Lists.newArrayListWithExpectedSize((int)newSchemeOfOldOfApproveTpl.size());
        this.resolveModifiedSchemes(successMsg, newSchemeOfOldOfApproveTpl);
        this.resolveDeletedSchemes(successMsg, newSchemeOfOldOfApproveTpl);
        if (CollectionUtils.isEmpty((Map)newSchemeOfOldOfApproveTpl)) {
            this.matchNoData(successMsg, failedMsg);
            return failedMsg;
        }
        SWCDataServiceHelper approveBillTplHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
        Map<Long, DynamicObject> approveBillTplDyMap = this.getApproveBillTplMap(newSchemeOfOldOfApproveTpl.keySet(), approveBillTplHelper);
        if (CollectionUtils.isEmpty(approveBillTplDyMap)) {
            this.matchNoData(successMsg, failedMsg);
            return failedMsg;
        }
        String tempMsgTpl = ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u6a21\u677f{0}\u7684\u5ba1\u6279\u89c6\u56fe{1}\uff1a\u5ba1\u6279\u5355\u6a21\u677f\u5b58\u5728\u6682\u5b58\u7248\u672c\uff0c\u65e0\u6cd5\u5904\u7406\u66f4\u65b0\u3002", (String)"CalApproveBillTplTips_54", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        HashMap matchNoMsg = Maps.newHashMap(successMsg);
        HashSet reportSchemeIdsToCopy = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry<Long, DynamicObject> entry : approveBillTplDyMap.entrySet()) {
            DynamicObject value = entry.getValue();
            Map pairMap = (Map)newSchemeOfOldOfApproveTpl.get(entry.getKey());
            if ("-3".equals(value.get("datastatus"))) {
                newSchemeOfOldOfApproveTpl.remove(entry.getKey());
                for (Map.Entry entry2 : pairMap.entrySet()) {
                    DynamicObject msgDy = (DynamicObject)((Pair)entry2.getValue()).getValue();
                    matchNoMsg.remove(msgDy.getLong("id"));
                    failedMsg.add(MessageFormat.format(tempMsgTpl, msgDy.getString("approvebilltpl.number"), msgDy.getString("schemename")));
                    successMsg.remove(((DynamicObject)((Pair)entry2.getValue()).getValue()).getLong("id"));
                }
                continue;
            }
            Map map = (Map)newSchemeOfOldOfApproveTpl.get(entry.getKey());
            for (Map.Entry pairEntry3 : map.entrySet()) {
                reportSchemeIdsToCopy.add(((Pair)pairEntry3.getValue()).getKey());
                matchNoMsg.remove(((DynamicObject)((Pair)pairEntry3.getValue()).getValue()).getLong("id"));
            }
        }
        if (successMsg.isEmpty() || newSchemeOfOldOfApproveTpl.isEmpty()) {
            return failedMsg;
        }
        Map copySchemeMap = SalaryRptService.copyDisplaySchemes((Collection)reportSchemeIdsToCopy, (String)"hsas_calapprovebilldetail");
        ArrayList<DynamicObject> updateApproveBillTplList = new ArrayList<DynamicObject>(approveBillTplDyMap.size());
        ArrayList<DynamicObject> auditApproveBillTplList = new ArrayList<DynamicObject>(approveBillTplDyMap.size());
        for (Map.Entry entry : approveBillTplDyMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            Map newSchemeOfOld = (Map)newSchemeOfOldOfApproveTpl.get(entry.getKey());
            if (newSchemeOfOld == null) continue;
            this.updatedApproveBillTpl(dynamicObject, newSchemeOfOld, copySchemeMap, modifyTime);
            if (StringUtils.equals((String)dynamicObject.getString("status"), (String)"C")) {
                auditApproveBillTplList.add(dynamicObject);
                continue;
            }
            updateApproveBillTplList.add(dynamicObject);
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        if (!updateApproveBillTplList.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            OperationResult operationResult = opImpl.localInvokeOperation("save", updateApproveBillTplList.toArray(new DynamicObject[0]), operateOption);
            logger.info("ApproveDealSchemeEdit.doDealApproveSchemeMsg save result {}", (Object)operationResult.isSuccess());
            if (!operationResult.isSuccess()) {
                List infoList = operationResult.getAllErrorOrValidateInfo();
                for (IOperateInfo info : infoList) {
                    Long pkValue = (Long)ObjectConverter.convert((Object)info.getPkValue(), Long.class, (boolean)false);
                    this.appendFailedMsg(failedMsg, info.getMessage(), (Map)newSchemeOfOldOfApproveTpl.get(pkValue));
                }
            }
        }
        if (!auditApproveBillTplList.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            for (DynamicObject object : auditApproveBillTplList) {
                OperationResult result = opImpl.localInvokeOperation("confirmchange", new DynamicObject[]{object}, operateOption);
                logger.info("ApproveDealSchemeEdit.doDealApproveSchemeMsg confirmchange result {}", (Object)result.isSuccess());
                if (result.isSuccess()) continue;
                this.appendFailedMsg(failedMsg, result.getMessage(), (Map)newSchemeOfOldOfApproveTpl.get(object.getLong("boid")));
            }
        }
        return failedMsg;
    }

    private void appendFailedMsg(List<String> failedMsg, String message, Map<Long, Pair<Long, DynamicObject>> pairMap) {
        if (CollectionUtils.isEmpty(pairMap)) {
            return;
        }
        String prefix = ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u6a21\u677f{0}\u7684\u5ba1\u6279\u89c6\u56fe{1}", (String)"CalApproveBillTplTips_59", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        for (Map.Entry<Long, Pair<Long, DynamicObject>> entry : pairMap.entrySet()) {
            DynamicObject msgDy = (DynamicObject)entry.getValue().getValue();
            failedMsg.add(MessageFormat.format(prefix, msgDy.getString("approvebilltpl.number"), msgDy.getString("schemename")) + message);
        }
    }

    private void matchNoData(Map<Long, DynamicObject> successMsg, List<String> failedMsg) {
        String resolvedMsgTpl = ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u6a21\u677f{0}\u7684\u5ba1\u6279\u89c6\u56fe{1}\uff1a\u6570\u636e\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"CalApproveBillTplTips_53", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        for (Map.Entry<Long, DynamicObject> entry : successMsg.entrySet()) {
            DynamicObject msgDy = entry.getValue();
            failedMsg.add(MessageFormat.format(resolvedMsgTpl, msgDy.getString("approvebilltpl.number"), msgDy.getString("schemename")));
        }
    }

    private void resolveModifiedSchemes(Map<Long, DynamicObject> successMsg, Map<Long, Map<Long, Pair<Long, DynamicObject>>> newSchemeOfOldOfApproveTpl) {
        String modifyApproveSchemeMsgListStr = this.getView().getPageCache().get("modifyApproveSchemeMsgList");
        if (!StringUtils.isEmpty((String)modifyApproveSchemeMsgListStr)) {
            List modifyApproveSchemeMsgList = (List)SerializationUtils.deSerializeFromBase64((String)modifyApproveSchemeMsgListStr);
            for (DynamicObject msgDy : modifyApproveSchemeMsgList) {
                DynamicObject modifyApproveSchemeMsgDy = successMsg.get(msgDy.getLong("id"));
                if (modifyApproveSchemeMsgDy == null) continue;
                long approveBillTplId = modifyApproveSchemeMsgDy.getLong("approvebilltpl.id");
                long oldReportSchemeId = modifyApproveSchemeMsgDy.getLong("reportscheme.id");
                long newReportSchemeId = modifyApproveSchemeMsgDy.getLong("reportscheme.sourceid");
                Map newSchemeOfOld = newSchemeOfOldOfApproveTpl.computeIfAbsent(approveBillTplId, ky -> Maps.newHashMapWithExpectedSize((int)8));
                newSchemeOfOld.put(oldReportSchemeId, Pair.of((Object)newReportSchemeId, (Object)modifyApproveSchemeMsgDy));
            }
        }
    }

    private void resolveDeletedSchemes(Map<Long, DynamicObject> successMsg, Map<Long, Map<Long, Pair<Long, DynamicObject>>> newSchemeOfOldOfApproveTpl) {
        DynamicObjectCollection dealSchemeEntity = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)dealSchemeEntity)) {
            for (DynamicObject dealSchemeDy : dealSchemeEntity) {
                DynamicObject approveSchemeMsgDy = dealSchemeDy.getDynamicObject("approveschememsg");
                DynamicObject msg = successMsg.get(approveSchemeMsgDy.getLong("id"));
                if (msg == null) continue;
                long approveBillTplId = approveSchemeMsgDy.getLong("approvebilltpl.id");
                long oldReportSchemeId = msg.getLong("reportscheme.id");
                long newReportSchemeId = dealSchemeDy.getLong("reportscheme.id");
                Map newSchemeOfOld = newSchemeOfOldOfApproveTpl.computeIfAbsent(approveBillTplId, ky -> Maps.newHashMapWithExpectedSize((int)8));
                newSchemeOfOld.put(oldReportSchemeId, Pair.of((Object)newReportSchemeId, (Object)msg));
            }
        }
    }

    private void updatedApproveBillTpl(DynamicObject approveBillTplDy, Map<Long, Pair<Long, DynamicObject>> newSchemeOfOld, Map<Long, DynamicObject> copySchemeMap, Date modifyTime) {
        DynamicObjectCollection schemeEntry = approveBillTplDy.getDynamicObjectCollection("schemeentryentity");
        for (DynamicObject approveSchemeDy : schemeEntry) {
            long oldSchemeId = approveSchemeDy.getLong("reportscheme.id");
            long oldSchemeSourceId = approveSchemeDy.getLong("reportscheme.sourceid");
            Pair<Long, DynamicObject> newSchemePair = newSchemeOfOld.get(oldSchemeId);
            if (newSchemePair == null || newSchemePair.getKey() == null || newSchemePair.getValue() == null) continue;
            DynamicObject newScheme = copySchemeMap.get(newSchemePair.getKey());
            if (newScheme == null) {
                newScheme = copySchemeMap.get(oldSchemeSourceId);
            }
            if (newScheme == null) continue;
            approveSchemeDy.set("reportscheme", (Object)newScheme);
            approveBillTplDy.set("modifytime", (Object)modifyTime);
        }
    }

    private Map<Long, DynamicObject> getApproveBillTplMap(Collection<Long> approveBillTplIds, SWCDataServiceHelper approveBillTplHelper) {
        QFilter approveBillTplFilter = new QFilter("boid", "in", approveBillTplIds);
        QFilter hisFilter = new QFilter("datastatus", "=", (Object)"-3");
        hisFilter.or(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        List filters = ApproveBillTplService.packageFilterForTpl((boolean)true, (String)"4715a0df000000ac");
        if (!CollectionUtils.isEmpty((Collection)filters)) {
            filters.forEach(arg_0 -> ((QFilter)approveBillTplFilter).and(arg_0));
        }
        DynamicObject[] approveBillTplDyArr = approveBillTplHelper.loadDynamicObjectArray("hsas_approvebilltpl", new QFilter[]{approveBillTplFilter, hisFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)approveBillTplDyArr.length);
        for (DynamicObject dynamicObject : approveBillTplDyArr) {
            long boId = dynamicObject.getLong("boid");
            DynamicObject object = (DynamicObject)result.get(boId);
            if (object != null && !"-3".equals(dynamicObject.getString("datastatus"))) continue;
            result.put(boId, dynamicObject);
        }
        return result;
    }

    private ListSelectedRowCollection getListSelectedRows() {
        String approveSchemeMsgPageId = this.getView().getParentView().getPageCache().get("approveSchemeMsgPageId");
        IFormView view = this.getView().getView(approveSchemeMsgPageId);
        IListView listView = (IListView)view;
        return listView.getSelectedRows();
    }

    private TableValueSetter createTableSetter() {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("schemename", new Object[0]);
        setter.addField("referreport", new Object[0]);
        setter.addField("reportscheme", new Object[0]);
        setter.addField("approvebilltpl", new Object[0]);
        setter.addField("approveschememsg", new Object[0]);
        return setter;
    }

    private DynamicObject[] queryApproveSchemeMsgArr(List<Long> pkIds, SWCDataServiceHelper approveSchemeMsgHelper) {
        QFilter filter = new QFilter("id", "in", pkIds);
        DynamicObject[] approveSchemeMsgArr = approveSchemeMsgHelper.query("id,modifytype,approvebilltpl.id,approvebilltpl.number,approvebilltpl.name,approvebilltpl.enable,approvebilltpl.schemeentryentity,reportscheme.id,reportscheme.sourceid,approveschemeid", new QFilter[]{filter});
        return approveSchemeMsgArr;
    }

    private void dealClose() {
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        returnData.put("dealmodify", "true");
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

