/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.approve;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.business.cal.helper.CalDetailHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCAdminOrgPermList;
import org.apache.commons.lang3.StringUtils;

public class CalApproveBillList
extends SWCAdminOrgPermList {
    public static final String DEFAULT_TASK_NUMBERS = "defaultTaskNumbers";
    public static final String DEFAULT_APPROVE_BILL_NO = "defaultApproveBillNo";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        boolean dataChanged = this.getModel().getDataChanged();
        if (dataChanged) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "submit": {
                this.checkSubmitOperation(args);
                break;
            }
            case "unsubmit": {
                this.checkIsSelect(args);
                break;
            }
            case "delete": {
                this.checkIsSelect(args);
                break;
            }
            case "abandoned": {
                this.beforeDoAbandoned(args);
                break;
            }
            case "disapprove": {
                this.beforeDisapproveDo(args);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "disapprove": {
                this.disapproveCheckClose(messageBoxClosedEvent);
                break;
            }
            case "submit": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("pageId", this.getView().getPageId());
                option.setVariableValue("source", "FormList");
                option.setVariableValue("confirm", "true");
                this.getView().invokeOperation("submit", option);
                break;
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"to_apvtpl"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "to_apvtpl": {
                long userId = Long.parseLong(RequestContext.get().getUserId());
                boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)this.getView().getEntityId(), (String)"0VYYLFGYBR=D");
                if (!permFlag) break;
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("hsas_approvebilltpl");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    private void updateCalPayRollTaskStatus(String operateKey, OperationResult operationResult) {
        switch (operateKey) {
            case "submit": 
            case "unsubmit": 
            case "abandoned": 
            case "disapprove": 
            case "dodisapprove": {
                List successPkIds = operationResult.getSuccessPkIds();
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_approvebill");
                DynamicObject[] bills = serviceHelper.query("caltasks", new QFilter[]{new QFilter("id", "in", (Object)successPkIds)});
                if (bills == null) {
                    return;
                }
                ArrayList<Long> calTaskIds = new ArrayList<Long>(10);
                for (DynamicObject bill : bills) {
                    DynamicObjectCollection caltasks = bill.getDynamicObjectCollection("caltasks");
                    for (DynamicObject caltask : caltasks) {
                        calTaskIds.add(caltask.getLong("fbasedataid_id"));
                    }
                }
                for (Long calTaskId : calTaskIds) {
                    PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
                }
                break;
            }
        }
    }

    protected void checkIsSelect(BeforeDoOperationEventArgs args) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        if (selectRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CalApproveBillList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    protected void checkSubmitOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        boolean idConfirm = Boolean.parseBoolean(formOperate.getOption().getVariableValue("confirm", String.valueOf(false)));
        if (!idConfirm) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectRows = listView.getSelectedRows();
            if (selectRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CalApproveBillList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            OperateOption option = formOperate.getOption();
            option.setVariableValue("pageId", this.getView().getPageId());
            option.setVariableValue("source", "FormList");
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List columns = args.getListColumns();
        for (IListColumn iListColumn : columns) {
            String listFieldKey = iListColumn.getListFieldKey();
            if (!"fseq".equals(listFieldKey) && !"billno".equals(listFieldKey) && !"billname".equals(listFieldKey)) continue;
            iListColumn.setFixed(true);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List columns;
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null && (columns = args.getFastFilterColumns()) != null && !columns.isEmpty()) {
            for (FilterColumn column : columns) {
                String fieldName;
                switch (fieldName = column.getFieldName()) {
                    case "caltasks.fbasedataid.number": {
                        List defaultTaskNumbers = (List)formShowParameter.getCustomParam(DEFAULT_TASK_NUMBERS);
                        if (defaultTaskNumbers == null) break;
                        ArrayList defaultValues = new ArrayList(defaultTaskNumbers);
                        column.setDefaultValues(defaultValues);
                        break;
                    }
                    case "billno": {
                        List approveBillNos = (List)formShowParameter.getCustomParam(DEFAULT_APPROVE_BILL_NO);
                        if (approveBillNos == null || approveBillNos.size() <= 0) break;
                        column.setDefaultValues(approveBillNos);
                        break;
                    }
                }
            }
        }
        List fastFilterColumns = args.getCommonFilterColumns();
        fastFilterColumns.forEach(filterColumn -> {
            String fieldName = filterColumn.getFieldName();
            if (SWCStringUtils.equals((String)fieldName, (String)"org.name")) {
                filterColumn.setDefaultValue(null);
            }
        });
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "payrollgroups.fbasedataid.id": 
            case "payrollgroups.fbasedataid.name": {
                this.addPermFilter(filters);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        String refEntityId = args.getRefEntityId();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "payrollgroups.fbasedataid.id": 
            case "payrollgroups.fbasedataid.name": {
                this.addPermFilter(filters);
                break;
            }
            case "approvebilltplv.name": 
            case "approvebilltplv.id": {
                this.addControlledPermFilter(filters, refEntityId);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        FormOperate formOperate = (FormOperate)args.getSource();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        switch (opKey) {
            case "abandoned": {
                operationResult.setShowMessage(false);
                this.afterDoAbandoned(args);
                ((IEntityOperate)formOperate).setCancelRefresh(false);
                break;
            }
            case "disapprove": {
                operationResult.setShowMessage(false);
                this.afterDisapproveDo(args);
                break;
            }
            case "dodisapprove": {
                operationResult.setShowMessage(false);
                this.afterDoDisapprove(args);
                break;
            }
        }
        this.updateCalPayRollTaskStatus(opKey, operationResult);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("isneedcollapse", "true");
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            pageCache.put("openway", "1");
        }
    }

    private void beforeDoAbandoned(BeforeDoOperationEventArgs args) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        if (selectRows.isEmpty()) {
            this.showNoSelectTips();
            args.setCancel(true);
        }
    }

    private void beforeDisapproveDo(BeforeDoOperationEventArgs args) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        if (selectRows.isEmpty()) {
            this.showNoSelectTips();
            args.setCancel(true);
            return;
        }
        this.selectDisapprove(args, selectRows);
    }

    private void showNoSelectTips() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CalApproveBillList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    private void afterDoAbandoned(AfterDoOperationEventArgs args) {
        List allErrorList = args.getOperationResult().getAllErrorOrValidateInfo();
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        int successCount = successPkIds.size();
        if (CollectionUtils.isEmpty((Collection)allErrorList)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5e9f\u5f03\u6210\u529f\u3002", (String)"CalApproveBillList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        int size = selectRows.size();
        if (size == 1 && !CollectionUtils.isEmpty((Collection)allErrorList)) {
            this.getView().showErrorNotification(((IOperateInfo)allErrorList.get(0)).getMessage());
            return;
        }
        String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u5f20\u5ba1\u6279\u5355\uff0c{1}\u5f20\u5e9f\u5f03\u6210\u529f\uff0c{2}\u5f20\u5931\u8d25\u3002", (String)"CalApproveBillList_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), size, successCount, size - successCount);
        ArrayList<String> failList = new ArrayList<String>(10);
        allErrorList.forEach(error -> failList.add(error.getMessage()));
        FormOperate formOperate = (FormOperate)args.getSource();
        this.getOperationResultParameter(formOperate.getOperateName().getLocaleValue(), title, failList);
        this.getView().invokeOperation("refresh");
    }

    private void afterDisapproveDo(AfterDoOperationEventArgs args) {
        if (args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("dodisapprove");
        }
    }

    private void afterDoDisapprove(AfterDoOperationEventArgs args) {
        List allErrorList = args.getOperationResult().getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)allErrorList)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u6210\u529f\u3002", (String)"CalApproveBillList_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        int size = selectRows.size();
        if (size == 1 && !CollectionUtils.isEmpty((Collection)allErrorList)) {
            this.getView().showErrorNotification(((IOperateInfo)allErrorList.get(0)).getMessage());
            this.getView().invokeOperation("refresh");
            return;
        }
        int successCount = args.getOperationResult().getSuccessPkIds().size();
        String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u5f20\u5ba1\u6279\u5355\uff0c{1}\u5f20\u53cd\u5ba1\u6279\u6210\u529f\uff0c{2}\u5f20\u5931\u8d25\u3002", (String)"CalApproveBillList_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]), size, successCount, size - successCount);
        ArrayList<String> failList = new ArrayList<String>(10);
        allErrorList.forEach(error -> failList.add(error.getMessage()));
        FormOperate formOperate = (FormOperate)args.getSource();
        this.getOperationResultParameter(formOperate.getOperateName().getLocaleValue(), title, failList);
        this.getView().invokeOperation("refresh");
    }

    private void disapproveCheckClose(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("is_disapprove_comfirm", "true");
            this.getView().invokeOperation("dodisapprove", op);
        }
    }

    private void selectDisapprove(BeforeDoOperationEventArgs args, ListSelectedRowCollection selectRows) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebill");
        ArrayList<Long> pkIdList = new ArrayList<Long>(10);
        for (ListSelectedRow row : selectRows) {
            pkIdList.add((Long)row.getPrimaryKeyValue());
        }
        DynamicObject[] approveBillList = ApproveBillService.getApproveBillList(pkIdList, (SWCDataServiceHelper)helper);
        ArrayList calPersonIds = new ArrayList(approveBillList.length);
        for (DynamicObject approveBillDy : approveBillList) {
            DynamicObjectCollection approveBillEntry = approveBillDy.getDynamicObjectCollection("calentryentity");
            approveBillEntry.forEach(approveBillEnt -> calPersonIds.add(approveBillEnt.getLong("calpersonid")));
        }
        boolean flag = CalDetailHelper.hasOnHoldReleaseAgencyBill(calPersonIds);
        if (flag) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u65f6\uff0c\u4f1a\u5c06\u5df2\u89e3\u85aa\u7684\u4ee3\u53d1\u5355\u5bf9\u5e94\u6570\u636e\u5e9f\u5f03\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"HSASCalTableListPayPlugin_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("disapprove"));
        }
    }

    public void getOperationResultParameter(String operateName, String title, List<String> failList) {
        this.getOperationResultParameter(operateName, title, failList, Boolean.TRUE);
    }

    public void getOperationResultParameter(String operateName, String title, List<String> failList, Boolean hasMore) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsbp_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = failList.size();
        for (int index = 0; index < 5 && index < len; ++index) {
            buf.append(failList.get(index)).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)hasMore);
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        parameters.setCustomParam("failList", failList);
        parameters.setCustomParam("operateName", (Object)operateName);
        this.getView().showForm(parameters);
    }

    public void setFilter(SetFilterEvent event) {
        QFilter qFilter = new QFilter("billno", "not like", (Object)"PREVIEW_%");
        event.addCustomQFilter(qFilter);
    }

    private HasPermOrgResult getHasPermOrgs() {
        return SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_approvebill", (String)"47150e89000000ac");
    }

    private void addPermFilter(List<QFilter> filters) {
        HasPermOrgResult permOrgs = this.getHasPermOrgs();
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            filters.add(new QFilter("org.id", "in", (Object)permOrgs.getHasPermOrgs()));
        }
    }

    private void addControlledPermFilter(List<QFilter> filters, String refEntityId) {
        QFilter baseDataFilter;
        HasPermOrgResult permOrgs = this.getHasPermOrgs();
        if (permOrgs != null && !permOrgs.hasAllOrgPerm() && (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)refEntityId, (List)permOrgs.getHasPermOrgs(), (boolean)true)) != null) {
            filters.add(baseDataFilter);
        }
    }
}

