/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.approve;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.common.events.approve.CreateApproveBillCalPersonDealEvent;
import kd.sdk.swc.hsas.formplugin.extpoint.approve.ICreateApproveBillExtService;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.business.approve.ApproveBillTplService;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsas.common.dto.ApproveBillAccountDTO;
import kd.swc.hsas.formplugin.web.approve.CreateApproveBillExtPlugin;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.PayStateEnum;

public class CalApproveSelectViewPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CalApproveSelectViewPlugin.class);
    private static final String BTN_OK = "donothing_ok";
    private static final String PREVIEW = "donothing_preview";
    private static final String APPROVEBILLTPL = "approvebilltpl";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.initData();
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit netSalaryEdit = (BasedataEdit)this.getView().getControl(APPROVEBILLTPL);
        netSalaryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        DynamicObject approveSelectDy = this.getModel().getDataEntity();
        String isChangeTpl = (String)this.getView().getFormShowParameter().getCustomParam("isChangeTpl");
        Map calPersonCalTableMap = (Map)this.getView().getFormShowParameter().getCustomParam("calPersonCalTableMap");
        long approveBillTplId = approveSelectDy.getLong("approvebilltpl.id");
        String enable = approveSelectDy.getString("approvebilltpl.enable");
        if (BTN_OK.equals(operateKey)) {
            if (approveBillTplId == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u85aa\u8d44\u5ba1\u6279\u5355\u6a21\u677f\u3002", (String)"CalApproveSelectViewPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("0".equals(enable)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CalApproveSelectViewPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isOnHold = ApproveBillService.getApproveBillTplIsOnHold((DynamicObject)approveSelectDy.getDynamicObject(APPROVEBILLTPL));
            Set calPersonOnHoldSet = (Set)JSON.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("calPersonOnHoldSet")), (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0]);
            Set<Long> calPersonAllIds = !isOnHold ? calPersonCalTableMap.keySet().stream().filter(data -> !calPersonOnHoldSet.contains(data)).map(Long::valueOf).collect(Collectors.toSet()) : calPersonCalTableMap.keySet().stream().map(Long::valueOf).collect(Collectors.toSet());
            CreateApproveBillCalPersonDealEvent event = this.dealEvent(calPersonCalTableMap, isOnHold, calPersonOnHoldSet);
            Set calPersonIds = event.getCalPersonSet();
            calPersonIds = calPersonIds == null ? new HashSet(16) : calPersonIds;
            calPersonIds.retainAll(calPersonAllIds);
            if (!formOperate.getOption().tryGetVariableValue("callBack", new RefObject()) && this.isPayDetailFail(calPersonIds, approveSelectDy, operateKey)) {
                return;
            }
            this.getView().getParentView().getPageCache().put("invokeOperation", "true");
            boolean isEquals = this.isCalPersonEquals(calPersonAllIds, calPersonIds);
            returnData.put("isAll", isEquals);
            returnData.put("isOnHold", isOnHold);
            if (!isEquals) {
                returnData.put("calPersons", JSON.toJSONString((Object)calPersonIds));
                returnData.put("errorCustomMsg", event.getErrorCustomMsg());
            }
            if (StringUtils.isEmpty((CharSequence)isChangeTpl)) {
                returnData.put("approveBillTplId", approveBillTplId);
            } else {
                SWCDataServiceHelper approveBillTplHisHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
                QFilter filter = new QFilter("boid", "=", (Object)approveBillTplId);
                filter.and(new QFilter("datastatus", "=", (Object)"1"));
                BaseDataHisHelper.addHisVerFilter((QFilter)filter);
                DynamicObject approveBillTplHisDy = approveBillTplHisHelper.queryOne("id", new QFilter[]{filter});
                if (null != approveBillTplHisDy) {
                    returnData.put("approveBillTplId", approveBillTplId);
                    returnData.put("approveBillTplHisId", approveBillTplHisDy.getLong("id"));
                }
            }
            this.getView().setReturnData(returnData);
            this.addOrUpdateSelectApvBillTpl();
            this.getView().close();
        }
        if (PREVIEW.equals(operateKey)) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_approvebill", (String)"0VYYHBJP2B9U");
            if (!permFlag) {
                this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u85aa\u8d44\u5ba1\u6279\u5355", (String)"CalApproveSelectViewPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u751f\u6210\u5ba1\u6279\u5355", (String)"CalApproveSelectViewPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
                return;
            }
            if (approveBillTplId == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u85aa\u8d44\u5ba1\u6279\u5355\u6a21\u677f\u3002", (String)"CalApproveSelectViewPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("0".equals(enable)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CalApproveSelectViewPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isOnHold = ApproveBillService.getApproveBillTplIsOnHold((DynamicObject)approveSelectDy.getDynamicObject(APPROVEBILLTPL));
            Set calPersonOnHoldSet = (Set)JSON.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("calPersonOnHoldSet")), (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0]);
            Set calPersonAllIds = !isOnHold ? calPersonCalTableMap.keySet().stream().filter(data -> !calPersonOnHoldSet.contains(data)).map(Long::valueOf).collect(Collectors.toSet()) : calPersonCalTableMap.keySet().stream().map(Long::valueOf).collect(Collectors.toSet());
            CreateApproveBillCalPersonDealEvent event = this.dealEvent(calPersonCalTableMap, isOnHold, calPersonOnHoldSet);
            Set calPersonIds = event.getCalPersonSet();
            calPersonIds = calPersonIds == null ? new HashSet(16) : calPersonIds;
            calPersonIds.retainAll(calPersonAllIds);
            if (calPersonIds.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"CalApproveSelectViewPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!formOperate.getOption().tryGetVariableValue("callBack", new RefObject()) && this.isPayDetailFail(calPersonIds, approveSelectDy, operateKey)) {
                return;
            }
            this.beginGenerateApproveBillPreview(args, calPersonCalTableMap, calPersonIds);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "donothing_preview": 
            case "donothing_ok": {
                if (!MessageBoxResult.OK.equals((Object)messageBoxResult) && !MessageBoxResult.Yes.equals((Object)messageBoxResult)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("callBack", "true");
                this.getView().invokeOperation(callBackId, operateOption);
                break;
            }
        }
    }

    private void initData() {
        Long userId = RequestContext.get().getCurrUserId();
        SWCDataServiceHelper approveBillTplRecordHelper = new SWCDataServiceHelper("hsas_approvetplrecord");
        QFilter filter = new QFilter("creator", "=", (Object)userId);
        DynamicObject approveBillTplRecordDy = approveBillTplRecordHelper.queryOne("approvebilltpl.id", new QFilter[]{filter});
        if (null != approveBillTplRecordDy) {
            Long pkId = approveBillTplRecordDy.getLong("approvebilltpl.id");
            SWCDataServiceHelper approveBillTplHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
            List filters = ApproveBillTplService.packageFilterForTpl((boolean)true);
            filters.add(new QFilter("id", "=", (Object)pkId));
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            filters.add(new QFilter("datastatus", "!=", (Object)"-1"));
            DynamicObject approveBillTplDy = approveBillTplHelper.queryOne("id, enable, status", filters.toArray(new QFilter[0]));
            if (null == approveBillTplDy) {
                this.getModel().setValue(APPROVEBILLTPL, null);
            } else {
                this.getModel().setValue(APPROVEBILLTPL, (Object)pkId);
            }
        } else {
            this.getModel().setValue(APPROVEBILLTPL, null);
        }
        this.getView().updateView(APPROVEBILLTPL);
    }

    private void addOrUpdateSelectApvBillTpl() {
        SWCDataServiceHelper approveBillTplRecordHelper = new SWCDataServiceHelper("hsas_approvetplrecord");
        Long userId = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("creator", "=", (Object)userId);
        DynamicObject approveBillTplRecordDy = approveBillTplRecordHelper.queryOne("creator, approvebilltpl, modifytime", new QFilter[]{filter});
        if (null == approveBillTplRecordDy) {
            Date operateDate = new Date();
            approveBillTplRecordDy = approveBillTplRecordHelper.generateEmptyDynamicObject();
            approveBillTplRecordDy.set("creator", (Object)userId);
            approveBillTplRecordDy.set("modifier", (Object)userId);
            approveBillTplRecordDy.set(APPROVEBILLTPL, (Object)this.getModel().getDataEntity().getDynamicObject(APPROVEBILLTPL).getLong("id"));
            approveBillTplRecordDy.set("createtime", (Object)operateDate);
            approveBillTplRecordDy.set("modifytime", (Object)operateDate);
            approveBillTplRecordHelper.saveOne(approveBillTplRecordDy);
        } else {
            Date operateDate = new Date();
            approveBillTplRecordDy.set(APPROVEBILLTPL, (Object)this.getModel().getDataEntity().getDynamicObject(APPROVEBILLTPL).getLong("id"));
            approveBillTplRecordDy.set("modifytime", (Object)operateDate);
            approveBillTplRecordHelper.updateOne(approveBillTplRecordDy);
        }
    }

    private void beginGenerateApproveBillPreview(BeforeDoOperationEventArgs args, Map<String, String> calPersonCalTableMap, Set<Long> calPersonIds) {
        try {
            this.generateApproveBillPreview(calPersonCalTableMap, calPersonIds);
        }
        catch (Exception exception) {
            args.setCancel(true);
            String codeRuleInfo = CodeRuleHelper.getCodeRuleExceptionInfo((Exception)exception);
            if (codeRuleInfo != null) {
                this.getView().showErrorNotification(codeRuleInfo);
                return;
            }
            logger.error("CalApproveSelectViewPlugin.beginGenerateApproveBillPreview, generateApproveBillPreview error, msg is: ", (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("", exception.getMessage()), new Object[0]);
        }
    }

    protected void generateApproveBillPreview(Map<String, String> calPersonCalTableMap, Set<Long> allCalPersonIds) {
        SWCDataServiceHelper approveBillHelper = new SWCDataServiceHelper("hsas_approvebill");
        DynamicObject approveBillDy = approveBillHelper.generateEmptyDynamicObject();
        Set<Long> previewCalPersonIds = allCalPersonIds.stream().limit(200L).collect(Collectors.toSet());
        Map<String, Integer> personNumMap = this.getPersonNumMap(previewCalPersonIds);
        this.setBillData(approveBillDy, personNumMap);
        LinkedHashSet<Long> calTableIds = new LinkedHashSet<Long>(calPersonCalTableMap.size());
        DynamicObjectCollection approveDyEntryDyCollection = approveBillDy.getDynamicObjectCollection("calentryentity");
        for (Map.Entry<String, String> mapEntry : calPersonCalTableMap.entrySet()) {
            Long calPersonId = Long.valueOf(mapEntry.getKey());
            if (!previewCalPersonIds.contains(calPersonId)) continue;
            DynamicObject calEntryDynamicObject = approveBillHelper.generateEmptyEntryDynamicObject("calentryentity");
            calEntryDynamicObject.set("seq", (Object)(approveDyEntryDyCollection.size() + 1));
            calEntryDynamicObject.set("calpersonid", (Object)Long.valueOf(mapEntry.getKey()));
            Long calTableId = Long.valueOf(mapEntry.getValue());
            calTableIds.add(calTableId);
            calEntryDynamicObject.set("caltableid", (Object)calTableId);
            approveDyEntryDyCollection.add((Object)calEntryDynamicObject);
        }
        approveBillHelper.saveOne(approveBillDy);
        ApproveBillAccountDTO approveBillAccountDTO = ApproveBillService.getItemInfoInCalTable(calTableIds);
        approveBillAccountDTO.setApproveBillId(Long.valueOf(approveBillDy.getLong("id")));
        ApproveBillService.updateItemAccountDy((ApproveBillAccountDTO)approveBillAccountDTO);
        long id = approveBillDy.getLong("id");
        BillShowParameter show = new BillShowParameter();
        show.setFormId("hsas_approvebill");
        show.setPkId((Object)id);
        show.setCustomParam("ispreview", (Object)"ispreview");
        show.setCustomParam("pkId", (Object)id);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1170px");
        styleCss.setHeight("689px");
        show.setStatus(OperationStatus.VIEW);
        show.getOpenStyle().setInlineStyleCss(styleCss);
        show.getOpenStyle().setShowType(ShowType.Modal);
        show.setCaption(ResManager.loadKDString((String)"\u85aa\u8d44\u5ba1\u6279\u5355\u9884\u89c8", (String)"CalApproveSelectViewPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)show);
    }

    private void setBillData(DynamicObject approveBillDy, Map<String, Integer> personNumAndTime) {
        String calTaskStr = (String)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        Long approveBillTplId = this.getModel().getDataEntity().getLong("approvebilltpl.id");
        Object orgIdStr = this.getView().getFormShowParameter().getCustomParam("orgId");
        String orgName = (String)this.getView().getFormShowParameter().getCustomParam("orgName");
        Object payRollGroupId = this.getView().getFormShowParameter().getCustomParam("payrollgroupId");
        Integer personNum = personNumAndTime.get("personIdNum");
        Integer totalSalaryFileNum = personNumAndTime.get("totalSalaryFileNum");
        String billNo = "PREVIEW_" + CodeRuleHelper.getNumber((DynamicObject)approveBillDy, (String)orgIdStr.toString());
        Date nowDate = new Date();
        long userId = RequestContext.get().getCurrUserId();
        HSASCalApproveBillHelper calApproveHelper = new HSASCalApproveBillHelper();
        String billName = calApproveHelper.createDefaultBillName(orgName, nowDate);
        approveBillDy.set("billno", (Object)billNo);
        approveBillDy.set("billname", (Object)billName);
        approveBillDy.set("org", orgIdStr);
        if (calTaskStr.split(",").length < 2) {
            approveBillDy.set("payrollgroup", payRollGroupId);
        }
        approveBillDy.set("creator", (Object)userId);
        approveBillDy.set("modifier", (Object)userId);
        approveBillDy.set("createtime", (Object)nowDate);
        approveBillDy.set("modifytime", (Object)nowDate);
        approveBillDy.set(APPROVEBILLTPL, (Object)approveBillTplId);
        HSASCalApproveBillHelper.setCalTasks((DynamicObject)approveBillDy, (String)calTaskStr);
        approveBillDy.set("totalpersonnum", (Object)personNum);
        approveBillDy.set("totalsalaryfilenum", (Object)totalSalaryFileNum);
        approveBillDy.set("billstatus", (Object)"A");
        String[] caltaskIdStrs = calTaskStr.split(",");
        HashSet<Long> caltaskIds = new HashSet<Long>(caltaskIdStrs.length);
        for (String caltaskId : caltaskIdStrs) {
            caltaskIds.add(Long.valueOf(caltaskId));
        }
        String payRollGroupIds = HSASCalApproveBillHelper.getPayRollGroupStrByTaskId(caltaskIds);
        HSASCalApproveBillHelper.setPayRollGroups((DynamicObject)approveBillDy, (String)payRollGroupIds);
        ArrayList calTaskIdList = new ArrayList(caltaskIds);
        calApproveHelper.afterSetBillData(approveBillDy, calTaskIdList);
    }

    protected Map<String, Integer> getPersonNumMap(Set<Long> calPersonIds) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectCalFields = "id,empnumber,salaryfile.number";
        DynamicObject[] calPersonList = calTableHelper.query(selectCalFields, new QFilter[]{new QFilter("id", "in", calPersonIds)});
        HashSet<String> personIdSet = new HashSet<String>(16);
        HashSet<String> salaryFileIdSet = new HashSet<String>(16);
        for (DynamicObject calPerson : calPersonList) {
            String personEmpnumber = calPerson.getString("empnumber");
            String salaryfileNumber = calPerson.getString("salaryfile.number");
            personIdSet.add(personEmpnumber);
            salaryFileIdSet.add(salaryfileNumber);
        }
        HashMap<String, Integer> personNumMap = new HashMap<String, Integer>(16);
        personNumMap.put("personIdNum", personIdSet.size());
        personNumMap.put("totalSalaryFileNum", salaryFileIdSet.size());
        return personNumMap;
    }

    public void beforeClosed(BeforeClosedEvent event) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String control;
        switch (control = beforeF7SelectEvent.getProperty().getName()) {
            case "approvebilltpl": {
                Long orgId = (Long)ObjectConverter.convert(this.getView().getFormShowParameter().getCustomParams().get("orgId"), Long.class, (boolean)false);
                List filters = ApproveBillTplService.packageFilterForTpl((Long)orgId, (boolean)true);
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("enable", "=", (Object)"1"));
                filters.add(new QFilter("datastatus", "!=", (Object)"-1"));
                beforeF7SelectEvent.setCustomQFilters(filters);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        String actId = event.getActionId();
        if (returnData != null && "calapproveviewf7listclose".equals(actId)) {
            Long selectId = (Long)returnData.get("operaresultId");
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            QFilter filter = new QFilter("id", "=", (Object)selectId);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebilltpl");
            DynamicObject approveBillTplDy = helper.queryOne(new QFilter[]{filter});
            dynamicObject.set(APPROVEBILLTPL, (Object)approveBillTplDy);
            this.getView().updateView(APPROVEBILLTPL);
        }
    }

    private boolean isPayDetailFail(Set<Long> calPersonIds, DynamicObject dynamicObject, String clkKey) {
        Boolean isPayDetail = ApproveBillService.isPayDetail((DynamicObject)dynamicObject.getDynamicObject(APPROVEBILLTPL));
        if (Boolean.TRUE.equals(isPayDetail)) {
            SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
            if (calPersonIds == null || calPersonIds.size() == 0) {
                logger.error("\u9884\u89c8\u5ba1\u6279\u5355\u6216\u751f\u6210\u5ba1\u6279\u5355\u65f6\u6838\u7b97\u540d\u5355\u8ba1\u7b97\u7ed3\u679c\u4e3a\u7a7a");
            }
            QFilter calPersonFilter = new QFilter("id", "in", calPersonIds);
            calPersonFilter.and(new QFilter("paystatus", "=", (Object)PayStateEnum.UNCREATE.getCode()));
            int count = calPersonHelper.count(new QFilter[]{calPersonFilter});
            if (count > 0) {
                this.getView().showConfirm(MessageFormat.format(ResManager.loadKDString((String)"\u6709{0}\u6761\u7b26\u5408\u6761\u4ef6\u7684\u6838\u7b97\u8bb0\u5f55\u672a\u751f\u6210\u53d1\u653e\u660e\u7ec6\uff0c\u662f\u5426\u751f\u6210\u5ba1\u6279\u5355\uff1f", (String)"CalApproveSelectViewPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), count), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(clkKey));
                return true;
            }
        }
        return false;
    }

    private CreateApproveBillCalPersonDealEvent dealEvent(Map<String, String> calPersonCalTableMap, boolean isOnHold, Set<String> calPersonOnHoldSet) {
        Set calPersonIds = !isOnHold ? calPersonCalTableMap.keySet().stream().filter(data -> !calPersonOnHoldSet.contains(data)).map(Long::valueOf).collect(Collectors.toSet()) : calPersonCalTableMap.keySet().stream().map(Long::valueOf).collect(Collectors.toSet());
        CreateApproveBillCalPersonDealEvent event = new CreateApproveBillCalPersonDealEvent();
        event.setCalPersonSet(calPersonIds);
        event.setView(this.getView());
        this.createBillCalPerson(event);
        return event;
    }

    private void createBillCalPerson(CreateApproveBillCalPersonDealEvent event) {
        CreateApproveBillExtPlugin createApproveBillExtService = new CreateApproveBillExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)createApproveBillExtService, ICreateApproveBillExtService.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.approve.ICreateApproveBillExtService#setCalPersonSet", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.setCalPersonSet(event);
            return null;
        });
        logger.info("end set calPerson event");
    }

    private boolean isCalPersonEquals(Set<Long> calPersonAllIds, Set<Long> calPersonIds) {
        if (calPersonAllIds == null || calPersonIds == null) {
            return false;
        }
        if (calPersonAllIds.size() != calPersonIds.size()) {
            return false;
        }
        return calPersonAllIds.containsAll(calPersonIds);
    }
}

