/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.approve;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.swc.hsas.business.approve.ApproveSettingHelper;

public class CalApproveShareListPlugin
extends AbstractListPlugin {
    private static final String OPERA_RESULT = "operaresult";
    private static final String SUCCESS = "success";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"cancelreference"});
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (key = ctlSource.getKey()) {
            case "cancelreference": {
                this.clickCancelReference();
                break;
            }
            case "btncancel": {
                this.closePage();
                break;
            }
        }
    }

    private void closePage() {
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("operation", "cancelreference");
        this.getView().setReturnData(returnData);
        this.getView().close();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        this.sendLinkData(args);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        super.listRowDoubleClick(evt);
        ListSelectedRow listSelectedRow = evt.getCurrentListSelectedRow();
        Long id = (Long)listSelectedRow.getPrimaryKeyValue();
        String captionName = listSelectedRow.getName();
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put(OPERA_RESULT, SUCCESS);
        returnData.put("operaresultId", id);
        returnData.put("operaresultName", captionName);
        this.getView().setReturnData(returnData);
        this.getView().close();
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    private void clickCancelReference() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"CalManageViewListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> pkIdList = new ArrayList<Long>(10);
        for (ListSelectedRow row : selectedRows) {
            Long pkId = (Long)row.getPrimaryKeyValue();
            pkIdList.add(pkId);
        }
        ApproveSettingHelper.setShareScheme(pkIdList);
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u5171\u4eab\u6210\u529f", (String)"CalApproveBillTplEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), new Object[0]));
        this.getView().updateView();
    }

    private void sendLinkData(HyperLinkClickArgs args) {
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        String name = currentSelectedRowInfo.getName();
        Object focusRowPkId = billList.getFocusRowPkId();
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put(OPERA_RESULT, SUCCESS);
        returnData.put("operaresultId", focusRowPkId);
        returnData.put("operaresultName", name);
        this.getView().setReturnData(returnData);
        this.getView().close();
    }
}

