/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.attbizdata;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.attbizdata.AttBizDataListHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections4.CollectionUtils;

public class AttBizDataBillEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
ClickListener {
    private static final String KEY_DATA_SOURCE_AND_USE_DETAIL_PANEL = "datasoucepanelap";
    public static final String ATTITEMTYPE_DETAIL = "0";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit adminOrg = (BasedataEdit)this.getView().getControl("adminorg");
        adminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit employee = (BasedataEdit)this.getView().getControl("employee");
        employee.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getView().getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit attBizItem = (BasedataEdit)this.getView().getControl("attbizitem");
        attBizItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit person = (BasedataEdit)this.getView().getControl("personfield");
        person.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject event) {
        BasedataEdit person = (BasedataEdit)this.getView().getControl("personfield");
        person.setMustInput(true);
        this.setDataSouceAndUseDetailPanel();
        this.setAdminOrgEnable();
        this.setValueFieldByAttBizItem();
        BasedataEdit control = (BasedataEdit)this.getView().getControl("adminorg");
        control.setMustInput(true);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                formOperate.getOption().setVariableValue("isListOp", Boolean.FALSE.toString());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        switch (operateKey) {
            case "audit": {
                if (!operationResult.isSuccess()) break;
                this.getView().updateView(KEY_DATA_SOURCE_AND_USE_DETAIL_PANEL);
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_DATA_SOURCE_AND_USE_DETAIL_PANEL});
                break;
            }
            case "unaudit": {
                if (!operationResult.isSuccess()) break;
                this.getView().updateView(KEY_DATA_SOURCE_AND_USE_DETAIL_PANEL);
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DATA_SOURCE_AND_USE_DETAIL_PANEL});
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (SWCStringUtils.equals((String)fieldKey, (String)"attbizitem")) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                this.changeAttBizItem(oldValue, newValue);
            }
        } else if (SWCStringUtils.equals((String)fieldKey, (String)"currency")) {
            DynamicObject oldCurrencyValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            DynamicObject newCurrencyValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.changeCurrency(oldCurrencyValue, newCurrencyValue);
        } else if (SWCStringUtils.equals((String)fieldKey, (String)"personfield")) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.getModel().setValue("depemp", null);
                this.getModel().setValue("person", null);
                this.getModel().setValue("employee", null);
                this.getModel().setValue("adminorg", null);
                this.setAdminOrgEnable();
            } else if (newValue instanceof DynamicObject) {
                DynamicObject newDepEmp = (DynamicObject)newValue;
                Long newDepEmpId = newDepEmp.getLong("id");
                Long newPersonId = newDepEmp.getLong("person.id");
                Long newEmployeeId = newDepEmp.getLong("employee.id");
                Long adminOrgId = newDepEmp.getLong("adminorg.id");
                this.getModel().setValue("depemp", (Object)newDepEmpId);
                this.getModel().setValue("person", (Object)newPersonId);
                this.getModel().setValue("employee", (Object)newEmployeeId);
                this.getModel().setValue("adminorg", (Object)adminOrgId);
                this.setAdminOrgEnable();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "currency": {
                DynamicObject bizItem = this.getModel().getDataEntity().getDynamicObject("attbizitem");
                HashSet<Long> currencyIdSet = new HashSet<Long>(16);
                if (!SWCObjectUtils.isEmpty((Object)bizItem)) {
                    DynamicObjectCollection currencyColl = bizItem.getDynamicObjectCollection("currency");
                    for (DynamicObject currency : currencyColl) {
                        currencyIdSet.add(currency.getLong("fbasedataid_id"));
                    }
                }
                if (currencyIdSet.size() <= 0) break;
                QFilter filter = new QFilter("id", "in", currencyIdSet);
                beforeF7SelectEvent.getCustomQFilters().add(filter);
                break;
            }
            case "adminorg": {
                beforeF7SelectEvent.setCancel(true);
                this.getView().getPageCache().put("adminorg", "1");
                BasedataEdit personField = (BasedataEdit)this.getControl("personfield");
                personField.click();
                break;
            }
            case "personfield": {
                String dyTypeName = this.getModel().getDataEntity().getDynamicObjectType().getName();
                Set adminOrgIdSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)dyTypeName, (String)"47150e89000000ac", (String)"adminorg");
                QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
                if (adminOrgIdSet != null) {
                    filter.and(new QFilter("hrpi_empposorgrel.adminorg.id", "in", (Object)adminOrgIdSet));
                }
                if ("1".equals(this.getView().getPageCache().get("adminorg"))) {
                    filter.and(new QFilter("employee", "=", (Object)((DynamicObject)this.getModel().getValue("employee")).getLong("id")));
                }
                this.getView().getPageCache().remove("adminorg");
                beforeF7SelectEvent.getCustomQFilters().add(filter);
                break;
            }
            case "attbizitem": {
                beforeF7SelectEvent.getCustomQFilters().add(new AttBizDataListHelper().getAttBizDataBizItemFilter(this.getView().getEntityId(), "47150e89000000ac"));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (SWCStringUtils.equals((String)actionId, (String)"adminorg") && CollectionUtils.isNotEmpty((Collection)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            Long depEmpId = (Long)returnData.get(0).getPrimaryKeyValue();
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_depemp");
            DynamicObject depEmp = helper.queryOriginalOne("adminorg.id", (Object)depEmpId);
            this.getModel().setValue("adminorg", (Object)depEmp.getLong("adminorg.id"));
            this.getModel().setValue("depemp", (Object)depEmpId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "attbizitem": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.clearFiledValue();
                    DynamicObject attBizItem = (DynamicObject)this.getModel().getValue("attbizitem");
                    if (attBizItem == null) break;
                    this.setDecimalFieldScale(attBizItem);
                    break;
                }
                String oldBizItemIdStr = messageBoxClosedEvent.getCustomVaule();
                if (!SWCStringUtils.isNotEmpty((String)oldBizItemIdStr)) break;
                Long oldBizItemId = Long.valueOf(oldBizItemIdStr);
                this.getModel().beginInit();
                this.getModel().setValue("attbizitem", (Object)oldBizItemId);
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
            case "currency": {
                this.currencyChangeConfirmEvent(messageBoxClosedEvent.getResult(), messageBoxClosedEvent);
                break;
            }
        }
    }

    private void currencyChangeConfirmEvent(MessageBoxResult result, MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            DynamicObject bizItem = (DynamicObject)this.getModel().getValue("attbizitem");
            DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
            if (!SWCObjectUtils.isEmpty((Object)bizItem)) {
                this.initAmountValue(currencyObj);
            }
        } else {
            String oldCurrencyIdStr = messageBoxClosedEvent.getCustomVaule();
            Long oldCurrencuId = null;
            if (SWCStringUtils.isNotEmpty((String)oldCurrencyIdStr)) {
                oldCurrencuId = Long.valueOf(oldCurrencyIdStr);
            }
            this.getModel().beginInit();
            this.getModel().setValue("currency", (Object)oldCurrencuId);
            this.getModel().endInit();
            this.getView().updateView();
        }
    }

    private void setDataSouceAndUseDetailPanel() {
        String auditStatus = (String)this.getModel().getValue("auditstatus");
        if (!"F".equals(auditStatus) && !"C".equals(auditStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DATA_SOURCE_AND_USE_DETAIL_PANEL});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_DATA_SOURCE_AND_USE_DETAIL_PANEL});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String attItemType = dataEntity.getString("attbizitem.attitemtype");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calattbizdatarel");
        if (ATTITEMTYPE_DETAIL.equals(attItemType)) {
            helper.setEntityName("hsas_calattbsdetailrel");
        }
        DynamicObjectCollection calRels = helper.queryOriginalCollection("caltask.id,salaryfile.id", new QFilter[]{new QFilter("attbizdataid", "=", this.getModel().getValue("id"))});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("caltask", new Object[0]);
        setter.addField("salaryfile", new Object[0]);
        for (DynamicObject calRel : calRels) {
            setter.addRow(new Object[]{calRel.getLong("caltask.id"), calRel.getLong("salaryfile.id")});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setAdminOrgEnable() {
        DynamicObject employee = (DynamicObject)this.getModel().getValue("employee");
        if (employee == null) {
            this.getModel().setValue("adminorg", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"adminorg"});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"adminorg"});
        DynamicObject depEmp = (DynamicObject)this.getModel().getValue("depemp");
        if (depEmp != null) {
            this.getModel().setValue("personfield", (Object)depEmp.getLong("id"));
        }
    }

    private void setValueFieldByAttBizItem() {
        DynamicObject attBizItem = (DynamicObject)this.getModel().getValue("attbizitem");
        if (attBizItem == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"currency", "inputdecimalvalue", "inputdatevalue"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"inputtextvalue"});
            FieldEdit textValueEdit = (FieldEdit)this.getView().getControl("inputtextvalue");
            textValueEdit.setMustInput(true);
            return;
        }
        this.setDecimalFieldScale(attBizItem);
        this.initFiledVisibleByDataType(attBizItem.getLong("datatype.id"));
    }

    private void initFiledVisibleByDataType(long dataTypeId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"currency", "inputtextvalue", "inputdatevalue", "inputdecimalvalue", "datalength", "earliestdate", "lastdate", "maxvalue", "minvalue", "scalelimit", "bizitemgrpentcur"});
        FieldEdit currencyEdit = (FieldEdit)this.getView().getControl("currency");
        currencyEdit.setMustInput(false);
        FieldEdit textValueEdit = (FieldEdit)this.getView().getControl("inputtextvalue");
        textValueEdit.setMustInput(false);
        FieldEdit dateValueEdit = (FieldEdit)this.getView().getControl("inputdatevalue");
        dateValueEdit.setMustInput(false);
        FieldEdit decimalValueEdit = (FieldEdit)this.getView().getControl("inputdecimalvalue");
        decimalValueEdit.setMustInput(false);
        if (1030L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"inputtextvalue", "datalength"});
            textValueEdit.setMustInput(true);
            this.getModel().setValue("inputtextvalue", this.getModel().getValue("textvalue"));
        } else if (1050L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"inputdatevalue", "earliestdate", "lastdate"});
            dateValueEdit.setMustInput(true);
            this.getModel().setValue("inputdatevalue", this.getModel().getValue("datevalue"));
        } else if (1010L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"inputdecimalvalue", "maxvalue", "minvalue", "scalelimit"});
            decimalValueEdit.setMustInput(true);
            this.getModel().setValue("inputdecimalvalue", this.getModel().getValue("decimalvalue"));
        } else if (1020L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"inputdecimalvalue", "currency", "bizitemgrpentcur"});
            this.getModel().setValue("inputdecimalvalue", this.getModel().getValue("amountvalue"));
            currencyEdit.setMustInput(true);
            decimalValueEdit.setMustInput(true);
            DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
            this.initAmountValue(currencyObj);
        }
    }

    private void changeAttBizItem(DynamicObject oldValue, DynamicObject newValue) {
        boolean isNeedClear = this.checkNeedClear();
        long dataTypeId = newValue.getLong("datatype.id");
        if (oldValue == null || !isNeedClear) {
            this.initFiledVisibleByDataType(dataTypeId);
            this.setDecimalFieldScale(newValue);
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("attbizitem", (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u5c06\u6e05\u7a7a\u5df2\u586b\u5199\u7684\u503c\u7b49\u76f8\u5173\u4fe1\u606f\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"AttBizDataBillEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, null, options, ConfirmTypes.Default, confirmCallBacks, null, String.valueOf(oldValue.getLong("id")));
    }

    private boolean checkNeedClear() {
        return this.getModel().getValue("currency") != null || SWCStringUtils.isNotEmpty((String)((String)this.getModel().getValue("inputtextvalue"))) || this.getModel().getValue("inputdecimalvalue") != null || this.getModel().getValue("inputdatevalue") != null;
    }

    private void setDecimalFieldScale(DynamicObject attBizItem) {
        long dataTypeId = attBizItem.getLong("datatype.id");
        int scale = this.getScale(attBizItem);
        if (1010L == dataTypeId || 1020L == dataTypeId) {
            this.setClientFieldScale("inputdecimalvalue", scale);
            this.setServerFieldScale("inputdecimalvalue", scale);
            this.getModel().setValue("inputdecimalvalue", null);
            this.setMaxValueAndMinValue(attBizItem);
        }
    }

    private int getScale(DynamicObject attBizItem) {
        String scalelimit = attBizItem.getString("scalelimit");
        int scale = 10;
        if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
            scale = Integer.parseInt(scalelimit);
        }
        return scale;
    }

    private void setClientFieldScale(String key, int scale) {
        HashMap<String, Integer> editorProps = new HashMap<String, Integer>();
        editorProps.put("sc", scale);
        editorProps.put("pc", 13);
        HashMap<String, HashMap<String, Integer>> ctrlProps = new HashMap<String, HashMap<String, Integer>>();
        ctrlProps.put("item", editorProps);
        this.getView().updateControlMetadata(key, ctrlProps);
    }

    private void setServerFieldScale(String key, int scale) {
        BigDecimal oldValue = (BigDecimal)this.getModel().getValue(key);
        if (oldValue != null) {
            BigDecimal newValue = oldValue.setScale(scale, RoundingMode.HALF_UP);
            this.getModel().setValue(key, (Object)newValue);
        }
    }

    private void setMaxValueAndMinValue(DynamicObject attBizItem) {
        if (attBizItem.getLong("datatype.id") != 1010L) {
            return;
        }
        BigDecimal maxVal = attBizItem.getBigDecimal("maxvalue");
        BigDecimal minVal = attBizItem.getBigDecimal("minvalue");
        boolean isMaxValNull = attBizItem.getBoolean("ismaxvalnull");
        boolean isMinValNull = attBizItem.getBoolean("isminvalnull");
        Object scalelimit = attBizItem.get("scalelimit");
        int scale = 10;
        if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
            scale = Integer.parseInt(String.valueOf(scalelimit));
        }
        if (!isMinValNull) {
            this.getModel().setValue("minvalue", (Object)minVal.setScale(scale, RoundingMode.HALF_UP).toPlainString());
        } else {
            this.getModel().setValue("minvalue", null);
        }
        if (!isMaxValNull) {
            this.getModel().setValue("maxvalue", (Object)maxVal.setScale(scale, RoundingMode.HALF_UP).toPlainString());
        } else {
            this.getModel().setValue("maxvalue", null);
        }
    }

    private void clearFiledValue() {
        this.getModel().beginInit();
        this.getModel().setValue("inputtextvalue", null);
        this.getModel().setValue("inputdatevalue", null);
        this.getModel().setValue("inputdecimalvalue", null);
        this.getModel().setValue("currency", null);
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void changeCurrency(DynamicObject oldCurrencyValue, DynamicObject newCurrencyValue) {
        BigDecimal decimalVal = (BigDecimal)this.getModel().getValue("inputdecimalvalue");
        if (decimalVal == null) {
            DynamicObject attBizItem = (DynamicObject)this.getModel().getValue("attbizitem");
            if (!SWCObjectUtils.isEmpty((Object)attBizItem)) {
                this.initAmountValue(newCurrencyValue);
            }
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("currency", (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5207\u6362\u5e01\u79cd\u540e\u5c06\u81ea\u52a8\u6839\u636e\u5e01\u79cd\u7cbe\u5ea6\u56db\u820d\u4e94\u5165\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AttBizDataBillEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        if (!SWCObjectUtils.isEmpty((Object)oldCurrencyValue)) {
            this.getView().showConfirm(msg, null, options, ConfirmTypes.Default, confirmCallBacks, null, String.valueOf(oldCurrencyValue.getLong("id")));
        } else {
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    private void initAmountValue(DynamicObject currency) {
        if (SWCObjectUtils.isEmpty((Object)currency)) {
            return;
        }
        int scale = currency.getInt("amtprecision");
        this.setClientFieldScale("inputdecimalvalue", scale);
        BigDecimal value = (BigDecimal)this.getModel().getValue("inputdecimalvalue");
        if (value != null) {
            this.getModel().setValue("inputdecimalvalue", (Object)value.setScale(scale, RoundingMode.HALF_UP));
        }
    }

    private static ListShowParameter constructShowParameter(String formId, String billFormId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId(formId);
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("600");
        inlineStyleCss.setWidth("1000");
        listShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowUsed(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        return listShowParameter;
    }
}

