/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.attbizdata;

import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.swc.hsas.business.attbizdata.AttBizDataListHelper;
import kd.swc.hsas.formplugin.web.attbizdata.AttBizCalTaskCalPeriodRel;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class AttBizDataListPlugin
extends SWCDataBaseList {
    private static final Log logger = LogFactory.getLog(AttBizDataListPlugin.class);

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List values;
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter == null) {
            return;
        }
        List fieldName = (List)currentCommonFilter.get("FieldName");
        if ("monthandyearoption".equals(fieldName.get(0)) && (values = (List)currentCommonFilter.get("Value")).size() > 1) {
            LocalDate lcalEndDate;
            String startDate = (String)values.get(0);
            String endDate = (String)values.get(1);
            DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE;
            LocalDate lcalStartDate = LocalDate.parse(startDate, formatter);
            Period period = Period.between(lcalStartDate, lcalEndDate = LocalDate.parse(endDate, formatter));
            int years = period.getYears();
            if (years > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u67e5\u8be2\u6027\u80fd\uff0c\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u7684\u8de8\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc71\u5e74\u3002", (String)"AttBizDataListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
        IPageCache pageCache = this.getView().getPageCache();
        List customFilter = (List)args.getFilterValues().get("customfilter");
        pageCache.put("filterValues", SerializationUtils.serializeToBase64((Object)customFilter));
        super.filterContainerSearchClick(args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String attBizDataIds = (String)this.getView().getFormShowParameter().getCustomParam("attBizDataIds");
        String startData = (String)this.getView().getFormShowParameter().getCustomParam("startDate");
        String endDate = (String)this.getView().getFormShowParameter().getCustomParam("endDate");
        if (SWCStringUtils.isNotEmpty((String)attBizDataIds) && SWCStringUtils.isNotEmpty((String)startData) && SWCStringUtils.isNotEmpty((String)endDate)) {
            Date bsStartDate = (Date)SerializationUtils.deSerializeFromBase64((String)startData);
            Date bsEndDate = (Date)SerializationUtils.deSerializeFromBase64((String)endDate);
            List commonFilterColumns = args.getCommonFilterColumns();
            this.setCommonFilterDefaultValue(commonFilterColumns, bsStartDate, bsEndDate);
            List fastFilterColumns = args.getFastFilterColumns();
            this.setFastFilterDefautValue(fastFilterColumns, attBizDataIds, bsStartDate, bsEndDate);
        }
        this.getView().getFormShowParameter().setCustomParam("attBizDataIds", null);
        this.getView().getFormShowParameter().setCustomParam("startDate", null);
        this.getView().getFormShowParameter().setCustomParam("endDate", null);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "attbizitem.id": {
                AttBizDataListHelper helper = new AttBizDataListHelper();
                String entityName = ((IListView)this.getView()).getBillFormId();
                filters.add(helper.getAttBizDataBizItemFilter(entityName, "47150e89000000ac"));
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        if (CollectionUtils.isEmpty((Collection)qFilters)) {
            return;
        }
        QFilter newFilter = null;
        AttBizDataListHelper helper = new AttBizDataListHelper();
        ArrayList<QFilter> newQFilterList = new ArrayList<QFilter>(2);
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter filter = (QFilter)iterator.next();
            if (filter == null) continue;
            String propertyName = filter.getProperty();
            if (SWCStringUtils.equals((String)"usagecountoption", (String)propertyName)) {
                newFilter = helper.buildUsageCountOptionFilter(filter.getValue());
                iterator.remove();
            } else if (SWCStringUtils.equals((String)"monthandyearoption", (String)propertyName)) {
                newFilter = helper.getMonthAndYearFilter(filter);
                iterator.remove();
            }
            if (newFilter == null) continue;
            newQFilterList.add(newFilter);
            newFilter = null;
        }
        if (!CollectionUtils.isEmpty(newQFilterList)) {
            qFilters.addAll(newQFilterList);
        }
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("allFilterList", SerializationUtils.serializeToBase64((Object)qFilters));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        String entityName = ((IListView)this.getView()).getBillFormId();
        switch (fieldName) {
            case "usagecount": {
                args.setCancel(true);
                Long focusRowPkId = (Long)this.getFocusRowPkId();
                this.openCalTaskAndCalPeriodRel(focusRowPkId, entityName);
                break;
            }
            case "nocounttimes": {
                args.setCancel(true);
                Long pkId = (Long)this.getFocusRowPkId();
                this.openNoCountCalTaskAndCalPeriodRel(pkId, entityName);
                break;
            }
        }
    }

    private void openNoCountCalTaskAndCalPeriodRel(Long pkId, String entityName) {
        if (SWCStringUtils.equals((String)entityName, (String)"hsas_attbizdatasummary") || SWCStringUtils.equals((String)entityName, (String)"hsas_attbssumresult")) {
            this.openCalTaskAndCalPeriodRelPop(pkId, "hsas_calattnocntrel");
        } else {
            this.openCalTaskAndCalPeriodRelPop(pkId, "hsas_calattdetnocntrel");
        }
    }

    private void openCalTaskAndCalPeriodRel(Long pkId, String entityName) {
        if (SWCStringUtils.equals((String)entityName, (String)"hsas_attbizdatasummary") || SWCStringUtils.equals((String)entityName, (String)"hsas_attbssumresult")) {
            this.openCalTaskAndCalPeriodRelPop(pkId, "hsas_calattbizdatarel");
        } else {
            this.openCalTaskAndCalPeriodRelPop(pkId, "hsas_calattbsdetailrel");
        }
    }

    private void openCalTaskAndCalPeriodRelPop(Long primaryKeyValue, String entityName) {
        QFilter filter = new QFilter("attbizdataid", "=", (Object)primaryKeyValue);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityName);
        showParameter.setHasRight(true);
        showParameter.setFormId("bos_listf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4f7f\u7528\u8be6\u60c5", (String)"AttBizDataListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowTitle(false);
        showParameter.addCustPlugin(AttBizCalTaskCalPeriodRel.class.getName());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setCommonFilterDefaultValue(List<FilterColumn> commonFilterColumns, Date bsStartDate, Date bsEndDate) {
        if (commonFilterColumns != null && !commonFilterColumns.isEmpty()) {
            ArrayList<String> dateList = new ArrayList<String>(2);
            dateList.add(SWCDateTimeUtils.format((Date)bsStartDate, (String)"yyyy-MM-dd"));
            dateList.add(SWCDateTimeUtils.format((Date)bsEndDate, (String)"yyyy-MM-dd"));
            for (FilterColumn filterColumn : commonFilterColumns) {
                if (!filterColumn.getFieldName().equals("monthandyearoption")) continue;
                filterColumn.setDefaultValues(dateList);
            }
        }
    }

    private void setFastFilterDefautValue(List<FilterColumn> fastFilterColumns, String attBizDataIds, Date bsStartDate, Date bsEndDate) {
        Set idSet = (Set)SerializationUtils.deSerializeFromBase64((String)attBizDataIds);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        SWCDataServiceHelper helper = new SWCDataServiceHelper(formId);
        QFilter filter = new QFilter("id", "in", (Object)idSet);
        filter.and("attstartdate", ">=", (Object)bsStartDate);
        filter.and("attstartdate", "<=", (Object)bsEndDate);
        filter.and("attenddate", ">=", (Object)bsStartDate);
        filter.and("attenddate", "<=", (Object)bsEndDate);
        DynamicObjectCollection bizDataColl = helper.queryOriginalCollection("id,identifynumber", new QFilter[]{filter});
        Set identifyNumSet = bizDataColl.stream().map(obj -> obj.getString("identifynumber")).collect(Collectors.toSet());
        for (FilterColumn filterColumn : fastFilterColumns) {
            if (!"identifynumber".equals(filterColumn.getFieldName())) continue;
            filterColumn.setDefaultValues(identifyNumSet.toArray());
        }
    }
}

