/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.attbizdata.his;

import com.alibaba.nacos.shaded.com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.attbizdata.AttBizDataListHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections.MapUtils;

public class AttBizDataHisPlugin
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AttBizDataHisPlugin.class);
    public static final String DONOTHING_CLEAR = "donothing_clear";
    public static final String DONOTHING_SEARCH = "donothing_search";
    private static final String MONTHANDYEAR_OPTION_PRE = "92";
    private static final String MONTHANDYEAR_OPTION_CUR = "63";
    private static final String MONTHANDYEAR_OPTION_AFTER = "8";
    private static final String MONTHANDYEAR_OPTION_PRE3 = "24";
    private static final String MONTHANDYEAR_OPTION_CUSTOMIZE = "5";
    public static final String ATTITEMTYPE_SUMMARY = "1";
    public static final String ATTITEMTYPE_DETAIL = "0";

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "monthandyearoption": {
                this.initFieldVisibleStatus();
                break;
            }
            case "employee": {
                List employeeList;
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (!(newValue instanceof List) || (employeeList = (List)newValue).size() <= 100) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u6b21\u67e5\u8be2\u7684\u4eba\u5458\u6570\u91cf\u4e0a\u9650\u4e3a100\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AttBizDataHisPlugin_02", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("employee", null);
                break;
            }
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit attBizItem = (BasedataEdit)this.getControl("attbizitem");
        attBizItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit employee = (BasedataEdit)this.getControl("employee");
        employee.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFilters();
        this.initFieldVisibleStatus();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String params = (String)parameter.getCustomParam("params");
        if (StringUtils.isBlank((CharSequence)params)) {
            return;
        }
        Map paramMap = (Map)SerializationUtils.deSerializeFromBase64((String)params);
        Boolean isSummaryList = MapUtils.getBoolean((Map)paramMap, (Object)"isSummaryList");
        String entityId = "";
        entityId = isSummaryList != false ? "hsas_attbizdatasummary" : "hsas_attbizdatadetail";
        switch (fieldKey) {
            case "attbizitem": {
                QFilter filter = null;
                filter = isSummaryList != false ? new QFilter("attitemtype", "in", (Object)ATTITEMTYPE_SUMMARY) : new QFilter("attitemtype", "in", (Object)ATTITEMTYPE_DETAIL);
                AttBizDataListHelper helper = new AttBizDataListHelper();
                QFilter attBizDataBizItemFilter = helper.getAttBizDataBizItemFilter(entityId, "47150e89000000ac");
                filter.and(attBizDataBizItemFilter);
                beforeF7SelectEvent.addCustomQFilter(filter);
                break;
            }
            case "employee": {
                Set adminOrgIdSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)entityId, (String)"47150e89000000ac", (String)"adminorg");
                if (adminOrgIdSet == null) {
                    return;
                }
                QFilter depEmpFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
                depEmpFilter.and("adminorg", "in", (Object)adminOrgIdSet);
                depEmpFilter.and("businessstatus", "in", (Object)Character.valueOf('1'));
                SWCDataServiceHelper depempHelper = new SWCDataServiceHelper("hrpi_depemp");
                DynamicObjectCollection depEmpCollection = depempHelper.queryOriginalCollection("id, employee.id", new QFilter[]{depEmpFilter});
                Set matchEmployeeIdSet = depEmpCollection.stream().map(depEmp -> depEmp.getLong("employee.id")).collect(Collectors.toSet());
                if (matchEmployeeIdSet == null) break;
                QFilter employeeFilter = new QFilter("id", "in", matchEmployeeIdSet);
                beforeF7SelectEvent.addCustomQFilter(employeeFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_search": {
                if (this.checkFilterParams()) {
                    args.setCancel(true);
                    return;
                }
                this.buildFilterParam();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IPageCache pageCache = this.getView().getPageCache();
        switch (operateKey) {
            case "donothing_clear": {
                this.clearAllData();
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"nullpanelap"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"listpanelap"});
                pageCache.remove("listHisPageId");
                break;
            }
            case "donothing_search": {
                String listHisPageId = pageCache.get("listHisPageId");
                if (StringUtils.isBlank((CharSequence)listHisPageId)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"nullpanelap"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"listpanelap"});
                    FormShowParameter parameter = this.getView().getFormShowParameter();
                    String params = (String)parameter.getCustomParam("params");
                    if (!StringUtils.isNotBlank((CharSequence)params)) break;
                    Map paramMap = (Map)SerializationUtils.deSerializeFromBase64((String)params);
                    if (MapUtils.getBoolean((Map)paramMap, (Object)"isSummaryList").booleanValue()) {
                        this.openAttBizDataList("hsas_attbsdatasummary_his");
                        break;
                    }
                    this.openAttBizDataList("hsas_attbsdatadetail_his");
                    break;
                }
                IListView view = (IListView)this.getView().getView(listHisPageId);
                view.invokeOperation("refresh");
                this.getView().sendFormAction((IFormView)view);
                break;
            }
        }
    }

    private void buildFilterParam() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection employeeCollection = dataEntity.getDynamicObjectCollection("employee");
        String monthAndYear = dataEntity.getString("monthandyearoption");
        DynamicObjectCollection attItemColl = dataEntity.getDynamicObjectCollection("attbizitem");
        String usageCount = dataEntity.getString("usagecountoption");
        String auditStatus = dataEntity.getString("auditstatus");
        Set employeeIdSet = employeeCollection.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
        Set attItemIdSet = attItemColl.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
        HashMap map = Maps.newHashMapWithExpectedSize((int)8);
        if (!ObjectUtils.isEmpty(employeeIdSet)) {
            map.put("employee", employeeIdSet);
            QFilter filter = new QFilter("employee.id", "in", employeeIdSet);
            AttBizDataListHelper helper = new AttBizDataListHelper();
            DynamicObjectCollection depEmpColl = helper.getDepEmp(new QFilter[]{filter});
            Set depEmpIdSet = depEmpColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            map.put("depemp", depEmpIdSet);
            logger.info("employeeIdSet is :{}", employeeIdSet);
            logger.info("depEmpIdSet is :{}", depEmpIdSet);
        }
        if (!ObjectUtils.isEmpty(attItemIdSet)) {
            map.put("attbizitem", attItemIdSet);
        }
        if (!StringUtils.isEmpty((CharSequence)usageCount)) {
            map.put("usagecountoption", usageCount);
        }
        if (!StringUtils.isEmpty((CharSequence)auditStatus)) {
            map.put("auditstatus", auditStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)monthAndYear)) {
            map.put("monthandyearoption", monthAndYear);
            if (MONTHANDYEAR_OPTION_CUSTOMIZE.equals(monthAndYear)) {
                Date attStartDate = dataEntity.getDate("attstartdate");
                Date attEndDate = dataEntity.getDate("attenddate");
                Date nextDay = new Date(attEndDate.getTime() + 86400000L);
                map.put("attstartdate", attStartDate);
                map.put("attenddate", nextDay);
            } else {
                this.getAttstartDateAndEndDate(monthAndYear, map);
            }
        }
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("allFilterList", SerializationUtils.serializeToBase64((Object)map));
    }

    private void getAttstartDateAndEndDate(String monthAndYear, Map<String, Object> map) {
        Calendar calendar = Calendar.getInstance();
        Date startTime = null;
        Date endTime = null;
        if (MONTHANDYEAR_OPTION_PRE.equals(monthAndYear)) {
            calendar.add(2, -1);
            calendar.set(5, 1);
            startTime = calendar.getTime();
            calendar.add(2, 1);
            calendar.set(5, 1);
            endTime = calendar.getTime();
        } else if (MONTHANDYEAR_OPTION_CUR.equals(monthAndYear)) {
            calendar.set(5, 1);
            startTime = calendar.getTime();
            calendar.add(2, 1);
            calendar.set(5, 1);
            endTime = calendar.getTime();
        } else if (MONTHANDYEAR_OPTION_AFTER.equals(monthAndYear)) {
            calendar.add(2, 1);
            calendar.set(5, 1);
            startTime = calendar.getTime();
            calendar.add(2, 1);
            calendar.set(5, 1);
            endTime = calendar.getTime();
        } else if (MONTHANDYEAR_OPTION_PRE3.equals(monthAndYear)) {
            endTime = calendar.getTime();
            calendar.add(2, -3);
            startTime = calendar.getTime();
        }
        String startDateStr = SWCDateTimeUtils.format((Date)startTime);
        String endDateStr = SWCDateTimeUtils.format((Date)endTime);
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = SWCDateTimeUtils.parseDate((String)startDateStr, (String)"yyyy-MM-dd");
            endDate = SWCDateTimeUtils.parseDate((String)endDateStr, (String)"yyyy-MM-dd");
            map.put("attstartdate", startDate);
            map.put("attenddate", endDate);
        }
        catch (ParseException e) {
            logger.error("\u9519\u8bef\u4fe1\u606f\u4e3a{}", (Object)e.getMessage());
        }
    }

    private void clearAllData() {
        IDataModel model = this.getModel();
        model.setValue("employee", null);
        model.setValue("monthandyearoption", null);
        model.setValue("attstartdate", null);
        model.setValue("attenddate", null);
        model.setValue("attbizitem", null);
        model.setValue("usagecountoption", null);
        model.setValue("auditstatus", null);
    }

    private void openAttBizDataList(String billFormId) {
        IPageCache pageCache = this.getView().getPageCache();
        String listId = AttBizDataListHelper.openPopPage((String)billFormId, (String)"hsas_listtpl", (String)"listpanelap", (ShowType)ShowType.InContainer, (IFormView)this.getView());
        pageCache.put("listHisPageId", listId);
    }

    private void initFieldVisibleStatus() {
        IDataModel model = this.getView().getModel();
        String monthandyearoption = (String)model.getValue("monthandyearoption");
        if (MONTHANDYEAR_OPTION_CUSTOMIZE.equals(monthandyearoption)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"attdaterang"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"attdaterang"});
    }

    private boolean checkFilterParams() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (ObjectUtils.isEmpty((Object)dataEntity)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ef4\u62a4\u67e5\u8be2\u6761\u4ef6\uff1a\u201c\u4eba\u5458\u201d\uff0c\u201c\u6240\u5c5e\u5e74\u6708\u201d\u3002", (String)"AttBizDataHisPlugin_01", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObjectCollection employeeCollection = dataEntity.getDynamicObjectCollection("employee");
        String monthAndYear = dataEntity.getString("monthandyearoption");
        if (ObjectUtils.isEmpty((Object)employeeCollection) && StringUtils.isEmpty((CharSequence)monthAndYear)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ef4\u62a4\u67e5\u8be2\u6761\u4ef6\uff1a\u201c\u4eba\u5458\u201d\uff0c\u201c\u6240\u5c5e\u5e74\u6708\u201d\u3002", (String)"AttBizDataHisPlugin_01", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (ObjectUtils.isEmpty((Object)employeeCollection)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ef4\u62a4\u67e5\u8be2\u6761\u4ef6\uff1a\u201c\u4eba\u5458\u201d\u3002", (String)"AttBizDataHisPlugin_03", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)monthAndYear)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ef4\u62a4\u67e5\u8be2\u6761\u4ef6\uff1a\u201c\u6240\u5c5e\u5e74\u6708\u201d\u3002", (String)"AttBizDataHisPlugin_04", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (MONTHANDYEAR_OPTION_CUSTOMIZE.equals(monthAndYear)) {
            Date attStartDate = dataEntity.getDate("attstartdate");
            Date attEndDate = dataEntity.getDate("attenddate");
            if (ObjectUtils.isEmpty((Object)attStartDate) || ObjectUtils.isEmpty((Object)attEndDate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u8303\u56f4\u3002", (String)"AttBizDataHisPlugin_05", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return true;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(attStartDate);
            calendar.add(1, 1);
            Date calendarTime = calendar.getTime();
            if (attEndDate.compareTo(calendarTime) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u67e5\u8be2\u6027\u80fd\uff0c\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u7684\u8de8\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc71\u5e74\u3002", (String)"AttBizDataHisPlugin_06", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void initFilters() {
        String filters;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String params = (String)parameter.getCustomParam("params");
        if (StringUtils.isBlank((CharSequence)params)) {
            return;
        }
        Map paramMap = (Map)SerializationUtils.deSerializeFromBase64((String)params);
        String filterValues = MapUtils.getString((Map)paramMap, (Object)"filterValues");
        HashMap<String, List> filterValuesMap = null;
        if (StringUtils.isNotBlank((CharSequence)filterValues)) {
            filterValuesMap = new HashMap<String, List>(2);
            List filterValuesList = (List)SerializationUtils.deSerializeFromBase64((String)filterValues);
            for (Map filterMap : filterValuesList) {
                String fieldName = (String)((List)filterMap.get("FieldName")).get(0);
                List valueList = (List)filterMap.get("Value");
                if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"usagecountoption") && !StringUtils.equals((CharSequence)fieldName, (CharSequence)"monthandyearoption")) continue;
                filterValuesMap.put(fieldName, valueList);
            }
        }
        if (StringUtils.isBlank((CharSequence)(filters = MapUtils.getString((Map)paramMap, (Object)"filters")))) {
            return;
        }
        List filterList = (List)SerializationUtils.deSerializeFromBase64((String)filters);
        for (QFilter filter : filterList) {
            List valueList;
            String propertyName = filter.getProperty();
            Object value = filter.getValue();
            if (ObjectUtils.isEmpty((Object)value)) continue;
            if (propertyName.equals("attbizitem.id")) {
                if (value instanceof List) {
                    Object[] valueArr = ((List)value).toArray();
                    this.getModel().setValue("attbizitem", (Object)valueArr);
                } else if (value instanceof Long) {
                    this.getModel().setValue("attbizitem", (Object)new Object[]{value});
                }
                this.getView().updateView("attbizitem");
            }
            if (propertyName.equals("auditstatus")) {
                if (value instanceof List) {
                    valueList = (List)value;
                    StringBuilder strBuilder = new StringBuilder();
                    valueList.forEach(str -> {
                        strBuilder.append(',');
                        strBuilder.append((String)str);
                    });
                    this.getModel().setValue("auditstatus", (Object)strBuilder.toString());
                } else if (value instanceof String) {
                    this.getModel().setValue("auditstatus", value);
                }
                this.getView().updateView("auditstatus");
            }
            if (!MapUtils.isNotEmpty(filterValuesMap)) continue;
            if (propertyName.equals("usagecount")) {
                valueList = (List)filterValuesMap.get("usagecountoption");
                this.setUsageCountOption(valueList);
            }
            if (!propertyName.equals("attstartdate")) continue;
            valueList = (List)filterValuesMap.get("monthandyearoption");
            this.setMonthAndYearOption(valueList);
        }
    }

    private void setMonthAndYearOption(List<Object> valueList) {
        if (valueList.isEmpty()) {
            return;
        }
        if (valueList.size() > 1) {
            try {
                Date startDate = SWCDateTimeUtils.parseDate((String)((String)valueList.get(0)), (String)"yyyy-MM-dd");
                Date endDate = SWCDateTimeUtils.parseDate((String)((String)valueList.get(1)), (String)"yyyy-MM-dd");
                this.getModel().setValue("attenddate", (Object)endDate);
                this.getModel().setValue("attstartdate", (Object)startDate);
            }
            catch (ParseException e) {
                logger.error("\u9519\u8bef\u4fe1\u606f\u4e3a{}", (Object)e.getMessage());
            }
            this.getModel().setValue("monthandyearoption", (Object)MONTHANDYEAR_OPTION_CUSTOMIZE);
            this.getView().updateView("monthandyearoption");
            this.getView().updateView("attstartdate");
            this.getView().updateView("attenddate");
            this.getView().updateView("attdaterang");
        } else if (StringUtils.isNotBlank((Object)valueList.get(0))) {
            this.getModel().setValue("monthandyearoption", valueList.get(0));
            this.getView().updateView("monthandyearoption");
        }
    }

    private void setUsageCountOption(List<Object> valueList) {
        if (valueList.isEmpty()) {
            return;
        }
        StringBuilder strBuilder = new StringBuilder();
        valueList.forEach(str -> {
            if (StringUtils.isNotBlank((Object)str)) {
                strBuilder.append(',');
                strBuilder.append(str);
            }
        });
        this.getModel().setValue("usagecountoption", (Object)strBuilder.toString());
        this.getView().updateView("usagecountoption");
    }
}

