/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bankcardoperating;

import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.formplugin.web.bankcardoperating.BankCardOpUpdateSettingPlugin;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PerBankCardInSFListPlugin
extends BankCardOpUpdateSettingPlugin {
    private static final String OP_VIEWHIS = "donothing_viewhis";
    private static final String OP_CHANGE = "donothing_listchange";
    private static Log LOGGER = LogFactory.getLog(PerBankCardInSFListPlugin.class);

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String option;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (SWCStringUtils.equals((String)"1", (String)((String)listShowParameter.getCustomParam("isHis")))) {
            args.getListColumn("bankcardnum").setHyperlink(false);
        }
        if (null != (option = (String)listShowParameter.getCustomParam("option")) || listShowParameter.isLookUp()) {
            return;
        }
        args.getListColumn("person.name").setFixed(true);
        args.getListColumn("employee.empnumber").setFixed(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (BaseDataHisHelper.isHisList((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listoperationcolumnap"});
        }
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc) {
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                if (!e.getRowData().containsProperty("isdelete")) {
                    return;
                }
                if (!OP_CHANGE.equalsIgnoreCase(operationColItem.getOperationKey()) && !"donothing_delete".equalsIgnoreCase(operationColItem.getOperationKey()) || !e.getRowData().getBoolean("isdelete")) continue;
                operationColItem.setVisible(false);
            }
        }
        super.packageData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_delete": {
                this.isDeleteCounter(args);
                break;
            }
            case "donothing_viewhis": {
                this.openHisListPage();
                break;
            }
            case "donothing_listchange": {
                this.openHisChangePage(this.getSelectedPK(), Boolean.TRUE);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent linkClick = args.getHyperLinkClickEvent();
        BillList billList = (BillList)linkClick.getSource();
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        if (selectedRow != null && "bankcardnum".equals(linkClick.getFieldName())) {
            args.setCancel(true);
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setFormId("hsas_perbankcardinsf");
            parameter.setPkId(selectedRow.getPrimaryKeyValue());
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u5361", (String)"PerBankCardInSFListPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void isDeleteCounter(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        int selectedRowsSize = selectedRows.size();
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue("donothing_delete", afterConfirm)) {
            this.deleteSecondConfirm(selectedRowsSize);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey) {
            case "donothing_delete": {
                String isUpdate;
                OperationResult operationResult = args.getOperationResult();
                operationResult.setShowMessage(false);
                this.showNotification(operationResult);
                if (!args.getOperationResult().isSuccess() || !Boolean.parseBoolean(isUpdate = formOperate.getOption().getVariableValue("updatepaysetting", "false"))) break;
                this.openUpdatePaySettingConfirmForm(this.getDeletePersonList(operationResult.getSuccessPkIds()));
                break;
            }
        }
    }

    private List<Long> getDeletePersonList(List<Object> perBankCardIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_perbankcard");
        QFilter idFilter = new QFilter("id", "in", perBankCardIds);
        DynamicObjectCollection collection = helper.queryOriginalCollection("person.id", new QFilter[]{idFilter});
        return collection.stream().map(data -> data.getLong("person.id")).collect(Collectors.toList());
    }

    private void showNotification(OperationResult operationResult) {
        int totalNum = operationResult.getBillCount();
        int deleteSize = operationResult.getSuccessPkIds().size();
        if (deleteSize == 0) {
            String msg = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u94f6\u884c\u5361\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u518d\u6b21\u5220\u9664\u3002", (String)"PerBankCardInSFListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        } else if (deleteSize == totalNum) {
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PerBankCardInSFListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
        } else {
            String msg = ResManager.loadKDString((String)"\u5df2\u5220\u9664%s\u6761\u7b26\u5408\u6761\u4ef6\u7684\u94f6\u884c\u5361\uff0c\u5176\u4f59\u5df2\u81ea\u52a8\u6392\u9664\u3002", (String)"PerBankCardInSFListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String formatMSG = String.format(Locale.ROOT, msg, deleteSize);
            this.getView().showSuccessNotification(formatMSG);
        }
        this.getView().invokeOperation("refresh");
    }

    private void openHisListPage() {
        Long id = this.getSelectedPK();
        if (id == null) {
            return;
        }
        this.openHisListPageOne(id);
    }

    private void openHisListPageOne(Long id) {
        ListShowParameter showParam = new ListShowParameter();
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParam.setParentPageId(this.getView().getPageId());
        showParam.setBillFormId("hsas_perbankcardext");
        showParam.setFormId("bos_list");
        showParam.setCustomParam("option", (Object)"showhisversion");
        showParam.setCustomParam("hisinfolist", (Object)"hisinfolist");
        showParam.setCustomParam("boid", (Object)id);
        showParam.setCustomParam("isHis", (Object)"1");
        String caption = ResManager.loadKDString((String)"\u94f6\u884c\u5361\u5386\u53f2\u6570\u636e\u7248\u672c", (String)"PerBankCardInSFListPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        showParam.setCaption(caption);
        QFilter qFilter1 = new QFilter("boid", "=", (Object)id);
        QFilter qFilter2 = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        showParam.getListFilterParameter().getQFilters().add(qFilter1);
        showParam.getListFilterParameter().getQFilters().add(qFilter2);
        this.getView().showForm((FormShowParameter)showParam);
    }

    private Long getSelectedPK() {
        IListView listView = (IListView)this.getView();
        if (listView.getFocusRowPkId() != null) {
            ListSelectedRow row = listView.getCurrentSelectedRowInfo();
            return (Long)row.getPrimaryKeyValue();
        }
        return null;
    }
}

