/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bankoffer;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BankOfferHeadContentPlugin
extends AbstractFormPlugin {
    private static final int COL_POSITION = 5;
    private static final int COL_HEASCONTENT = 2;
    private static final int MAX_ROWLENGTH = 255;

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.init();
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"subheadcontent", "btnok"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData[] changeData = args.getChangeSet();
        this.headTypeChange(fieldKey, changeData);
        this.subHeadContentChange(fieldKey, changeData);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "refresh": {
                this.refreshValue(args, formOperate);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control sControl = (Control)evt.getSource();
        switch (sControl.getKey()) {
            case "subheadcontent": {
                this.editHeadContent();
                break;
            }
            case "btnok": {
                this.saveInput();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "hsas_bankoffertextcon": {
                this.setSubTextContent(event);
                break;
            }
            case "hsas_bankofferfieldcon": {
                this.setSubFieldContent(event);
                break;
            }
        }
    }

    private void init() {
        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getParentView().getFormShowParameter()).getBillStatus();
        if (!BillOperationStatus.ADDNEW.equals((Object)billStatus) && !BillOperationStatus.EDIT.equals((Object)billStatus)) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        Label label = (Label)this.getView().getControl("headcontenttitle");
        Integer row = (Integer)this.getView().getFormShowParameter().getCustomParam("headContentRow");
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            label.setText(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7684\u5217\u4fe1\u606f", (String)"BankOfferTpl_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]), row));
        } else {
            label.setText(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7b2c{0}\u884c\u7684\u5217\u4fe1\u606f\u3002", (String)"BankOfferTpl_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]), row));
        }
        int entryIndex = this.getView().getParentView().getModel().getEntryCurrentRowIndex("exceltitleent");
        DynamicObjectCollection excelTitleCollection = this.getView().getParentView().getModel().getEntryEntity("exceltitleent");
        DynamicObjectCollection headContentCollection = ((DynamicObject)excelTitleCollection.get(entryIndex)).getDynamicObjectCollection("headcontententity");
        IDataModel model = this.getModel();
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)model;
        model.beginInit();
        if (headContentCollection.isEmpty()) {
            this.getView().invokeOperation("newentry");
            model.endInit();
            return;
        }
        TableValueSetter headContentSetter = BankOfferHelper.createHeadContentTableSetter();
        for (DynamicObject headContentDy : headContentCollection) {
            String headType = headContentDy.getString("headtype");
            Map contentFieldToNameMap = BankOfferHelper.getContentFieldToNameMap();
            String subHeadContent = headContentDy.getString("subheadcontent");
            if (SWCStringUtils.equals((String)headType, (String)"1")) {
                subHeadContent = (String)contentFieldToNameMap.get(headContentDy.getString("selectfield"));
            }
            headContentSetter.addRow(new Object[]{headType, subHeadContent, headContentDy.getString("selectfield"), headContentDy.getString("fieldshowtype"), headContentDy.getString("alignment"), headContentDy.getString("collocation")});
        }
        abstractFormDataModel.batchCreateNewEntryRow("headcontententity", headContentSetter);
        model.endInit();
        this.getView().updateView("headcontententity");
    }

    private void subHeadContentChange(String fieldKey, ChangeData[] changeData) {
        if (StringUtils.equals((CharSequence)"subheadcontent", (CharSequence)fieldKey)) {
            int entryIndex = this.getModel().getEntryCurrentRowIndex("headcontententity");
            DynamicObjectCollection headContentCollection = this.getModel().getEntryEntity("headcontententity");
            DynamicObject headContentDy = (DynamicObject)headContentCollection.get(entryIndex);
            String headType = headContentDy.getString("headtype");
            if ("2".equals(headType)) {
                return;
            }
            String newValue = (String)changeData[0].getNewValue();
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            Map fieldMap = (Map)pageCache.get("separator", Map.class);
            if (null == fieldMap || fieldMap.isEmpty()) {
                fieldMap = BankOfferHelper.getContentFieldToNameMap();
                pageCache.put("separator", (Object)fieldMap);
            }
            if (fieldMap.values().contains(newValue)) {
                for (Map.Entry entry : fieldMap.entrySet()) {
                    if (!StringUtils.equals((CharSequence)((CharSequence)entry.getValue()), (CharSequence)newValue)) continue;
                    this.getModel().setValue("selectfield", entry.getKey());
                    return;
                }
            } else {
                this.getModel().setValue("selectfield", null);
                this.invokeRefreshOperation("subheadcontent");
            }
        }
    }

    private void headTypeChange(String fieldKey, ChangeData[] changeData) {
        if (StringUtils.equals((CharSequence)"headtype", (CharSequence)fieldKey)) {
            this.getModel().setValue("subheadcontent", null);
            this.getModel().setValue("selectfield", null);
            String newValue = (String)changeData[0].getNewValue();
            if (StringUtils.equals((CharSequence)newValue, (CharSequence)"2")) {
                this.getModel().setValue("fieldshowtype", null);
            } else {
                this.getModel().setValue("fieldshowtype", (Object)"1");
            }
        }
    }

    private void editHeadContent() {
        int entryIndex = this.getModel().getEntryCurrentRowIndex("headcontententity");
        DynamicObjectCollection headContentCollection = this.getModel().getEntryEntity("headcontententity");
        DynamicObject headContentDy = (DynamicObject)headContentCollection.get(entryIndex);
        String headType = headContentDy.getString("headtype");
        FormShowParameter parameter = new FormShowParameter();
        if ("1".equals(headType)) {
            parameter.setCustomParam("selectfield", (Object)headContentDy.getString("selectfield"));
            parameter.setFormId("hsas_bankofferfieldcon");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_bankofferfieldcon"));
        } else {
            parameter.setCustomParam("subheadcontent", (Object)headContentDy.getString("subheadcontent"));
            parameter.setFormId("hsas_bankoffertextcon");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_bankoffertextcon"));
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void setSubTextContent(ClosedCallBackEvent event) {
        String subHeadContent = (String)event.getReturnData();
        if (null == subHeadContent) {
            return;
        }
        this.getModel().setValue("subheadcontent", (Object)subHeadContent);
    }

    private void setSubFieldContent(ClosedCallBackEvent event) {
        String selectField = (String)event.getReturnData();
        if (null == selectField) {
            return;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map fieldMap = (Map)pageCache.get("separator", Map.class);
        if (null == fieldMap || fieldMap.isEmpty()) {
            fieldMap = BankOfferHelper.getContentFieldToNameMap();
            pageCache.put("separator", (Object)fieldMap);
        }
        this.getModel().setValue("subheadcontent", fieldMap.get(selectField));
    }

    protected void invokeRefreshOperation(String opKey) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ispropertyrefresh", "true");
        operateOption.setVariableValue("refreshcontent", opKey);
        this.getView().invokeOperation("refresh", operateOption);
    }

    private void refreshValue(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        boolean isPropertyRefresh = Boolean.parseBoolean(formOperate.getOption().getVariableValue("ispropertyrefresh", String.valueOf(false)));
        if (isPropertyRefresh) {
            args.setCancel(true);
            int entryIndex = this.getModel().getEntryCurrentRowIndex("headcontententity");
            DynamicObject selectOvDy = (DynamicObject)this.getModel().getEntryEntity("headcontententity").get(entryIndex);
            String refreshField = formOperate.getOption().getVariableValue("refreshcontent");
            selectOvDy.set(refreshField, null);
            this.getView().updateView(refreshField, entryIndex);
        }
    }

    private void saveInput() {
        if (!this.validateEntity()) {
            return;
        }
        HashMap<String, DynamicObjectCollection> data = new HashMap<String, DynamicObjectCollection>(16);
        DynamicObjectCollection headContentCollection = this.getModel().getEntryEntity("headcontententity");
        data.put("headcontententity", headContentCollection);
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private boolean validateEntity() {
        DynamicObjectCollection headContentCollection = this.getModel().getEntryEntity("headcontententity");
        String regex = "^[A-Za-z]+$";
        int index = 0;
        int len = 0;
        HashSet<String> colSet = new HashSet<String>(16);
        for (DynamicObject headContentDy : headContentCollection) {
            ++index;
            String collocation = headContentDy.getString("collocation");
            String subHeadContent = headContentDy.getString("subheadcontent");
            if (StringUtils.isBlank((CharSequence)subHeadContent)) {
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\u4e3a\u7a7a\u3002", (String)"BankOfferTplTips_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), index, 2));
                return false;
            }
            len += subHeadContent.length();
            if (StringUtils.isBlank((CharSequence)collocation)) {
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\u4e3a\u7a7a\u3002", (String)"BankOfferTplTips_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), index, 5));
                return false;
            }
            if (!collocation.matches(regex)) {
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\u53ea\u5141\u8bb8\u8f93\u5165\u5b57\u6bcd\u3002\u4f8b\uff1aA\u3002", (String)"BankOfferTplTips_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), index, 5));
                return false;
            }
            String headContent = headContentDy.getString("collocation");
            if (StringUtils.isNotBlank((CharSequence)headContent)) {
                headContent = headContent.toUpperCase();
            }
            colSet.add(headContent);
        }
        if (colSet.size() != headContentCollection.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5217\u4f4d\u7f6e\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"BankOfferTplTips_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (len > 255) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u5934\u884c\u5185\u5bb9\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255\u3002", (String)"BankOfferTplTips_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

