/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bankoffer;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hsas.business.bankoffer.BankOfferHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.lang.StringUtils;

public class BankOfferTplEdit
extends SWCDataBaseEdit
implements TreeNodeClickListener {
    private static final String[] OPTIONAL_PARAMETER_ARRAY = new String[]{"filetotalnum", "filepaycurrency", "filecountry", "filepayrolldate", "filebankcgsettingid", "filebankcgsettingnum", "fileexportdate", "fileagentpayaccount", "fileagentpaybank", "headtotalnum", "headpaycurrency", "headtotalamount", "headpaysubjecthis", "headpaysubjecthisnum", "headpayrolldate", "headbankcgsettingid", "headbankcgsettingnum", "headexportdate", "headagentpayaccount", "headagentpaybank"};
    private static final String LEFT_SEPERATE = "{";
    private static final String RIGHT_SEPERATE = "}";
    private static final String FILENAME_REGULAR = "[\\\\/:\\*\\?\\\"<>\\|=\\+%&#]";
    private static final String BLANK_STRING = " ";
    private static final int COL_HEASCONTENT = 3;
    private static final int COL_FIXCONTENT = 6;
    private static final String DELETEDETAILENTRY = "deletedetailentry";
    private static final String ADDDETAILENTRY = "adddetailentry";
    public static final String MODIFYAFTERAUDIT = "donothing_modifyafteraudit";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.init();
        this.getView().getPageCache().put("BOS.setRowDataByNumberDisable", "true");
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (formId.contains("his")) {
            return;
        }
        this.setDetailEntDefaultData();
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(OPTIONAL_PARAMETER_ARRAY);
        this.addClickListeners(new String[]{"headcontent", "fieldvalue"});
        Label texPreviewLabel = (Label)this.getView().getControl("txtpreview");
        texPreviewLabel.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData[] changeData = args.getChangeSet();
        this.currencyChange(fieldKey);
        this.countryTypeChange(fieldKey, changeData);
        this.bankTypeChange(fieldKey, changeData);
        this.fileTypeChange(fieldKey, changeData);
        this.limitContentChange(fieldKey, changeData);
        this.separateWaysChange(fieldKey, changeData);
        this.headRowIsEmptyChange(fieldKey, changeData);
        this.headContentChange(fieldKey, changeData);
        this.headSourceChange(fieldKey, changeData);
        this.fieldValueChange(fieldKey, changeData);
        this.showHeadChange(fieldKey, changeData);
        this.fixWayChange(fieldKey, changeData);
        this.fixContentChange(fieldKey, changeData);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control sControl = (Control)evt.getSource();
        switch (sControl.getKey()) {
            case "txtpreview": {
                this.txtPreview();
                break;
            }
            case "headcontent": {
                this.editHeadContent();
                break;
            }
            case "fieldvalue": {
                this.editFieldValue();
                break;
            }
            case "filetotalnum": 
            case "filepaycurrency": 
            case "filecountry": 
            case "filepayrolldate": 
            case "filebankcgsettingid": 
            case "filebankcgsettingnum": 
            case "fileexportdate": 
            case "fileagentpayaccount": 
            case "fileagentpaybank": {
                this.setArgToFileName(sControl.getKey());
                break;
            }
            case "headtotalnum": 
            case "headpaycurrency": 
            case "headtotalamount": 
            case "headpaysubjecthis": 
            case "headpaysubjecthisnum": 
            case "headpayrolldate": 
            case "headbankcgsettingid": 
            case "headbankcgsettingnum": 
            case "headexportdate": 
            case "headagentpayaccount": 
            case "headagentpaybank": {
                this.setArgToHeadContent(sControl.getKey());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "excelpreview": {
                this.excelPreview();
                break;
            }
            case "save": 
            case "submit": 
            case "audit": 
            case "changesave": {
                boolean isSaveAllRight = this.validateBeforeSave(args);
                if (!isSaveAllRight) break;
                this.changeNameToField();
                break;
            }
            case "auditconfirmchange": {
                this.confirmChangeBeforeDo(args, formOperate);
                break;
            }
            case "refresh": {
                this.refreshValue(args, formOperate);
                break;
            }
            case "viewheadcontent": {
                this.editHeadContent();
                break;
            }
            case "viewdemo": {
                this.viewDemo();
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs args) {
        DynamicObjectCollection excelEntry;
        int[] rowIndexs = args.getRowIndexs();
        String name = args.getEntryProp().getName();
        if (StringUtils.equals((String)name, (String)"exceltitleent") && (excelEntry = this.getModel().getEntryEntity("exceltitleent")).size() <= rowIndexs.length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4fdd\u7559\u4e00\u884c\u8868\u5934\u4fe1\u606f\u3002", (String)"BankOfferTplTips_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        this.updateSeq(key);
        switch (key) {
            case "save": 
            case "submit": 
            case "audit": 
            case "changesave": {
                this.setTxtTitle();
                this.setFileName();
                this.getModel().setDataChanged(false);
                break;
            }
            case "auditconfirmchange": {
                if (!args.getOperationResult().isSuccess()) break;
                this.setTxtTitle();
                this.setFileName();
                this.getModel().setDataChanged(false);
                break;
            }
            case "deletedetailentry": 
            case "adddetailentry": {
                this.setIsShowThousandthEnable();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "headcontent": {
                this.setHeadContent(event);
                break;
            }
            case "hsas_bankofferdselectcon": {
                this.setSelectBySelectField(event);
                break;
            }
            case "hsas_bankofferdtextcon": {
                this.setSelectByInputText(event);
                break;
            }
            case "hsas_bankoffertplseparate": {
                this.setSeparateToText(event);
                break;
            }
            case "hsas_bankofferdcustomcon": {
                this.setSelectByCustom(event);
                break;
            }
        }
    }

    private void init() {
        this.countryTypeInit();
        this.bankTypeInit();
        this.fileTypeInit();
        this.limitContentInit();
        this.isShowHeadInit();
        this.setSeparateWaysStyle();
        this.setTxtTitle();
        this.setExcelTitleDefaultHeadContent();
        this.setDetailEntDefaultFieldValue();
        this.initFileName();
        this.setIsShowThousandthEnable();
        this.fixContentEnable();
        this.setLabValue();
        this.getModel().setDataChanged(false);
    }

    private void setExcelTitleDefaultHeadContent() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection excelTitleEntries = dataEntity.getDynamicObjectCollection("exceltitleent");
        Map contentFieldToNameMap = BankOfferHelper.getContentFieldToNameMap();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        for (int i = 0; i < excelTitleEntries.size(); ++i) {
            DynamicObject excelTitleEntry = (DynamicObject)excelTitleEntries.get(i);
            DynamicObjectCollection headContentEntries = excelTitleEntry.getDynamicObjectCollection("headcontententity");
            StringJoiner headContent = new StringJoiner("\uff0c");
            for (DynamicObject headContentEntry : headContentEntries) {
                String headtype = headContentEntry.getString("headtype");
                if (SWCStringUtils.equals((String)headtype, (String)"1")) {
                    String selectField = headContentEntry.getString("selectfield");
                    String headContentName = (String)contentFieldToNameMap.get(selectField);
                    headContent.add(headContentName);
                    continue;
                }
                String headContentText = headContentEntry.getString("subheadcontent");
                headContent.add(headContentText);
            }
            this.getModel().setValue("headcontent", (Object)headContent.toString(), i);
        }
        model.endInit();
    }

    private void setDetailEntDefaultFieldValue() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection detailEntries = dataEntity.getDynamicObjectCollection("detailent");
        Map detailFieldToNameMap = BankOfferHelper.getPayDetailFieldMap();
        List ids = detailEntries.stream().filter(data -> "4".equals(data.getString("fieldsource"))).map(data -> data.getLong("fieldselect")).collect(Collectors.toList());
        Map customPatchMap = BankOfferHelper.getCustomNameMap(ids);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        for (int i = 0; i < detailEntries.size(); ++i) {
            String fieldSelect;
            DynamicObject detailEntry = (DynamicObject)detailEntries.get(i);
            String fieldSource = detailEntry.getString("fieldsource");
            String fieldValueName = detailEntry.getString("fieldvalue");
            if (SWCStringUtils.equals((String)fieldSource, (String)"2")) {
                fieldSelect = detailEntry.getString("fieldselect");
                fieldValueName = (String)detailFieldToNameMap.get(fieldSelect);
            }
            if ("4".equals(fieldSource)) {
                fieldSelect = detailEntry.getString("fieldselect");
                fieldValueName = (String)customPatchMap.get(fieldSelect);
            }
            this.getModel().setValue("fieldvalue", (Object)fieldValueName, i);
        }
        model.endInit();
        this.getView().updateView("detailent");
    }

    private void setDetailEntDefaultData() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status) && BaseDataHisHelper.isCurrPage((IFormView)this.getView())) {
            TableValueSetter setter = new TableValueSetter(new String[0]);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            this.createTableSetter(setter);
            model.beginInit();
            this.setTableSetterData(setter);
            model.batchCreateNewEntryRow("detailent", setter);
            model.endInit();
            this.getView().updateView("detailent");
            this.getModel().setDataChanged(false);
        }
    }

    private void createTableSetter(TableValueSetter setter) {
        setter.addField("fieldname", new Object[0]);
        setter.addField("fieldsource", new Object[0]);
        setter.addField("fieldvalue", new Object[0]);
        setter.addField("fieldselect", new Object[0]);
        setter.addField("fieldquerytable", new Object[0]);
        setter.addField("fieldlength", new Object[0]);
        setter.addField("fixway", new Object[0]);
        setter.addField("fixcontent", new Object[0]);
        setter.addField("isshowthousandth", new Object[0]);
        setter.addField("isnull", new Object[0]);
    }

    private void setTableSetterData(TableValueSetter setter) {
        List bankOfferTplDetailEntData = BankOfferHelper.getBankOfferTplDetailEntData();
        for (Object[] ent : bankOfferTplDetailEntData) {
            setter.addRow(ent);
        }
    }

    private void fixContentEnable() {
        DynamicObjectCollection detailEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("detailent");
        int index = 0;
        for (DynamicObject detailDy : detailEntry) {
            String fixWay = detailDy.getString("fixway");
            if ("3".equals(fixWay) || "4".equals(fixWay)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"fixcontent"});
            }
            ++index;
        }
    }

    private void setLabValue() {
        for (String labKey : OPTIONAL_PARAMETER_ARRAY) {
            Control control = this.getView().getControl(labKey);
            if (!(control instanceof Label)) continue;
            String name = "";
            if (labKey.startsWith("file")) {
                labKey = labKey.replaceFirst("file", "");
                name = LEFT_SEPERATE + (String)BankOfferHelper.getFileFieldToNameMap().get(labKey) + RIGHT_SEPERATE;
            } else if (labKey.startsWith("head")) {
                labKey = labKey.replaceFirst("head", "");
                name = LEFT_SEPERATE + (String)BankOfferHelper.getContentFieldToNameMap().get(labKey) + RIGHT_SEPERATE;
            }
            ((Label)control).setText(name);
        }
    }

    private void limitContentInit() {
        String limitContent = this.getModel().getDataEntity().getString("limitcontent");
        if ("1".equals(limitContent)) {
            this.showLimitContent("limitline");
            this.hideLimitContent("limitamount");
            return;
        }
        if ("3".equals(limitContent)) {
            this.showLimitContent("limitamount");
            this.hideLimitContent("limitline");
            this.setLimitAmountTitle();
            return;
        }
        this.hideLimitContent("limitline", "limitamount");
    }

    private void isShowHeadInit() {
        boolean isShowHead = this.getModel().getDataEntity().getBoolean("isshowhead");
        if (isShowHead) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"headcontentap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"headcontentap"});
        }
    }

    private void fileTypeInit() {
        String fileType = this.getModel().getDataEntity().getString("filetype");
        if ("1".equals(fileType)) {
            this.hideTxtHead();
        } else {
            this.showTxtHead();
        }
    }

    private void bankTypeInit() {
        String bankType = this.getModel().getDataEntity().getString("banktype");
        if ("1".equals(bankType)) {
            this.hideBank();
        } else {
            this.showBank();
        }
    }

    private void countryTypeInit() {
        String countryType = this.getModel().getDataEntity().getString("countrytype");
        if ("1".equals(countryType)) {
            this.hideCountry();
        } else {
            this.showCountry();
        }
    }

    private boolean validateBeforeSave(BeforeDoOperationEventArgs args) {
        int limitLine;
        int rightCount;
        int leftCount;
        boolean isAllRight = true;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String limitContent = dataEntity.getString("limitcontent");
        String fileName = dataEntity.getString("filename");
        String txtHead = dataEntity.getString("txthead");
        OperationResult operationResult = new OperationResult();
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        map.put(dataEntity.getLong("id"), "");
        operationResult.setBillNos(map);
        operationResult.setBillCount(1);
        if (StringUtils.isNotBlank((String)fileName)) {
            Object pattern;
            Matcher matcher;
            leftCount = this.getCount(fileName, LEFT_SEPERATE);
            if (leftCount != (rightCount = this.getCount(fileName, RIGHT_SEPERATE))) {
                this.addErrorInfo(operationResult, ResManager.loadKDString((String)"\u6587\u4ef6\u540d\uff1a\u68c0\u6d4b\u5230\u62ec\u53f7\u4e0d\u5b8c\u6574\uff0c\u53ef\u80fd\u5bfc\u81f4\u53c2\u6570\u8bc6\u522b\u5931\u8d25\u3002", (String)"BankOfferTplTips_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ErrorLevel.Warning);
                isAllRight = false;
            }
            if ((matcher = ((Pattern)(pattern = Pattern.compile(FILENAME_REGULAR))).matcher(fileName)).find()) {
                this.addErrorInfo(operationResult, ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u5305\u542b\u4e0b\u5217\u5b57\u7b26: \u201c/\u201d\u3001\u201c:\u201d\u3001\u201c*\u201d\u3001\u201c?\u201d\u3001\u201c\"\u201d\u3001\u201c<\u201d\u3001\u201c>\u201d\u3001\u201c|\u201d\u3001\u201c=\u201d\u3001\u201c+\u201d\u3001\u201c%\u201d\u3001\u201c&\u201d\u3001\u201c#\u201d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"BankOfferTplTips_26", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                isAllRight = false;
            }
        }
        if (SWCStringUtils.equals((String)limitContent, (String)"1") && ((limitLine = dataEntity.getInt("limitline")) <= 0 || limitLine > 1000000)) {
            this.addErrorInfo(operationResult, ResManager.loadKDString((String)"\u5355\u4e2a\u6587\u4ef6\u884c\u6570\u4e0a\u9650\u5e94\u57281-1000000\u4e4b\u95f4\u3002", (String)"BankOfferTplTips_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ErrorLevel.Warning);
            isAllRight = false;
        }
        if (StringUtils.isNotBlank((String)txtHead) && (leftCount = this.getCount(txtHead, LEFT_SEPERATE)) != (rightCount = this.getCount(txtHead, RIGHT_SEPERATE))) {
            this.addErrorInfo(operationResult, ResManager.loadKDString((String)"\u8868\u5934\u5185\u5bb9\u8bbe\u7f6e\uff1a\u68c0\u6d4b\u5230\u62ec\u53f7\u4e0d\u5b8c\u6574\uff0c\u53ef\u80fd\u5bfc\u81f4\u53c2\u6570\u8bc6\u522b\u5931\u8d25\u3002", (String)"BankOfferTplTips_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ErrorLevel.Warning);
            isAllRight = false;
        }
        DynamicObjectCollection excelTitleEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("exceltitleent");
        int index = 0;
        for (DynamicObject excelTitleDy : excelTitleEntry) {
            String headContent;
            ++index;
            boolean isEmpty = excelTitleDy.getBoolean("isempty");
            if (isEmpty || !StringUtils.isEmpty((String)(headContent = excelTitleDy.getString("headcontent")))) continue;
            this.addErrorInfo(operationResult, MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8868\u5934\u5185\u5bb9\u201d\uff08\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff09\u3002", (String)"BankOfferTplTips_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]), index, 3), ErrorLevel.FatalError);
            isAllRight = false;
        }
        DynamicObjectCollection detailCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("detailent");
        int jindex = 0;
        boolean isHavePayAmount = false;
        Set customEnableSet = BankOfferHelper.getCustomEnableSet(detailCollection.stream().filter(data -> "4".equals(data.getString("fieldsource"))).map(data -> data.getLong("fieldselect")).collect(Collectors.toList()));
        for (DynamicObject detailDy : detailCollection) {
            List<String> fixWays;
            int length;
            String fixContent = detailDy.getString("fixcontent");
            String fieldSelect = detailDy.getString("fieldselect");
            if ("payamount".equals(fieldSelect)) {
                isHavePayAmount = true;
            }
            if (null != fixContent && ((length = BankOfferHelper.length((String)fixContent)) > 1 || BLANK_STRING.equals(fixContent))) {
                this.getModel().setValue("fixcontent", null, jindex);
                this.addErrorInfo(operationResult, MessageFormat.format(ResManager.loadKDString((String)"\u62a5\u76d8\u660e\u7ec6\u5b57\u6bb5\u8bbe\u7f6e\u7b2c{0}\u884c\u7b2c{1}\u5217\uff1a\u8865\u9f50\u5185\u5bb9\u4ec5\u5141\u8bb8\u8f93\u51651\u4e2a\u82f1\u6587\u3001\u6570\u5b57\u3001\u6216\u82f1\u6587\u7b26\u53f7\uff0c\u8bf7\u8c03\u6574\u3002", (String)"BankOfferTplTips_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]), jindex + 1, 6), ErrorLevel.FatalError);
                isAllRight = false;
            }
            String fixWay = detailDy.getString("fixway");
            int fixLength = detailDy.getInt("fieldlength");
            if (fixLength == 0 && (StringUtils.isNotBlank((String)fixWay) || StringUtils.isNotBlank((String)fixContent))) {
                this.addErrorInfo(operationResult, MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u7b2c{0}\u884c\u5b57\u6bb5\u7684\u957f\u5ea6\u3002", (String)"BankOfferTplTips_23", (String)"swc-hsas-formplugin", (Object[])new Object[0]), jindex + 1), ErrorLevel.Warning);
                isAllRight = false;
            }
            if (StringUtils.isBlank((String)fixWay) && StringUtils.isNotBlank((String)fixContent)) {
                this.addErrorInfo(operationResult, MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5b57\u6bb5\u957f\u5ea6\u4e0d\u8db3\u8865\u9f50\u65b9\u5f0f\uff08\u7b2c{0}\u884c\uff09\u3002", (String)"BankOfferTplTips_24", (String)"swc-hsas-formplugin", (Object[])new Object[0]), jindex + 1), ErrorLevel.Warning);
                isAllRight = false;
            }
            if ((fixWays = Arrays.asList("1", "2")).contains(fixWay) && SWCStringUtils.isEmpty((String)fixContent)) {
                this.addErrorInfo(operationResult, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u62a5\u76d8\u660e\u7ec6\u201d\u7b2c{0}\u884c\uff1a\u8bf7\u586b\u5199\u201c\u8865\u9f50\u5185\u5bb9\u201d\u3002", (String)"BankOfferTplTips_30", (String)"swc-hsas-formplugin", (Object[])new Object[0]), jindex + 1), ErrorLevel.Warning);
                isAllRight = false;
            }
            String fieldName = detailDy.getString("fieldname");
            if (fixLength != 0 && fieldName.length() > fixLength) {
                this.addErrorInfo(operationResult, MessageFormat.format(ResManager.loadKDString((String)"\u62a5\u76d8\u660e\u7ec6\u5b57\u6bb5\u8bbe\u7f6e\u7b2c{0}\u884c\uff1a\u5b57\u6bb5\u540d\u79f0\u957f\u5ea6\u5927\u4e8e\u8bbe\u7f6e\u7684\u5b57\u6bb5\u957f\u5ea6\uff0c\u5c06\u5bfc\u81f4\u94f6\u884c\u62a5\u76d8\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u8c03\u6574\u3002", (String)"BankOfferTplTips_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]), jindex + 1), ErrorLevel.FatalError);
                isAllRight = false;
            }
            String fieldSource = detailDy.getString("fieldsource");
            String fieldValue = detailDy.getString("fieldvalue");
            List<String> needValueList = Arrays.asList("1", "2", "4");
            if (needValueList.contains(fieldSource) && SWCStringUtils.isEmpty((String)fieldValue)) {
                this.addErrorInfo(operationResult, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u62a5\u76d8\u660e\u7ec6\u201d\u7b2c{0}\u884c\uff1a\u8bf7\u586b\u5199\u201c\u5b57\u6bb5\u53d6\u503c\u201d\u3002", (String)"BankOfferTplTips_28", (String)"swc-hsas-formplugin", (Object[])new Object[0]), jindex + 1), ErrorLevel.Warning);
                isAllRight = false;
            } else if ("4".equals(fieldSource) && !customEnableSet.contains(detailDy.getLong("fieldselect"))) {
                this.addErrorInfo(operationResult, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u62a5\u76d8\u660e\u7ec6\u201d\u7b2c{0}\u884c\uff1a\u5b57\u6bb5\u53d6\u503c\u201c{1}\u201d\u4e0d\u53ef\u7528\u3002", (String)"BankOfferTplTips_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]), jindex + 1, fieldValue), ErrorLevel.Warning);
                isAllRight = false;
            }
            ++jindex;
        }
        if (SWCStringUtils.equals((String)limitContent, (String)"3")) {
            BigDecimal limitAmount = dataEntity.getBigDecimal("limitamount");
            if (BigDecimal.ZERO.compareTo(limitAmount) >= 0) {
                this.addErrorInfo(operationResult, ResManager.loadKDString((String)"\u5355\u4e2a\u91d1\u989d\u4e0a\u9650\u5e94\u57281-9999999999999.9999999999\u4e4b\u95f4\u3002", (String)"BankOfferTpl_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ErrorLevel.Warning);
                isAllRight = false;
            }
            if (!isHavePayAmount) {
                this.addErrorInfo(operationResult, ResManager.loadKDString((String)"\u5f53\u524d\u6587\u4ef6\u5927\u5c0f\u9650\u5236\u65b9\u5f0f\u4e3a\u91d1\u989d\uff0c\u8bf7\u5728\u62a5\u76d8\u660e\u7ec6\u5b57\u6bb5\u4e2d\u6dfb\u52a0\u6536\u6b3e\u91d1\u989d\u3002", (String)"BankOfferTpl_23", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                isAllRight = false;
            }
        }
        if (!isAllRight) {
            FormOperate formOperate = (FormOperate)args.getSource();
            this.getView().showOperationResult(operationResult, formOperate.getOperateName().getLocaleValue());
            args.setCancel(true);
        }
        return isAllRight;
    }

    private void addErrorInfo(OperationResult result, String msg, ErrorLevel level) {
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setLevel(level);
        errorInfo.setMessage(msg);
        result.addErrorInfo(errorInfo);
    }

    private int getCount(String str, String key) {
        if (str == null || key == null || "".equals(str.trim()) || "".equals(key.trim())) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(key, index)) != -1) {
            index += key.length();
            ++count;
        }
        return count;
    }

    private void setSeparateWaysStyle() {
        TextEdit separator = (TextEdit)this.getView().getControl("separator");
        TextEdit fixLength = (TextEdit)this.getView().getControl("fixlength");
        BasedataEdit country = (BasedataEdit)this.getView().getControl("countryid");
        BasedataEdit bank = (BasedataEdit)this.getView().getControl("bankcgsettingid");
        TextEdit limitLine = (TextEdit)this.getView().getControl("limitline");
        DecimalEdit limitAmount = (DecimalEdit)this.getView().getControl("limitamount");
        ComboEdit separateDropDown = (ComboEdit)this.getView().getControl("separatedropdown");
        separator.setMustInput(true);
        fixLength.setMustInput(true);
        country.setMustInput(true);
        bank.setMustInput(true);
        limitLine.setMustInput(true);
        limitAmount.setMustInput(true);
        separateDropDown.setMustInput(true);
    }

    private void headContentChange(String fieldKey, ChangeData[] changeData) {
        String newValue;
        if (StringUtils.equals((String)"headcontent", (String)fieldKey) && StringUtils.isBlank((String)(newValue = (String)changeData[0].getNewValue()))) {
            int entryIndex = this.getModel().getEntryCurrentRowIndex("exceltitleent");
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex("exceltitleent", entryIndex);
            entryOperate.deleteEntryData("headcontententity");
        }
    }

    private void headSourceChange(String fieldKey, ChangeData[] changeData) {
        if (StringUtils.equals((String)"fieldsource", (String)fieldKey)) {
            int entryIndex = this.getModel().getEntryCurrentRowIndex("detailent");
            this.getModel().setValue("fieldvalue", null, entryIndex);
            this.getModel().setValue("fieldselect", null, entryIndex);
            this.getModel().setValue("fieldlength", (Object)0, entryIndex);
            this.getModel().setValue("fixway", null, entryIndex);
            this.getModel().setValue("fixcontent", null, entryIndex);
            this.getModel().setValue("isshowthousandth", null, entryIndex);
            this.getModel().setValue("fieldquerytable", null, entryIndex);
            this.setIsShowThousandthEnable();
            String newValue = (String)changeData[0].getNewValue();
            if ("3".equals(newValue)) {
                this.getModel().setValue("isnull", (Object)Boolean.FALSE);
            }
            if ("5".equals(newValue)) {
                this.getModel().setValue("isnull", (Object)Boolean.TRUE);
            }
        }
    }

    private void fieldValueChange(String fieldKey, ChangeData[] changeData) {
        if (StringUtils.equals((String)"fieldvalue", (String)fieldKey)) {
            String newValue = (String)changeData[0].getNewValue();
            int entryIndex = this.getModel().getEntryCurrentRowIndex("detailent");
            if (StringUtils.isBlank((String)newValue)) {
                this.getModel().setValue("fieldselect", null, entryIndex);
                this.getModel().setValue("fieldquerytable", null, entryIndex);
                this.getModel().setValue("isshowthousandth", (Object)Boolean.FALSE, entryIndex);
                this.getView().setEnable(Boolean.FALSE, entryIndex, new String[]{"isshowthousandth"});
                return;
            }
            String amountFiled = (String)BankOfferHelper.getAmountTypeMap().get(newValue);
            if (StringUtils.isNotBlank((String)amountFiled)) {
                this.getModel().setValue("isshowthousandth", (Object)Boolean.TRUE);
                this.getView().setEnable(Boolean.TRUE, entryIndex, new String[]{"isshowthousandth"});
            } else {
                this.getModel().setValue("isshowthousandth", (Object)Boolean.FALSE, entryIndex);
                this.getView().setEnable(Boolean.FALSE, entryIndex, new String[]{"isshowthousandth"});
            }
            this.setIsShowThousandthEnable();
            this.fixContentEnable();
        }
    }

    private void showHeadChange(String fieldKey, ChangeData[] changeData) {
        if (!StringUtils.equals((String)"isshowhead", (String)fieldKey)) {
            return;
        }
        Boolean newValue = (Boolean)changeData[0].getNewValue();
        if (null == newValue) {
            return;
        }
        if (Boolean.TRUE.equals(newValue)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"headcontentap"});
            String fileType = this.getModel().getDataEntity().getString("filetype");
            if ("1".equals(fileType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"excelheadcontentap"});
                this.getModel().deleteEntryData("exceltitleent");
                this.getView().invokeOperation("newentry");
                this.getModel().setValue("txthead", null);
                CodeEdit codeTextEditor = (CodeEdit)this.getView().getControl("codeeditap");
                codeTextEditor.setText("");
                this.getView().updateView("codeeditap");
                this.getView().updateView("txthead");
            } else {
                this.getModel().setValue("txthead", null);
                CodeEdit codeTextEditor = (CodeEdit)this.getView().getControl("codeeditap");
                codeTextEditor.setText("");
                this.getView().updateView("codeeditap");
                this.getView().updateView("txthead");
                this.getView().setVisible(Boolean.TRUE, new String[]{"textheadcontentap"});
            }
        } else {
            this.getModel().deleteEntryData("exceltitleent");
            this.getModel().setValue("txthead", null);
            CodeEdit codeTextEditor = (CodeEdit)this.getView().getControl("codeeditap");
            codeTextEditor.setText("");
            this.getView().updateView("codeeditap");
            this.getView().updateView("txthead");
            this.getView().setVisible(Boolean.FALSE, new String[]{"headcontentap"});
        }
    }

    private void fixWayChange(String fieldKey, ChangeData[] changeData) {
        if (!StringUtils.equals((String)"fixway", (String)fieldKey)) {
            return;
        }
        int entryIndex = this.getModel().getEntryCurrentRowIndex("detailent");
        String newValue = (String)changeData[0].getNewValue();
        DynamicObjectCollection detailEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("detailent");
        int fieldLength = ((DynamicObject)detailEntry.get(entryIndex)).getInt("fieldlength");
        if (StringUtils.isNotBlank((String)newValue) && fieldLength == 0) {
            this.invokeRefreshOperation("fixway");
            this.getView().setEnable(Boolean.TRUE, entryIndex, new String[]{"fixcontent"});
            this.getView().updateView("fixcontent", entryIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5b57\u6bb5\u957f\u5ea6\u3002", (String)"BankOfferTplTips_21", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        if ("3".equals(newValue) || "4".equals(newValue)) {
            this.getModel().setValue("fixcontent", null, entryIndex);
            this.getView().setEnable(Boolean.FALSE, entryIndex, new String[]{"fixcontent"});
            this.getView().updateView("fixcontent", entryIndex);
        } else {
            this.getView().setEnable(Boolean.TRUE, entryIndex, new String[]{"fixcontent"});
            this.getView().updateView("fixcontent", entryIndex);
        }
    }

    private void fixContentChange(String fieldKey, ChangeData[] changeData) {
        if (!StringUtils.equals((String)"fixcontent", (String)fieldKey)) {
            return;
        }
        int entryIndex = this.getModel().getEntryCurrentRowIndex("detailent");
        String newValue = (String)changeData[0].getNewValue();
        DynamicObjectCollection detailEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("detailent");
        int fieldLength = ((DynamicObject)detailEntry.get(entryIndex)).getInt("fieldlength");
        String fixWay = ((DynamicObject)detailEntry.get(entryIndex)).getString("fixway");
        if (null != newValue && (fieldLength == 0 || StringUtils.isBlank((String)fixWay))) {
            this.invokeRefreshOperation("fixcontent");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5b57\u6bb5\u957f\u5ea6\u548c\u5b57\u6bb5\u957f\u5ea6\u4e0d\u8db3\u8865\u9f50\u65b9\u5f0f\u3002", (String)"BankOfferTplTips_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private void headRowIsEmptyChange(String fieldKey, ChangeData[] changeData) {
        if (StringUtils.equals((String)"isempty", (String)fieldKey)) {
            Boolean newValue = (Boolean)changeData[0].getNewValue();
            int entryIndex = this.getModel().getEntryCurrentRowIndex("exceltitleent");
            if (Boolean.TRUE.equals(newValue)) {
                this.getModel().setValue("headcontent", null);
                this.getView().setEnable(Boolean.FALSE, entryIndex, new String[]{"headcontent"});
            } else {
                this.getView().setEnable(Boolean.TRUE, entryIndex, new String[]{"headcontent"});
            }
            DynamicObjectCollection excelEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("exceltitleent");
            int index = 0;
            for (DynamicObject excelDy : excelEntry) {
                boolean isEmpty = excelDy.getBoolean("isempty");
                if (isEmpty) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"headcontent"});
                }
                ++index;
            }
            this.getView().updateView("headcontententity");
            this.getView().updateView("exceltitleent");
        }
    }

    private void separateWaysChange(String fieldKey, ChangeData[] changeData) {
        if (StringUtils.equals((String)"separatedropdown", (String)fieldKey)) {
            String newValue = (String)changeData[0].getNewValue();
            if ("4".equals(newValue)) {
                this.getModel().setValue("separator", null);
                this.showFixLengthType(Boolean.TRUE);
                this.getModel().setValue("fixlength", null);
            } else if ("5".equals(newValue)) {
                FormShowParameter para = new FormShowParameter();
                para.setFormId("hsas_bankoffertplseparate");
                para.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hsas_bankoffertplseparate");
                this.getModel().setValue("fixlength", (Object)1);
                para.setCloseCallBack(closeCallBack);
                this.getView().showForm(para);
                this.showFixLengthType(Boolean.FALSE);
            } else {
                this.showFixLengthType(Boolean.FALSE);
                this.getModel().setValue("fixlength", (Object)1);
                this.getModel().setValue("separator", BankOfferHelper.getSeparateDropDownMap().get(newValue));
            }
            this.getModel().setValue("separateways", (Object)newValue);
        }
    }

    private void fileTypeChange(String fieldKey, ChangeData[] changeData) {
        if (StringUtils.equals((String)"filetype", (String)fieldKey)) {
            String newValue = (String)changeData[0].getNewValue();
            this.getModel().setValue("isshowhead", null);
            if ("1".equals(newValue)) {
                this.getModel().setValue("separator", null);
                this.getModel().setValue("fixlength", (Object)1);
                this.getModel().setValue("separatedropdown", null);
                this.getModel().setValue("separateways", null);
                this.getModel().setValue("txthead", null);
                this.hideTxtHead();
            } else {
                this.getModel().deleteEntryData("exceltitleent");
                this.showTxtHead();
            }
        }
    }

    private void limitContentChange(String fieldKey, ChangeData[] changeData) {
        if (StringUtils.equals((String)"limitcontent", (String)fieldKey)) {
            String newValue = (String)changeData[0].getNewValue();
            if ("1".equals(newValue)) {
                this.showLimitContent("limitline");
                this.hideLimitContent("limitamount");
                this.getModel().setValue("limitline", null);
            } else if ("3".equals(newValue)) {
                this.setLimitAmountTitle();
                this.showLimitContent("limitamount");
                this.hideLimitContent("limitline");
                this.getModel().setValue("limitamount", null);
            } else {
                this.hideLimitContent("limitline", "limitamount");
            }
        }
    }

    private void bankTypeChange(String fieldKey, ChangeData[] changeData) {
        if (StringUtils.equals((String)"banktype", (String)fieldKey)) {
            String newValue = (String)changeData[0].getNewValue();
            if ("1".equals(newValue)) {
                this.hideBank();
            } else {
                this.showBank();
            }
        }
    }

    private void countryTypeChange(String fieldKey, ChangeData[] changeData) {
        if (StringUtils.equals((String)"countrytype", (String)fieldKey)) {
            String newValue = (String)changeData[0].getNewValue();
            if ("1".equals(newValue)) {
                this.hideCountry();
            } else {
                this.showCountry();
            }
        }
    }

    private void currencyChange(String fieldKey) {
        if (StringUtils.equals((String)"currencyid", (String)fieldKey)) {
            this.setLimitAmountTitle();
        }
    }

    private void changeNameToField() {
        String fileName;
        Boolean isShowHead = this.getModel().getDataEntity().getBoolean("isshowhead");
        CodeEdit codeTextEditor = (CodeEdit)this.getView().getControl("codeeditap");
        String text = codeTextEditor.getText();
        if (isShowHead.booleanValue() && StringUtils.isNotBlank((String)text)) {
            this.getModel().setValue("txthead", (Object)BankOfferHelper.extractMessage((String)text, (boolean)true, (boolean)false));
        }
        if (!isShowHead.booleanValue()) {
            this.getModel().setValue("txthead", null);
            this.getModel().deleteEntryData("exceltitleent");
        }
        if (StringUtils.isNotBlank((String)(fileName = this.getModel().getDataEntity().getString("filename")))) {
            this.getModel().setValue("filename", (Object)BankOfferHelper.extractMessage((String)fileName, (boolean)true, (boolean)true));
        }
    }

    private void showCountry() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"countryid"});
    }

    private void hideCountry() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"countryid"});
        this.getModel().setValue("countryid", null);
        this.getView().updateView("countryid");
    }

    private void showBank() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"bankcgsettingid"});
    }

    private void hideBank() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bankcgsettingid"});
        this.getModel().setValue("bankcgsettingid", null);
        this.getView().updateView("bankcgsettingid");
    }

    private void showLimitContent(String key) {
        this.getView().setVisible(Boolean.TRUE, new String[]{key});
        this.getView().updateView(key);
    }

    private void hideLimitContent(String ... keys) {
        this.getView().setVisible(Boolean.FALSE, keys);
        for (String key : keys) {
            this.getModel().setValue(key, (Object)1);
            this.getView().updateView(key);
        }
    }

    private void setLimitAmountTitle() {
        String currencyName = this.getModel().getDataEntity().getString("currencyid.name");
        if (SWCStringUtils.isNotEmpty((String)currencyName)) {
            String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5355\u4e2a\u6587\u4ef6\u91d1\u989d\u4e0a\u9650\u4e3a(%s)\u3002", (String)"BankOfferTpl_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]), currencyName);
            DecimalEdit decimalEdit = (DecimalEdit)this.getView().getControl("limitamount");
            decimalEdit.setCaption(new LocaleString(title));
            this.getView().updateView("limitamount");
        }
    }

    private void showTxtHead() {
        Boolean isShowHead = this.getModel().getDataEntity().getBoolean("isshowhead");
        this.getView().setVisible(Boolean.FALSE, new String[]{"excelheadcontentap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"separator"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"separatewayap"});
        String separateWays = this.getModel().getDataEntity().getString("separateways");
        if ("5".equals(separateWays)) {
            String separate = this.getModel().getDataEntity().getString("separator");
            this.getModel().beginInit();
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("separatedropdown");
            String separateId = UUID.randomUUID().toString();
            comboEdit.setComboItems(this.getSeparateComboItem(separate, separateId));
            this.getModel().setValue("separatedropdown", (Object)separateId);
            this.getModel().endInit();
            this.getView().updateView("separatedropdown");
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("separatedropdown", (Object)separateWays);
            this.getModel().endInit();
            this.getView().updateView("separatedropdown");
        }
        if ("4".equals(separateWays)) {
            this.showFixLengthType(Boolean.TRUE);
        } else {
            this.showFixLengthType(Boolean.FALSE);
        }
        if (Boolean.FALSE.equals(isShowHead)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"textheadcontentap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"textheadcontentap"});
        }
    }

    private void hideTxtHead() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"separatewayap", "textheadcontentap"});
        Boolean isShowHead = this.getModel().getDataEntity().getBoolean("isshowhead");
        if (Boolean.TRUE.equals(isShowHead)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"excelheadcontentap"});
        }
    }

    private void showFixLengthType(Boolean isVisible) {
        this.getView().setVisible(isVisible, new String[]{"fixlength"});
    }

    private void setTxtTitle() {
        String txtContent = this.getModel().getDataEntity().getString("txthead");
        if (StringUtils.isNotBlank((String)txtContent)) {
            CodeEdit codeTextEditor = (CodeEdit)this.getView().getControl("codeeditap");
            codeTextEditor.setText(BankOfferHelper.extractMessage((String)txtContent, (boolean)false, (boolean)false));
            this.getView().updateView("codeeditap");
        }
    }

    private void setFileName() {
        String fileName = this.getModel().getDataEntity().getString("filename");
        if (StringUtils.isNotBlank((String)fileName)) {
            this.getModel().setValue("filename", (Object)BankOfferHelper.extractMessage((String)fileName, (boolean)false, (boolean)true));
            this.getView().updateView("filename");
        }
    }

    private void initFileName() {
        String fileName = this.getModel().getDataEntity().getString("filename");
        if (StringUtils.isBlank((String)fileName)) {
            this.getModel().setValue("filename", (Object)ResManager.loadKDString((String)"{\u4ed8\u6b3e\u94f6\u884c.\u94f6\u884c\u7c7b\u522b.\u540d\u79f0}\u85aa\u8d44\u62a5\u76d8\u8868{\u5bfc\u51fa\u62a5\u76d8\u65e5\u671f}", (String)"BankOfferTpl_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().updateView("filename");
            return;
        }
        this.setFileName();
    }

    private void setArgToFileName(String key) {
        String[] textValueArr = key.split("file");
        key = textValueArr[1];
        String labelArg = LEFT_SEPERATE + BankOfferHelper.getLabelValue((String)key, (boolean)true) + RIGHT_SEPERATE;
        String oldFileNameValue = this.getModel().getDataEntity().getString("filename");
        if (StringUtils.isNotEmpty((String)oldFileNameValue)) {
            oldFileNameValue = oldFileNameValue.trim() + labelArg;
            this.getModel().setValue("filename", (Object)oldFileNameValue);
        } else {
            this.getModel().setValue("filename", (Object)labelArg);
        }
        TextEdit textEdit = (TextEdit)this.getControl("filename");
        textEdit.setFocus(true);
    }

    private void setArgToHeadContent(String key) {
        String[] textValueArr = key.split("head");
        key = textValueArr[1];
        String labelArg = LEFT_SEPERATE + BankOfferHelper.getLabelValue((String)key, (boolean)false) + RIGHT_SEPERATE;
        CodeEdit codeTextEditor = (CodeEdit)this.getView().getControl("codeeditap");
        String oldHeadContentValue = codeTextEditor.getText();
        if (StringUtils.isNotEmpty((String)oldHeadContentValue)) {
            oldHeadContentValue = oldHeadContentValue + labelArg;
            codeTextEditor.setText(oldHeadContentValue);
        } else {
            String txtHead = this.getModel().getDataEntity().getString("txthead");
            if (StringUtils.isNotEmpty((String)txtHead)) {
                labelArg = BankOfferHelper.extractMessage((String)txtHead, (boolean)false, (boolean)false) + labelArg;
            }
            codeTextEditor.setText(labelArg);
        }
        this.getView().updateView("codeeditap");
    }

    private void editHeadContent() {
        int entryIndex = this.getModel().getEntryCurrentRowIndex("exceltitleent");
        DynamicObject excelTitleDy = this.getModel().getEntryRowEntity("exceltitleent", entryIndex);
        boolean isEmpty = excelTitleDy.getBoolean("isempty");
        if (isEmpty) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5934\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"BankOfferTplTips_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsas_bankofferheadcontent");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "headcontent"));
        parameter.setCustomParam("headContentRow", (Object)(entryIndex + 1));
        this.getView().showForm(parameter);
    }

    private void txtPreview() {
        CodeEdit codeTextEditor = (CodeEdit)this.getView().getControl("codeeditap");
        String txtContent = codeTextEditor.getText();
        if (StringUtils.isBlank((String)txtContent)) {
            String txtHead = this.getModel().getDataEntity().getString("txthead");
            txtContent = BankOfferHelper.extractMessage((String)txtHead, (boolean)false, (boolean)false);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsas_bankoffertxtpre");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("textcontent", (Object)txtContent);
        this.getView().showForm(parameter);
    }

    private void excelPreview() {
        String maxCol = this.getMaxCol();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsas_bankofferexcelpre");
        parameter.setCustomParam("maxCol", (Object)maxCol);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void viewDemo() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsas_bankofferviewdemo");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private String getMaxCol() {
        DynamicObjectCollection excelCollection = this.getModel().getEntryEntity("exceltitleent");
        String maxLetter = "A";
        for (DynamicObject excelDy : excelCollection) {
            DynamicObjectCollection headContentCollection = excelDy.getDynamicObjectCollection("headcontententity");
            for (DynamicObject headContentDy : headContentCollection) {
                String col = headContentDy.getString("collocation");
                if (col.length() > maxLetter.length()) {
                    maxLetter = col;
                    continue;
                }
                if (col.length() != maxLetter.length() || col.compareToIgnoreCase(maxLetter) <= 0) continue;
                maxLetter = col;
            }
        }
        maxLetter = maxLetter.toUpperCase();
        char[] arr = maxLetter.toCharArray();
        int colMax = 0;
        for (int i = 0; i < arr.length; ++i) {
            int temp = arr[i] - 65;
            colMax = colMax * 26 + temp + 1;
        }
        return String.valueOf(colMax);
    }

    private void editFieldValue() {
        int entryIndex = this.getModel().getEntryCurrentRowIndex("detailent");
        DynamicObjectCollection headContentCollection = this.getModel().getEntryEntity("detailent");
        DynamicObject detailDy = (DynamicObject)headContentCollection.get(entryIndex);
        String fieldSource = detailDy.getString("fieldsource");
        String fieldValue = detailDy.getString("fieldvalue");
        FormShowParameter parameter = new FormShowParameter();
        if ("2".equals(fieldSource)) {
            parameter.setFormId("hsas_bankofferdselectcon");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_bankofferdselectcon"));
        } else if ("1".equals(fieldSource)) {
            parameter.setFormId("hsas_bankofferdtextcon");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_bankofferdtextcon"));
        } else if ("4".equals(fieldSource)) {
            parameter.setFormId("hsas_bankofferdcustomcon");
            parameter.setCustomParam("fieldselect", (Object)detailDy.getString("fieldselect"));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_bankofferdcustomcon"));
        }
        parameter.setCustomParam("fieldvalue", (Object)fieldValue);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void setHeadContent(ClosedCallBackEvent event) {
        Map data = (Map)event.getReturnData();
        if (data == null || data.isEmpty()) {
            return;
        }
        int entryIndex = this.getModel().getEntryCurrentRowIndex("exceltitleent");
        DynamicObjectCollection headContentCollection = (DynamicObjectCollection)data.get("headcontententity");
        StringJoiner headContent = new StringJoiner("\uff0c");
        for (DynamicObject headContentDy : headContentCollection) {
            headContent.add(headContentDy.getString("subheadcontent"));
        }
        IDataModel model = this.getModel();
        model.beginInit();
        this.getModel().setValue("headcontent", (Object)headContent.toString());
        IDataModel entryOperate = model;
        entryOperate.setEntryCurrentRowIndex("exceltitleent", entryIndex);
        entryOperate.deleteEntryData("headcontententity");
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)model;
        TableValueSetter headContentSetter = BankOfferHelper.createHeadContentTableSetter();
        for (DynamicObject headContentDy : headContentCollection) {
            headContentSetter.addRow(new Object[]{headContentDy.getString("headtype"), headContentDy.getString("subheadcontent"), headContentDy.getString("selectfield"), headContentDy.getString("fieldshowtype"), headContentDy.getString("alignment"), headContentDy.getString("collocation")});
        }
        abstractFormDataModel.batchCreateNewEntryRow("headcontententity", headContentSetter);
        model.endInit();
        this.getView().updateView("exceltitleent");
        this.getView().updateView("headcontententity");
    }

    private void setSelectBySelectField(ClosedCallBackEvent event) {
        Map fieldMap = (Map)event.getReturnData();
        if (fieldMap == null || fieldMap.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        this.getModel().setValue("fieldselect", fieldMap.get("fieldselect"));
        model.endInit();
        this.getModel().setValue("fieldquerytable", fieldMap.get("fieldquerytable"));
        this.getModel().setValue("fieldvalue", fieldMap.get("fieldvalue"));
        this.getView().updateView("detailent");
    }

    private void setSeparateToText(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (returnData != null && ((Boolean)returnData.get("isOk")).booleanValue()) {
            String separate = (String)returnData.get("separate");
            this.getModel().beginInit();
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("separatedropdown");
            String separateId = UUID.randomUUID().toString();
            comboEdit.setComboItems(this.getSeparateComboItem(separate, separateId));
            this.getModel().setValue("separatedropdown", (Object)separateId);
            this.getModel().setValue("separator", (Object)separate);
            this.getModel().endInit();
            this.getView().updateView("separatedropdown");
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("separatedropdown", null);
            this.getModel().endInit();
            this.getView().updateView("separatedropdown");
        }
    }

    private List<ComboItem> getSeparateComboItem(String separate, String separateId) {
        ArrayList comboItemValues = Lists.newArrayList((Object[])new String[]{"|", ",", ";", ResManager.loadKDString((String)"Tab(\u5236\u8868\u7b26)", (String)"BankOfferTpl_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7a7a\u683c", (String)"BankOfferTpl_20", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"BankOfferTpl_21", (String)"swc-hsas-formplugin", (Object[])new Object[0])});
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(7);
        for (int index = 0; index < comboItemValues.size(); ++index) {
            comboItems.add(this.getComboItem((String)comboItemValues.get(index), String.valueOf(index), true));
        }
        comboItems.add(this.getComboItem(separate, separateId, false));
        return comboItems;
    }

    private ComboItem getComboItem(String caption, String value, boolean isVisible) {
        ComboItem comboItem = new ComboItem(new LocaleString(caption), value);
        comboItem.setItemVisible(isVisible);
        return comboItem;
    }

    private void setSelectByInputText(ClosedCallBackEvent event) {
        String fieldValue = (String)event.getReturnData();
        if (null == fieldValue) {
            return;
        }
        this.getModel().setValue("fieldvalue", (Object)fieldValue);
        this.getView().updateView("detailent");
    }

    private void setSelectByCustom(ClosedCallBackEvent event) {
        Map map = (Map)event.getReturnData();
        if (null == map) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        this.getModel().setValue("fieldselect", map.get("id"));
        model.endInit();
        this.getModel().setValue("fieldvalue", map.get("name"));
        this.getView().updateView("detailent");
    }

    private void updateSeq(String key) {
        if (StringUtils.equals((String)"newentry", (String)key) || StringUtils.equals((String)"deleteentry", (String)key) || StringUtils.equals((String)"moveexceltitleentryup", (String)key) || StringUtils.equals((String)"moveexceltitleentrydown", (String)key)) {
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("exceltitleent");
            for (DynamicObject dynamicObject : entryEntity) {
                int seq = dynamicObject.getInt("seq");
                dynamicObject.set("headrow", (Object)seq);
            }
            entryEntity.size();
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getView().updateView("headrow", i);
            }
        }
    }

    private void setIsShowThousandthEnable() {
        DynamicObjectCollection detailEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("detailent");
        int index = 0;
        for (DynamicObject detailDy : detailEntry) {
            String filedValue = detailDy.getString("fieldvalue");
            String filedAmount = (String)BankOfferHelper.getAmountTypeMap().get(filedValue);
            if (StringUtils.isEmpty((String)filedAmount)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"isshowthousandth"});
            }
            ++index;
        }
        this.getView().updateView("detailent");
    }

    private void confirmChangeBeforeDo(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        boolean isRight = this.validateBeforeSave(args);
        if (!isRight) {
            args.setCancel(true);
        } else {
            this.changeNameToField();
        }
    }

    protected void invokeRefreshOperation(String opKey) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ispropertyrefresh", "true");
        operateOption.setVariableValue("refreshfield", opKey);
        this.getView().invokeOperation("refresh", operateOption);
    }

    private void refreshValue(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        boolean isPropertyRefresh = Boolean.parseBoolean(formOperate.getOption().getVariableValue("ispropertyrefresh", String.valueOf(false)));
        if (isPropertyRefresh) {
            args.setCancel(true);
            int entryIndex = this.getModel().getEntryCurrentRowIndex("detailent");
            DynamicObject detailEntry = (DynamicObject)this.getModel().getEntryEntity("detailent").get(entryIndex);
            String refreshField = formOperate.getOption().getVariableValue("refreshfield");
            detailEntry.set(refreshField, null);
            if ("fixway".equals(refreshField)) {
                this.getView().getPageCache().put("isFixWayRefresh", "true");
            }
            this.getView().updateView(refreshField, entryIndex);
        }
    }
}

