/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.accountconfig;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hsas.business.approve.ApproveSettingHelper;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.common.constants.PaySalaryAccountConstants;
import kd.swc.hsas.common.dto.PaySalAccountConfigDTO;
import kd.swc.hsas.formplugin.web.basedata.accountconfig.PaySalaryAccountConfigBasePlugin;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.GeneralFilterCompareService;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayAccountUseConfigPlugin
extends PaySalaryAccountConfigBasePlugin
implements BeforeFilterF7SelectListener {
    private Log log = LogFactory.getLog(PayAccountUseConfigPlugin.class);
    private static final String BASE_DATA = "data";
    private static final String ALL = "0";
    private static final String TARGET = "1";
    private static final String PAY_BY_CARD = "1";
    private static final String PAY_BY_CASH = "2";
    private static final String ACCOUNT_CURRENCY = "2";
    private static final String BAR_STAFF_DELETE = "bar_staff_delete";
    private static final String CALL_BACK_CHECK_DATA = "call_back_check_data";
    private static final String CONFIRM_SAVE = "confirm_save";
    private static Set<String> compareTypes = new HashSet<String>(Arrays.asList(CompareTypeEnum.IN.getId(), CompareTypeEnum.NOTIN.getId()));
    private static Set<String> compareCommonTypes = new HashSet<String>(Arrays.asList(CompareTypeEnum.NOTIN.getId(), CompareTypeEnum.ISNOTNULL.getId(), CompareTypeEnum.NOTEQUAL.getId(), CompareTypeEnum.NOTLIKE.getId(), CompareTypeEnum.GREATER.getId(), CompareTypeEnum.LESS.getId(), CompareTypeEnum.BETWEEN.getId(), CompareTypeEnum.LIKE.getId(), CompareTypeEnum.LEFTLIKE.getId(), CompareTypeEnum.RIGHTLIKE.getId(), CompareTypeEnum.ISNULL.getId(), CompareTypeEnum.GREATEROREQUAL.getId(), CompareTypeEnum.LESSOREQUAL.getId(), CompareTypeEnum.EQUAL.getId(), CompareTypeEnum.IN.getId()));

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        FilterGrid filterGrid = (FilterGrid)this.getControl("specialfilter");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.initFilterCondition();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnback"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formParam = this.getView().getFormShowParameter();
        this.getModel().setValue("country", formParam.getCustomParam("countryId"));
        this.getModel().setValue("useorg", formParam.getCustomParam("useOrgId"));
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("specialfilter");
        List filterColumns = filterGrid.getFilterColumns();
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hsas_payaccountpersonquery");
        List selectFields = queryEntityType.getSelectFields();
        List sortList = selectFields.stream().map(QuerySelectField::getAlias).collect(Collectors.toList());
        int size = filterColumns.size();
        Map[] sortFilterColumns = new Map[size];
        Map filedNameLangMap = ApproveSettingHelper.getPaySalaryAccountSpRuleMap();
        for (Map column : filterColumns) {
            String fieldName = (String)column.get("fieldName");
            String name = (String)filedNameLangMap.get(fieldName);
            if (name == null) continue;
            column.put("fieldCaption", name);
            int index = sortList.indexOf(fieldName);
            sortFilterColumns[index] = column;
            if ("basedata".equals(column.get("type"))) {
                column.put("compareTypes", ((List)column.get("compareTypes")).stream().filter(obj -> compareTypes.contains(obj.getId())).collect(Collectors.toList()));
                continue;
            }
            column.put("compareTypes", ((List)column.get("compareTypes")).stream().filter(obj -> compareCommonTypes.contains(obj.getId())).collect(Collectors.toList()));
        }
        filterGrid.setFilterColumns(Arrays.asList(sortFilterColumns));
        if (((Boolean)formParam.getCustomParam("isModify")).booleanValue()) {
            this.setSpecialRuleToForm(filterGrid, (Integer)formParam.getCustomParam("seq"));
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView("specialfilter");
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        String fieldName = event.getFieldName();
        Long countryId = this.getModel().getDataEntity().getLong("country.id");
        Long useOrgId = this.getModel().getDataEntity().getLong("useorg.id");
        if ("payrollgroup.name".equals(fieldName)) {
            QFilter filter = new QFilter("country.id", "=", (Object)countryId);
            filter.and(new QFilter("org", "=", (Object)useOrgId));
            event.addCustomQFilter(filter);
            return;
        }
        if ("empgroup.name".equals(fieldName)) {
            QFilter filter = new QFilter("bussinessfield.id", "=", (Object)107010L);
            event.addCustomQFilter(filter);
            return;
        }
        if ("laborrelrecord.lawentity.name".equals(fieldName)) {
            QFilter filter = new QFilter("country.id", "=", (Object)countryId);
            filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"hbss_lawentity", (Long)useOrgId));
            event.addCustomQFilter(filter);
            return;
        }
        if ("hsas_empentrel.enterprise.name".equals(fieldName)) {
            QFilter filter = new QFilter("country.id", "=", (Object)countryId);
            filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"hbss_lawentity", (Long)useOrgId));
            event.addCustomQFilter(filter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String operateKey;
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                if (!SWCStringUtils.isEmpty((String)operate.getOption().getVariableValue("ignoreCheck", null))) break;
                this.checkData(beforeDoOperationEventArgs, operateKey);
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "save": {
                this.getPageCache().put("isClose", "1");
                OperationResult operationResult = args.getOperationResult();
                if (!operationResult.isSuccess()) break;
                FormShowParameter formParam = this.getView().getFormShowParameter();
                int seq = (Integer)formParam.getCustomParam("seq");
                HashMap returnData = Maps.newHashMapWithExpectedSize((int)3);
                returnData.put("isOk", Boolean.TRUE);
                returnData.put("seq", seq);
                this.dealPaySalAccountConfigDTO(seq);
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "call_back_check_data": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operation = OperateOption.create();
                operation.setVariableValue("ignoreCheck", "1");
                this.getView().invokeOperation(this.getView().getPageCache().get("operateKey"), operation);
                break;
            }
            case "confirm_save": {
                MessageBoxResult result = messageBoxClosedEvent.getResult();
                if (!result.equals((Object)MessageBoxResult.Yes)) break;
                this.getView().getPageCache().put("isClose", "1");
                this.getView().close();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String isClose = this.getView().getPageCache().get("isClose");
        if (!SWCStringUtils.equals((String)"1", (String)isClose) && !OperationStatus.VIEW.equals((Object)status)) {
            String msg = ResManager.loadKDString((String)"\u82e5\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PayAccountUseConfigPlugin_23", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"PayAccountUseConfigPlugin_21", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"PayAccountUseConfigPlugin_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CONFIRM_SAVE);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, listener, btnNameMaps);
            e.setCancel(true);
        }
    }

    private void setSpecialRuleToForm(FilterGrid filterGrid, int seq) {
        IFormView parentView = this.getView().getParentView();
        SWCPageCache cache = new SWCPageCache(parentView);
        List specialRuleList = (List)cache.get("specialRuleList", ArrayList.class);
        try {
            PaySalAccountConfigDTO dto = (PaySalAccountConfigDTO)SWCJSONUtils.cast((String)((String)specialRuleList.get(seq)), PaySalAccountConfigDTO.class);
            PaySalarySettingHelper.setSpecialRuleDataToPage((PaySalAccountConfigDTO)dto, (IFormView)this.getView());
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)dto.getPayRuleDetailDTO().getRuleContent(), FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        catch (IOException e) {
            this.log.info("JSON error");
        }
    }

    private void dealPaySalAccountConfigDTO(int seq) {
        IFormView parentView = this.getView().getParentView();
        SWCPageCache cache = new SWCPageCache(parentView);
        String filterGridData = this.getFilterGridDataString();
        PaySalAccountConfigDTO specialRuleData = PaySalarySettingHelper.getSpecialRuleDataFormPage((DynamicObjectCollection)this.getModel().getEntryEntity("opentryentity"), (String)filterGridData);
        List specialRuleList = (List)cache.get("specialRuleList", ArrayList.class);
        String specialRuleDataString = null;
        try {
            specialRuleDataString = SWCJSONUtils.toString((Object)specialRuleData);
        }
        catch (IOException e) {
            this.log.info("JSON error");
        }
        if (specialRuleList.size() > seq) {
            specialRuleList.set(seq, specialRuleDataString);
        } else {
            specialRuleList.add(specialRuleDataString);
        }
        cache.put("specialRuleList", (Object)specialRuleList);
    }

    private FilterCondition getFilterGridData() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("specialfilter");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        return filterGridState.getFilterCondition();
    }

    private String getFilterGridDataString() {
        FilterCondition condition = this.getFilterGridData();
        List relFilters = condition.getFilterRow();
        String data = "";
        if (relFilters != null && relFilters.size() > 0) {
            data = SerializationUtils.toJsonString((Object)condition);
        }
        return data;
    }

    private void checkData(BeforeDoOperationEventArgs args, String operateKey) {
        String filterGridData = this.getFilterGridDataString();
        if (SWCStringUtils.isEmpty((String)filterGridData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5458\u5de5\u8303\u56f4\u3002", (String)"PayAccountUseConfigPlugin_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        GeneralFilterCompareService service = new GeneralFilterCompareService();
        if (!service.isCompleteness(this.getFilterGridData().getFilterRow())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5458\u5de5\u8303\u56f4\u7684\u6761\u4ef6\u8bbe\u7f6e\u62ec\u53f7\u4e0d\u5b8c\u6574\uff0c\u5c06\u5bfc\u81f4\u53c2\u6570\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PayAccountUseConfigPlugin_24", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("opentryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        boolean isAllTarget = entryEntity.stream().noneMatch(obj -> PaySalaryAccountConstants.NOTTARGET.contains(obj.getString("opsalaryitem")));
        if (isAllTarget) {
            String msg = ResManager.loadKDString((String)"\u89c4\u5219\u8bbe\u7f6e\u4e2d\u672a\u5bf9\u201c\u5176\u4ed6\u201d\u5b9e\u53d1\u9879\u76ee\u8fdb\u884c\u8bbe\u7f6e\uff0c\u8bf7\u786e\u8ba4\u8be5\u5458\u5de5\u6240\u6709\u5b9e\u53d1\u9879\u90fd\u5df2\u8bbe\u7f6e\u3002\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"PayAccountUseConfigPlugin_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PaySalaryAccountConfigPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"PaySalaryAccountConfigPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CALL_BACK_CHECK_DATA);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, listener, btnNameMaps);
            args.setCancel(true);
            this.getView().getPageCache().put("operateKey", operateKey);
        }
    }

    private void initFilterCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("specialfilter");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        filterCondition.getFilterRow().clear();
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hsas_payaccountpersonquery");
        List selectFields = queryEntityType.getSelectFields();
        ArrayList<String> fieldIds = new ArrayList<String>(selectFields.size());
        for (QuerySelectField querySelectField : selectFields) {
            fieldIds.add(querySelectField.getAlias());
        }
        filterGrid.setFilterFieldKeys(fieldIds);
        filterGrid.setEntityNumber("hsas_payaccountpersonquery");
        this.getView().updateView("specialfilter");
    }
}

