/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.calrule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.salaryfile.SalaryFileImportDataOperate;
import kd.swc.hsas.business.service.CalItemGroupServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CalRuleBatchImportPlugin
extends BatchImportPlugin {
    public static final String NUMBER = "number";
    public static final String AMOUNT = "amount";
    public static final int TOTAL_SALARY_TYPE_WRONG = 1;
    public static final int NET_SALARY_TYPE_WRONG = 16;
    public static final int ALL_SALARY_TYPE_WRONG = 17;

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        JSONObject data;
        Iterator<ImportBillData> it = rowdatas.iterator();
        ArrayList salaryItemNumberList = new ArrayList(10);
        ArrayList<String> calruleNumberList = new ArrayList<String>(10);
        for (ImportBillData importBillData : rowdatas) {
            data = importBillData.getData();
            String calNumber = (String)data.get((Object)NUMBER);
            calruleNumberList.add(calNumber);
            JSONArray jsonArray = data.getJSONArray("calruleitementry");
            jsonArray.forEach(param -> {
                JSONObject json = (JSONObject)param;
                JSONObject salaryItemJson = json.getJSONObject("salaryitem");
                if (salaryItemJson == null) {
                    return;
                }
                String number = salaryItemJson.getString(NUMBER);
                if (number != null) {
                    salaryItemNumberList.add(number);
                }
            });
        }
        Map<String, String> salaryItemMap = new HashMap<String, String>(rowdatas.size());
        if (salaryItemNumberList.size() > 0) {
            QFilter fIdFilter = new QFilter(NUMBER, "in", salaryItemNumberList);
            fIdFilter.and(new QFilter("enable", "=", (Object)"1"));
            fIdFilter.and(new QFilter("status", "=", (Object)"C"));
            DynamicObject[] dataByFids = CalItemGroupServiceHelper.getDataByFids((QFilter[])new QFilter[]{fIdFilter});
            salaryItemMap = Arrays.stream(dataByFids).collect(Collectors.toMap(key -> key.getString(NUMBER), value -> value.getString("taxtag"), (v1, v2) -> v1));
        }
        HashMap<String, String> dataMap = this.querypayRollScenes(calruleNumberList);
        while (it.hasNext()) {
            data = it.next();
            if (this.validSalary((ImportBillData)data, logger, salaryItemMap, dataMap)) continue;
            it.remove();
        }
        return super.save(rowdatas, logger);
    }

    private boolean validSalary(ImportBillData billData, ImportLogger logger, Map<String, String> salaryItemMap, Map<String, String> dataMap) {
        JSONObject data = billData.getData();
        boolean ischangedCalRul = true;
        if (MapUtils.isNotEmpty((Map)data)) {
            Map totalSalary = (Map)data.get("totalsalary");
            Map netSalary = (Map)data.get("netsalary");
            String totalSalaryNumber = "";
            String netSalaryNumber = "";
            if (MapUtils.isNotEmpty((Map)totalSalary)) {
                totalSalaryNumber = (String)totalSalary.get(NUMBER);
            }
            if (MapUtils.isNotEmpty((Map)netSalary)) {
                netSalaryNumber = (String)netSalary.get(NUMBER);
            }
            boolean isValidAmountType = this.checkValidAmountType(billData, logger, totalSalaryNumber, netSalaryNumber);
            boolean isValidItemEntry = this.checkValidCalRuleItemEntry(billData, logger, salaryItemMap);
            boolean isAllowResultCover = this.isAllowResultCover((Map<String, Object>)data, logger);
            String calNumber = (String)data.get(NUMBER);
            if (SWCStringUtils.isNotEmpty((String)dataMap.get(calNumber))) {
                ischangedCalRul = this.ischangedCalRul(billData, (Map<String, Object>)data, logger, dataMap);
            }
            return isValidAmountType && isValidItemEntry && isAllowResultCover && ischangedCalRul;
        }
        return true;
    }

    private boolean ischangedCalRul(ImportBillData billData, Map<String, Object> data, ImportLogger logger, Map<String, String> dataMap) {
        boolean ischangedCalRul = true;
        String errorRowMsg = "";
        boolean flag = false;
        String number = (String)data.get(NUMBER);
        String afterCalType = (String)data.get("aftercaltype");
        if (!SWCStringUtils.equals((String)afterCalType, (String)dataMap.get(number))) {
            errorRowMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u5df2\u88ab\u85aa\u8d44\u6838\u7b97\u573a\u666f\u5f15\u7528\uff0c\u201c\u6838\u7b97\u540e\u5904\u7406\u7c7b\u578b\u201d\u8bf7\u4e0e\u53d8\u66f4\u524d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"CalRuleBatchImportPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            flag = true;
            ischangedCalRul = false;
        }
        if (flag) {
            SalaryFileImportDataOperate.log((int)billData.getStartIndex(), (String)errorRowMsg, (ImportLogger)logger);
        }
        return ischangedCalRul;
    }

    private HashMap<String, String> querypayRollScenes(List<String> calruleNumberList) {
        DynamicObject[] query;
        DynamicObject[] queryCal;
        HashMap<String, String> dataMap = new HashMap<String, String>(10);
        HashSet<Long> pkList = new HashSet<Long>(10);
        SWCDataServiceHelper helperCal = new SWCDataServiceHelper("hsas_calrule");
        String selectCalProperties = "boid,name,number,aftercaltype";
        QFilter pkFilterCal = new QFilter(NUMBER, "in", calruleNumberList);
        QFilter statusFilterCal = new QFilter("status", "=", (Object)"C");
        statusFilterCal.and(pkFilterCal);
        QFilter[] filtersCal = new QFilter[]{statusFilterCal};
        for (DynamicObject dynamicObject : queryCal = helperCal.query(selectCalProperties, filtersCal)) {
            pkList.add(dynamicObject.getLong("boid"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        String selectProperties = "name,number,aftercaltype,status,datastatus,calrule.number";
        QFilter pkFilter = new QFilter("calrule.id", "in", pkList);
        QFilter[] filters = new QFilter[]{pkFilter};
        for (DynamicObject dynamicObject : query = helper.query(selectProperties, filters)) {
            if (dynamicObject.getString("datastatus").equals("-2") && dynamicObject.getString("status").equals("C")) continue;
            dataMap.put(dynamicObject.getString("calrule.number"), dynamicObject.getString("aftercaltype"));
        }
        return dataMap;
    }

    private boolean isAllowResultCover(Map<String, Object> data, ImportLogger logger) {
        boolean isAllowResultCover = true;
        String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u85aa\u916c\u9879\u76ee\u201c{1}\u201d\u7684\u6570\u636e\u6765\u6e90\u662f\u7ed3\u679c\u8986\u76d6\uff0c\u5fc5\u987b\u5141\u8bb8\u7ed3\u679c\u8986\u76d6\u3002", (String)"CalRuleBatchImportPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        List calRuleItemEntryList = (List)data.get("calruleitementry");
        String billNumber = (String)data.get(NUMBER);
        for (int i = 0; i < calRuleItemEntryList.size(); ++i) {
            Map itemMap = (Map)calRuleItemEntryList.get(i);
            String dataSource = (String)itemMap.get("datasource");
            String allowResultCover = (String)itemMap.get("allowresultcover");
            int rowIndex = (Integer)itemMap.get("rowNum");
            Map salaryItem = (Map)itemMap.get("salaryitem");
            String itemNumber = (String)salaryItem.get(NUMBER);
            if (!"4".equals(dataSource) || "1".equals(allowResultCover)) continue;
            isAllowResultCover = false;
            logger.log(Integer.valueOf(rowIndex), MessageFormat.format(errorMsg, billNumber, itemNumber));
        }
        if (!isAllowResultCover) {
            logger.fail();
        }
        return isAllowResultCover;
    }

    private boolean checkValidCalRuleItemEntry(ImportBillData billData, ImportLogger logger, Map<String, String> salaryItemMap) {
        boolean isValidSalary = true;
        JSONObject data = billData.getData();
        String openTaxCal = data.getString("opentaxcal");
        List calRuleItemEntryList = (List)data.get((Object)"calruleitementry");
        if (CollectionUtils.isNotEmpty((Collection)calRuleItemEntryList)) {
            int startIndex = billData.getStartIndex();
            for (Map calRulItem : calRuleItemEntryList) {
                String errorRowMsg = "";
                boolean flag = false;
                Map salaryItem = (Map)calRulItem.get("salaryitem");
                String itemNumber = (String)salaryItem.get(NUMBER);
                String dataSource = (String)calRulItem.get("datasource");
                if (openTaxCal != null && SWCStringUtils.equals((String)openTaxCal, (String)"1")) {
                    String taxTag = salaryItemMap.get(itemNumber);
                    if (SWCStringUtils.equals((String)"2", (String)taxTag) && !SWCStringUtils.equals((String)"6", (String)dataSource)) {
                        errorRowMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u5f00\u5173\u5f00\u542f\u540e\uff0c\u5f53\u85aa\u916c\u9879\u76ee\u7684\u201c\u4e2a\u7a0e\u6807\u7b7e\u201d\u4e3a\u201c\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u201d\u65f6\uff0c\u201c\u6570\u636e\u6765\u6e90\u201d\u9700\u8981\u4e3a\u201c\u4e2a\u7a0e\u4e91\u670d\u52a1\u201d\u4e14\u4e0d\u80fd\u4fee\u6539\u503c\u3002", (String)"CalRuleBatchImportPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                        flag = true;
                        isValidSalary = false;
                    }
                    if (!SWCStringUtils.equals((String)"2", (String)taxTag) && SWCStringUtils.equals((String)"6", (String)dataSource)) {
                        errorRowMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u5f00\u5173\u5f00\u542f\u540e\uff0c\u5f53\u85aa\u916c\u9879\u76ee\u7684\u201c\u4e2a\u7a0e\u6807\u7b7e\u201d\u4e3a\u201c\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u201d\u65f6\uff0c\u624d\u80fd\u9009\u62e9\u201c\u6570\u636e\u6765\u6e90\u201d\u7b49\u4e8e\u201c\u4e2a\u7a0e\u4e91\u670d\u52a1\u201d\u3002", (String)"CalRuleBatchImportPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                        flag = true;
                        isValidSalary = false;
                    }
                } else if (SWCStringUtils.equals((String)"6", (String)dataSource)) {
                    errorRowMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u8ba1\u7b97\u5f00\u5173\u5f00\u542f\u65f6\uff0c\u5f53\u85aa\u916c\u9879\u76ee\u7684\u201c\u4e2a\u7a0e\u6807\u7b7e\u201d\u4e0d\u7b49\u4e8e\u201c\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u201d\u65f6\uff0c\u4e0d\u80fd\u9009\u62e9\u201c\u6570\u636e\u6765\u6e90\u201d\u7b49\u4e8e\u201c\u4e2a\u7a0e\u4e91\u670d\u52a1\u201d\u3002", (String)"CalRuleBatchImportPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    flag = true;
                    isValidSalary = false;
                }
                String allowResultCover = (String)calRulItem.get("allowresultcover");
                if (SWCStringUtils.equals((String)"6", (String)dataSource) && !SWCStringUtils.equals((String)"0", (String)allowResultCover)) {
                    errorRowMsg = ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u4e3a\u4e2a\u7a0e\u4e91\u670d\u52a1\u65f6\uff0c\u5141\u8bb8\u7ed3\u679c\u8986\u76d6\u53ea\u80fd\u4e3a\u5426\u3002", (String)"CalRuleBatchImportPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    flag = true;
                    isValidSalary = false;
                }
                String salaryItemNumber = (String)salaryItem.get(NUMBER);
                String taxTag = salaryItemMap.get(salaryItemNumber);
                String isPayOutItem = (String)calRulItem.get("ispayoutitem");
                if (openTaxCal != null && SWCStringUtils.equals((String)openTaxCal, (String)"1") && SWCStringUtils.equals((String)"2", (String)taxTag) && !SWCStringUtils.equals((String)"0", (String)isPayOutItem)) {
                    errorRowMsg = ResManager.loadKDString((String)"\u5f53\u85aa\u916c\u9879\u76ee\u7684\u4e2a\u7a0e\u6807\u7b7e\u4e3a\u201c\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u201d\u65f6\uff0c\u5b9e\u53d1\u9879\u76ee\u5fc5\u987b\u4e3a\u201c\u5426\u201d\u3002", (String)"CalRuleBatchImportPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    flag = true;
                    isValidSalary = false;
                }
                if (flag) {
                    SalaryFileImportDataOperate.log((int)startIndex, (String)errorRowMsg, (ImportLogger)logger);
                }
                ++startIndex;
            }
        }
        return isValidSalary;
    }

    private boolean checkValidAmountType(ImportBillData billData, ImportLogger logger, String totalSalaryNumber, String netSalaryNumber) {
        boolean isValidSalary = true;
        String number = billData.getData().getString(NUMBER);
        DynamicObject totalSalaryEntity = this.findSalary(totalSalaryNumber);
        DynamicObject netSalaryEntity = this.findSalary(netSalaryNumber);
        int totalSalaryType = 0;
        int netSalaryType = 0;
        if (Objects.nonNull(totalSalaryEntity) && !AMOUNT.equals(totalSalaryEntity.get("datatype.showtype"))) {
            totalSalaryType = 1;
        }
        if (Objects.nonNull(netSalaryEntity) && !AMOUNT.equals(netSalaryEntity.get("datatype.showtype"))) {
            netSalaryType = 16;
        }
        int allSalaryType = netSalaryType ^ totalSalaryType ^ 0x11;
        String errorMsg = "";
        if (allSalaryType == 0) {
            errorMsg = ResManager.loadKDString((String)"%s\uff1a\u201c\u603b\u85aa\u8d44\u201d\u3001\u201c\u51c0\u85aa\u8d44\u201d\u7ef4\u62a4\u7684\u85aa\u916c\u9879\u76ee\u5fc5\u987b\u4e3a\u91d1\u989d\u7c7b\u578b\u3002", (String)"CalRuleBatchImportPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            errorMsg = String.format(Locale.ROOT, errorMsg, number);
        } else if (!(totalSalaryType ^ true)) {
            errorMsg = ResManager.loadKDString((String)"%s\uff1a \u201c\u603b\u85aa\u8d44\u201d\u7ef4\u62a4\u7684\u85aa\u916c\u9879\u76ee\u5fc5\u987b\u4e3a\u91d1\u989d\u7c7b\u578b\u3002", (String)"CalRuleBatchImportPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            errorMsg = String.format(Locale.ROOT, errorMsg, number);
        } else if ((netSalaryType ^ 0x10) == 0) {
            errorMsg = ResManager.loadKDString((String)"%s\uff1a \u51c0\u85aa\u8d44\u7ef4\u62a4\u7684\u85aa\u916c\u9879\u76ee\u5fc5\u987b\u4e3a\u91d1\u989d\u7c7b\u578b\u3002", (String)"CalRuleBatchImportPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            errorMsg = String.format(Locale.ROOT, errorMsg, number);
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            SalaryFileImportDataOperate.log((int)billData.getStartIndex(), (String)errorMsg, (ImportLogger)logger);
            isValidSalary = false;
        }
        return isValidSalary;
    }

    private DynamicObject findSalary(String number) {
        ArrayList list = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)number)) {
            list.add(number);
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter qFilter = new QFilter(NUMBER, "in", (Object)list);
        return serviceHelper.queryOne("datatype.showtype", new QFilter[]{qFilter});
    }
}

