/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.calrule;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class CalRuleList
extends SWCDataBaseList {
    private static final String CALLBACKID_SUBMIT = "LIST_SORRYYOUAREAGOODMAN";
    private static final String CALLBACKID_AUDIT = "LIST_IAMFINE";
    private static final String SUBMIT_AFTERCONFIRM = "list_notfirstsubmit";
    private static final String AUDIT_AFTERCONFIRM = "list_notfirstaudit";
    private static final String AFTERCALTYPE = "aftercaltype";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "submit": {
                boolean submit_hasPayOutItem;
                RefObject subAfterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(SUBMIT_AFTERCONFIRM, subAfterConfirm) || (submit_hasPayOutItem = this.checkHasPayOutItem(CALLBACKID_SUBMIT))) break;
                args.setCancel(true);
                break;
            }
            case "audit": {
                boolean audit_hasPayOutItem;
                RefObject auditAfterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(AUDIT_AFTERCONFIRM, auditAfterConfirm) || (audit_hasPayOutItem = this.checkHasPayOutItem(CALLBACKID_AUDIT))) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private DynamicObject[] queryRules(Object[] pkList, QFilter statusFilter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        String selectProperties = "name,number,calruleitementry.ispayoutitem,aftercaltype";
        QFilter pkFilter = new QFilter("id", "in", (Object)pkList);
        if (statusFilter != null) {
            pkFilter.and(statusFilter);
        }
        QFilter[] filters = new QFilter[]{pkFilter};
        String orderBys = "calruleitementry.ispayoutitem desc";
        return helper.query(selectProperties, filters, orderBys);
    }

    private boolean checkHasPayOutItem(String confirmId) {
        String errMsg;
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(confirmId);
        MessageBoxOptions msgBoxOption = MessageBoxOptions.YesNo;
        IListView listView = (IListView)this.getView();
        Object[] pkList = listView.getSelectedRows().getPrimaryKeyValues();
        QFilter statusFilter = null;
        if (confirmId.equals(CALLBACKID_SUBMIT)) {
            statusFilter = new QFilter("status", "=", (Object)"A");
        } else if (confirmId.equals(CALLBACKID_AUDIT)) {
            statusFilter = new QFilter("status", "=", (Object)"B");
        }
        DynamicObject[] calRules = this.queryRules(pkList, statusFilter);
        ArrayList<String> errList = new ArrayList<String>();
        int totalNum = pkList.length;
        int noPayoutNum = 0;
        boolean hasPayoutItem = false;
        for (DynamicObject calRule : calRules) {
            String name = calRule.getLocaleString("name").getLocaleValue();
            String number = calRule.getString("number");
            String afterCalType = calRule.getString(AFTERCALTYPE);
            DynamicObjectCollection calruleitementry = calRule.getDynamicObjectCollection("calruleitementry");
            if (!SWCStringUtils.equals((String)afterCalType, (String)"1")) continue;
            hasPayoutItem = false;
            for (DynamicObject dynamicObject : calruleitementry) {
                String ispayoutitem = dynamicObject.getString("ispayoutitem");
                if (!SWCStringUtils.equals((String)ispayoutitem, (String)"1")) continue;
                hasPayoutItem = true;
                break;
            }
            if (hasPayoutItem) continue;
            String errRule = String.format("%s(%s)", name, number);
            errList.add(errRule);
            ++noPayoutNum;
        }
        if (noPayoutNum < 1) {
            return true;
        }
        if (noPayoutNum == 1 && noPayoutNum == totalNum) {
            errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u89c4\u5219\u65e0\u5b9e\u53d1\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u85aa\u8d44\u53d1\u653e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalRuleList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(errMsg, msgBoxOption, callBackListener);
            return false;
        }
        if (noPayoutNum > 1 && noPayoutNum == totalNum) {
            errMsg = ResManager.loadKDString((String)"\u6240\u9009\u8ba1\u7b97\u89c4\u5219\u65e0\u5b9e\u53d1\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u85aa\u8d44\u53d1\u653e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalRuleList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(errMsg, msgBoxOption, callBackListener);
            return false;
        }
        errMsg = ResManager.loadKDString((String)"\u6240\u9009\u8ba1\u7b97\u89c4\u5219\u90e8\u5206\u65e0\u5b9e\u53d1\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u85aa\u8d44\u53d1\u653e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalRuleList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String errContext = this.builContextStr(errList);
        this.getView().showConfirm(errMsg, errContext, msgBoxOption, ConfirmTypes.Default, callBackListener);
        return false;
    }

    private String builContextStr(List<String> errList) {
        String topStr = ResManager.loadKDString((String)"\u4e0d\u542b\u5b9e\u53d1\u9879\u76ee\u7684\u8ba1\u7b97\u89c4\u5219\uff1a\n", (String)"CalRuleList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(topStr);
        for (String err : errList) {
            sb.append(err);
            sb.append('\n');
        }
        return sb.toString();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "LIST_SORRYYOUAREAGOODMAN": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(SUBMIT_AFTERCONFIRM, "true");
                this.getView().invokeOperation("submit", operateOption);
                break;
            }
            case "LIST_IAMFINE": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(AUDIT_AFTERCONFIRM, "true");
                this.getView().invokeOperation("audit", operateOption);
                break;
            }
        }
    }
}

