/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcolla;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;

public class EntityObjectFieldEdit
extends AbstractFormPlugin {
    private static final String FIELD_KEY = "fieldkey";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_TYPE = "fieldtype";
    private static final String FIELD_REF = "fieldref";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject evt) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String entityObject = (String)params.get("entiytObject");
        List selectedKeys = (List)params.get("selectedKeys");
        this.initEntryRow(entityObject, selectedKeys);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (evt.getSource() instanceof Button && "btnok".equals(key = ((Button)evt.getSource()).getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRowIndexArray = entryGrid.getSelectRows();
            DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> selectedFieldKeys = new ArrayList<String>(10);
            if (null != selectRowIndexArray && selectRowIndexArray.length > 0) {
                for (int index : selectRowIndexArray) {
                    selectedFieldKeys.add(((DynamicObject)entryEntities.get(index)).getString(FIELD_KEY));
                }
            }
            this.getView().returnDataToParent(selectedFieldKeys);
            this.getView().close();
        }
    }

    private void initEntryRow(String entityObject, List<String> selectedKeys) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.setEntry(entityObject, selectedKeys, setter);
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setEntry(String entityObject, List<String> selectedKeys, TableValueSetter setter) {
        MainEntityType personEntityType = EntityMetadataCache.getDataEntityType((String)entityObject);
        Map fieldMap = personEntityType.getAllFields();
        boolean selectedKeysNotEmpty = CollectionUtils.isNotEmpty(selectedKeys);
        int i = 0;
        for (Map.Entry entry : fieldMap.entrySet()) {
            IDataEntityProperty prop = (IDataEntityProperty)entry.getValue();
            if (selectedKeysNotEmpty && selectedKeys.contains(entry.getKey())) continue;
            setter.set("id", entry.getKey(), i);
            setter.set(FIELD_KEY, entry.getKey(), i);
            setter.set(FIELD_NAME, (Object)prop.getDisplayName().toString(), i);
            setter.set(FIELD_TYPE, (Object)prop.getPropertyType().getName(), i);
            if (prop instanceof BasedataProp) {
                setter.set(FIELD_REF, (Object)((BasedataProp)prop).getBaseEntityId(), i);
            }
            ++i;
        }
    }
}

