/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcolla;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.swc.hsas.business.cloudcolla.HSASCloudCollaHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class PayRollActEdit
extends AbstractFormPlugin
implements IBillPlugin,
BeforeF7SelectListener {
    private static final String BIZAPP = "bizapp";
    private static final String PREPAYROLLACT = "prepayrollact";
    private static final String TRIGGER_COLLA = "triggercolla";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizApp = (BasedataEdit)this.getControl(BIZAPP);
        bizApp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prePayRollAct = (BasedataEdit)this.getControl(PREPAYROLLACT);
        prePayRollAct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit triggerColla = (BasedataEdit)this.getControl(TRIGGER_COLLA);
        triggerColla.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject e) {
        String parentEntityId;
        HSASCloudCollaHelper.getInstance().initEntryIsSysPreset(this.getView(), TRIGGER_COLLA, "istriggercollasyspreset");
        this.getModel().setDataChanged(false);
        switch (parentEntityId = this.getView().getParentView().getEntityId()) {
            case "hsas_payrollactgtpl": {
                IFormView view = this.getView();
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify"});
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        HSASCloudCollaHelper.getInstance().initEntryIsSysPreset(this.getView(), TRIGGER_COLLA, "istriggercollasyspreset");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "triggercolla": {
                ChangeData changeData = e.getChangeSet()[0];
                HSASCloudCollaHelper.getInstance().setEntryIsSysPreset(changeData, this.getView(), "istriggercollasyspreset");
                break;
            }
            case "bizapp": {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                this.getModel().getDataEntity().set(PREPAYROLLACT, null);
                this.getModel().deleteEntryData("entryentity");
                model.endInit();
                this.getView().updateView(PREPAYROLLACT);
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentry": {
                DynamicObject bizapp = this.getModel().getDataEntity().getDynamicObject(BIZAPP);
                if (null != bizapp) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u534f\u4f5c\u5e94\u7528\u201d\u3002", (String)"TriggerCollaEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "save": {
                DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
                List validEntryEntities = dynamicObjects.stream().filter(entry -> !SWCObjectUtils.isEmpty((Object)entry.getDynamicObject(TRIGGER_COLLA))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(validEntryEntities)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u534f\u4f5c\u64cd\u4f5c\u4fe1\u606f\u201d\u3002", (String)"PayRollActEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        switch (fieldKey) {
            case "bizapp": {
                List cloudIdList = HSASCloudCollaHelper.getDefaultCloudIds();
                listShowParameter.setCustomParam("bizcloudids", (Object)cloudIdList);
                listShowParameter.setCustomParam("focusCloudId", (Object)"/U+QDTL900//");
                QFilter filter = new QFilter("bizcloud", "in", (Object)cloudIdList);
                listShowParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "prepayrollact": {
                Long pkId;
                DynamicObject bizApp = this.getModel().getDataEntity().getDynamicObject(BIZAPP);
                if (null != bizApp) {
                    QFilter filter1 = new QFilter("bizapp.id", "=", bizApp.get("id"));
                    listShowParameter.getListFilterParameter().getQFilters().add(filter1);
                }
                if (null == (pkId = Long.valueOf(this.getModel().getDataEntity().getLong("id"))) || 0L == pkId) break;
                QFilter filter2 = new QFilter("id", "!=", (Object)pkId);
                listShowParameter.getListFilterParameter().getQFilters().add(filter2);
                break;
            }
            case "triggercolla": {
                List selectedIds;
                DynamicObject bizAppDy = this.getModel().getDataEntity().getDynamicObject(BIZAPP);
                if (null == bizAppDy) break;
                QFilter filter3 = new QFilter("bizapp.id", "=", bizAppDy.get("id"));
                listShowParameter.getListFilterParameter().getQFilters().add(filter3);
                DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
                if (!CollectionUtils.isNotEmpty((Collection)entryEntities) || !CollectionUtils.isNotEmpty(selectedIds = entryEntities.stream().filter(entry -> null != entry.get("triggercolla.id") && 0L != entry.getLong("triggercolla.id")).map(entry -> entry.get("triggercolla.id")).collect(Collectors.toList()))) break;
                QFilter filter4 = new QFilter("id", "not in", selectedIds);
                listShowParameter.getListFilterParameter().getQFilters().add(filter4);
                break;
            }
        }
    }
}

