/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcolla;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.ext.hr.ruleengine.controls.DefaultResult;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.infos.ResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hsas.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hsas.common.constants.PayRollActGrpConstants;
import kd.swc.hsas.common.dto.HRPolicyDTO;
import kd.swc.hsas.common.dto.HRRuleDTO;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class PayRollActPolicyEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
PayRollActGrpConstants {
    private static final Log LOGGER = LogFactory.getLog(PayRollActPolicyEdit.class);
    private static final String RULE_DESIGN_MODEL_HIGHT = "700";
    private static final String RULE_DESIGN_MODEL_WIDTH = "1200";
    public static final String CTRL_STRATEGY_PRIVATE = "7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"ruletoolbar"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryrulelist");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "baraddrule": {
                this.showRuleDesignPage(null);
                break;
            }
            case "btndeleterule": {
                this.deleteRuleEntry();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "retrundefault": {
                boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
                this.updateReturnDefaultValue(newValue);
                break;
            }
            case "ruledate": {
                Object newDate = e.getChangeSet()[0].getNewValue();
                if (!(newDate instanceof Date)) break;
                DefaultResult control = this.getDefaultResultControl();
                this.updateRuleDate((Date)newDate, new RuleControl[]{control});
                this.getModel().setValue("ruledate", null);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int row = evt.getRowIndex();
        if (HRStringUtils.equals((String)fieldName, (String)"rulenumber")) {
            this.showRuleDesignPage(row);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONObject customParams = (JSONObject)formShowParameter.getCustomParams();
        String policyObjectStr = customParams.getString("hrPolicy");
        this.initRuleEntryVisible();
        if (!SWCStringUtils.isEmpty((String)policyObjectStr)) {
            try {
                HRPolicyDTO policyObject = (HRPolicyDTO)SWCJSONUtils.cast((String)policyObjectStr, HRPolicyDTO.class);
                this.initPageLayout(policyObject);
                this.initPageValue(policyObject);
                return;
            }
            catch (IOException ex) {
                LOGGER.error("\u521d\u59cb\u5316\u9875\u9762\u51fa\u9519", (Throwable)ex);
                throw PayRollActGrpHelper.getDefaultException((Exception)ex);
            }
        }
        this.initPageLayout(null);
        this.initPageValue(null);
    }

    private void initRuleEntryVisible() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Boolean isSetRule = customParams.getOrDefault("isShowRuleList", Boolean.TRUE);
        this.getView().setVisible(isSetRule, new String[]{"flexpanelap2"});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("CALLBACK_ADD_RULE".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof HRRuleDTO && !StringUtils.isEmpty((CharSequence)((HRRuleDTO)returnData).getRuleNumber())) {
            HRRuleDTO rule = (HRRuleDTO)returnData;
            Integer index = this.isRuleNumberExist(rule.getRuleNumber());
            IDataModel dataModel = this.getModel();
            if (index < 0) {
                index = dataModel.createNewEntryRow("entryrulelist");
            }
            dataModel.setValue("rulenumber", (Object)rule.getRuleNumber(), index.intValue());
            dataModel.setValue("rulename", (Object)rule.getRuleName(), index.intValue());
            dataModel.setValue("filtercondition", (Object)rule.getFilterCondition(), index.intValue());
            dataModel.setValue("filterconditionstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()), index.intValue());
            dataModel.setValue("filterresult", (Object)rule.getFilterResult(), index.intValue());
            dataModel.setValue("filterresultstr", (Object)PayRollActGrpHelper.formatRuleResultInfo((String)rule.getFilterResult()), index.intValue());
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        DefaultResult defaultResultControl;
        super.clientCallBack(e);
        String name = e.getName();
        if ("CLIENT_CALLBACK_UPDATE_F7_FILTER".equalsIgnoreCase(name) && (defaultResultControl = this.getDefaultResultControl()) != null) {
            String value = defaultResultControl.getValue();
            String filterStr = this.addFilterToResult(value);
            defaultResultControl.setValueAndUpdateControl(filterStr);
        }
    }

    private void updateRuleDate(Date date, RuleControl ... controls) {
        if (controls == null || controls.length < 1 || null == date) {
            return;
        }
        String dateFormat = this.getView().getPageCache().get("ruleDateFormat");
        String value = SWCStringUtils.isEmpty((String)dateFormat) ? SWCDateTimeUtils.formatDate((Date)date) : SWCDateTimeUtils.format((Date)date, (String)dateFormat);
        for (RuleControl ruleControl : controls) {
            ruleControl.setDate(value);
        }
    }

    private void updateReturnDefaultValue(boolean newValue) {
        if (newValue) {
            String customParam = (String)this.getView().getFormShowParameter().getCustomParam("resultParamStr");
            if (!SWCStringUtils.isEmpty((String)customParam)) {
                DefaultResult defaultResultControl = this.getDefaultResultControl();
                String filterStr = this.addFilterToResult(customParam);
                LOGGER.info("[payrollactg] set rule result control value = {}", (Object)filterStr);
                defaultResultControl.setValueAndUpdateControl(filterStr);
            }
        } else {
            this.getDefaultResultControl().setValueAndUpdateControl(null);
        }
        this.setReturnDefaultVisible(newValue);
    }

    private String addFilterToResult(String customParam) {
        if (SWCStringUtils.isEmpty((String)customParam)) {
            return customParam;
        }
        try {
            RuleResultInfo cast = (RuleResultInfo)SWCJSONUtils.cast((String)customParam, RuleResultInfo.class, (boolean)true);
            List resultList = cast.getResultList();
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                return customParam;
            }
            for (ResultInfo resultInfo : resultList) {
                List<QFilter> qFilterByResultInfo = this.getQFilterByResultInfo(resultInfo);
                if (CollectionUtils.isEmpty(qFilterByResultInfo)) continue;
                resultInfo.setFilters(SWCJSONUtils.toString(qFilterByResultInfo));
            }
            return SWCJSONUtils.toString((Object)cast);
        }
        catch (IOException e) {
            LOGGER.info("[payrollacttpl] parse json error.", (Object)e);
            return customParam;
        }
    }

    private List<QFilter> getQFilterByResultInfo(ResultInfo resultInfo) {
        String param = resultInfo.getParam();
        if (SWCStringUtils.isEmpty((String)param)) {
            return Collections.emptyList();
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgIdStr = (String)customParams.get("createOrg");
        Long orgId = Long.valueOf(orgIdStr);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return Collections.emptyList();
        }
        String formId = parentView.getFormShowParameter().getFormId();
        String ctrlStrategy = CTRL_STRATEGY_PRIVATE;
        if ("hsas_payrollactg".equalsIgnoreCase(formId)) {
            ctrlStrategy = parentView.getModel().getDataEntity().getString("ctrlstrategy");
        }
        List<QFilter> result = CTRL_STRATEGY_PRIVATE.equals(ctrlStrategy) ? this.getPrivateFilter(param, orgId) : this.getNonPrivateFilter(param, orgId);
        return result;
    }

    private List<QFilter> getPrivateFilter(String param, Long orgId) {
        LOGGER.info("[payrollactg] policy page get createOrg = {} ", (Object)orgId);
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"hsas", (String)"hsas_payrollactg");
        boolean isAllOrgPermission = permOrgs.hasAllOrgPerm();
        QFilter all = new QFilter("1", "=", (Object)1);
        switch (param.toLowerCase(Locale.ROOT)) {
            case "hsas_salaryfile.hsas_salaryfile.payrollgroup.id": {
                return Arrays.asList(new QFilter("org", "=", (Object)orgId), this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "hsas_salaryfile.hsas_salaryfile.empgroup.id": {
                return Collections.singletonList(this.getEmpGroupQfilter("hsas"));
            }
            case "hsas_salaryfile.hsas_salaryfile.salarycalcstyle.id": {
                SWCDataServiceHelper orm = new SWCDataServiceHelper("hsas_salarycalcstyle");
                DynamicObject[] dynamicObjects = orm.queryOriginalArray("id", new QFilter[]{SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_salarycalcstyle", (Long)orgId), this.getEnableQFilter(), this.getStatusQFilter()});
                if (dynamicObjects == null) {
                    return Collections.singletonList(new QFilter("1", "=", (Object)2));
                }
                return Collections.singletonList(new QFilter("id", "in", Arrays.stream(dynamicObjects).map(item -> item.getLong("id")).collect(Collectors.toList())));
            }
            case "itc_taxfile.itc_taxfile.empgroup.id": {
                return Collections.singletonList(this.getEmpGroupQfilter("itc"));
            }
            case "itc_taxfile.itc_taxfile.taxunit.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "itc_taxfile.itc_taxfile.org.id": {
                return Arrays.asList(new QFilter("fishrtax", "=", (Object)"1"), isAllOrgPermission ? all : new QFilter("id", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.empgroup.id": {
                return Collections.singletonList(this.getEmpGroupQfilter("hcsi"));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayer.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayertheory.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hsas_personchange.hsas_personchange.changereason.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), new QFilter("bussinessfield.id", "!=", (Object)107010L));
            }
        }
        return Collections.emptyList();
    }

    private QFilter getEmpGroupQfilter(String appNumber) {
        List empGroupByAppNumber = SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)appNumber);
        if (CollectionUtils.isEmpty((Collection)empGroupByAppNumber)) {
            return new QFilter("id", "in", Collections.emptyList());
        }
        return new QFilter("id", "in", (Object)empGroupByAppNumber);
    }

    private List<QFilter> getNonPrivateFilter(String param, Long orgId) {
        LOGGER.info("[payrollactg] policy page get createOrg = {} ", (Object)orgId);
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"hsas", (String)"hsas_payrollactg");
        boolean isAllOrgPermission = permOrgs.hasAllOrgPerm();
        QFilter all = new QFilter("1", "=", (Object)1);
        switch (param.toLowerCase(Locale.ROOT)) {
            case "hsas_salaryfile.hsas_salaryfile.payrollgroup.id": {
                isAllOrgPermission = permOrgs.hasAllOrgPerm();
                return Arrays.asList(isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()), this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "hsas_salaryfile.hsas_salaryfile.empgroup.id": {
                return Arrays.asList(new QFilter("bussinessfield", "=", (Object)107010L), this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "hsas_salaryfile.hsas_salaryfile.salarycalcstyle.id": {
                SWCDataServiceHelper orm = new SWCDataServiceHelper("hsas_salarycalcstyle");
                DynamicObject[] dynamicObjects = orm.queryOriginalArray("id", new QFilter[]{isAllOrgPermission ? all : SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_salarycalcstyle", (List)permOrgs.getHasPermOrgs(), (boolean)true), this.getEnableQFilter(), this.getStatusQFilter()});
                if (dynamicObjects == null) {
                    return Collections.singletonList(new QFilter("1", "=", (Object)2));
                }
                return Collections.singletonList(new QFilter("id", "in", Arrays.stream(dynamicObjects).map(item -> item.getLong("id")).collect(Collectors.toList())));
            }
            case "itc_taxfile.itc_taxfile.empgroup.id": {
                return Arrays.asList(new QFilter("bussinessfield", "=", (Object)107030L), this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "itc_taxfile.itc_taxfile.taxunit.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "itc_taxfile.itc_taxfile.org.id": {
                return Arrays.asList(new QFilter("fishrtax", "=", (Object)"1"), isAllOrgPermission ? all : new QFilter("id", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.empgroup.id": {
                return Arrays.asList(new QFilter("bussinessfield", "=", (Object)107050L), this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayer.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayertheory.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hsas_personchange.hsas_personchange.changereason.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), new QFilter("bussinessfield.id", "!=", (Object)107010L));
            }
        }
        return Collections.emptyList();
    }

    private QFilter getEnableQFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    private QFilter getStatusQFilter() {
        return new QFilter("status", "=", (Object)"C");
    }

    private void deleteRuleEntry() {
        EntryGrid control = (EntryGrid)this.getControl("entryrulelist");
        int[] selectRows = control.getSelectRows();
        this.getView().getModel().deleteEntryRows("entryrulelist", selectRows);
    }

    private void showRuleDesignPage(Integer row) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u89c4\u5219\u8bbe\u7f6e", (String)"PayRollActPolicyEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        billShowParameter.setCustomParams(this.getParaMap(row));
        billShowParameter.setFormId("hsas_ruledesignconfig");
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight(RULE_DESIGN_MODEL_HIGHT);
        inlineStyleCss.setWidth(RULE_DESIGN_MODEL_WIDTH);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        billShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_ADD_RULE"));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private Map<String, Object> getParaMap(Integer row) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sceneId", this.getSceneId());
        param.put("hrRule", this.getRule(row));
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("resultParamStr");
        param.put("resultParamStr", this.addFilterToResult(customParam));
        return param;
    }

    private HRRuleDTO getRule(Integer row) {
        HRRuleDTO hrRuleDTO = new HRRuleDTO();
        if (null != row) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryrulelist", row.intValue());
            hrRuleDTO.setRuleNumber(entryRowEntity.getString("rulenumber"));
            hrRuleDTO.setRuleName(entryRowEntity.getString("rulename"));
            hrRuleDTO.setFilterCondition(entryRowEntity.getString("filtercondition"));
            hrRuleDTO.setFilterResult(this.addFilterToResult(entryRowEntity.getString("filterresult")));
        }
        return hrRuleDTO;
    }

    private Integer isRuleNumberExist(String ruleNumber) {
        Integer result = -1;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryrulelist");
        if (StringUtils.isEmpty((CharSequence)ruleNumber) || CollectionUtils.isEmpty((Collection)entryEntity)) {
            return result;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            if (!ruleNumber.equals(dynamicObject.getString("rulenumber"))) continue;
            return i;
        }
        return result;
    }

    private void setReturnDefaultVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"flexreturndefault"});
    }

    private void initPageLayout(HRPolicyDTO policyObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"ruletips", "tipsflex"});
        if (policyObject == null) {
            this.setReturnDefaultVisible(false);
            return;
        }
        this.setReturnDefaultVisible(policyObject.getIsDefaultResult());
    }

    private void initPageValue(HRPolicyDTO policyObject) {
        if (policyObject == null) {
            this.setNewPageValue();
        } else {
            this.setUpdatePageValue(policyObject);
        }
        this.setRuleTips();
    }

    private void setRuleTips() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityObjectId = (String)customParams.get("entityobject");
        String fieldNumber = (String)customParams.get("fieldnumber");
        if (SWCStringUtils.isEmpty((String)entityObjectId) || SWCStringUtils.isEmpty((String)fieldNumber)) {
            return;
        }
        SWCDataServiceHelper orm = new SWCDataServiceHelper("hsas_payrollactgtips");
        SWCDataServiceHelper bosEntityOrm = new SWCDataServiceHelper("bos_entityobject");
        DynamicObject entityObject = bosEntityOrm.queryOne((Object)entityObjectId);
        DynamicObject tipsObject = orm.generateEmptyDynamicObject();
        tipsObject.set("entityobject", (Object)entityObject);
        tipsObject.set("fieldnumber", (Object)fieldNumber);
        List tipsResult = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptContent", (Object[])new Object[]{"hsas_payrollactgtips", "hsas_payrollactgtips", tipsObject});
        if (CollectionUtils.isEmpty((Collection)tipsResult)) {
            return;
        }
        String tips = (String)tipsResult.get(0);
        if (SWCStringUtils.isEmpty((String)tips)) {
            return;
        }
        Hint hintap = (Hint)this.getControl("ruletips");
        this.getView().setVisible(Boolean.TRUE, new String[]{"ruletips", "tipsflex"});
        hintap.setConent(tips);
    }

    private void setNewPageValue() {
        DefaultResult defaultResultControl = this.getDefaultResultControl();
        defaultResultControl.setScene(String.valueOf(this.getSceneId()));
        String newPolicyNumber = PayRollActGrpHelper.newPolicyNumber();
        this.getModel().setValue("number", (Object)newPolicyNumber);
        this.getModel().setValue("name", (Object)newPolicyNumber);
    }

    private void setUpdatePageValue(HRPolicyDTO policyObject) {
        DefaultResult defaultResultControl = this.getDefaultResultControl();
        defaultResultControl.setScene(String.valueOf(this.getSceneId()));
        defaultResultControl.setValue(this.addFilterToResult(policyObject.getResults()));
        this.getModel().setValue("name", (Object)policyObject.getName());
        this.getModel().setValue("number", (Object)policyObject.getNumber());
        this.getModel().setValue("retrundefault", (Object)policyObject.getIsDefaultResult());
        this.initEntryRuleList(policyObject);
    }

    private DefaultResult getDefaultResultControl() {
        return (DefaultResult)this.getControl("defaultresultap");
    }

    private Long getSceneId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("sceneId");
    }

    private void initEntryRuleList(HRPolicyDTO policy) {
        List entryRuleList = policy.getEntryRuleList();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        for (int i = 0; i < entryRuleList.size(); ++i) {
            HRRuleDTO rule = (HRRuleDTO)entryRuleList.get(i);
            setter.set("filtercondition", (Object)rule.getFilterCondition(), i);
            setter.set("filterconditionstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()), i);
            setter.set("filterresult", (Object)rule.getFilterResult(), i);
            setter.set("filterresultstr", (Object)PayRollActGrpHelper.formatRuleResultInfo((String)rule.getFilterResult()), i);
            setter.set("rulename", (Object)rule.getRuleName(), i);
            setter.set("rulenumber", (Object)rule.getRuleNumber(), i);
            setter.set("seq", (Object)rule.getRuleOrder(), i);
        }
        dataModel.batchCreateNewEntryRow("entryrulelist", setter);
        dataModel.endInit();
    }
}

