/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcolla;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.RuleCondition;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.controls.RuleResult;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.swc.hsas.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hsas.common.constants.PayRollActGrpConstants;
import kd.swc.hsas.common.dto.HRRuleDTO;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayRollActRuleDesignEdit
extends AbstractFormPlugin
implements PayRollActGrpConstants {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter para = this.getView().getFormShowParameter();
        Map customParams = para.getCustomParams();
        this.initVisible();
        this.initValue(customParams);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("ruledate".equals(fieldKey)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue instanceof Date) {
                RuleCondition conditionControl = this.getRuleConditionControl();
                RuleResult resultControl = this.getRuleResultControl();
                this.updateRuleDate((Date)newValue, new RuleControl[]{conditionControl, resultControl});
            }
            this.getModel().setValue("ruledate", null);
        }
    }

    private void updateRuleDate(Date date, RuleControl ... controls) {
        if (controls == null || controls.length < 1 || null == date) {
            return;
        }
        String dateFormat = this.getView().getPageCache().get("ruleDateFormat");
        String value = SWCStringUtils.isEmpty((String)dateFormat) ? SWCDateTimeUtils.formatDate((Date)date) : SWCDateTimeUtils.format((Date)date, (String)dateFormat);
        for (RuleControl ruleControl : controls) {
            ruleControl.setDate(value);
        }
    }

    private void initValue(Map<String, Object> customParams) {
        Long sceneId = this.getSceneId();
        HRRuleDTO rule = (HRRuleDTO)JSONObject.toJavaObject((JSON)((JSONObject)customParams.get("hrRule")), HRRuleDTO.class);
        this.initRuleNumebr(rule);
        this.initRuleName(rule);
        this.initRuleConditionControl(sceneId, rule);
        this.initRuleResultControl(sceneId, rule);
        this.getModel().setDataChanged(false);
    }

    private void initRuleName(HRRuleDTO rule) {
        if (null == rule) {
            return;
        }
        this.getModel().setValue("name", (Object)rule.getRuleName());
    }

    private void initRuleNumebr(HRRuleDTO rule) {
        String ruleNumber = null == rule || SWCStringUtils.isEmpty((String)rule.getRuleNumber()) ? PayRollActGrpHelper.newRuleNumber() : rule.getRuleNumber();
        this.getModel().setValue("number", (Object)ruleNumber);
    }

    private void initRuleResultControl(Long sceneId, HRRuleDTO rule) {
        RuleResult ruleResult = this.getRuleResultControl();
        if (sceneId != null) {
            ruleResult.setScene(String.valueOf(sceneId));
        }
        if (null == rule) {
            return;
        }
        String filterResult = rule.getFilterResult();
        if (!SWCStringUtils.isEmpty((String)filterResult)) {
            ruleResult.setValue(filterResult);
        } else {
            String customParam = (String)this.getView().getFormShowParameter().getCustomParam("resultParamStr");
            ruleResult.setValue(customParam);
        }
    }

    private void initRuleConditionControl(Long sceneId, HRRuleDTO rule) {
        RuleCondition ruleCondition = this.getRuleConditionControl();
        if (sceneId != null) {
            ruleCondition.setScene(String.valueOf(sceneId));
        }
        if (null == rule) {
            return;
        }
        String filterCondition = rule.getFilterCondition();
        if (!SWCStringUtils.isEmpty((String)filterCondition)) {
            ruleCondition.setValue(filterCondition);
        }
    }

    private void initVisible() {
        this.setControlVisibility(this.isBaseInfoVisibility(), "flexbaseinfo");
        this.setControlVisibility(this.isRuleConditionVisibility(), "flexcondition");
        this.setControlVisibility(this.isRuleResultVisibility(), "flexresult");
    }

    private Boolean isVisibility(String controlName) {
        Boolean isValue = (Boolean)this.getView().getFormShowParameter().getCustomParam(controlName);
        return isValue == null ? Boolean.TRUE : isValue;
    }

    private Boolean isBaseInfoVisibility() {
        return this.isVisibility("baseInfoVisibility");
    }

    private Boolean isRuleConditionVisibility() {
        return this.isVisibility("ruleConditionVisibility");
    }

    private Boolean isRuleResultVisibility() {
        return this.isVisibility("ruleResultVisibility");
    }

    private void setControlVisibility(Boolean visible, String controlName) {
        if (visible != null) {
            this.getView().setVisible(visible, new String[]{controlName});
        }
    }

    public void afterBindData(EventObject e) {
        String number;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if ((OperationStatus.ADDNEW.equals((Object)status) || OperationStatus.EDIT.equals((Object)status)) && SWCStringUtils.isEmpty((String)String.valueOf(this.getModel().getValue("name"))) && !SWCStringUtils.isEmpty((String)(number = this.getModel().getDataEntity().getString("number")))) {
            this.getModel().setValue("name", (Object)number);
        }
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "barconfirm": {
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                if (OperationStatus.VIEW.equals((Object)status)) {
                    this.getView().invokeOperation("close");
                    return;
                }
                List<String> msgList = this.getRuleControlValidateMsg();
                if (!CollectionUtil.isEmpty(msgList)) {
                    msgList.forEach(msg -> this.getView().showTipNotification(msg));
                    return;
                }
                this.returnConditionToParent();
                this.getModel().setDataChanged(false);
                this.getView().invokeOperation("close");
                break;
            }
            case "barcancel": {
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    private List<String> getRuleControlValidateMsg() {
        ArrayList<String> msgList = new ArrayList<String>();
        if (this.isRuleConditionVisibility().booleanValue()) {
            this.validateRuleControl(msgList, (RuleControl)this.getRuleConditionControl());
        }
        if (this.isRuleResultVisibility().booleanValue()) {
            this.validateRuleControl(msgList, (RuleControl)this.getRuleResultControl());
        }
        return msgList;
    }

    private void validateRuleControl(List<String> msgList, RuleControl ruleControl) {
        RuleValidateInfo validate = PayRollActGrpHelper.validate((RuleControl)ruleControl);
        if (!validate.isSuccess()) {
            msgList.addAll(validate.getMsgList());
        }
    }

    private void returnConditionToParent() {
        HRRuleDTO rule = this.getHrRule();
        this.getView().returnDataToParent((Object)rule);
    }

    private HRRuleDTO getHrRule() {
        HRRuleDTO rule = new HRRuleDTO();
        rule.setRuleName(this.getName());
        rule.setRuleNumber(this.getNumber());
        rule.setSceneId(this.getSceneId());
        rule.setFilterCondition(this.getFilterCondition());
        rule.setFilterResult(this.getFilterResult());
        return rule;
    }

    private String getFilterCondition() {
        RuleCondition ruleControl = this.getRuleConditionControl();
        return ruleControl.getValue();
    }

    private RuleCondition getRuleConditionControl() {
        return (RuleCondition)this.getControl("ruleconditionap");
    }

    private String getFilterResult() {
        RuleResult ruleControl = this.getRuleResultControl();
        return ruleControl.getValue();
    }

    private RuleResult getRuleResultControl() {
        return (RuleResult)this.getControl("ruleresultap");
    }

    private String getName() {
        return this.getModel().getDataEntity().getString("name");
    }

    private String getNumber() {
        return this.getModel().getDataEntity().getString("number");
    }

    private Long getSceneId() {
        Object sceneId = this.getView().getFormShowParameter().getCustomParam("sceneId");
        if (sceneId instanceof Long) {
            return (Long)sceneId;
        }
        return null;
    }
}

