/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.cloudcollaplugin;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cloudcolla.CloudSalaryFileAssembleFactory;
import kd.swc.hsas.business.cloudcolla.CloudSalaryFileDataHelper;
import kd.swc.hsas.business.cloudcolla.ICloudCollaSalaryFileHandler;
import kd.swc.hsas.common.dto.CollaSalaryFileDataEntity;
import kd.swc.hsas.common.enums.CloudSalaryFileTypeEnum;
import kd.swc.hsbp.business.cloudcolla.CloudCollaContextHelper;
import kd.swc.hsbp.common.vo.AbstractCloudCollaExecutePlugin;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;

public class CloudCollaSalaryFileDataAssemblePlugin
implements AbstractCloudCollaExecutePlugin {
    private static final Log LOGGER = LogFactory.getLog(CloudCollaSalaryFileDataAssemblePlugin.class);
    private CollaRuleExecuteContext executeInfo;
    private Map<Integer, CollaSalaryFileDataEntity> saveType;

    public void setSaveType(Map<Integer, CollaSalaryFileDataEntity> saveType) {
        this.saveType = saveType;
    }

    public List<String> execute(List<DynamicObject> salaryFiles, Map<String, Object> fieldRuleResult) {
        if (CollectionUtils.isEmpty(salaryFiles)) {
            return new ArrayList<String>();
        }
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(salaryFiles.size());
        ArrayList<DynamicObject> confirmChangeList = new ArrayList<DynamicObject>(salaryFiles.size());
        ArrayList<CollaSalaryFileDataEntity> updatePayDateList = new ArrayList<CollaSalaryFileDataEntity>(salaryFiles.size());
        ArrayList<CollaSalaryFileDataEntity> doNothingList = new ArrayList<CollaSalaryFileDataEntity>(salaryFiles.size());
        for (DynamicObject salaryFile : salaryFiles) {
            CollaSalaryFileDataEntity collaSalaryFileDataEntity = this.saveType.get(salaryFile.hashCode());
            CloudSalaryFileTypeEnum saveType = collaSalaryFileDataEntity.getSaveType();
            switch (saveType) {
                case NEW: {
                    newList.add(salaryFile);
                    break;
                }
                case CONFIRM_CHANGE: {
                    confirmChangeList.add(salaryFile);
                    break;
                }
                case UPDATE_PAY_START_END_DATE: {
                    updatePayDateList.add(collaSalaryFileDataEntity);
                    break;
                }
                case DO_NOTHING: {
                    doNothingList.add(collaSalaryFileDataEntity);
                    break;
                }
            }
        }
        ArrayList<String> result = new ArrayList<String>(10);
        CloudSalaryFileDataHelper helper = CloudSalaryFileDataHelper.getInstance();
        Set insertIdSet = helper.insertSalaryData(newList, result);
        Set changeIdSet = helper.confirmChangeSalaryData(confirmChangeList, result);
        Set updatePayDateIdSet = helper.updatePayDateSalaryData(updatePayDateList, result);
        Set doNothingIdSet = doNothingList.stream().map(CollaSalaryFileDataEntity::getExistSalaryFile).map(item -> item.getLong("id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(salaryFiles)) {
            this.executeInfo.getExeResult().put("hsas_salaryfile", salaryFiles);
            HashSet<Long> inserts = new HashSet<Long>(16);
            inserts.addAll(insertIdSet);
            HashSet<Long> changes = new HashSet<Long>(16);
            changes.addAll(changeIdSet);
            HashSet<Long> doNothings = new HashSet<Long>(16);
            doNothings.addAll(doNothingIdSet);
            ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>(10);
            tempList.addAll(this.processTempMap(inserts, "NEW"));
            tempList.addAll(this.processTempMap(changes, "CHANGE"));
            tempList.addAll(this.processTempMap(updatePayDateIdSet, "CHANGE"));
            tempList.addAll(this.processTempMap(doNothings, "DO_NOTHING"));
            this.executeInfo.getResult().put("hsas_salaryfile", tempList);
        }
        return result;
    }

    private List<Map<String, Object>> processTempMap(Set<Long> datas, String type) {
        if (CollectionUtils.isEmpty(datas)) {
            return Collections.emptyList();
        }
        return datas.stream().map(item -> {
            ImmutableMap temp = ImmutableMap.of((Object)"entityNumber", (Object)"hsas_salaryfile", (Object)"type", (Object)type, (Object)"dataId", (Object)item);
            return temp;
        }).collect(Collectors.toList());
    }

    public List<String> afterAssembleData(Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, String currentTriggerObjectName) {
        Map handlerResult;
        this.executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        ArrayList<String> result = new ArrayList<String>();
        if (CollectionUtils.isEmpty(fieldRuleResult)) {
            return result;
        }
        List salaryFiles = (List)fieldRuleResult.get(currentTriggerObjectName);
        DynamicObject salaryFile = (DynamicObject)salaryFiles.get(0);
        String flowType = (String)commonParams.get("flowType");
        ICloudCollaSalaryFileHandler handler = CloudSalaryFileAssembleFactory.create((String)flowType);
        CloudCollaContextHelper.getInstance().parseAndSetCustomizeResultOnlyFlowOutData(salaryFile, commonParams);
        this.saveType = handlerResult = handler.AssembleData(salaryFile, fieldRuleResult, fieldMapResult, assembleSaveData, commonParams, ruleEngineData);
        return result;
    }
}

