/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.importtask.guide;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.url.UrlService;
import kd.swc.hsas.business.importtaskguide.ImportTaskGuideExportService;
import kd.swc.hsas.business.importtaskguide.ImportTaskGuideImportService;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.constants.ImportConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskGuideImportViewPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_DOWNLOAD = "btndownload";
    private static final String KEY_BTN_RESETFILE = "btnresetfile";
    private static final String KEY_BTN_UPLOAD = "btnupload";

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_DOWNLOAD, KEY_BTN_RESETFILE});
        Image label = (Image)this.getControl(KEY_BTN_UPLOAD);
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
        Label title = (Label)this.getControl("title");
        title.setText(ResManager.loadKDString((String)"\u5bfc\u5165\u4efb\u52a1", (String)"TaskGuideImportViewPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_importtask", (String)"2PAWH9DYXXLZ")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5bfc\u5165\u4efb\u52a1\u201d\u7684\u201c\u5bfc\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskGuideImportViewPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                ImportTaskGuideExportService exportService = new ImportTaskGuideExportService();
                exportService.exportExcelTemplate(this.getView());
                break;
            }
            case "btnresetfile": {
                this.resetFileInfo();
                break;
            }
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = (String)urls[0];
            view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
            view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
            String fullUrl = UrlService.getAttachmentFullUrl((String)url);
            model.setValue("filepath", (Object)url);
            model.setValue("fullpath", (Object)fullUrl);
        }
    }

    private void resetFileInfo() {
        this.getModel().setValue("filename", (Object)"");
        this.getModel().setValue("filepath", (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
    }

    private void importData() {
        String url = this.getModel().getDataEntity().getString("filepath");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"HSASCalTableImportStartPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter params = this.getView().getFormShowParameter();
        Long importTaskId = (Long)params.getCustomParam("importTaskId");
        Long migrationtplId = (Long)params.getCustomParam("migrationtplId");
        String writeTaskType = (String)params.getCustomParam("writetasktype");
        Long orgId = Long.valueOf(params.getCustomParam("orgId").toString());
        String importTaskName = (String)params.getCustomParam("importTaskName");
        String pageId = this.getView().getParentView().getPageId();
        ImportTaskGuideImportService importService = new ImportTaskGuideImportService(url, importTaskId, migrationtplId);
        try {
            Map result = importService.parseAndCheckExcelData(writeTaskType, orgId, pageId, importTaskName);
            String errorMsg = (String)result.get("errorMsg");
            if (!SWCStringUtils.isEmpty((String)errorMsg)) {
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
            returnData.put("isOk", Boolean.TRUE);
            returnData.put("totalCount", result.get("totalCount"));
            returnData.put("cacheKey", result.get("cacheKey"));
            returnData.put("importTaskId", importTaskId);
            returnData.put("migrationtplId", migrationtplId);
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
        catch (Exception ex) {
            this.getView().showMessage(ImportConstants.IMPORT_TEMPLATE_ERROR(), ex.getMessage(), MessageTypes.Default);
        }
    }
}

