/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.agencypay.AgencyPayHelper;
import kd.swc.hsas.common.enums.AgencyPayStateEnum;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCPayDetailAgencyList
extends AbstractListPlugin {
    private static final String CALLBACKID_RESELECTED = "callbackid_reselected";
    private static final String CALLBACKID_CURCONFIRM = "callbackid_curconfirm";
    private static final String CALLBACKID_AGBCREATERESULT = "callbackid_agbcreateresult";
    private static final String CALLBACKID_ENTRYLIMITCONFIRM = "callbackid_entrylimitconfirm";
    private static final String OP_MODIFYPAYSUBJECTV = "modifypaysubjectv";
    private static final String CREATEAGENCY_BANKOFFER = "createagency_bankoffer";
    private static final String OP_CREATEAGENCY = "donothing_createagency";
    private static final String AFTERCONFIRM_CREATEAGENCY = "createagency_afterconfirm";
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "createagency_bankoffer": 
            case "donothing_createagency": {
                this.beforeCreateAgency(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_createagency": {
                this.afterCreateAgency(args);
                break;
            }
            case "donothing_viewbill": {
                this.viewAgencyPayBill();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "callbackid_curconfirm": {
                this.toCreatePayBillAfterSplit(event);
                break;
            }
            case "callbackid_agbcreateresult": {
                this.resultCloseEvent(event);
                break;
            }
            case "callbackid_entrylimitconfirm": {
                this.toCountOrgAndCurAfterConfirm(event);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String key;
        switch (key = args.getFieldName()) {
            case "agencypaybill.billno": 
            case "agencypaybill_billno": {
                args.setCancel(true);
                this.viewAgencyPay();
                break;
            }
        }
    }

    private void beforeCreateAgency(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        boolean afterCounfirm = option.tryGetVariableValue(AFTERCONFIRM_CREATEAGENCY, new RefObject());
        ListSelectedRowCollection coll = args.getListSelectedData();
        Object[] ids = coll.getPrimaryKeyValues();
        int selectedRows = ids.length;
        if (!afterCounfirm) {
            if (selectedRows > 10000) {
                this.openPromptConfirm(args);
                args.setCancel(true);
            } else {
                this.countOrgAndCur(args.getListSelectedData());
                args.setCancel(true);
            }
        } else {
            boolean isCompleted = Boolean.parseBoolean(formOperate.getOption().getVariableValue("batchop_completed", String.valueOf(false)));
            if (!isCompleted) {
                this.clearCache();
            }
            option.setVariableValue("batchop_batchsize", "500");
            option.setVariableValue("pageid", this.getView().getPageId());
        }
    }

    private void resultCloseEvent(ClosedCallBackEvent event) {
        Boolean showBill;
        Map returnData = (Map)event.getReturnData();
        if (returnData != null && (showBill = (Boolean)returnData.get("showBill")) != null && showBill.booleanValue()) {
            String pageId = this.getView().getPageId();
            IAppCache cache = AppCache.get((String)pageId);
            Set billIdSet = (Set)cache.get("billIdSet", Set.class);
            if (billIdSet == null || billIdSet.isEmpty()) {
                this.clearCache();
                this.getView().invokeOperation("refresh");
                return;
            }
            AgencyPayHelper.viewAgencyPayBill((IFormView)this.getView(), (Set)AgencyPayHelper.stringToLong((Set)billIdSet));
        }
        this.clearCache();
        this.getView().invokeOperation("refresh");
    }

    private void viewAgencyPay() {
        ListView listView = (ListView)this.getView();
        Long detailId = (Long)listView.getFocusRowPkId();
        Map agencyIdAndStatusMap = AgencyPayHelper.queryAgencyIdByDetailId((Long)detailId);
        if (CollectionUtils.isEmpty((Map)agencyIdAndStatusMap)) {
            return;
        }
        if (agencyIdAndStatusMap.size() == 1) {
            agencyIdAndStatusMap.entrySet().forEach(obj -> {
                long billId = (Long)obj.getKey();
                String status = (String)obj.getValue();
                BaseShowParameter parameter = new BaseShowParameter();
                BillOperationStatus operationStatus = SWCShowFormServiceHelper.getBillOperationStatus((String)status);
                parameter.setFormId("hsas_agencypaybill");
                parameter.setPkId((Object)billId);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                if (SWCStringUtils.equals((String)status, (String)"A")) {
                    parameter.setStatus(OperationStatus.VIEW);
                }
                parameter.setBillStatus(operationStatus);
                this.getView().showForm((FormShowParameter)parameter);
            });
        } else {
            AgencyPayHelper.viewAgencyPayBill((IFormView)this.getView(), agencyIdAndStatusMap.keySet());
        }
    }

    private void viewAgencyPayBill() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            ListShowParameter bill = new ListShowParameter();
            bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bill.setBillFormId("hsas_agencypaybill");
            this.getView().showForm((FormShowParameter)bill);
        } else {
            this.viewAgencyPayBillOfSelectedDetail();
        }
    }

    private void viewAgencyPayBillOfSelectedDetail() {
        ListShowParameter bill = new ListShowParameter();
        SWCDataServiceHelper billHelper = new SWCDataServiceHelper("hsas_agencypaybill");
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] payDetailIds = selectedRows.getPrimaryKeyValues();
        List payDetailIdList = Arrays.stream(payDetailIds).map(payDetailId -> Long.parseLong(String.valueOf(payDetailId))).collect(Collectors.toList());
        QFilter payDetailFilter = new QFilter("id", "in", payDetailIdList);
        DynamicObject[] payDetailQuerys = payDetailHelper.query("id,agencypaybill.id", new QFilter[]{payDetailFilter});
        Set<Long> agencyPayBillIdSet = Arrays.stream(payDetailQuerys).map(detail -> detail.getLong("agencypaybill.id")).collect(Collectors.toSet());
        Set<Long> newAgencyPayBillIdSet = this.getPermissionBillIdSet(billHelper, agencyPayBillIdSet);
        int count = newAgencyPayBillIdSet.size();
        if (count == 0 || count == 1 && newAgencyPayBillIdSet.contains(0L)) {
            String msg = ResManager.loadKDString((String)"\u6240\u9009\u53d1\u653e\u660e\u7ec6\u672a\u751f\u6210\u4ee3\u53d1\u5355\uff0c\u65e0\u5bf9\u5e94\u53ef\u67e5\u8be2\u6570\u636e\u3002", (String)"SWCPayDetailAgencyList_11", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        } else {
            QFilter newIdFilter = new QFilter("id", "in", newAgencyPayBillIdSet);
            ListFilterParameter filterParameter = new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{newIdFilter}), null);
            bill.setListFilterParameter(filterParameter);
            bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bill.setBillFormId("hsas_agencypaybill");
            this.getView().showForm((FormShowParameter)bill);
        }
    }

    private Set<Long> getPermissionBillIdSet(SWCDataServiceHelper billHelper, Set<Long> agencyPayBillIdSet) {
        boolean isSuper = SWCPermissionServiceHelper.isSuperUser();
        if (isSuper) {
            return agencyPayBillIdSet;
        }
        QFilter billIdFilter = new QFilter("id", "in", agencyPayBillIdSet);
        DynamicObject[] agencyPayBills = billHelper.query("id,org.id,payrollgrp.id", new QFilter[]{billIdFilter});
        HashSet newAgencyPayBillIdSet = Sets.newHashSetWithExpectedSize((int)16);
        String permItemId = "47150e89000000ac";
        String appId = "/UHMBBGZQ65X";
        String entityNum = "hsas_agencypaybill";
        HashSet orgPermIdSet = null;
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)appId, (String)entityNum, (String)permItemId);
        if (permOrgs != null && permOrgs.getHasPermOrgs() != null) {
            orgPermIdSet = new HashSet(permOrgs.getHasPermOrgs());
        }
        Set payRollGrpIds = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)appId, (String)entityNum, (String)permItemId);
        for (DynamicObject agencyPayBill : agencyPayBills) {
            long Id = agencyPayBill.getLong("id");
            long orgId = agencyPayBill.getLong("org.id");
            long payrollGroupId = agencyPayBill.getLong("payrollgrp.id");
            Boolean isPerm = !(orgPermIdSet != null && !orgPermIdSet.contains(orgId) || payRollGrpIds != null && !payRollGrpIds.contains(payrollGroupId));
            if (!isPerm.booleanValue()) continue;
            newAgencyPayBillIdSet.add(Id);
        }
        return newAgencyPayBillIdSet;
    }

    private void toCreatePayBillAfterSplit(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (returnData != null) {
            Boolean result = (Boolean)returnData.get("result");
            OperateOption option = OperateOption.create();
            option.setVariableValue(AFTERCONFIRM_CREATEAGENCY, "true");
            if (result != null && result.booleanValue()) {
                Boolean issplit = (Boolean)returnData.get("issplit");
                if (issplit != null && issplit.booleanValue()) {
                    option.setVariableValue("isSplitCur", Boolean.TRUE.toString());
                } else {
                    option.setVariableValue("isSplitCur", Boolean.FALSE.toString());
                }
                this.getView().invokeOperation(OP_CREATEAGENCY, option);
            }
        }
    }

    private void afterCreateAgency(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateName = formOperate.getOperateName().getLocaleValue();
        ArrayList<String> failList = new ArrayList<String>(10);
        List errorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        for (IOperateInfo errorInfo : errorOrValidateInfo) {
            failList.add(errorInfo.getMessage());
        }
        operationResult.setShowMessage(false);
        String pageId = this.getView().getPageId();
        IAppCache appCache = AppCache.get((String)pageId);
        Set billIdSet = (Set)appCache.get("billIdSet", Set.class);
        int billCount = 0;
        if (null != billIdSet) {
            billCount = billIdSet.size();
        }
        List successDetailId = operationResult.getSuccessPkIds();
        int successCount = successDetailId.size();
        this.showAgencyCreateResult(operateName, billCount, successCount, failList);
    }

    private void countOrgAndCur(ListSelectedRowCollection coll) {
        String entityName = "hsas_paydetail";
        Object[] ids = coll.getPrimaryKeyValues();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        QFilter payStateUnpayFilter = new QFilter("paystate", "=", (Object)PayStateEnum.UNPAY.getCode());
        payStateUnpayFilter.and("agencypaystate", "=", (Object)AgencyPayStateEnum.NOT_GENERATE.getCode());
        payStateUnpayFilter.and("bankofferstatus", "in", (Object)BankOfferEnum.getBankOfferArray());
        QFilter payStatePayFailFilter = new QFilter("paystate", "=", (Object)PayStateEnum.PAYFAIL.getCode());
        QFilter payStateFilter = payStateUnpayFilter.or(payStatePayFailFilter);
        QFilter casFilter = new QFilter("paysubjecthis.cashintergration", "=", (Object)"1");
        QFilter abandonFilter = new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode()));
        QFilter stopPayFilter = new QFilter("onholdstatus", "not in", (Object)new String[]{String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()), String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode())});
        QFilter detailAbandonFilter = new QFilter("abandonedstatus", "!=", (Object)Boolean.TRUE);
        QFilter modifyBillFilter = new QFilter("acctmodifybill", "=", (Object)0L);
        modifyBillFilter.or(new QFilter("acctmodifybill.billstatus", "=", (Object)"E"));
        QFilter bankCardFilter = new QFilter("ismustbankcard", "=", (Object)Boolean.TRUE);
        bankCardFilter.and(new QFilter("perbankcard.id", "!=", (Object)0L));
        bankCardFilter.or(new QFilter("ismustbankcard", "=", (Object)Boolean.FALSE));
        QFilter[] filters = new QFilter[]{filter, payStateFilter, casFilter, abandonFilter, stopPayFilter, detailAbandonFilter, modifyBillFilter, bankCardFilter};
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        String org = "org";
        String grp = "payrollgroup";
        String cur = "paycurrency";
        int idCount = helper.count(filters);
        int orgCount = helper.count(entityName, org, filters, (Distinctable)WithDistinctable.get());
        int grpCount = helper.count(entityName, grp, filters, (Distinctable)WithDistinctable.get());
        int curCount = helper.count(entityName, cur, filters, (Distinctable)WithDistinctable.get());
        if (idCount <= 0 || orgCount <= 0 || grpCount <= 0 || curCount <= 0) {
            this.getView().showErrorNotification(this.getCreateAgencyErrorMsg());
            return;
        }
        if (curCount == 1) {
            if (orgCount == 1 && grpCount == 1) {
                OperateOption option = OperateOption.create();
                option.setVariableValue(AFTERCONFIRM_CREATEAGENCY, "true");
                this.getView().invokeOperation(OP_CREATEAGENCY, option);
            } else {
                this.openSplitConfirm(this.getConfirmMsg(true, false), false);
            }
        } else if (orgCount == 1 && grpCount == 1) {
            this.openSplitConfirm(this.getConfirmMsg(false, true), true);
        } else {
            this.openSplitConfirm(this.getConfirmMsg(true, true), true);
        }
    }

    private void openSplitConfirm(String msg, boolean isMulCur) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_agencycurconfirm");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setShowTitle(false);
        if (!isMulCur) {
            para.setCustomParam("isShowSplit", (Object)Boolean.FALSE);
        }
        para.setCustomParam("context", (Object)msg);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKID_CURCONFIRM);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private String getConfirmMsg(boolean isMulOrgOrGrp, boolean isMulCur) {
        if (isMulCur) {
            if (isMulOrgOrGrp) {
                return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u7b26\u5408\u6761\u4ef6\u7684\u660e\u7ec6\u4e2d\u5305\u542b\u591a\u79cd\u6536\u6b3e\u5e01\u79cd\uff0c\u5e76\u4e14\uff0c\u4e0d\u540c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u6216\u4e0d\u540c\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u53d1\u653e\u660e\u7ec6\u5c06\u4f1a\u62c6\u5206\u5230\u4e0d\u540c\u7684\u4ee3\u53d1\u5355\u4e2d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SWCPayDetailAgencyList_13", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u7b26\u5408\u6761\u4ef6\u7684\u660e\u7ec6\u4e2d\u5305\u542b\u591a\u79cd\u6536\u6b3e\u5e01\u79cd\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SWCPayDetailAgencyList_12", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
        }
        if (isMulOrgOrGrp) {
            return ResManager.loadKDString((String)"\u4e0d\u540c\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u6216\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u53d1\u653e\u660e\u7ec6\u5c06\u62c6\u5206\u81f3\u4e0d\u540c\u7684\u4ee3\u53d1\u5355\u4e2d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SWCPayDetailAgencyList_7", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
        }
        return "";
    }

    private void showAgencyCreateResult(String operateName, int billCount, int successCount, List<String> failList) {
        if (billCount == 0) {
            String msg = ResManager.loadKDString((String)"\u751f\u6210\u4ee3\u53d1\u5355\u5931\u8d25\u3002", (String)"SWCPayDetailAgencyList_9", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            this.clearCache();
            this.getView().showErrorNotification(msg);
            return;
        }
        IListView listView = (IListView)this.getView();
        int totalCount = listView.getSelectedRows().size();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_agbcreateresult");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setShowTitle(false);
        String title = this.buildMsg(totalCount, successCount, totalCount - successCount, billCount);
        para.setCustomParam("title", (Object)title);
        para.setCustomParam("operateName", (Object)operateName);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = failList.size();
        for (int index = 0; index < 5 && index < len; ++index) {
            buf.append(failList.get(index)).append("<br/>");
        }
        para.setCustomParam("hasMore", (Object)(failList.size() > 5 ? 1 : 0));
        para.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        para.setCustomParam("failList", failList);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKID_AGBCREATERESULT);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private String buildMsg(Integer totalCount, Integer successCount, Integer failCount, Integer billCount) {
        StringBuilder sb = new StringBuilder();
        String main = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u53d1\u653e\u660e\u7ec6\uff0c{1}\u6761\u7b26\u5408\u6761\u4ef6\uff0c\u6210\u529f\u751f\u6210{2}\u5f20\u4ee3\u53d1\u5355\u3002", (String)"AgencyCreateResultPlugin_0", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
        String err = ResManager.loadKDString((String)"{3}\u6761\u5931\u8d25\u3002", (String)"AgencyCreateResultPlugin_1", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
        String format = null;
        if (failCount != null && failCount > 0) {
            format = sb.append(main).append(err).toString();
            return MessageFormat.format(format, totalCount, successCount, billCount, failCount);
        }
        format = sb.append(main).toString();
        return MessageFormat.format(format, totalCount, successCount, billCount);
    }

    private String getCreateAgencyErrorMsg() {
        return ResManager.loadKDString((String)"\u751f\u6210\u4ee3\u53d1\u5355\u5931\u8d25\u3002\u660e\u7ec6\u9700\u6ee1\u8db3\u4ee5\u4e0b\u6240\u6709\u6761\u4ef6\u65b9\u53ef\u751f\u6210\u4ee3\u53d1\u5355\uff1a\u2460\u5bf9\u63a5\u51fa\u7eb3\u7cfb\u7edf-\u91d1\u8776\u4e91\u661f\u701a\uff1b\u2461\u4ed8\u6b3e\u72b6\u6001\u4e3a\u5f85\u4ed8\u6b3e\u4e14\u4e0d\u5728\u4ed8\u6b3e\u6d41\u7a0b\u4e2d\uff0c\u6216\u4ed8\u6b3e\u72b6\u6001\u4e3a\u4ed8\u6b3e\u5931\u8d25\uff1b\u2462\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u7a7a\u6216\u89e3\u9664\uff1b\u2463\u94f6\u884c\u5361\u53d8\u66f4\u72b6\u6001\u4e3a\u7a7a\u6216\u5ba1\u6279\u4e0d\u901a\u8fc7\uff1b\u2464\u662f\u5426\u5e9f\u5f03\u4e3a\u5426\uff1b\u2465\u94f6\u884c\u5361\u4fe1\u606f\u5b8c\u6574\u3002", (String)"SWCPayDetailAgencyList_4", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
    }

    private void clearCache() {
        String pageId = this.getView().getPageId();
        IAppCache cache = AppCache.get((String)pageId);
        cache.remove("paySubjectAndHisMap");
        cache.remove("seqMap");
        cache.remove("billIdSet");
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.clearCache();
    }

    private void openPromptConfirm(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        SWCPageCache pageCache = new SWCPageCache(view);
        pageCache.put("listSelectedRowCollection", (Object)args.getListSelectedData());
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_agencyentlimconfirm");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setShowTitle(false);
        String format = ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u5355\u636e\u5206\u5f55\u9650\u989d\u4e3a{0}\uff0c\u82e5\u6570\u636e\u8d85\u8fc7{1}\uff0c\u5c06\u6839\u636e\u5355\u636e\u9650\u989d\u81ea\u52a8\u62c6\u5206\u751f\u6210\u4ee3\u53d1\u5355\u3002", (String)"SWCPayDetailAgencyList_10", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
        String msg = MessageFormat.format(format, "10,000", "10,000");
        para.setCustomParam("msg", (Object)msg);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKID_ENTRYLIMITCONFIRM);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private void toCountOrgAndCurAfterConfirm(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (returnData != null) {
            ListSelectedRowCollection coll = null;
            IFormView view = this.getView();
            SWCPageCache pageCache = new SWCPageCache(view);
            coll = (ListSelectedRowCollection)pageCache.get("listSelectedRowCollection", ListSelectedRowCollection.class);
            Boolean result = (Boolean)returnData.get("result");
            if (result != null && result.booleanValue() && coll != null) {
                this.countOrgAndCur(coll);
            }
        }
    }
}

