/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.common.events.paydetail.BankOfferFilterEvent;
import kd.sdk.swc.hsas.formplugin.extpoint.paydetail.IBankOfferExtPlugin;
import kd.swc.hsas.business.bankoffer.BankOfferExportService;
import kd.swc.hsas.common.dto.BankOfferSelectTplDTO;
import kd.swc.hsas.common.enums.AgencyPayStateEnum;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsas.formplugin.web.basedata.paydetail.BankOfferExtPlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class SWCPayDetailBankOfferList
extends AbstractListPlugin {
    private static final String BANK_OFFER = "donothing_bankoffer";
    private static final String BANK_OFFERMUL = "donothing_bankoffermul";
    private static final String BANK_OFFER_INVALID = "donothing_bankoffer_invalid";
    private static final String BANK_OFFER_LOG = "donothing_openlog";
    private static final String BANK_OFFER_TPL = "donothing_opentpl";
    private static final String OP_BANK_OFFER_INVALID = "batch_bankoffer_invalid";
    private static final String CALLBACKID_BANKOFFERINVALIDREASON = "callbackid_bankofferinvalidreason";
    private static final String CALLBACKID_BANKOFFERSELECT = "callbackid_bankofferselect";
    private static final String CALLBACKID_BANKOFFERSECOND = "callbackid_bankoffersecond";
    private static final String CALLBACKID_BANKOFFERSECONDMUL = "callbackid_bankoffersecondMul";
    private static final String CALLBACKID_BANKOFFEREXPORT = "callbackid_bankofferexport";
    private static final String CALLBACKID_BANKOFFERINVALIDSECOND = "callbackid_bankofferinvalidsecond";
    private static final String BANKOFFERNUM = "bankOfferNum";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection coll = args.getListSelectedData();
        Object[] ids = coll.getPrimaryKeyValues();
        switch (operateKey) {
            case "donothing_bankoffer": 
            case "donothing_bankoffermul": {
                int totalNum = ids.length;
                DynamicObjectCollection bankOfferCol = this.getBankOfferColByIds(ids);
                Set<Long> bankOfferColIds = bankOfferCol.stream().map(bankOffer -> bankOffer.getLong("agentpaybank.bank_cate")).collect(Collectors.toSet());
                int enableNum = bankOfferCol.size();
                this.openConfirmForm(totalNum, enableNum, args, bankOfferColIds);
                this.getView().getPageCache().put(BANKOFFERNUM, String.valueOf(enableNum));
                List list = bankOfferCol.stream().map(bankOffer -> bankOffer.getString("id")).collect(Collectors.toList());
                this.getView().getPageCache().put("ids", String.join((CharSequence)",", list));
                break;
            }
            case "donothing_bankoffer_invalid": {
                int enableInvalidNum = this.getBankOfferInvalidCountByIds(ids);
                this.checkInvalidValue(enableInvalidNum, args);
                break;
            }
            case "donothing_opentpl": {
                this.checkViewPermByUserId("hsas_bankoffertpl", args);
                ListShowParameter show = new ListShowParameter();
                show.setBillFormId("hsas_bankoffertpl");
                show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)show);
                break;
            }
            case "donothing_openlog": {
                this.checkViewPermByUserId("hsas_bankreportlog", args);
                this.openExportLogForm("hsas_bankreportlog");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_bankoffer_invalid": {
                break;
            }
            case "batch_bankoffer_invalid": {
                OperationResult operationResult = args.getOperationResult();
                operationResult.setShowMessage(false);
                int totalNum = operationResult.getBillCount();
                int enableNum = operationResult.getSuccessPkIds().size();
                this.openInvalidConfirmForm(totalNum, enableNum);
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (SWCStringUtils.equals((String)"bankofferlog_number", (String)args.getHyperLinkClickEvent().getFieldName())) {
            this.checkViewPermByUserId("hsas_bankreportlog", null);
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            Long logId = (Long)listView.getFocusRowPkId();
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankofferrrec");
            QFilter filter = new QFilter("entryentity.paydetail", "=", (Object)logId);
            DynamicObject[] dynamicObjects = helper.query("id", new QFilter[]{filter});
            if (dynamicObjects.length == 0) {
                String errorTips = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalPayrollTaskList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorTips);
                return;
            }
            List logIds = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            ListShowParameter show = new ListShowParameter();
            show.setBillFormId("hsas_bankreportlog");
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            show.setCustomParam("defaultLogNumbers", logIds);
            this.getView().showForm((FormShowParameter)show);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "callbackid_bankoffersecond": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null || !((Boolean)returnData.get("isOk")).booleanValue()) break;
                Set bankOfferColIds = (Set)returnData.get("bankOfferColIds");
                this.openBankOfferSelectForm(bankOfferColIds);
                break;
            }
            case "callbackid_bankoffersecondMul": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null || !((Boolean)returnData.get("isOk")).booleanValue()) break;
                Set bankOfferColIds = (Set)returnData.get("bankOfferColIds");
                this.openBankOfferSelectMulFormNew(bankOfferColIds);
                break;
            }
            case "callbackid_bankofferinvalidreason": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null || !((Boolean)returnData.get("isOk")).booleanValue()) break;
                this.operationInvalidData((String)returnData.get("reason"));
                break;
            }
            case "callbackid_bankofferselect": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null || !((Boolean)returnData.get("isOk")).booleanValue()) break;
                List selectBankList = (List)returnData.get("bankOfferData");
                this.operationExportData(selectBankList);
                break;
            }
            case "callbackid_bankofferexport": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "callbackid_bankofferinvalidsecond": {
                if (!e.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.openForm(null, "hsas_bankofferinvareason", CALLBACKID_BANKOFFERINVALIDREASON);
                break;
            }
        }
    }

    private void checkViewPermByUserId(String entryName, BeforeDoOperationEventArgs args) {
        boolean permFlag = SWCPermissionServiceHelper.hasViewPermission((String)"/UHMBBGZQ65X", (String)entryName);
        if (!permFlag && args != null) {
            args.setCancel(true);
        }
    }

    private void operationExportData(List<BankOfferSelectTplDTO> selectBankList) {
        String totalNum = this.getView().getPageCache().get(BANKOFFERNUM);
        String recordId = UUID.randomUUID().toString();
        this.getView().getPageCache().put("recordId", recordId);
        String ids = this.getView().getPageCache().get("ids");
        List idList = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("totalNum", totalNum);
        map.put("recordId", recordId);
        this.openForm(map, "hsas_exportbankprogress", CALLBACKID_BANKOFFEREXPORT);
        BankOfferExportService service = new BankOfferExportService();
        service.checkPayDetailByBankOfferTpl(idList, selectBankList, recordId, this.getView(), map);
    }

    private void operationInvalidData(String invalidReason) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("invalidReason", invalidReason);
        this.getView().invokeOperation(OP_BANK_OFFER_INVALID, operateOption);
    }

    private int getBankOfferInvalidCountByIds(Object[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids);
        filter.and(new QFilter("paystate", "!=", (Object)PayStateEnum.PAID.getCode()));
        filter.and(new QFilter("bankofferstatus", "=", (Object)BankOfferEnum.EXPORTED.getCode()));
        QFilter abandonedFilter = new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE);
        abandonedFilter.or(new QFilter("abandonedstatus", "is null", null));
        filter.and(abandonedFilter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        return helper.count(new QFilter[]{filter});
    }

    private void checkInvalidValue(int enableNum, BeforeDoOperationEventArgs args) {
        if (0 == enableNum) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u76d8\u5931\u6548\u5931\u8d25\uff0c\u53ea\u80fd\u5931\u6548\u201c\u4ed8\u6b3e\u72b6\u6001\u201d\u4e0d\u4e3a\u201c\u5df2\u4ed8\u6b3e\u201d\uff0c\u201c\u94f6\u884c\u62a5\u76d8\u72b6\u6001\u201d\u4e3a\u201c\u5df2\u5bfc\u51fa\u201d\uff0c\u5e76\u4e14\u201c\u672a\u5e9f\u5f03\u201d\u7684\u660e\u7ec6\u3002", (String)"SWCPayDetailBankOfferList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u660e\u7ec6\u5728\u62a5\u76d8\u6587\u4ef6\u4e2d\u5747\u672a\u4ed8\u6b3e\uff0c\u907f\u514d\u91cd\u590d\u652f\u4ed8\u3002\u62a5\u76d8\u5931\u6548\u540e\uff0c\u53ef\u5bf9\u660e\u7ec6\u518d\u6b21\u5bfc\u51fa\u62a5\u76d8\u6216\u5bf9\u63a5\u51fa\u7eb3\u4ed8\u6b3e\u3002\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"SWCPayDetailBankOfferList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_BANKOFFERINVALIDSECOND));
        args.setCancel(true);
    }

    private void openInvalidConfirmForm(int totalNum, int enableNum) {
        int unEnableNum = totalNum - enableNum;
        if (0 == unEnableNum) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62a5\u76d8\u5931\u6548\u6210\u529f\u3002", (String)"SWCPayDetailBankOfferList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openInvalidResultForm(totalNum, enableNum, unEnableNum);
    }

    private DynamicObjectCollection getBankOfferColByIds(Object[] ids) {
        BankOfferFilterEvent filterEvent = this.getBankOfferFilterEvent();
        QFilter payStateFilter = SWCPayDetailBankOfferList.getPayStateFilter(filterEvent);
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)10);
        if (payStateFilter != null) {
            filterList.add(payStateFilter);
        }
        QFilter filter = new QFilter("id", "in", (Object)ids);
        filter.and(new QFilter("bankofferstatus", "in", (Object)BankOfferEnum.getBankOfferArray()));
        filter.and(new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE));
        QFilter modifyBillFilter = new QFilter("acctmodifybill", "=", (Object)0L);
        filter.and(modifyBillFilter);
        QFilter bankCardFilter = new QFilter("ismustbankcard", "=", (Object)Boolean.TRUE);
        bankCardFilter.and(new QFilter("perbankcard.id", "!=", (Object)0L));
        bankCardFilter.or(new QFilter("ismustbankcard", "=", (Object)Boolean.FALSE));
        filter.and(bankCardFilter);
        filterList.add(filter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        return helper.queryOriginalCollection("id,agentpaybank,agentpaybank.bank_cate", filterList.toArray(new QFilter[0]));
    }

    private BankOfferFilterEvent getBankOfferFilterEvent() {
        QFilter payStateFilter = new QFilter("paystate", "=", (Object)PayStateEnum.UNPAY.getCode());
        QFilter paySubjectFilter = new QFilter("paysubjecthis.cashintergration", "=", (Object)" ");
        QFilter onHoldFilter = new QFilter("onholdstatus", "=", (Object)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()));
        onHoldFilter.or(new QFilter("onholdstatus", "=", (Object)" "));
        QFilter agencyFilter = new QFilter("agencypaystate", "=", (Object)AgencyPayStateEnum.NOT_GENERATE.getCode());
        HashMap<String, QFilter> fieldFilterMap = new HashMap<String, QFilter>(16);
        fieldFilterMap.put(payStateFilter.getProperty(), payStateFilter);
        fieldFilterMap.put(paySubjectFilter.getProperty(), paySubjectFilter);
        fieldFilterMap.put(onHoldFilter.getProperty(), onHoldFilter);
        fieldFilterMap.put(agencyFilter.getProperty(), agencyFilter);
        BankOfferFilterEvent filterEvent = new BankOfferFilterEvent(fieldFilterMap);
        this.beforeBankOfferFilter(filterEvent);
        return filterEvent;
    }

    public static QFilter getPayStateFilter(BankOfferFilterEvent filterEvent) {
        if (filterEvent == null) {
            return null;
        }
        Map fieldFilterMap = filterEvent.getFieldFilterMap();
        QFilter extFilter = null;
        if (!CollectionUtils.isEmpty((Map)fieldFilterMap)) {
            for (Map.Entry filterEntry : fieldFilterMap.entrySet()) {
                if (StringUtils.equals((CharSequence)((CharSequence)filterEntry.getKey()), (CharSequence)"paysubjecthis.cashintergration")) continue;
                extFilter = extFilter == null ? (QFilter)filterEntry.getValue() : extFilter.and((QFilter)filterEntry.getValue());
            }
        }
        QFilter presetFilterForPayFail = new QFilter("paystate", "=", (Object)PayStateEnum.PAYFAIL.getCode());
        presetFilterForPayFail.and("onholdstatus", "in", (Object)new String[]{String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()), " "});
        QFilter stateFilter = filterEvent.isPayFailEffect() ? (extFilter == null ? presetFilterForPayFail : extFilter.or(presetFilterForPayFail)) : extFilter;
        return stateFilter;
    }

    private void beforeBankOfferFilter(BankOfferFilterEvent event) {
        BankOfferExtPlugin extPlugin = new BankOfferExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extPlugin, IBankOfferExtPlugin.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.paydetail.IBankOfferExtPlugin#beforeBankOfferFilter", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.beforeBankOfferFilter(event);
            return null;
        });
    }

    private void openConfirmForm(int totalNum, int enableNum, BeforeDoOperationEventArgs args, Set<Long> bankOfferColIds) {
        if (0 == enableNum) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94f6\u884c\u62a5\u76d8\u5931\u8d25\u3002\u660e\u7ec6\u9700\u8981\u6ee1\u8db3\u4ee5\u4e0b\u6240\u6709\u6761\u4ef6\uff0c\u624d\u53ef\u751f\u6210\u94f6\u884c\u62a5\u76d8\uff1a\u2460\u4ed8\u6b3e\u72b6\u6001\u4e3a\u5f85\u4ed8\u6b3e\uff1b\u2461\u672a\u5bf9\u63a5\u51fa\u7eb3\u7cfb\u7edf\uff1b\u2462\u94f6\u884c\u62a5\u76d8\u72b6\u6001\u4e3a\u672a\u5bfc\u51fa/\u5df2\u5931\u6548\uff1b\u2463\u94f6\u884c\u5361\u4fe1\u606f\u5b8c\u6574\uff1b\u2464\u672a\u505c\u7f13\u53d1\u6216\u505c\u7f13\u53d1\u5df2\u89e3\u85aa\uff1b\u2465\u672a\u5e9f\u5f03\uff1b\u2466\u672a\u53d1\u8d77\u94f6\u884c\u5361\u4fe1\u606f\u53d8\u66f4\u3002", (String)"SWCPayDetailBankOfferList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int unEnableNum = totalNum - enableNum;
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (unEnableNum > 0) {
            this.openSecondConfirmForm(totalNum, enableNum, unEnableNum, operateKey, bankOfferColIds);
            args.setCancel(true);
            return;
        }
        if (BANK_OFFER.equals(operateKey)) {
            this.openBankOfferSelectForm(bankOfferColIds);
        }
        if (BANK_OFFERMUL.equals(operateKey)) {
            this.openBankOfferSelectMulFormNew(bankOfferColIds);
        }
        args.setCancel(true);
    }

    private void openSecondConfirmForm(int totalNum, int enableNum, int unEnableNum, String operateKey, Set<Long> bankOfferColIds) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("totalNum", totalNum);
        map.put("enableNum", enableNum);
        map.put("unEnableNum", unEnableNum);
        map.put("agentpaybankIds", bankOfferColIds);
        String callBackId = operateKey.equals(BANK_OFFER) ? CALLBACKID_BANKOFFERSECOND : CALLBACKID_BANKOFFERSECONDMUL;
        this.openForm(map, "hsas_bankoffersecconfim", callBackId);
    }

    private void openBankOfferSelectForm(Set<Long> bankOfferColIds) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("bankOfferColIds", bankOfferColIds);
        this.openForm(map, "hsas_bankofferselconfim", CALLBACKID_BANKOFFERSELECT);
    }

    private void openBankOfferSelectMulForm() {
        this.openForm(null, "hsas_bankoffermulconfim", CALLBACKID_BANKOFFERSELECT);
    }

    private void openBankOfferSelectMulFormNew(Set<Long> bankOfferColIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = SWCPayDetailBankOfferList.getBankQFilter();
        QFilter idFilter = new QFilter("agentpaybank.bank_cate", "in", bankOfferColIds);
        DynamicObject[] payDetailArr = helper.query("id,approvebill,agentpaybank,agentpaybank.id,agentpaybank.bank_cate,agentpaybank.bank_cate.id", new QFilter[]{filter, idFilter});
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        Set agentpaybankIds = Arrays.stream(payDetailArr).map(payDetail -> payDetail.getLong("agentpaybank.bank_cate.id")).collect(Collectors.toSet());
        map.put("agentpaybankIds", agentpaybankIds);
        this.openForm(map, "hsas_bankoffermulconfim", CALLBACKID_BANKOFFERSELECT);
    }

    public static QFilter getBankQFilter() {
        QFilter filter = new QFilter("paystate", "=", (Object)PayStateEnum.UNPAY.getCode());
        QFilter agencyStateFilter = new QFilter("agencypaystate", "=", (Object)AgencyPayStateEnum.NOT_GENERATE.getCode());
        filter.and(agencyStateFilter);
        QFilter bankofferstatus = new QFilter("bankofferstatus", "in", (Object)new String[]{String.valueOf(BankOfferEnum.UNDEXPORT.getCode()), String.valueOf(BankOfferEnum.INVALIDED.getCode())});
        filter.and(bankofferstatus);
        QFilter abandonFilter = new QFilter("abandonedstatus", "!=", (Object)Boolean.TRUE);
        filter.and(abandonFilter);
        QFilter paySubjectFilter = new QFilter("paysubjecthis.cashintergration", "=", (Object)" ");
        filter.and(paySubjectFilter);
        QFilter onHoldFilter = new QFilter("onholdstatus", "in", (Object)new String[]{null, " ", String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode())});
        filter.and(onHoldFilter);
        QFilter modifyBillFilter = new QFilter("acctmodifybill", "=", (Object)0L);
        filter.and(modifyBillFilter);
        QFilter isNeedBankCardQFilter = new QFilter("ismustbankcard", "=", (Object)Boolean.TRUE);
        isNeedBankCardQFilter.and("perbankcard.id", "!=", (Object)0L);
        return filter;
    }

    private void openInvalidResultForm(int totalNum, int enableNum, int unEnableNum) {
        String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u53d1\u653e\u660e\u7ec6\uff0c{1}\u6761\u62a5\u76d8\u5931\u6548\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"SWCPayDetailBankOfferList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        title = MessageFormat.format(title, totalNum, enableNum, unEnableNum);
        String failMsg = ResManager.loadKDString((String)"\u53ea\u53ef\u5bf9\u4ed8\u6b3e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u4ed8\u6b3e\u201d\u3001\u94f6\u884c\u62a5\u76d8\u72b6\u6001\u4e3a\u201c\u5df2\u5bfc\u51fa\u201d\u3001\u201c\u672a\u5e9f\u5f03\u201d\u7684\u660e\u7ec6\u64cd\u4f5c\u62a5\u76d8\u5931\u6548\u3002", (String)"SWCPayDetailBankOfferList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, (String)title, Collections.singletonList(failMsg));
        this.getView().showForm(parameters);
    }

    private void openForm(Map map, String formId, String callBackId) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId(formId);
        para.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callBackId);
        if (map != null && !map.isEmpty()) {
            para.setCustomParam("customMap", (Object)map);
        }
        if (callBackId != null) {
            para.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(para);
    }

    private void openExportLogForm(String formId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId(formId);
        showParameter.setFormId("bos_list");
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

