/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonCheckBoxFilterColumn;
import kd.bos.filter.CommonDateFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCPayDetailList
extends AbstractListPlugin {
    private final String FIELD_TASK = "caltask_number";
    public static final String BEGIN_DATE = "beginDate";
    public static final String END_DATE = "endDate";
    public static final String DEFAULT_TASK_NUMBERS = "defaultTaskNumbers";
    private final Log logger = LogFactory.getLog(SWCPayDetailList.class);
    private Map<String, String> payFormatMap;
    private Map<String, String> calFormatMap;
    private String IS_NOT_NULL = "is not null";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.accountStatusComboItemChange();
        if (this.isEnableNoPermBtn() && !SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_paydetail", (String)"4730fc9f000004ae")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap2"});
        }
    }

    private void accountStatusComboItemChange() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hsas_paydetail");
        IDataEntityProperty property = (IDataEntityProperty)mainEntityType.getProperties().get((Object)"acctmodifybill");
        BasedataProp baseDataProp = (BasedataProp)property;
        BillStatusProp comboProp = (BillStatusProp)baseDataProp.getDynamicComplexPropertyType().getProperty("billstatus");
        List billStatusList = comboProp.getComboItems();
        comboProp.setComboItems(this.orderBillStatusList(billStatusList));
    }

    private List<ValueMapItem> orderBillStatusList(List<ValueMapItem> billStatusList) {
        int size = billStatusList.size();
        ArrayList<ValueMapItem> newBillStatusList = new ArrayList<ValueMapItem>(size);
        newBillStatusList.add(this.getValueMapItemByString(billStatusList, "A"));
        newBillStatusList.add(this.getValueMapItemByString(billStatusList, "B"));
        newBillStatusList.add(this.getValueMapItemByString(billStatusList, "G"));
        newBillStatusList.add(this.getValueMapItemByString(billStatusList, "D"));
        newBillStatusList.add(this.getValueMapItemByString(billStatusList, "C"));
        newBillStatusList.add(this.getValueMapItemByString(billStatusList, "E"));
        return newBillStatusList;
    }

    private ValueMapItem getValueMapItemByString(List<ValueMapItem> billStatusList, String val) {
        for (ValueMapItem valueMapItem : billStatusList) {
            if (!SWCStringUtils.equals((String)val, (String)valueMapItem.getValue())) continue;
            return valueMapItem;
        }
        return null;
    }

    public void setFilter(SetFilterEvent e) {
        List ids;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        if (this.checkLevelTable() && !this.checkPayrollDateValue(qFilters)) {
            String msg = ResManager.loadKDString((String)"\u201c\u85aa\u8d44\u6240\u5c5e\u5e74\u6708\u201d\u8fc7\u6ee4\u6761\u4ef6\uff1a\u8bf7\u9009\u62e91\u5e74\u8303\u56f4\u5185\u7684\u85aa\u8d44\u6240\u5c5e\u5e74\u6708\u3002", (String)"SWCPayDetailList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map payRollDateModifyMap = (Map)formShowParameter.getCustomParam("defaultDateMap");
        String isFirst = this.getView().getPageCache().get("isFirst");
        if (SWCStringUtils.isEmpty((String)isFirst) && payRollDateModifyMap != null && SWCStringUtils.isEmpty((String)((String)formShowParameter.getCustomParam("abandonedstatus")))) {
            qFilters.removeIf(qFilter -> "abandonedstatus".equals(qFilter.getProperty()));
            this.getView().getPageCache().put("isFirst", "0");
        }
        if ((ids = (List)formShowParameter.getCustomParam("defaultIds")) != null && !ids.isEmpty()) {
            qFilters.add(new QFilter("id", "in", (Object)ids));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (SWCStringUtils.equals((String)"caltask_number", (String)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            IListView listview = (IListView)this.getView();
            Long enrollId = (Long)listview.getFocusRowPkId();
            String formId = ((AbstractListView)listview).getBillFormId();
            boolean isEnRollIdExists = SWCShowFormServiceHelper.isExists((Object)enrollId, (String)formId);
            if (!isEnRollIdExists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalPayrollTaskList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            Long taskId = this.getTaskId(enrollId);
            CalPayrollTaskHelper.openCalPersonListView((AbstractFormPlugin)this, (Long)taskId);
        } else if (SWCStringUtils.equals((String)"acctmodifybill_billno", (String)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            IListView listview = (IListView)this.getView();
            Long enrollId = (Long)listview.getFocusRowPkId();
            List<Long> billIds = this.getAcctModifyBillId(enrollId);
            ListShowParameter show = new ListShowParameter();
            show.setBillFormId("hsas_acctmodifybill");
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            show.setCustomParam("defaultIds", billIds);
            this.getView().showForm((FormShowParameter)show);
        }
    }

    private Long getTaskId(Long pkId) {
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        String selectProperties = "caltask.id";
        DynamicObject payDetail = payDetailHelper.queryOne(selectProperties, (Object)pkId);
        if (payDetail == null) {
            return null;
        }
        return payDetail.getLong(selectProperties);
    }

    private List<Long> getAcctModifyBillId(Long pkId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifybill");
        QFilter filter = new QFilter("entryentity.paydetail", "=", (Object)pkId);
        DynamicObject[] dynamicObjects = helper.query("id", new QFilter[]{filter});
        if (dynamicObjects.length == 0) {
            String errorTips = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalPayrollTaskList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorTips);
            return new ArrayList<Long>(10);
        }
        List<Long> billIds = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        return billIds;
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        this.setAmountScale(e);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        this.payFormatMap = Maps.newHashMapWithExpectedSize((int)16);
        this.calFormatMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection pageDatas = e.getPageData();
        for (DynamicObject data : pageDatas) {
            String id = data.getString("id");
            if (data.containsProperty("paycurrency") && data.containsProperty("payamount")) {
                String paycurrencySign = data.getString("paycurrency.sign");
                BigDecimal payamount = data.getBigDecimal("payamount");
                String payFormat = this.getAmountScaleFormatValue(payamount, data.getInt("paycurrency.amtprecision"), paycurrencySign);
                this.payFormatMap.put(id, payFormat);
            }
            if (!data.containsProperty("calcurrency") || !data.containsProperty("calamount")) continue;
            String calcurrencySign = data.getString("calcurrency.sign");
            BigDecimal calamount = data.getBigDecimal("calamount");
            String calFormat = this.getAmountScaleFormatValue(calamount, data.getInt("calcurrency.amtprecision"), calcurrencySign);
            this.calFormatMap.put(id, calFormat);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String option = (String)listShowParameter.getCustomParam("option");
        if (null != option || listShowParameter.isLookUp()) {
            return;
        }
        args.getListColumn("salaryfilehis.person.name").setFixed(true);
        args.getListColumn("salaryfilehis.employee.empnumber").setFixed(true);
        args.getListColumn("salaryfilehis.number").setFixed(true);
    }

    private void setAmountScale(PackageDataEvent e) {
        String fieldKey = ((ColumnDesc)e.getSource()).getFieldKey();
        if (SWCStringUtils.equals((String)fieldKey, (String)"payamount")) {
            String id = e.getRowData().getString("id");
            String formatValue = this.payFormatMap.get(id);
            e.setFormatValue((Object)formatValue);
        } else if (SWCStringUtils.equals((String)fieldKey, (String)"calamount")) {
            String id = e.getRowData().getString("id");
            String formatValue = this.calFormatMap.get(id);
            e.setFormatValue((Object)formatValue);
        }
    }

    private String getScaleFormatValue(BigDecimal value, int scale) {
        BigDecimal zero = new BigDecimal("0");
        BigDecimal one = new BigDecimal("1");
        StringBuilder format = null;
        format = null == value || value.divide(one, 0, RoundingMode.DOWN).compareTo(zero) == 0 ? new StringBuilder("0") : new StringBuilder("#,###");
        if (scale > 0) {
            format.append('.');
        }
        for (int i = 0; i < scale; ++i) {
            format.append('0');
        }
        DecimalFormat myFormat = new DecimalFormat(format.toString());
        return myFormat.format(value);
    }

    private String getAmountScaleFormatValue(BigDecimal value, int scale, String logo) {
        BigDecimal zero = new BigDecimal("0");
        BigDecimal one = new BigDecimal("1");
        if (SWCStringUtils.isEmpty((String)logo)) {
            logo = "";
        }
        StringBuilder logoBuilder = new StringBuilder(logo);
        StringBuilder format = new StringBuilder();
        if (null == value || value.divide(one, 0, RoundingMode.DOWN).compareTo(zero) == 0) {
            format.append('0');
        } else {
            format.append("#,###");
        }
        if (scale > 0) {
            format.append('.');
        }
        for (int i = 0; i < scale; ++i) {
            format.append('0');
        }
        DecimalFormat myFormat = new DecimalFormat(format.toString());
        String formatValue = myFormat.format(value);
        StringBuilder valueBuilder = logoBuilder.append(formatValue);
        return valueBuilder.toString();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null) {
            List columns = args.getFastFilterColumns();
            if (columns != null && !columns.isEmpty()) {
                for (FilterColumn column : columns) {
                    String fieldName;
                    switch (fieldName = column.getFieldName()) {
                        case "caltask.number": {
                            List defaultTaskNumbers = (List)formShowParameter.getCustomParam(DEFAULT_TASK_NUMBERS);
                            if (defaultTaskNumbers == null) break;
                            ArrayList defaultValues = new ArrayList(defaultTaskNumbers);
                            column.setDefaultValues(defaultValues);
                            FilterColumn paystateColumn = args.getFilterColumn("paystate");
                            paystateColumn.setDefaultValue(null);
                            break;
                        }
                        case "salaryfilehis.employee.empnumber": {
                            List defaultEmpNumbers = (List)formShowParameter.getCustomParam("defaultEmpNumbers");
                            if (defaultEmpNumbers == null) break;
                            ArrayList defaultValues = new ArrayList(defaultEmpNumbers);
                            column.setDefaultValues(defaultValues);
                            break;
                        }
                    }
                }
            }
            List fastFilterColumns = args.getCommonFilterColumns();
            String beginDate = (String)formShowParameter.getCustomParam(BEGIN_DATE);
            String endDate = (String)formShowParameter.getCustomParam(END_DATE);
            Map payRollDateModifyMap = (Map)formShowParameter.getCustomParam("defaultDateMap");
            fastFilterColumns.forEach(filterColumn -> {
                CommonDateFilterColumn commonDateFilterColumn;
                String fieldName = filterColumn.getFieldName();
                if (SWCStringUtils.equals((String)fieldName, (String)"org.name")) {
                    filterColumn.setDefaultValue(null);
                }
                if (SWCStringUtils.isNotEmpty((String)beginDate) && SWCStringUtils.isNotEmpty((String)endDate) && SWCStringUtils.equals((String)fieldName, (String)"payrolldate")) {
                    commonDateFilterColumn = (CommonDateFilterColumn)filterColumn;
                    commonDateFilterColumn.setDefaultValues(new Object[]{beginDate, endDate});
                }
                if (SWCStringUtils.equals((String)fieldName, (String)"payrolldate") && payRollDateModifyMap != null && !payRollDateModifyMap.isEmpty()) {
                    commonDateFilterColumn = (CommonDateFilterColumn)filterColumn;
                    commonDateFilterColumn.setDefaultValues(new Object[]{payRollDateModifyMap.get(BEGIN_DATE), payRollDateModifyMap.get(END_DATE)});
                }
                if (SWCStringUtils.equals((String)fieldName, (String)"abandonedstatus") && payRollDateModifyMap != null && !payRollDateModifyMap.isEmpty()) {
                    String abandonedStatus = (String)formShowParameter.getCustomParam("abandonedstatus");
                    CommonCheckBoxFilterColumn commonCheckBoxFilterColumn = (CommonCheckBoxFilterColumn)filterColumn;
                    commonCheckBoxFilterColumn.setDefaultValues(new Object[]{abandonedStatus});
                }
            });
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        String refEntityId = args.getRefEntityId();
        switch (fieldName) {
            case "salaryitem.id": 
            case "salaryitem.name": {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                this.setAmoutFilter(qFilters);
                filters.addAll(qFilters);
                this.addControlledPermFilter(filters, refEntityId);
                break;
            }
            case "empgroup.id": 
            case "empgroup.name": {
                QFilter empGroupFilter = new QFilter("id", "in", (Object)SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hsas"));
                filters.add(empGroupFilter);
                break;
            }
            case "caltask.id": 
            case "caltask.name": 
            case "caltask.number": {
                Iterator iterator = filters.iterator();
                while (iterator.hasNext()) {
                    QFilter qfilter = (QFilter)iterator.next();
                    if (!SWCStringUtils.equals((String)qfilter.getProperty(), (String)"status")) continue;
                    iterator.remove();
                }
                this.addPermFilter(filters);
                break;
            }
            case "payrollgroup.id": 
            case "payrollgroup.name": 
            case "payrollscene.id": 
            case "payrollscene.name": 
            case "salaryfilehis.number": 
            case "salaryfilehis.id": {
                this.addPermFilter(filters);
                break;
            }
            case "paysubjecthis.name": 
            case "paysubjecthis.id": {
                this.addControlledPermFilter(filters, refEntityId);
                break;
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "payrollgroup.id": 
            case "payrollgroup.name": 
            case "payrollscene.id": 
            case "payrollscene.name": {
                this.addPermFilter(filters);
                break;
            }
        }
    }

    private void setAmoutFilter(List<QFilter> qFilters) {
        QFilter amountFilter = new QFilter("datatype.showtype", "=", (Object)"amount");
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"2");
        qFilters.add(enableFilter);
        qFilters.add(amountFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"exportlist")) {
            String isRight = operate.getOption().getVariableValue("ishasright", "false");
            if ("true".equals(isRight)) {
                return;
            }
            if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_paydetail", (String)"4730fc9f000004ae")) {
                this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u53d1\u653e\u660e\u7ec6", (String)"SWCPayDetailList_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"SWCPayDetailList_7", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "payroll": {
                OperationResult result = args.getOperationResult();
                List pkidCollection = result.getSuccessPkIds();
                this.updatePayrollState(pkidCollection);
                this.showOperationResult(result);
                break;
            }
        }
    }

    private void showOperationResult(OperationResult result) {
        result.setShowMessage(false);
        List pkidCollection = result.getSuccessPkIds();
        List failCollection = result.getAllErrorOrValidateInfo();
        if (null == pkidCollection || pkidCollection.size() < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u5bf9\u4ed8\u6b3e\u72b6\u6001\u4e3a\u201c\u5f85\u4ed8\u6b3e\u201d\uff0c\u672a\u751f\u6210\u4ee3\u53d1\u5355\uff0c\u94f6\u884c\u5361\u4fe1\u606f\u5b8c\u6574\uff0c\u672a\u5728\u94f6\u884c\u5361\u53d8\u66f4\u6d41\u7a0b\u4e2d\uff0c\u672a\u505c\u7f13\u53d1\uff0c\u672a\u7ec8\u6b62\u53d1\u653e\uff0c\u672a\u5e9f\u5f03\u7684\u660e\u7ec6\u64cd\u4f5c\u5b8c\u6210\u4ed8\u6b3e\u3002", (String)"SWCPayDetailList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        } else if (null == failCollection || failCollection.size() < 1) {
            String notification = ResManager.loadKDString((String)"\u4ed8\u6b3e\u6210\u529f\u3002", (String)"SWCPayDetailList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(notification);
        } else {
            int successCount = pkidCollection.size();
            int failCount = failCollection.size();
            int sumCount = successCount + failCount;
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u5b8c\u6210\u4ed8\u6b3e\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"SWCPayDetailList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), sumCount, successCount, failCount);
            ArrayList<String> failList = new ArrayList<String>();
            failList.add(ResManager.loadKDString((String)"\u53ea\u53ef\u5bf9\u4ed8\u6b3e\u72b6\u6001\u4e3a\u201c\u5f85\u4ed8\u6b3e\u201d\uff0c\u672a\u751f\u6210\u4ee3\u53d1\u5355\uff0c\u94f6\u884c\u5361\u4fe1\u606f\u5b8c\u6574\uff0c\u672a\u5728\u94f6\u884c\u5361\u53d8\u66f4\u6d41\u7a0b\u4e2d\uff0c\u672a\u505c\u7f13\u53d1\uff0c\u672a\u7ec8\u6b62\u53d1\u653e\uff0c\u672a\u5e9f\u5f03\u7684\u660e\u7ec6\u64cd\u4f5c\u5b8c\u6210\u4ed8\u6b3e\u3002", (String)"SWCPayDetailList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            FormShowParameter resultParameter = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u5b8c\u6210\u4ed8\u6b3e", (String)"SWCPayDetailList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)title, failList);
            this.getView().showForm(resultParameter);
        }
    }

    private void updatePayrollState(List<Object> pkidCollection) {
        SWCDataServiceHelper helperDetail = new SWCDataServiceHelper("hsas_paydetail");
        String properties_detail = "id, calpersonid,paystate,agencypaystate,payedtime";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", pkidCollection)};
        DynamicObject[] details = helperDetail.query(properties_detail, filters);
        if (null == details || details.length < 1) {
            return;
        }
        int expectedSize = details.length * 4 / 3;
        HashSet calPersonIds = Sets.newHashSetWithExpectedSize((int)expectedSize);
        for (DynamicObject detail : details) {
            detail.set("payedtime", (Object)new Date());
            Long calPkid = detail.getLong("calpersonid");
            calPersonIds.add(calPkid);
        }
        helperDetail.update(details);
        AgencyPayWriteBackService service = new AgencyPayWriteBackService();
        service.updateCaltablePayState((Set)calPersonIds);
    }

    private boolean checkLevelTable() {
        String isShard = this.getView().getPageCache().get("isShard");
        if (SWCStringUtils.isEmpty((String)isShard)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("bos_cbs_shard_config");
            QFilter filter = new QFilter("entitynumber", "=", (Object)"hsas_paydetail");
            filter.and(new QFilter("configstatus", "=", (Object)"2"));
            boolean exists = helper.isExists(new QFilter[]{filter});
            this.getView().getPageCache().put("isShard", Boolean.toString(exists));
            return exists;
        }
        return Boolean.parseBoolean(isShard);
    }

    private boolean checkPayrollDateValue(List<QFilter> qFilters) {
        if (qFilters.size() == 0) {
            return false;
        }
        Iterator<QFilter> iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter filter = iterator.next();
            if (!"payrolldate".equals(filter.getProperty())) continue;
            List nests = filter.getNests(false);
            if (nests == null || nests.size() != 1) {
                iterator.remove();
                return false;
            }
            if (this.IS_NOT_NULL.equals(filter.getCP())) {
                iterator.remove();
                return false;
            }
            if (nests.size() != 1) continue;
            Date beginDate = (Date)filter.getValue();
            Date endDate = (Date)((QFilter.QFilterNest)nests.get(0)).getFilter().getValue();
            long dif = (endDate.getTime() - beginDate.getTime()) / 86400000L;
            if (dif <= 365L) continue;
            iterator.remove();
            return false;
        }
        return true;
    }

    private HasPermOrgResult getHasPermOrgs() {
        return SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_paydetail", (String)"47150e89000000ac");
    }

    private void addPermFilter(List<QFilter> filters) {
        HasPermOrgResult permOrgs = this.getHasPermOrgs();
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            filters.add(new QFilter("org.id", "in", (Object)permOrgs.getHasPermOrgs()));
        }
    }

    private void addControlledPermFilter(List<QFilter> filters, String refEntityId) {
        QFilter baseDataFilter;
        HasPermOrgResult permOrgs = this.getHasPermOrgs();
        if (permOrgs != null && !permOrgs.hasAllOrgPerm() && (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)refEntityId, (List)permOrgs.getHasPermOrgs(), (boolean)true)) != null) {
            filters.add(baseDataFilter);
        }
    }

    private boolean isEnableNoPermBtn() {
        return PermCommonUtil.isEnableNoPermBtnHide();
    }
}

