/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.assignbankcard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.assignbankcard.AssignBankCardDTO;
import kd.swc.hsas.business.assignbankcard.AssignBankCardHelper;
import kd.swc.hsas.business.assignbankcard.AssignBankCardType;
import kd.swc.hsas.business.assignbankcard.MatchBankCardByRuleService;
import kd.swc.hsas.common.constants.AssignBankCardConstants;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class AssignBankCardList
extends SWCDataBaseList
implements AssignBankCardConstants {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "assignbankcard": {
                this.assignBankCard();
                args.setCancel(true);
                break;
            }
        }
    }

    private void assignBankCard() {
        long userId = RequestContext.get().getCurrUserId();
        boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_paydetail", (String)"2GIBYCJDRF+T");
        if (!permFlag) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u53d1\u653e\u660e\u7ec6\u201d\u7684\u201c\u8865\u5145\u94f6\u884c\u5361\u201d\u6743\u9650\u3002", (String)"AssignBankCardList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        List<AssignBankCardDTO> AssignBankCardDTOLists = this.findPayDetailAbleToAssign();
        if (AssignBankCardDTOLists.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94f6\u884c\u5361\u8865\u5145\u5931\u8d25\u3002\u8bf7\u786e\u4fdd\u660e\u7ec6\u5177\u6709\u6743\u9650\uff0c\u5e76\u540c\u65f6\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\uff1a\u2460\u94f6\u884c\u5361\u672a\u7ef4\u62a4\uff1b\u2461\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u7a7a\u6216\u89e3\u9664\uff1b\u2462\u94f6\u884c\u5361\u53d8\u66f4\u72b6\u6001\u4e3a\u7a7a\u6216\u5ba1\u6279\u4e0d\u901a\u8fc7\uff1b\u2463\u672a\u5e9f\u5f03\u3002", (String)"AssignBankCardList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        AssignBankCardType assignBankCardType = this.classifyDetailByManualOrNot(AssignBankCardDTOLists);
        MatchBankCardByRuleService matchBankCardByRuleService = new MatchBankCardByRuleService(assignBankCardType);
        boolean needOpen = this.countPayDetailMatchOrManualAssign(assignBankCardType = matchBankCardByRuleService.matchBankCardByRule());
        if (needOpen) {
            this.openAssignBankCardF7(assignBankCardType);
        }
    }

    private List<AssignBankCardDTO> findPayDetailAbleToAssign() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] payDetailIds = selectedRows.getPrimaryKeyValues();
        List payDetailIdList = Arrays.stream(payDetailIds).map(payDetailId -> Long.parseLong(String.valueOf(payDetailId))).collect(Collectors.toList());
        DynamicObject[] paydetailResults = AssignBankCardHelper.findDetailAbleToAssign(payDetailIdList);
        List<DynamicObject> paydetailResultsList = Arrays.asList(paydetailResults);
        ArrayList AssignBankCardDTOLists = Lists.newArrayListWithCapacity((int)10);
        paydetailResultsList.forEach(paydetailResult -> {
            AssignBankCardDTO assignBankCardDTO = new AssignBankCardDTO();
            assignBankCardDTO.setPayDetail(paydetailResult);
            AssignBankCardDTOLists.add(assignBankCardDTO);
        });
        return AssignBankCardDTOLists;
    }

    private AssignBankCardType classifyDetailByManualOrNot(List<AssignBankCardDTO> AssignBankCardDTOLists) {
        AssignBankCardType assignBankCardType = new AssignBankCardType();
        ArrayList notManualDTOList = Lists.newArrayListWithCapacity((int)10);
        ArrayList ruleHisIds = Lists.newArrayListWithCapacity((int)10);
        ArrayList boIds = Lists.newArrayListWithCapacity((int)10);
        for (AssignBankCardDTO assignBankCardDTO : AssignBankCardDTOLists) {
            DynamicObject paydetail = assignBankCardDTO.getPayDetail();
            Boolean isManually = paydetail.getBoolean("paysettinghis.ismanuallymodify");
            if (isManually.booleanValue()) {
                assignBankCardType.addDetailNeedManuallyAssign(assignBankCardDTO);
                continue;
            }
            Long paySettingRuleHisID = paydetail.getLong("paysettinghis.payrule.id");
            ruleHisIds.add(paySettingRuleHisID);
            notManualDTOList.add(assignBankCardDTO);
        }
        SWCDataServiceHelper ruleHelper = new SWCDataServiceHelper("hsas_payaccountcfg");
        QFilter boidFilter = new QFilter("id", "in", (Object)ruleHisIds);
        DynamicObject[] currentVersionQuerys = ruleHelper.query("id,boid", new QFilter[]{boidFilter});
        HashMap ruleHisCurrentMap = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(currentVersionQuerys).forEach(currentVersionQuery -> {
            Long Id = currentVersionQuery.getLong("id");
            Long boId = currentVersionQuery.getLong("boid");
            boIds.add(boId);
            ruleHisCurrentMap.put(Id, boId);
        });
        QFilter sourceFilter = new QFilter("id", "in", (Object)boIds);
        sourceFilter.and(new QFilter("status", "=", (Object)"C"));
        sourceFilter.and(new QFilter("enable", "=", (Object)"1"));
        String payCfgSelectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hsas_payaccountcfg");
        DynamicObject[] sourceQuerys = ruleHelper.query(payCfgSelectProperties, new QFilter[]{sourceFilter});
        HashMap currentSourceMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap currentQueryMap = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(sourceQuerys).forEach(sourceQuery -> {
            Long sourceVId = sourceQuery.getLong("sourcevid");
            Long Id = sourceQuery.getLong("id");
            currentSourceMap.put(Id, sourceVId);
            currentQueryMap.put(Id, sourceQuery);
        });
        notManualDTOList.forEach(notManualDTO -> {
            DynamicObject paydetail = notManualDTO.getPayDetail();
            Long ruleHisId = paydetail.getLong("paysettinghis.payrule.id");
            Long ruleCurrentId = (Long)ruleHisCurrentMap.get(ruleHisId);
            Long sourcevid = (Long)currentSourceMap.get(ruleCurrentId);
            if (ruleHisId != null && ruleHisId.equals(sourcevid)) {
                DynamicObject sourceQuery = (DynamicObject)currentQueryMap.get(ruleCurrentId);
                notManualDTO.setPayRule(sourceQuery);
                assignBankCardType.addDetailCardMatchByRule(notManualDTO);
            } else {
                assignBankCardType.addDetailNeedManuallyAssign(notManualDTO);
            }
        });
        return assignBankCardType;
    }

    private boolean countPayDetailMatchOrManualAssign(AssignBankCardType assignBankCardType) {
        List detailCardMatchByRule = assignBankCardType.getDetailCardMatchByRule();
        List detailNeedManuallyAssign = assignBankCardType.getDetailNeedManuallyAssign();
        int matchCount = detailCardMatchByRule.size();
        int manualCount = detailNeedManuallyAssign.size();
        int total = matchCount + manualCount;
        if (manualCount == 0) {
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u53d1\u653e\u660e\u7ec6\u8865\u5145\u94f6\u884c\u5361\u6210\u529f\u3002", (String)"AssignBankCardList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), matchCount), Integer.valueOf(5000));
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u6309\u89c4\u5219\u5339\u914d\u94f6\u884c\u5361\u6210\u529f\u3002", "AssignBankCardList_8", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"assignbankcard", (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            return false;
        }
        if (matchCount != 0) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u53d1\u653e\u660e\u7ec6\u7b26\u5408\u6761\u4ef6\uff0c{1}\u6761\u9700\u624b\u5de5\u6307\u5b9a\uff0c{2}\u6761\u5df2\u6309\u89c4\u5219\u91cd\u65b0\u5339\u914d\u94f6\u884c\u5361\uff0c\u5176\u4f59\u5df2\u4e3a\u60a8\u81ea\u52a8\u6392\u9664\u3002", (String)"AssignBankCardList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), total, manualCount, matchCount), Integer.valueOf(5000));
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u6309\u89c4\u5219\u5339\u914d\u94f6\u884c\u5361\u6210\u529f\u3002", "AssignBankCardList_8", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"assignbankcard", (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            return true;
        }
        this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u53d1\u653e\u660e\u7ec6\u7b26\u5408\u6761\u4ef6\uff0c{1}\u6761\u9700\u624b\u5de5\u6307\u5b9a\uff0c\u5176\u4f59\u5df2\u4e3a\u60a8\u81ea\u52a8\u6392\u9664\u3002", (String)"AssignBankCardList_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]), total, manualCount), Integer.valueOf(5000));
        return true;
    }

    private void openAssignBankCardF7(AssignBankCardType assignBankCardType) {
        List detailNeedManuallyAssign = assignBankCardType.getDetailNeedManuallyAssign();
        ArrayList payDetailIds = Lists.newArrayListWithExpectedSize((int)10);
        HashMap payDetailSalaryFileMap = Maps.newHashMapWithExpectedSize((int)16);
        detailNeedManuallyAssign.forEach(assignBankCardDTO -> {
            Long payDetailId = assignBankCardDTO.getPayDetail().getLong("id");
            payDetailIds.add(payDetailId);
            DynamicObject salaryFile = assignBankCardDTO.getPayDetail().getDynamicObject("salaryfilehis");
            if (salaryFile != null) {
                Long salaryFileId = salaryFile.getLong("id");
                payDetailSalaryFileMap.put(payDetailId, salaryFileId);
            }
        });
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)16);
        customParams.put("payDetailIds", payDetailIds);
        customParams.put("payDetailSalaryFileMap", payDetailSalaryFileMap);
        FormShowParameter assignBankCardShowParameter = new FormShowParameter();
        assignBankCardShowParameter.setFormId("hsas_assignbankcard");
        assignBankCardShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        assignBankCardShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_assignbankcard"));
        assignBankCardShowParameter.setCustomParams((Map)customParams);
        this.getView().showForm(assignBankCardShowParameter);
        MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u6307\u5b9a\u94f6\u884c\u5361\u9875\u9762\u6253\u5f00\u6210\u529f\u3002", "AssignBankCardList_7", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"assignbankcard", (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "hsas_assignbankcard": {
                this.showNotificationAndRefresh(closedCallBackEvent);
                break;
            }
        }
    }

    private void showNotificationAndRefresh(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        this.getView().invokeOperation("refresh");
        if (returnData == null || returnData.size() == 0) {
            return;
        }
        int successNum = (Integer)returnData.get("successNum");
        int failNum = (Integer)returnData.get("failNum");
        if (failNum == 0) {
            this.getView().showSuccessNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u53d1\u653e\u660e\u7ec6\u8865\u5145\u94f6\u884c\u5361\u6210\u529f\u3002", (String)"AssignBankCardList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), successNum), Integer.valueOf(5000));
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u624b\u52a8\u6307\u5b9a\u94f6\u884c\u5361\u6210\u529f\u3002", "AssignBankCardList_9", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"assignbankcard", (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
        } else {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u53d1\u653e\u660e\u7ec6\u8865\u5145\u94f6\u884c\u5361\u6210\u529f\uff0c{1}\u6761\u5931\u8d25\u3002\u660e\u7ec6\u9700\u6709\u6743\u9650\u4e14\u540c\u65f6\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\uff1a\u2460\u9700\u8981\u4f46\u672a\u7ef4\u62a4\u94f6\u884c\u5361\uff1b\u2461\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u7a7a\u6216\u201c\u89e3\u201d\uff1b\u2462\u94f6\u884c\u5361\u53d8\u66f4\u72b6\u6001\u4e3a\u7a7a\u6216\u201c\u5ba1\u6279\u4e0d\u901a\u8fc7\u201d\uff1b\u2463\u662f\u5426\u5e9f\u5f03\u7b49\u4e8e\u5426\u3002", (String)"AssignBankCardList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), successNum, failNum), Integer.valueOf(5000));
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u624b\u52a8\u6307\u5b9a\u94f6\u884c\u5361\u90e8\u5206\u6216\u5168\u90e8\u5931\u8d25\u3002", "AssignBankCardList_10", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"assignbankcard", (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
        }
    }
}

