/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.bankaccountmodifybill;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.swc.hsas.business.workflow.WorkflowHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BankAccountModifyList
extends AbstractListPlugin {
    private static final String UPDATE_PAYDETAIL = "updatepaydetail";
    private static final String OP_UPDATE_PAYDETAIL = "op_updatepaydetail";
    private static final String OPEN_PAYDETAIL = "openpaydetail";
    private static final String VIEW_FLOWCAHRT_PERMID = "0K6+MBJ9Z+KL";
    private Map<String, String> auditorsMap;
    private Map<Long, String> personsMap;

    public void initialize() {
        super.initialize();
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        List qFilters = setFilterEvent.getQFilters();
        this.changeMyselfFilter(qFilters);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent linkClick = args.getHyperLinkClickEvent();
        BillList billList = (BillList)linkClick.getSource();
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        if (selectedRow != null) {
            if ("auditornext".equals(linkClick.getFieldName())) {
                args.setCancel(true);
                long userId = RequestContext.get().getCurrUserId();
                boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_acctmodifybill", (String)VIEW_FLOWCAHRT_PERMID);
                if (!permFlag) {
                    String msg = ResManager.loadKDString((String)"\u65e0\u201c\u94f6\u884c\u5361\u53d8\u66f4\u5355-\u53d1\u653e\u660e\u7ec6\u53d8\u66f4\u201d\u7684\u201c\u67e5\u770b\u6d41\u7a0b\u56fe\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BankAccountModifyList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(msg);
                    return;
                }
                ListShowParameter listShow = (ListShowParameter)this.getView().getFormShowParameter();
                String pageId = listShow.getPageId();
                WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)selectedRow.getPrimaryKeyValue());
            }
            if ("billno".equals(linkClick.getFieldName())) {
                if (!this.isHaveUnionPerm(selectedRow.getPrimaryKeyValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u94f6\u884c\u5361\u53d8\u66f4\u5355-\u53d1\u653e\u660e\u7ec6\u53d8\u66f4\u5206\u5f55\u201d\u7684\u6240\u6709\u6570\u636e\u6743\u9650\uff0c\u65e0\u6cd5\u67e5\u770b\u53d8\u66f4\u5355\u8be6\u60c5\u3002", (String)"BankAccountModifyList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifybill");
                DynamicObject dynamicObject = helper.queryOne("acctmodifyway", selectedRow.getPrimaryKeyValue());
                IPageCache pageCache = this.getView().getPageCache();
                if ("3".equals(dynamicObject.getString("acctmodifyway"))) {
                    pageCache.put("isVisibleCollapse", "true");
                    pageCache.put("isneedcollapse", null);
                } else {
                    pageCache.put("isVisibleCollapse", null);
                    pageCache.put("isneedcollapse", "true");
                }
            }
        }
    }

    private void changeMyselfFilter(List<QFilter> qFilters) {
        FormShowParameter formShowParameter;
        List ids;
        boolean removeIf = qFilters.removeIf(qFilter -> "myself".equals(qFilter.getProperty()));
        if (removeIf) {
            QFilter filter = new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId());
            qFilters.add(filter);
        }
        if ((ids = (List)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam("defaultIds")) != null) {
            QFilter filter = new QFilter("id", "in", (Object)ids);
            qFilters.add(filter);
        }
    }

    private boolean isHaveUnionPerm(Object id) {
        String permItemId;
        String entityNum;
        String appId;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifybill");
        DynamicObject dynamicObject = helper.queryOne("entryentity.paydetail", id);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        HashSet<Long> payDetailIds = new HashSet<Long>(dynamicObjectCollection.size());
        for (DynamicObject payDetail : dynamicObjectCollection) {
            payDetailIds.add(payDetail.getLong("paydetail.id"));
        }
        long userId = RequestContext.get().getCurrUserId();
        List qFilterList = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((long)userId, (String)(appId = "/UHMBBGZQ65X"), (String)(entityNum = "hsas_paydetail"), (String)(permItemId = "47150e89000000ac"));
        if (qFilterList == null) {
            return false;
        }
        if (qFilterList.size() == 0) {
            return true;
        }
        int size = qFilterList.size();
        QFilter[] qFilters = new QFilter[size + 1];
        for (int i = 0; i < size; ++i) {
            qFilters[i] = (QFilter)qFilterList.get(i);
        }
        qFilters[size] = new QFilter("id", "in", payDetailIds);
        helper = new SWCDataServiceHelper("hsas_paydetail");
        DynamicObject[] dataArrays = helper.query("id", qFilters);
        if (dataArrays == null) {
            return false;
        }
        return dataArrays.length == payDetailIds.size();
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        super.beforeShowBill(event);
        BillShowParameter billShowParameter = event.getParameter();
        if (!billShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                ArrayList pkIds = new ArrayList(10);
                collection.forEach(coll -> pkIds.add(String.valueOf(coll.getPkValue())));
                if (!pkIds.isEmpty()) {
                    BankAccountModifyList.this.auditorsMap = WorkflowHelper.getNextAuditors(pkIds);
                    BankAccountModifyList.this.getPersonsMap(pkIds);
                }
                return collection;
            }
        });
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        if (event.getSource() instanceof ColumnDesc) {
            ColumnDesc columnDesc = (ColumnDesc)event.getSource();
            String key = columnDesc.getKey();
            if ("auditornext".equals(key) && MapUtils.isNotEmpty(this.auditorsMap)) {
                String auditor = this.auditorsMap.get(event.getRowData().getPkValue().toString());
                event.setFormatValue((Object)auditor);
            } else if ("personname".equals(key) && MapUtils.isNotEmpty(this.personsMap)) {
                Long id = event.getRowData().getLong("id");
                event.setFormatValue((Object)this.personsMap.get(id));
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List ids = (List)formShowParameter.getCustomParam("defaultIds");
        List filterColumns = args.getCommonFilterColumns();
        filterColumns.forEach(filterColumn -> {
            String fieldName = filterColumn.getFieldName();
            if (SWCStringUtils.equals((String)fieldName, (String)"myself") && ids != null) {
                filterColumn.setDefaultValue(null);
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection coll = args.getListSelectedData();
        Object[] ids = coll.getPrimaryKeyValues();
        switch (operateKey) {
            case "updatepaydetail": {
                int failNum = this.getUpdateFailCountByIds(ids);
                this.checkDoModifyPayDetail(failNum);
                break;
            }
            case "openpaydetail": {
                HashMap<String, Date> payrollDateMap = new HashMap<String, Date>(16);
                Set<Long> payDetailIds = this.getPayDetailIds(ids, payrollDateMap);
                this.openPayDetail(payDetailIds, payrollDateMap);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "op_updatepaydetail": {
                this.afterUpdateModifyBill(args);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("close");
            this.getView().sendFormAction(parentView);
        }
    }

    private void openPayDetail(Set<Long> payDetailIds, Map<String, Date> payrollDateMap) {
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("hsas_paydetail");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setCustomParam("defaultIds", payDetailIds);
        show.setCustomParam("defaultDateMap", payrollDateMap);
        show.setCustomParam("abandonedstatus", null);
        this.getView().showForm((FormShowParameter)show);
    }

    private Set<Long> getPayDetailIds(Object[] ids, Map<String, Date> payrollDateMap) {
        QFilter filter = new QFilter("id", "in", (Object)ids);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifybill");
        DynamicObject[] query = helper.query("entryentity.paydetail,entryentity.modifypaydetail", new QFilter[]{filter});
        HashSet<Long> payDetailIds = new HashSet<Long>(16);
        Date beginDate = null;
        Date endDate = null;
        for (DynamicObject dynamicObject : query) {
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : collection) {
                DynamicObject payDetail = entry.getDynamicObject("paydetail");
                Long id = payDetail.getLong("id");
                Date payrollDate = payDetail.getDate("payrolldate");
                if (beginDate == null || payrollDate.before(beginDate)) {
                    beginDate = payrollDate;
                }
                if (endDate == null || payrollDate.after(endDate)) {
                    endDate = payrollDate;
                }
                payDetailIds.add(id);
                payDetailIds.add(entry.getLong("modifypaydetail.id"));
            }
        }
        payrollDateMap.put("beginDate", beginDate);
        payrollDateMap.put("endDate", endDate);
        return payDetailIds;
    }

    private void afterUpdateModifyBill(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        operationResult.setShowMessage(false);
        int total = operationResult.getBillCount();
        int succeed = operationResult.getSuccessPkIds().size();
        int fail = total - succeed;
        if (fail <= 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u653e\u660e\u7ec6\u6210\u529f\u3002", (String)"BankAccountModifyList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        String format = ResManager.loadKDString((String)"\u5171{0}\u5f20\u53d8\u66f4\u5355\uff0c{1}\u5f20\u66f4\u65b0\u53d1\u653e\u660e\u7ec6\u6210\u529f\uff0c{2}\u5f20\u5931\u8d25\u3002", (String)"BankAccountModifyList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        String title = MessageFormat.format(format, total, succeed, fail);
        List failList = allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, (String)title, failList);
        this.getView().showForm(parameters);
        this.getView().invokeOperation("refresh");
    }

    private int getUpdateFailCountByIds(Object[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids);
        filter.and(new QFilter("updatestatus", "=", (Object)"F"));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifybill");
        int count = helper.count(new QFilter[]{filter});
        return count;
    }

    private void checkDoModifyPayDetail(int failNum) {
        if (failNum <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u5bf9\u66f4\u65b0\u72b6\u6001\u4e3a\u201c\u66f4\u65b0\u5931\u8d25\u201d\u7684\u53d8\u66f4\u5355\u64cd\u4f5c\u66f4\u65b0\u53d1\u653e\u660e\u7ec6\u3002", (String)"BankAccountModifyList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("needValidate", "1");
        this.getView().invokeOperation(OP_UPDATE_PAYDETAIL, operateOption);
    }

    private void getPersonsMap(List<String> pkIds) {
        this.personsMap = new HashMap<Long, String>(16);
        List ids = pkIds.stream().map(Long::parseLong).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifybill");
        DynamicObject[] collections = helper.query("id,acctmodifyway,billno,handler,creator,createtime,billstatus,entryentity.salaryfilehis", new QFilter[]{filter});
        HashSet<String> nameSet = new HashSet<String>(16);
        for (DynamicObject dynamicObject : collections) {
            Long id = dynamicObject.getLong("id");
            DynamicObjectCollection entryCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCollection) {
                String name = entry.getString("salaryfilehis.person.name");
                nameSet.add(name);
            }
            String nameStrings = String.join((CharSequence)",", nameSet);
            this.personsMap.put(id, nameStrings);
            nameSet.clear();
        }
    }
}

