/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.bankaccountmodifybill;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hsas.common.events.paydetail.BankAccountModifyFilterEvent;
import kd.swc.hsas.business.modifybankaccount.helper.BankAccountModifyHelper;
import kd.swc.hsas.common.constants.BankAccountModifyConstants;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class BankAccountModifyPlugin
extends SWCDataBaseEdit
implements BankAccountModifyConstants {
    private static final String OPEN_BANKCARD = "openbankcard";
    private static final String ADD_PAYDETAIL = "addpaydetail";
    private static final String OPEN_PAYDETAIL = "openpaydetail";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        UpdateTabNameHelper.updateTabName((IFormView)this.getView(), (String)"billno");
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setWorkflowVisible();
        this.setEntModifyTypeData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": {
                String bizKey = (String)this.getView().getFormShowParameter().getCustomParam("businessKey");
                operate.getOption().setVariableValue("bizKey", bizKey);
                break;
            }
            case "openbankcard": {
                this.openPersonBankCard();
                break;
            }
            case "unsubmit": {
                args.setCancel(this.checkBillStatus());
                break;
            }
            case "addpaydetail": {
                this.openPayDetailF7();
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().updateView();
                break;
            }
            case "openpaydetail": {
                boolean permFlag = SWCPermissionServiceHelper.hasViewPermission((String)"/UHMBBGZQ65X", (String)"hsas_paydetail");
                if (permFlag) {
                    this.openPayDetail();
                    break;
                }
                args.setCancel(true);
                break;
            }
            case "modify": {
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().updateView();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey;
        super.afterDoOperation(eventArgs);
        switch (operateKey = eventArgs.getOperateKey()) {
            case "submit": {
                boolean opResult = eventArgs.getOperationResult().isSuccess();
                if (!opResult) break;
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().setEnable(Boolean.TRUE, new String[]{"unsubmitpay"});
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "hsas_paydetail": {
                this.setRowValue(closedCallBackEvent);
                break;
            }
            case "hsas_perbankcardadd": {
                this.setModifyBankAcctRowValue(closedCallBackEvent);
                break;
            }
        }
    }

    private void openPersonBankCard() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        int acctmodifyway = dataEntity.getInt("acctmodifyway");
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject entry = (DynamicObject)collection.get(currentRowIndex);
        Long personId = entry.getLong("salaryfilehis.person.id");
        Long employeeId = entry.getLong("salaryfilehis.employee.id");
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_perbankcardadd", (boolean)false);
        Map<String, Object> map = this.cacheFirstBankInfoForCurrRow(currentRowIndex);
        map.put("person.id", personId);
        map.put("employee.id", employeeId);
        map.put("acctmodifyway", acctmodifyway);
        map.put("parententitynumber", "hsas_acctmodifybill");
        showParameter.setCustomParams(map);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_perbankcardadd"));
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        QFilter qFilter = new QFilter("employee.id", "=", (Object)employeeId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("isdelete", "=", (Object)"0"));
        qFilters.add(qFilter);
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openPayDetail() {
        HashSet<Long> payDetailIds = new HashSet<Long>(16);
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Date beginDate = null;
        Date endDate = null;
        HashMap<String, Date> payrollDateMap = new HashMap<String, Date>(16);
        for (DynamicObject entry : collection) {
            DynamicObject payDetail = entry.getDynamicObject("paydetail");
            Long id = payDetail.getLong("id");
            payDetailIds.add(id);
            payDetailIds.add(entry.getLong("modifypaydetail.id"));
            Date payrollDate = payDetail.getDate("payrolldate");
            if (beginDate == null || payrollDate.before(beginDate)) {
                beginDate = payrollDate;
            }
            if (endDate != null && !payrollDate.after(endDate)) continue;
            endDate = payrollDate;
        }
        payrollDateMap.put("beginDate", beginDate);
        payrollDateMap.put("endDate", endDate);
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("hsas_paydetail");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setCustomParam("defaultIds", payDetailIds);
        show.setCustomParam("defaultDateMap", payrollDateMap);
        show.setCustomParam("abandonedstatus", null);
        this.getView().showForm((FormShowParameter)show);
    }

    private void setRowValue(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
        if (selectedRows != null && !selectedRows.isEmpty()) {
            DynamicObject[] payDetails = this.queryDataForEnt(selectedRows.getPrimaryKeyValues());
            this.addDetailToEnt(payDetails);
        }
    }

    private void setModifyBankAcctRowValue(ClosedCallBackEvent event) {
        ListSelectedRow selectedRow;
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
        if (selectedRows != null && !selectedRows.isEmpty() && (selectedRow = selectedRows.get(0)) != null) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_perbankcard");
            DynamicObject bankInfo = helper.queryOne("id,sourcevid", selectedRow.getPrimaryKeyValue());
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().beginInit();
            this.getModel().setValue("modifyperbankcard", (Object)bankInfo.getLong("sourcevid"));
            this.getModel().endInit();
            this.getView().updateView("entryentity", currentRowIndex);
        }
    }

    private DynamicObject[] queryDataForEnt(Object[] primaryKeyValues) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        String selectFields = "id,salaryfilehis.id,caltask,perbankcard.id";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)};
        return helper.query(selectFields, filters);
    }

    private void addDetailToEnt(DynamicObject[] payDetails) {
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        TableValueSetter vsData = new TableValueSetter(new String[0]);
        this.initTableValueSetter(vsData);
        HashSet<Long> personIdSet = new HashSet<Long>(payDetails.length);
        for (DynamicObject payDetail : payDetails) {
            personIdSet.add(payDetail.getLong("salaryfilehis.person.id"));
        }
        Map perContactMap = BankAccountModifyHelper.getPerContactMapByPersonIds(new ArrayList(personIdSet));
        for (DynamicObject detail : payDetails) {
            vsData.addRow(new Object[]{detail.getLong("id"), detail.getLong("salaryfilehis.id"), detail.getLong("caltask.id"), detail.getLong("perbankcard.id"), perContactMap.getOrDefault(detail.getLong("salaryfilehis.person.id"), 0L), ResManager.loadKDString((String)"\u66f4\u6b63\u524d", (String)"BankAccountModifyPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u66f4\u6b63\u540e", (String)"BankAccountModifyPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0])});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", vsData);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void initTableValueSetter(TableValueSetter vsData) {
        vsData.addField("paydetail", new Object[0]);
        vsData.addField("salaryfilehis", new Object[0]);
        vsData.addField("caltask", new Object[0]);
        vsData.addField("perbankcard", new Object[0]);
        vsData.addField("percontact", new Object[0]);
        vsData.addField("beforemodify", new Object[0]);
        vsData.addField("aftermodify", new Object[0]);
    }

    private boolean checkBillStatus() {
        return "G".equals(this.getModel().getValue("billstatus"));
    }

    private void setWorkflowVisible() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String curNode = (String)formShowParameter.getCustomParam("CURNODE");
        if ("AuditTask5".equals(curNode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"operationcolumnap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"titlepanelflex"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"operationcolumnap"});
        }
    }

    private void setEntModifyTypeData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        String modifyWay = model.getDataEntity().getString("acctmodifyway");
        Boolean isShow = "2".equals(modifyWay) || "3".equals(modifyWay);
        boolean isPersonSelf = "1".equals(modifyWay);
        if (isPersonSelf && entryEntity.size() > 0) {
            Long personId = ((DynamicObject)entryEntity.get(0)).getLong("salaryfilehis.person.id");
            this.getPageCache().put("personId", String.valueOf(personId));
        }
        this.getView().setVisible(isShow, new String[]{"phone", "peremail"});
        for (int index = 0; index < entryEntity.size(); ++index) {
            model.setValue("beforemodify", (Object)ResManager.loadKDString((String)"\u66f4\u6b63\u524d", (String)"BankAccountModifyPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), index);
            model.setValue("aftermodify", (Object)ResManager.loadKDString((String)"\u66f4\u6b63\u540e", (String)"BankAccountModifyPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), index);
        }
        this.getView().updateView("entryentity");
        model.setDataChanged(false);
    }

    private void openPayDetailF7() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        List ids = dynamicObjectCollection.stream().map(dy -> dy.getLong("paydetail.id")).collect(Collectors.toList());
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"hsas_paydetail", (boolean)true);
        BankAccountModifyFilterEvent filterEvent = BankAccountModifyHelper.beforeBankAccountModifyFilterEvent();
        QFilter stateFilter = BankAccountModifyHelper.getPayStateFilter((BankAccountModifyFilterEvent)filterEvent);
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)10);
        if (stateFilter != null) {
            filterList.add(stateFilter);
        }
        QFilter filter = new QFilter("id", "not in", ids);
        filter.and(new QFilter("ismustbankcard", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE));
        QFilter modifyBillFilter = new QFilter("acctmodifybill", "in", Arrays.asList(0L, this.getModel().getDataEntity().getLong("id")));
        modifyBillFilter.or(new QFilter("acctmodifybill.billstatus", "=", (Object)"E"));
        filter.and(modifyBillFilter);
        long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        String appId = "/UHMBBGZQ65X";
        String entityNum = "hsas_paydetail";
        List qFilterList = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((long)userId, (String)appId, (String)entityNum, (String)permItemId);
        if (qFilterList == null) {
            filter.and(new QFilter("1", "!=", (Object)1));
        } else {
            for (QFilter qFilter : qFilterList) {
                filter.and(qFilter);
            }
        }
        filterList.add(filter);
        String modifyWay = dataEntity.getString("acctmodifyway");
        if ("1".equals(modifyWay)) {
            String personId = this.getPageCache().get("personId");
            filterList.add(new QFilter("salaryfilehis.person.id", "=", (Object)Long.parseLong(personId)));
        }
        ListFilterParameter listFilterParameter = para.getListFilterParameter();
        for (QFilter qFilter : filterList) {
            listFilterParameter.setFilter(qFilter);
        }
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_paydetail"));
        this.getView().showForm((FormShowParameter)para);
    }

    private Map<String, Object> cacheFirstBankInfoForCurrRow(int currentRowIndex) {
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)8);
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("hsas_perbankcardadd", currentRowIndex + "");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        long payDetailId = entryRowEntity.getLong("paydetail.id");
        customParams.put("paydetail", payDetailId);
        String firstCacheMark = "first" + payDetailId;
        String firstBankInfo = pageCache.get(firstCacheMark);
        if (firstBankInfo != null) {
            customParams.put("first", firstBankInfo);
            return customParams;
        }
        JSONObject bankInfoJson = new JSONObject();
        bankInfoJson.put("receivername", (Object)entryRowEntity.getString("perbankcard.username"));
        bankInfoJson.put("payrollacrel", entryRowEntity.get("perbankcard.accountrelation.id"));
        bankInfoJson.put("bankaccount", (Object)entryRowEntity.getString("perbankcard.bankcardnum"));
        bankInfoJson.put("bebank", entryRowEntity.get("perbankcard.bankdeposit.id"));
        bankInfoJson.put("perbankcard", entryRowEntity.get("perbankcard.id"));
        firstBankInfo = bankInfoJson.toJSONString();
        pageCache.put(firstCacheMark, firstBankInfo);
        customParams.put("first", firstBankInfo);
        return customParams;
    }
}

