/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.paydetail.bankoffer;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.swc.hsas.common.dto.BankOfferProgressInfo;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class BankOfferExportTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BankOfferExportTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> arg1) throws KDException {
        BankOfferProgressInfo progressInfo;
        String recordId = (String)arg1.get("recordId");
        int preProgress = 0;
        Date preChangeTime = new Date();
        while ((progressInfo = (BankOfferProgressInfo)SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_BANKOFFER_%s", recordId)).get("cache_bankreport_key", BankOfferProgressInfo.class)) != null) {
            int status = progressInfo.getStatus();
            int progress = 0;
            String desc = "";
            Integer total = progressInfo.getTotal();
            Integer finishCount = progressInfo.getFinish();
            if (!total.equals(0)) {
                progress = new BigDecimal(String.valueOf(finishCount)).divide(new BigDecimal(String.valueOf(total)), 2, 4).multiply(new BigDecimal("100")).intValue();
            }
            if (progress >= 100) {
                desc = ResManager.loadKDString((String)"\u94f6\u884c\u62a5\u76d8\u5bfc\u51fa\u5df2\u5b8c\u6210\u3002", (String)"BankOfferExportTask_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.feedbackProgress(progress, desc, null);
                logger.info(desc);
                break;
            }
            desc = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u94f6\u884c\u62a5\u76d8\u5bfc\u51fa\u8fdb\u5ea6\u4e3a\uff1a%d%%", (String)"BankOfferExportTask_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), progress);
            logger.info(desc);
            this.feedbackProgress(progress, desc, null);
            if (status == 2) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("sleep failed:{}", (Object)e.getMessage());
            }
            Date now = new Date();
            if (progress != preProgress) {
                preProgress = progress;
                preChangeTime = now;
            }
            if (now.getTime() - preChangeTime.getTime() <= 10800000L) continue;
            break;
        }
    }
}

