/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.payrollgroup;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.payrollgrp.PayrollGrpHelper;
import kd.swc.hsbp.business.cost.CostHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PayrollGroupCostAdaptionEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    public static final String HR_ORG = "hrorg";
    public static final String COST_SET = "costset";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (CostHelper.isEnableCost()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{HR_ORG, COST_SET});
            Long pkId = (Long)this.getModel().getDataEntity().getPkValue();
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costadaptionmap");
            QFilter qFilter = new QFilter("mapobj.id", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP);
            Map params = this.getView().getFormShowParameter().getCustomParams();
            if (pkId == 0L && BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
                pkId = (Long)params.get("currentDataId");
            }
            if (pkId == 0L) {
                return;
            }
            qFilter.and(new QFilter("source", "=", (Object)pkId));
            DynamicObject costAdaptionObj = serviceHelper.queryOne("hrorg,costadaption", new QFilter[]{qFilter});
            if (costAdaptionObj != null) {
                this.getModel().setValue(HR_ORG, (Object)costAdaptionObj.getLong("hrorg.id"));
                this.getModel().setValue("costadaption", (Object)costAdaptionObj.getLong("costadaption.id"));
                this.getModel().setDataChanged(false);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{HR_ORG, COST_SET});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costAdaptionEdit = (BasedataEdit)this.getView().getControl("costadaption");
        costAdaptionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit hrOrgEdit = (BasedataEdit)this.getView().getControl(HR_ORG);
        hrOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "confirmchange": {
                OperationResult operationResult = args.getOperationResult();
                if (!CostHelper.isEnableCost() || !operationResult.isSuccess()) break;
                this.saveCostAdaptionInfo();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("country".equals(propName) || HR_ORG.equals(propName)) {
            if (!CostHelper.isEnableCost()) {
                return;
            }
            this.getModel().setValue("costadaption", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName;
        switch (propertyName = event.getProperty().getName()) {
            case "costadaption": {
                PayrollGrpHelper.setFilter((BeforeF7SelectEvent)event, (IFormView)this.getView());
                break;
            }
            case "hrorg": {
                HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"/UHMBBGZQ65X", (String)"hsas_payrollgrp", (String)"47150e89000000ac");
                boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
                if (hasAllOrgPerm) break;
                ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
                QFilter qFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
                param.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    private void saveCostAdaptionInfo() {
        DynamicObject payrollGroupHis = this.getModel().getDataEntity();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Long pkId = (Long)params.get("boid");
        Long id = payrollGroupHis.getLong("id");
        SWCDataServiceHelper payrollGroupHelper = new SWCDataServiceHelper("pcs_costadaptionmap");
        QFilter qFilter = new QFilter("mapobj.id", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP);
        qFilter.and(new QFilter("source", "in", (Object)new Long[]{id, pkId}));
        DynamicObject[] costAdaptionMappingObjArr = payrollGroupHelper.query("status,source,costadaption,modifytime,modifier,hrorg", new QFilter[]{qFilter});
        HashMap<Long, DynamicObject> costAdaptionMappingObjMap = new HashMap<Long, DynamicObject>(2);
        for (DynamicObject costAdaptionMappingObj : costAdaptionMappingObjArr) {
            costAdaptionMappingObjMap.put(costAdaptionMappingObj.getLong("source"), costAdaptionMappingObj);
        }
        Date currentDate = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject costAdaptionMappingObj = (DynamicObject)costAdaptionMappingObjMap.get(id);
        Long costAdaptionId = payrollGroupHis.getLong("costadaption.id");
        Long hrOrgId = payrollGroupHis.getLong("hrorg.id");
        if (costAdaptionMappingObj == null) {
            costAdaptionMappingObj = this.getDynamicObject(payrollGroupHelper, currentDate, userId);
            costAdaptionMappingObj.set("source", (Object)id);
        }
        costAdaptionMappingObj.set("costadaption", (Object)costAdaptionId);
        costAdaptionMappingObj.set(HR_ORG, (Object)hrOrgId);
        costAdaptionMappingObj.set("status", (Object)"C");
        costAdaptionMappingObj.set("modifier", (Object)userId);
        costAdaptionMappingObj.set("modifytime", (Object)currentDate);
        DynamicObject costAdaptionMappingBoObj = (DynamicObject)costAdaptionMappingObjMap.get(pkId);
        if (costAdaptionMappingBoObj == null) {
            costAdaptionMappingBoObj = this.getDynamicObject(payrollGroupHelper, currentDate, userId);
            costAdaptionMappingBoObj.set("source", (Object)pkId);
            costAdaptionMappingBoObj.set("status", (Object)"C");
        }
        costAdaptionMappingBoObj.set("costadaption", (Object)costAdaptionId);
        costAdaptionMappingBoObj.set(HR_ORG, (Object)hrOrgId);
        costAdaptionMappingBoObj.set("modifier", (Object)userId);
        costAdaptionMappingBoObj.set("modifytime", (Object)currentDate);
        payrollGroupHelper.saveOne(costAdaptionMappingObj);
        payrollGroupHelper.saveOne(costAdaptionMappingBoObj);
    }

    private DynamicObject getDynamicObject(SWCDataServiceHelper payrollGroupHelper, Date currentDate, Long userId) {
        DynamicObject costAdaptionMappingBoObj = payrollGroupHelper.generateEmptyDynamicObject();
        costAdaptionMappingBoObj.set("createtime", (Object)currentDate);
        costAdaptionMappingBoObj.set("creator", (Object)userId);
        costAdaptionMappingBoObj.set("modifier", (Object)userId);
        costAdaptionMappingBoObj.set("modifytime", (Object)currentDate);
        costAdaptionMappingBoObj.set("mapobj", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP);
        return costAdaptionMappingBoObj;
    }
}

