/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.payrollgroup;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PayrollGroupSalSlipSumEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String IS_SALARY_SLIP_SUM = "issalaryslipsum";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getModel().getDataEntity().getBoolean(IS_SALARY_SLIP_SUM)) {
            FieldEdit fieldEdit = (FieldEdit)this.getControl("payrollgrpmulsum");
            fieldEdit.setMustInput(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit salarySlipViewBasedata = (BasedataEdit)this.getView().getControl("salaryslipview");
        salarySlipViewBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payRollGrpMulSumBasedata = (BasedataEdit)this.getView().getControl("payrollgrpmulsum");
        payRollGrpMulSumBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        switch (name) {
            case "issalaryslipsum": {
                if (!((Boolean)changeData.getNewValue()).booleanValue()) {
                    this.clearPayRollGrpMulSum();
                }
                FieldEdit fieldEdit = (FieldEdit)this.getControl("payrollgrpmulsum");
                fieldEdit.setMustInput(((Boolean)changeData.getNewValue()).booleanValue());
                break;
            }
            case "country": {
                this.clearPayRollGrpMulSum();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName;
        switch (propertyName = event.getProperty().getName()) {
            case "salaryslipview": 
            case "payrollgrpmulsum": {
                long country = this.getModel().getDataEntity().getLong("country.id");
                if (country == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u56fd\u5bb6/\u5730\u533a\u3002", (String)"PayRollSceneControlEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    break;
                }
                QFilter qFilter = new QFilter("country", "=", (Object)country);
                QFilter commonQFilter = SWCPayRollSceneService.createInstance().getCommonQFilter(this.getModel().getDataEntity(), "org", "country", propertyName);
                ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
                param.getListFilterParameter().setFilter(qFilter.and(commonQFilter));
                break;
            }
        }
    }

    private void clearPayRollGrpMulSum() {
        this.getModel().setValue("payrollgrpmulsum", null);
    }
}

