/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.payrollsecene;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.payrollscene.errorinfo.PayRollSceneErrorInfo;
import kd.swc.hsas.business.payrollscene.helper.SWCPayRollSceneHelper;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsbp.business.datachanged.BizChangedHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.constants.WtcInteCfgConstants;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCEntryEntityCopyUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.SceneGroupVO;
import kd.swc.hsbp.common.vo.SceneRuleVO;

public class SWCPayRollSceneEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener,
EntryGridSetRowDataListener {
    private static final String CACHE_BIZ_DATA_ID_SET = "bizDataIdSetCache";
    private static final String ADD_SALARY_CAL_STYLE = "add_salary_cal_cstyle";
    private static final String DELETE_ENTRY = "deleteentry";
    private static final String ADD_GROUP = "donothing_addgroup";
    private static final String MODIFY_GROUP = "donothing_modifygroup";
    private static final String DEL_GROUP = "donothing_delgroup";
    private static final String KEY_CHOOSEINDEX = "chooseindex";
    private static final String KEY_GROUPCONTENT = "groupcontent";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        SWCPayRollSceneService.createInstance().multiSetBeforeF7SelectListener((Object)this, new String[]{"periodtype", "calrule", "callistrule", "calbordermulbd", "salaryslipview", "callistview", "schemeaftercal", "genbizdata"});
        this.addClickListeners(new String[]{"calbordermulbd"});
        this.addClickListeners(new String[]{ADD_SALARY_CAL_STYLE});
        this.addClickListeners(new String[]{DELETE_ENTRY});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addSetRowDataListener((EntryGridSetRowDataListener)this);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        Boolean visible = this.getModel().getDataEntity(true).getBoolean("lssuepayslip");
        this.setSalSlipInfoVisible(visible);
        this.initSchemeAfterCal(true);
        Boolean isEnableAtt = (Boolean)this.getModel().getValue("isenableatt");
        if (isEnableAtt.booleanValue()) {
            this.getView().setVisible(isEnableAtt, new String[]{"isenableatt"});
        } else {
            boolean enableWtcInte = this.isEnableWtcInte();
            this.getView().setVisible(Boolean.valueOf(enableWtcInte), new String[]{"isenableatt"});
        }
        this.setMatchAttPeriodVisible();
        List<SceneGroupVO> groups = this.getGroups();
        List sortRules = groups.stream().sorted(Comparator.comparingInt(SceneGroupVO::getIndex)).collect(Collectors.toList());
        if (sortRules.size() > 0) {
            int chooseIndex = this.getModel().getDataEntity().getInt(KEY_CHOOSEINDEX);
            if (chooseIndex == 0) {
                this.getModel().setValue(KEY_CHOOSEINDEX, (Object)((SceneGroupVO)sortRules.get(0)).getIndex());
            }
            this.updateRuleAp();
        } else {
            SceneGroupVO vo = new SceneGroupVO();
            vo.setIndex(1);
            vo.setName(ResManager.getLocaleString((String)"\u9ed8\u8ba4\u89c4\u5219", (String)"SWCPayRollSceneEdit_1", (String)"swc-hsas-formplugin"));
            groups.add(vo);
            this.getModel().setValue(KEY_CHOOSEINDEX, (Object)vo.getIndex());
            this.getModel().setValue(KEY_GROUPCONTENT, (Object)JSON.toJSONString(groups));
            this.updateRuleAp();
        }
        this.getModel().setDataChanged(false);
        this.lockBizDataCellIfNeeded(null);
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        SWCPayRollSceneService.createInstance().lockCommonFields(this.getView());
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.lockBizDataCellIfNeeded(null);
        this.getView().updateView("entryentity");
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        IPageCache pageCache = entryGrid.getView().getPageCache();
        if (pageCache != null) {
            pageCache.put("BOS.setRowDataByNumberAutoAddRow", Boolean.FALSE.toString());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData changeData;
        String key = args.getProperty().getName();
        if (SWCArrayUtils.isEmpty((Object[])args.getChangeSet()) || (changeData = args.getChangeSet()[0]) == null) {
            return;
        }
        switch (key) {
            case "org": 
            case "country": {
                this.clearInfoIfCountryAndOrgChanged(key, changeData);
                break;
            }
            case "attachcondition": {
                boolean update = false;
                for (ChangeData data : args.getChangeSet()) {
                    if (data == null) continue;
                    update = true;
                    this.updateMultiBizDataEntryViewList(data);
                }
                if (update) {
                    this.lockBizDataCellIfNeeded(null);
                }
                this.getView().updateView("entryentity");
                break;
            }
            case "lssuepayslip": {
                Boolean visible = Boolean.TRUE.equals(changeData.getNewValue());
                this.setSalSlipInfoVisible(visible);
                break;
            }
            case "isenableatt": {
                this.setMatchAttPeriodVisible();
                break;
            }
            case "aftercaltype": {
                this.initSchemeAfterCal(false);
                break;
            }
            case "schemeaftercal": {
                this.changeGenbizdataVisible();
                break;
            }
        }
        if ("salarycalcstyle".equals(key) || "attachcondition".equals(key) || "calbordermulbd".equals(key) || "callistrule".equals(key)) {
            this.setEntryToGroupContent();
        }
    }

    private void setEntryToGroupContent() {
        int currentRowIndex = this.getModel().getDataEntity().getInt(KEY_CHOOSEINDEX);
        List<SceneGroupVO> groups = this.getGroups();
        SceneGroupVO group = groups.stream().filter(o -> o.getIndex() == currentRowIndex).findAny().orElse(null);
        if (group != null) {
            DynamicObject calListRule = this.getModel().getDataEntity().getDynamicObject("callistrule");
            DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            group.setCalListRuleId(calListRule != null ? Long.valueOf(calListRule.getLong("id")) : null);
            ArrayList<SceneRuleVO> rules = new ArrayList<SceneRuleVO>(10);
            for (DynamicObject entry : entryColl) {
                SceneRuleVO rule = new SceneRuleVO();
                rule.setAttachcondition(entry.getString("attachcondition"));
                rule.setCalcstyle(Long.valueOf(entry.getLong("salarycalcstyle.id")));
                DynamicObjectCollection mulbizItems = entry.getDynamicObjectCollection("calbordermulbd");
                if (mulbizItems != null) {
                    List bizItems = mulbizItems.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
                    rule.setBizItems(bizItems);
                }
                rules.add(rule);
            }
            group.setRules(rules);
        }
        this.getModel().setValue(KEY_GROUPCONTENT, (Object)JSON.toJSONString(groups));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "add_salary_cal_cstyle": {
                List<String> fieldList = Arrays.asList("org", "country");
                if (this.checkFieldInValid(fieldList)) {
                    args.setCancel(true);
                    break;
                }
                this.openSalaryCalStyleBaseView();
                break;
            }
            case "deleteentry": {
                this.deleteCache(args);
                break;
            }
            case "changesave": 
            case "save": 
            case "submit": 
            case "donothing_confirmchange": 
            case "auditconfirmchange": 
            case "confirmchangenoaudit": {
                OperateOption option = formOperate.getOption();
                option.setVariableValue("isDetail", Boolean.TRUE.toString());
                break;
            }
            case "donothing_addgroup": {
                this.showAddGroupForm();
                break;
            }
            case "donothing_modifygroup": {
                this.showModiyGroupForm();
                break;
            }
            case "donothing_delgroup": {
                this.delGroup();
                break;
            }
        }
    }

    private void showModiyGroupForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsas_addrulegroup");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MODIFY_GROUP));
        List<SceneGroupVO> groups = this.getGroups();
        List indexs = groups.stream().map(SceneGroupVO::getIndex).collect(Collectors.toList());
        int currentRowIndex = this.getModel().getDataEntity().getInt(KEY_CHOOSEINDEX);
        SceneGroupVO group = groups.stream().filter(o -> o.getIndex() == currentRowIndex).findAny().orElse(null);
        if (group != null) {
            parameter.setCustomParam("indexs", indexs);
            parameter.setCustomParam("name", (Object)JSON.toJSONString((Object)group.getName()));
            parameter.setCustomParam("index", (Object)group.getIndex());
            this.getView().showForm(parameter);
        }
    }

    private void showAddGroupForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsas_addrulegroup");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_GROUP));
        List<SceneGroupVO> groups = this.getGroups();
        List indexs = groups.stream().map(SceneGroupVO::getIndex).collect(Collectors.toList());
        parameter.setCustomParam("indexs", indexs);
        this.getView().showForm(parameter);
    }

    private void delGroup() {
        int currentRowIndex = this.getModel().getDataEntity().getInt(KEY_CHOOSEINDEX);
        List<SceneGroupVO> groups = this.getGroups();
        if (groups.size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u5206\u7ec4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u7ec4\u89c4\u5219\u3002", (String)"SWCPayRollSceneEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        groups.removeIf(o -> o.getIndex() == currentRowIndex);
        this.getModel().setValue(KEY_GROUPCONTENT, (Object)JSON.toJSONString(groups));
        this.getModel().setValue(KEY_CHOOSEINDEX, (Object)(groups.size() > 0 ? groups.get(0).getIndex() : 0));
        this.updateRuleAp();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
        switch (name) {
            case "calrule": {
                List<String> fieldList = Arrays.asList("org", "country");
                if (this.checkFieldInValid(fieldList)) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                DynamicObject data = this.getModel().getDataEntity();
                String afterCalType = data.getString("aftercaltype");
                QFilter afterCalTypeFilter = null;
                afterCalTypeFilter = "1".equals(afterCalType) ? new QFilter("aftercaltype", "=", (Object)"1") : new QFilter("aftercaltype", "=", (Object)"2");
                QFilter filter = sceneService.getCommonQFilter(this.getModel().getDataEntity(), "org", "country", name);
                beforeF7SelectEvent.addCustomQFilter(filter);
                beforeF7SelectEvent.addCustomQFilter(afterCalTypeFilter);
                break;
            }
            case "periodtype": 
            case "salaryslipview": {
                List<String> fieldList = Arrays.asList("org", "country");
                if (this.checkFieldInValid(fieldList)) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter filter = sceneService.getCommonQFilter(this.getModel().getDataEntity(), "org", "country", name);
                beforeF7SelectEvent.addCustomQFilter(filter);
                break;
            }
            case "callistview": 
            case "callistrule": {
                List<String> fieldList = Collections.singletonList("org");
                if (this.checkFieldInValid(fieldList)) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter filter = sceneService.getCommonQFilter(this.getModel().getDataEntity(), "org", null, name);
                beforeF7SelectEvent.addCustomQFilter(filter);
                break;
            }
            case "calbordermulbd": {
                List<String> fieldList = Arrays.asList("org", "country");
                if (this.checkFieldInValid(fieldList)) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter filter = sceneService.getCommonQFilter(this.getModel().getDataEntity(), "org", "country", name);
                filter.and("islistgenerate", "=", (Object)"1");
                filter.and("cycle", "=", (Object)"0");
                if ("getLookUpList".equals(beforeF7SelectEvent.getSourceMethod()) || "setItemByIdFromClient".equals(beforeF7SelectEvent.getSourceMethod()) || "setItemByNumber".equals(beforeF7SelectEvent.getSourceMethod())) {
                    beforeF7SelectEvent.addCustomQFilter(filter);
                    break;
                }
                if ("click".equals(beforeF7SelectEvent.getSourceMethod())) {
                    beforeF7SelectEvent.setCancel(true);
                    this.openBizDataMultiSelectedView();
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "schemeaftercal": 
            case "genbizdata": {
                QFilter countryFilter;
                List<String> fieldList = Collections.singletonList("org");
                if (this.checkFieldInValid(fieldList)) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter filter = sceneService.getCommonQFilter(this.getModel().getDataEntity(), "org", "country", name);
                if (SWCStringUtils.equals((String)"schemeaftercal", (String)name)) {
                    filter.and("number", "!=", (Object)"1010_S");
                }
                if ((countryFilter = this.getCountryFilter()) == null) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                beforeF7SelectEvent.addCustomQFilter(filter);
                beforeF7SelectEvent.addCustomQFilter(countryFilter);
                break;
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent event) {
        this.lockBizDataCellIfNeeded(null);
    }

    public void entryGridSetRowData(EntryGridSetRowDataEvent event) {
        Map columnMap = event.getValues();
        if (columnMap == null || columnMap.isEmpty()) {
            return;
        }
        columnMap.remove("salarycalcstyle");
        Map customColumnMap = SWCEntryEntityCopyUtils.getRowColumnVal((Map)columnMap);
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        this.getModel().beginInit();
        for (Map.Entry customColumnEntry : customColumnMap.entrySet()) {
            Boolean hasBizData;
            String attachConditionVal;
            if (customColumnEntry.getKey() == null || (Integer)customColumnEntry.getKey() > entryEntity.size()) continue;
            Integer index = (Integer)customColumnEntry.getKey();
            DynamicObject entity = (DynamicObject)entryEntity.get(index.intValue());
            Map cellsInCurrRow = (Map)customColumnEntry.getValue();
            Object attachCond = cellsInCurrRow.get("attachcondition");
            if (!(attachCond instanceof String) || (attachConditionVal = ((String)attachCond).trim()).length() == 0) {
                attachConditionVal = entity.getString("attachcondition");
            }
            String string = attachConditionVal = (hasBizData = Boolean.valueOf("1".equals(attachConditionVal))) != false ? "1" : "0";
            if (!hasBizData.booleanValue()) {
                this.getModel().setValue("calbordermulbd", null);
                List bizDataTuples = (List)columnMap.get("calbordermulbd");
                if (bizDataTuples != null && !bizDataTuples.isEmpty()) {
                    bizDataTuples.removeIf(bizDataTuple -> index.equals(bizDataTuple.item1));
                }
            }
            this.getModel().setValue("attachcondition", (Object)attachConditionVal, index.intValue());
            this.getView().setEnable(hasBizData, index.intValue(), new String[]{"calbordermulbd"});
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.lockBizDataCellIfNeeded(null);
        columnMap.remove("attachcondition");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "hsas_salarycalcstyle": {
                this.updateEntryEntity(returnData);
                break;
            }
            case "hsbs_bizitem": {
                if (!(returnData instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection collection = (ListSelectedRowCollection)returnData;
                this.getView().getModel().setValue("calbordermulbd", (Object)collection.getPrimaryKeyValues());
                break;
            }
            case "donothing_addgroup": {
                this.addGroup((Map)returnData);
                break;
            }
            case "donothing_modifygroup": {
                this.modifyGroup((Map)returnData);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "deleteentry": {
                this.setEntryToGroupContent();
                break;
            }
            case "changesave": 
            case "save": 
            case "submit": 
            case "donothing_confirmchange": 
            case "auditconfirmchange": 
            case "confirmchangenoaudit": {
                this.updateRuleAp();
                break;
            }
        }
    }

    private void modifyGroup(Map groupData) {
        OrmLocaleValue localName = (OrmLocaleValue)groupData.get("name");
        LocaleString name = new LocaleString();
        name.putAll((Map)localName);
        Integer index = (Integer)groupData.get("index");
        int currentRowIndex = this.getModel().getDataEntity().getInt(KEY_CHOOSEINDEX);
        List<SceneGroupVO> groups = this.getGroups();
        SceneGroupVO group = groups.stream().filter(o -> o.getIndex() == currentRowIndex).findAny().orElse(null);
        if (group != null) {
            group.setName(name);
            group.setIndex(index.intValue());
            this.getModel().setValue(KEY_CHOOSEINDEX, (Object)index);
            this.getModel().setValue(KEY_GROUPCONTENT, (Object)JSON.toJSONString(groups));
            this.updateRuleAp();
        }
    }

    private void addGroup(Map groupData) {
        OrmLocaleValue localName = (OrmLocaleValue)groupData.get("name");
        LocaleString name = new LocaleString();
        name.putAll((Map)localName);
        Integer index = (Integer)groupData.get("index");
        List<SceneGroupVO> groups = this.getGroups();
        SceneGroupVO group = new SceneGroupVO();
        group.setName(name);
        group.setIndex(index.intValue());
        group.setRules(new ArrayList(10));
        groups.add(group);
        this.getModel().setValue(KEY_GROUPCONTENT, (Object)JSON.toJSONString(groups));
        this.getModel().setValue(KEY_CHOOSEINDEX, (Object)index);
        this.updateRuleAp();
    }

    private void updateRuleAp() {
        FlexPanelAp rulegroupsap = new FlexPanelAp();
        rulegroupsap.setKey("rulegroupsap");
        rulegroupsap.setDirection("column");
        rulegroupsap.setJustifyContent("flex-start");
        rulegroupsap.setAlignItems("stretch");
        rulegroupsap.setGrow(0);
        rulegroupsap.setWrap(false);
        List<SceneGroupVO> groups = this.getGroups();
        int currentRowIndex = this.getModel().getDataEntity().getInt(KEY_CHOOSEINDEX);
        List sortRules = groups.stream().sorted(Comparator.comparingInt(SceneGroupVO::getIndex)).collect(Collectors.toList());
        for (SceneGroupVO rule : sortRules) {
            FlexPanelAp panelAp = new FlexPanelAp();
            panelAp.setGrow(0);
            panelAp.setKey("rulegroupsap_" + rule.getIndex());
            panelAp.setHeight(new LocaleString("50px"));
            panelAp.setDirection("row");
            panelAp.setWrap(false);
            panelAp.setShrink(0);
            panelAp.setJustifyContent("flex-start");
            panelAp.setAlignItems("center");
            panelAp.setClickable(true);
            Style style = new Style();
            Border border = new Border();
            String borderStyle = "1px_solid_#e5e5e5";
            border.setRight(borderStyle);
            border.setBottom(borderStyle);
            style.setBorder(border);
            Padding padding = new Padding();
            padding.setLeft("20px");
            style.setPadding(padding);
            panelAp.setStyle(style);
            LabelAp labelAp = new LabelAp();
            labelAp.setName(rule.getName());
            labelAp.setKey("rulegroupname_" + rule.getIndex());
            panelAp.getItems().add(labelAp);
            panelAp.setBackColor("#f5f5f5");
            if (currentRowIndex == rule.getIndex()) {
                border.setLeft("3px_solid_themeColor");
                border.setRight("");
                labelAp.setForeColor("themeColor");
                panelAp.setBackColor("#ffffff");
                AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
                model.beginInit();
                model.deleteEntryData("entryentity");
                model.setValue("callistrule", null);
                Long calListRuleId = rule.getCalListRuleId();
                if (calListRuleId != null) {
                    this.getModel().setValue("callistrule", (Object)calListRuleId);
                }
                TableValueSetter setter = new TableValueSetter(new String[0]);
                setter.addField("salarycalcstyle", new Object[0]);
                setter.addField("attachcondition", new Object[0]);
                List rules = rule.getRules();
                if (rules != null) {
                    for (SceneRuleVO sceneRuleVO : rules) {
                        setter.addRow(new Object[]{sceneRuleVO.getCalcstyle(), sceneRuleVO.getAttachcondition()});
                    }
                    model.batchCreateNewEntryRow("entryentity", setter);
                    for (int i = 0; i < rules.size(); ++i) {
                        model.setValue("calbordermulbd", (Object)((SceneRuleVO)rules.get(i)).getBizItems().toArray(), i);
                    }
                }
                model.endInit();
                this.getView().updateView("entryentity");
                this.getView().updateView("callistrule");
            }
            rulegroupsap.getItems().add(panelAp);
        }
        this.getView().updateControlMetadata("rulegroupsap", rulegroupsap.createControl());
    }

    private QFilter getCountryFilter() {
        DynamicObject country = (DynamicObject)this.getModel().getValue("country");
        if (country == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u56fd\u5bb6/\u5730\u533a\u3002", (String)"SWCPayRollSceneEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return null;
        }
        QFilter filter = new QFilter("country", "=", (Object)country.getLong("id"));
        filter.or(new QFilter("areatype", "=", (Object)"1"));
        return filter;
    }

    private void initSchemeAfterCal(boolean init) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String afterCalType = dataEntity.getString("aftercaltype");
        if (SWCStringUtils.equals((String)"1", (String)afterCalType)) {
            SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
            Long schemeAfterCal = sceneService.getDefaultSchemeAfterCal();
            this.getModel().setValue("schemeaftercal", (Object)schemeAfterCal);
            this.getView().setEnable(Boolean.FALSE, new String[]{"schemeaftercal"});
            this.changeGenbizdataVisible(schemeAfterCal);
            this.getView().setVisible(Boolean.TRUE, new String[]{"salslipflex"});
        } else {
            long schemeAfterCalId = dataEntity.getLong("schemeaftercal.id");
            if (!init) {
                this.getModel().setValue("schemeaftercal", null);
            }
            this.changeGenbizdataVisible(schemeAfterCalId);
            this.getView().setEnable(Boolean.TRUE, new String[]{"schemeaftercal"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"salslipflex"});
            this.getModel().setValue("lssuepayslip", (Object)Boolean.FALSE);
            this.getModel().setValue("releasesalaryslip", null);
            this.getModel().setValue("salaryslipview", null);
        }
        if (!init) {
            this.getModel().setValue("calrule", null);
        }
        this.getView().updateView("schemeaftercal");
    }

    private void changeGenbizdataVisible(Long schemeAfterCal) {
        if (schemeAfterCal == 0L) {
            return;
        }
        SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
        DynamicObject schemeAfterCalObj = sceneService.getSchemeAfterCalObjById(schemeAfterCal);
        if (schemeAfterCalObj.getBoolean("genbizdata")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"genbizdata"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"genbizdata"});
        }
    }

    private void changeGenbizdataVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean genBizdata = dataEntity.getBoolean("schemeaftercal.genbizdata");
        if (genBizdata) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"genbizdata"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"genbizdata"});
        }
    }

    private void clearInfoIfCountryAndOrgChanged(String propertyName, ChangeData changeData) {
        DynamicObject oldDyObj;
        DynamicObject newDyObj = (DynamicObject)changeData.getNewValue();
        if (newDyObj == null || (oldDyObj = (DynamicObject)changeData.getOldValue()) == null || newDyObj.getLong("id") != oldDyObj.getLong("id")) {
            List<SceneGroupVO> groups = this.getGroups();
            if ("org".equals(propertyName)) {
                IDataModel model = this.getModel();
                model.setValue("callistrule", null);
                model.setValue("callistview", null);
                if (groups != null) {
                    groups.forEach(groupVO -> groupVO.setCalListRuleId(null));
                }
            }
            this.clearCommonData(groups);
            this.getModel().setValue(KEY_GROUPCONTENT, (Object)JSON.toJSONString(groups));
            this.getView().updateView();
        }
    }

    private void setMatchAttPeriodVisible() {
        Boolean enableAtt = (Boolean)this.getModel().getValue("isenableatt");
        this.getView().setVisible(enableAtt, new String[]{"matchattperiod"});
        FieldEdit matchAttPeriodItem = (FieldEdit)this.getControl("matchattperiod");
        matchAttPeriodItem.setMustInput(enableAtt.booleanValue());
    }

    private boolean checkFieldInValid(List<String> fieldList) {
        if (SWCListUtils.isEmpty(fieldList)) {
            return true;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (String field : fieldList) {
            Object dyObj = dataEntity.get(field);
            boolean hasInputted = dyObj == null || dyObj instanceof DynamicObject && ((DynamicObject)dyObj).getLong("id") == 0L;
            if (!hasInputted) continue;
            this.showMustInputInfoForPointKey(field);
            return true;
        }
        return false;
    }

    private void updateMultiBizDataEntryViewList(ChangeData changeData) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", changeData.getRowIndex());
        Boolean enable = !"0".equals(changeData.getNewValue());
        if (enable.booleanValue()) {
            this.putLastValueIfExists(dynamicObject, changeData.getRowIndex());
        } else {
            this.clearBizDataIfLocked(dynamicObject);
        }
    }

    private void putLastValueIfExists(DynamicObject currDyObj, int currRowIndex) {
        String lastBizDataJson = this.getView().getPageCache().get("bizDataIdSetCache," + currDyObj.getLong("salarycalcstyle.id"));
        if (lastBizDataJson == null) {
            return;
        }
        DynamicObjectCollection multiBizDataColl = this.getModel().getEntryRowEntity("entryentity", currRowIndex).getDynamicObjectCollection("calbordermulbd");
        multiBizDataColl.clear();
        JSONArray bizDataIdJsonArr = (JSONArray)JSON.parseObject((String)lastBizDataJson).get((Object)CACHE_BIZ_DATA_ID_SET);
        bizDataIdJsonArr.forEach(bizDataId -> multiBizDataColl.addNew().set("fbasedataid_id", bizDataId));
    }

    private void lockBizDataCellIfNeeded(int[] needLockRows) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (SWCListUtils.isEmpty((List)entryEntity)) {
            return;
        }
        for (DynamicObject entry : entryEntity) {
            int seq = entry.getInt("seq") - 1;
            Boolean enable = "1".equals(entry.getString("attachcondition"));
            this.getView().setEnable(enable, seq, new String[]{"calbordermulbd"});
        }
    }

    private int[] needLockRows() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (SWCListUtils.isEmpty((List)entryEntity)) {
            return null;
        }
        return entryEntity.stream().filter(dyObj -> "0".equals(dyObj.getString("attachcondition"))).mapToInt(dyObj -> dyObj.getInt("seq") - 1).toArray();
    }

    private void clearBizDataIfLocked(DynamicObject currDyObj) {
        if (currDyObj == null) {
            return;
        }
        DynamicObjectCollection multiBizDataColl = currDyObj.getDynamicObjectCollection("calbordermulbd");
        if (SWCListUtils.isEmpty((List)multiBizDataColl)) {
            return;
        }
        Set bizDataIdSet = multiBizDataColl.stream().map(bizData -> bizData.getString("fbasedataid_id")).map(Long::valueOf).collect(Collectors.toSet());
        JSONObject bizDataJson = new JSONObject();
        bizDataJson.put(CACHE_BIZ_DATA_ID_SET, bizDataIdSet);
        this.getView().getPageCache().put("bizDataIdSetCache," + currDyObj.getLong("salarycalcstyle.id"), bizDataJson.toJSONString());
        currDyObj.set("calbordermulbd", null);
    }

    private void clearCommonData(List<SceneGroupVO> groups) {
        IDataModel model = this.getModel();
        model.setValue("periodtype", null);
        model.setValue("calrule", null);
        model.setValue("salaryslipview", null);
        model.setValue("schemeaftercal", null);
        model.setValue("genbizdata", null);
        model.deleteEntryData("entryentity");
        if (groups != null) {
            for (SceneGroupVO group : groups) {
                group.setRules(new ArrayList(10));
            }
        }
    }

    private void showMustInputInfoForPointKey(String fieldKey) {
        String errMsg;
        Map errMsgMap = PayRollSceneErrorInfo.getErrMsgMap();
        if (SWCStringUtils.isNotEmpty((String)fieldKey) && (errMsg = (String)errMsgMap.get(fieldKey)) != null) {
            this.getView().showTipNotification(errMsg);
        }
    }

    private void openSalaryCalStyleBaseView() {
        int currRowIndex = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getFocusRow();
        this.getModel().setEntryCurrentRowIndex("entryentity", currRowIndex);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_salarycalcstyle", (boolean)true);
        showParameter.setFormId("hsbp_allowreturnnullf7");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_salarycalcstyle"));
        QFilter filter = SWCPayRollSceneService.createInstance().getCommonQFilter(this.getModel().getDataEntity(), "org", "country", "salarycalcstyle");
        filter.and("salarycalstyle", "=", (Object)"1");
        showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(filter.toArray()), null));
        Object[] selectedSalaryCalStyleIdArr = this.getSelectedSalaryCalStyleIdArr();
        if (!SWCArrayUtils.isEmpty((Object[])selectedSalaryCalStyleIdArr)) {
            showParameter.setSelectedRows(selectedSalaryCalStyleIdArr);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Object[] getSelectedSalaryCalStyleIdArr() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (SWCListUtils.isEmpty((List)entryEntity)) {
            return null;
        }
        List salaryCalStyleList = entryEntity.stream().map(dyObj -> dyObj.getLong("salarycalcstyle.id")).collect(Collectors.toList());
        QFilter filter = SWCPayRollSceneService.createInstance().getCommonQFilter(this.getModel().getDataEntity(), "org", "country", "salarycalcstyle");
        filter.and("salarycalstyle", "=", (Object)"1");
        filter.and("id", "in", salaryCalStyleList);
        return SWCPayRollSceneHelper.getValidCalSalaryStyleIdArr((QFilter)filter);
    }

    private void deleteCache(BeforeDoOperationEventArgs args) {
        int[] selectedRows = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        for (int selectRow : selectedRows) {
            this.clearBizDataIfLocked(this.getModel().getEntryRowEntity("entryentity", selectRow));
        }
    }

    private void updateEntryEntity(Object returnData) {
        ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
        List newSalaryCalStyleIdList = listSelectedRowCollection.stream().map(pkId -> (Long)pkId.getPrimaryKeyValue()).collect(Collectors.toList());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject entryDyObj = (DynamicObject)iterator.next();
            long oldSalaryCalStyleId = entryDyObj.getLong("salarycalcstyle.id");
            if (!newSalaryCalStyleIdList.contains(oldSalaryCalStyleId)) {
                this.clearBizDataIfLocked(entryDyObj);
                iterator.remove();
                continue;
            }
            newSalaryCalStyleIdList.remove(oldSalaryCalStyleId);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int index = 0;
        for (DynamicObject lastDyObj : entryEntity) {
            vs.set("salarycalcstyle", (Object)lastDyObj.getLong("salarycalcstyle.id"), index);
            String attachCondition = lastDyObj.getString("attachcondition");
            vs.set("attachcondition", (Object)lastDyObj.getString("attachcondition"), index);
            vs.set("calbordermulbd", (Object)lastDyObj.getDynamicObjectCollection("calbordermulbd"), index);
            ++index;
        }
        for (Long newSalaryCalStyleId : newSalaryCalStyleIdList) {
            vs.set("salarycalcstyle", (Object)newSalaryCalStyleId, index);
            vs.set("attachcondition", (Object)"0", index);
            ++index;
        }
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", vs);
        this.lockBizDataCellIfNeeded(null);
        model.endInit();
        this.setEntryToGroupContent();
        this.getView().updateView();
    }

    private void openBizDataMultiSelectedView() {
        int currClickRowIndex = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getFocusRow();
        this.getModel().setEntryCurrentRowIndex("entryentity", currClickRowIndex);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsbs_bizitem", (boolean)true);
        showParameter.setFormId("hsbp_allowreturnnullf7");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsbs_bizitem"));
        QFilter filter = SWCPayRollSceneService.createInstance().getCommonQFilter(this.getModel().getDataEntity(), "org", "country", "calbordermulbd");
        filter.and("islistgenerate", "=", (Object)"1");
        filter.and("cycle", "=", (Object)"0");
        showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(filter.toArray()), null));
        DynamicObject calBorderEntity = this.getModel().getEntryRowEntity("entryentity", currClickRowIndex);
        DynamicObjectCollection multiBizDataColl = calBorderEntity.getDynamicObjectCollection("calbordermulbd");
        if (!SWCListUtils.isEmpty((List)multiBizDataColl)) {
            Object[] bizDataItems = multiBizDataColl.stream().map(bizData -> bizData.getLong("fbasedataid_id")).toArray();
            showParameter.setSelectedRows(bizDataItems);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setSalSlipInfoVisible(Boolean visible) {
        this.getView().setVisible(visible, new String[]{"releasesalaryslip", "salaryslipview"});
        this.getView().setEnable(visible, new String[]{"releasesalaryslip", "salaryslipview"});
        if (!visible.booleanValue()) {
            this.getModel().beginInit();
            this.getModel().setValue("releasesalaryslip", null);
            this.getModel().setValue("salaryslipview", null);
            this.getModel().endInit();
            this.getView().updateView("releasesalaryslip");
            this.getView().updateView("salaryslipview");
        }
    }

    private boolean isEnableWtcInte() {
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"wtcinte");
        boolean enableWtcInte = Boolean.FALSE;
        if (paramMap != null) {
            Boolean wtcinte = (Boolean)paramMap.get("enableWtcInte");
            Integer scheme = paramMap.getOrDefault("scheme", WtcInteCfgConstants.FIELD_SCHEME_THREE);
            if (wtcinte.booleanValue() && (WtcInteCfgConstants.FIELD_SCHEME_ONE.equals(scheme) || WtcInteCfgConstants.FIELD_SCHEME_TWO.equals(scheme))) {
                enableWtcInte = Boolean.TRUE;
            }
        }
        return enableWtcInte;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.contains("rulegroupsap_")) {
            int currentRowIndex;
            int clickIndex = Integer.parseInt(key.split("_")[1]);
            if (clickIndex == (currentRowIndex = this.getModel().getDataEntity().getInt(KEY_CHOOSEINDEX))) {
                return;
            }
            this.getModel().setValue(KEY_CHOOSEINDEX, (Object)clickIndex);
            this.updateRuleAp();
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (SWCStringUtils.isNotEmpty((String)key) && key.contains("rulegroupsap_")) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            e.setControl((Control)container);
        }
    }

    private List<SceneGroupVO> getGroups() {
        String groupcontent = this.getModel().getDataEntity().getString(KEY_GROUPCONTENT);
        if (SWCStringUtils.isEmpty((String)groupcontent)) {
            return new ArrayList<SceneGroupVO>(10);
        }
        return (List)JSON.parseObject((String)groupcontent, (TypeReference)new TypeReference<List<SceneGroupVO>>(){}, (Feature[])new Feature[0]);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        BizChangedHelper.operateBizChangedSet((DynamicObject)this.getModel().getDataEntity(true), Arrays.asList(KEY_CHOOSEINDEX, "callistrule", "entryentity"), (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.DELETE);
        DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (entryColl != null) {
            for (DynamicObject entry : entryColl) {
                BizChangedHelper.operateBizChangedSet((DynamicObject)entry, Arrays.asList("salarycalcstyle", "calbordermulbd", "attachcondition"), (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.DELETE);
                DynamicObjectCollection bizDatas = entry.getDynamicObjectCollection("calbordermulbd");
                if (bizDatas == null) continue;
                bizDatas.forEach(o -> o.getDataEntityState().setBizChanged(false));
            }
        }
        this.getModel().getDataEntity(true).getDataEntityState().setRemovedItems(Boolean.valueOf(false));
    }
}

